/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICiticApi;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountPayReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAccountPayResDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticFundTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticRspCodeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticSelfTransTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.ArrivalUploadStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeBalanceTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.TradeBaseResponse;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.AccountOptReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TradeSettlementFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TransferBaseDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.config.DelayRoutingConfig;
import com.dtyunxi.tcbj.center.settlement.biz.constant.SettlementTradeEntireStatusEnum;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaySettlementHelperAbstract;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.SettlementAccountOptService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.DateUtil;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementArrivalUploadDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementArrivalUploadEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.vo.BaseVo;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransferService
extends PaySettlementHelperAbstract<TransferBaseDto> {
    private Logger logger = LoggerFactory.getLogger(TransferService.class);
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;
    @Resource
    private SettlementAccountOptService settlementAccountOptService;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private ICiticApi citicApi;
    @Resource
    private ISettlementAccountService settlementAccountService;
    @Resource
    private ILockService lockService;
    @Resource
    private SettlementArrivalUploadDas settlementArrivalUploadDas;
    @Resource
    private DelayRoutingConfig delayRoutingConfig;

    @Override
    public TradeBaseResponse<TransferBaseDto> checkAndBuild(TransferBaseDto dto) {
        this.logger.info("\u3010\u4f59\u989d\u5212\u8d26\u3011checkAndBuild\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.notEmpty((Object)dto.getFormerTradeFlow(), (SettlementExceptionCode)SettlementExceptionCode.SEARCH_PAY_TRADE_FLOW_NOT);
        TradeSettlementFlowReqDto createTradeFlow = new TradeSettlementFlowReqDto();
        CubeBeanUtils.copyProperties((Object)createTradeFlow, (Object)dto, (String[])new String[0]);
        createTradeFlow.setOptTradeNo(dto.getOrderNo());
        createTradeFlow.setLaunchTradeAmount(dto.getFormerTradeFlow().getLaunchTradeAmount());
        createTradeFlow.setTradeAmount(createTradeFlow.getLaunchTradeAmount());
        createTradeFlow.setTradePoundage(BigDecimal.ZERO);
        createTradeFlow.setTradePoundageRate(BigDecimal.ZERO);
        createTradeFlow.setOptAccountNo(dto.getFormerTradeFlow().getSettlementAccountNo());
        createTradeFlow.setOptAccountName(dto.getFormerTradeFlow().getSettlementAccountName());
        createTradeFlow.setOptAccountType(dto.getFormerTradeFlow().getSettlementAccountType());
        createTradeFlow.setSettlementAccountNo(dto.getFormerTradeFlow().getSettlementAccountNo());
        createTradeFlow.setSettlementAccountName(dto.getFormerTradeFlow().getSettlementAccountName());
        createTradeFlow.setSettlementAccountType(dto.getFormerTradeFlow().getSettlementAccountType());
        createTradeFlow.setRoutingTimer(this.delayRoutingConfig.calculateStartRoutingDate(dto.getRequestTime()));
        dto.setTradeFlowParam(createTradeFlow);
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    public TradeBaseResponse<TransferBaseDto> executeProcess(TransferBaseDto dto) {
        this.logger.info("\u5df2\u5f03\u7528");
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TradeBaseResponse<TransferBaseDto> before(TransferBaseDto dto) {
        this.logger.info("\u3010\u4f59\u989d\u5212\u8d26\u3011before\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        dto.getTradeFlowParam().setTradeType(SettlementFlowTradeTypeEnum.ROUTING.getCode());
        dto.getTradeFlowParam().setTradeStatus(SettlementFlowTradeStatusEnum.CREATED.getCode());
        dto.getTradeFlowParam().setTradeEntireStatus(SettlementTradeEntireStatusEnum.NOTSTART.getCode());
        TradeSettlementFlowEo tradeFlowEo = super.createTradeFlow(dto);
        TradeSettlementFlowRespDto tradeFlowDto = new TradeSettlementFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)tradeFlowEo, (BaseVo)tradeFlowDto);
        dto.setTradeFlow(tradeFlowDto);
        AccountOptReqDto optAccountReqDto = new AccountOptReqDto();
        optAccountReqDto.setAccountNo(dto.getTradeFlow().getOptAccountNo());
        optAccountReqDto.setAccountFlowType(SettlementAccountFlowTypeEnum.SALES.getCode());
        optAccountReqDto.setChangeBalance(dto.getTradeFlow().getTradeAmount());
        optAccountReqDto.setChangeType(SettlementAccountFlowChangeTypeEnum.EXPENSE.getCode());
        optAccountReqDto.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.ROUTE_BALANCE.getCode());
        optAccountReqDto.setLinkedTradeNo(dto.getTradeFlow().getTradeNo());
        optAccountReqDto.setLinkedParentTradeNo(dto.getTradeFlow().getParentTradeNo());
        optAccountReqDto.setRouteFrozen(optAccountReqDto.getChangeBalance());
        optAccountReqDto.setType(Integer.valueOf(1));
        SettlementAccountFlowRespDto optAccountFlow = this.settlementAccountOptService.optAccountFrozen(optAccountReqDto);
        dto.setOptAccountFlow(optAccountFlow);
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TradeBaseResponse<TransferBaseDto> run(TransferBaseDto dto) {
        this.logger.info("\u3010\u4f59\u989d\u5212\u8d26\u3011run\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        TradeBaseResponse response = new TradeBaseResponse();
        TradeSettlementFlowRespDto updateTradeAccept = new TradeSettlementFlowRespDto();
        updateTradeAccept.setTradeStatus(SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        updateTradeAccept.setId(dto.getTradeFlow().getId());
        super.updateTradeFlow(updateTradeAccept, SettlementFlowTradeStatusEnum.CREATED.getCode());
        CiticAccountPayReqDto resDto = new CiticAccountPayReqDto();
        SettlementAccountRespDto buyerAccount = this.settlementAccountService.queryByAccountNo(dto.getFormerTradeFlow().getOptAccountNo());
        AssertUtils.notEmpty((Object)buyerAccount, (SettlementExceptionCode)SettlementExceptionCode.SEARCH_ACCOUNT_NOT);
        resDto.setUserDId(buyerAccount.getBindAccountNo());
        resDto.setUserDNm(buyerAccount.getAccountName());
        SettlementAccountRespDto sellerAccount = this.settlementAccountService.queryByAccountNo(dto.getFormerTradeFlow().getSettlementAccountNo());
        AssertUtils.notEmpty((Object)sellerAccount, (SettlementExceptionCode)SettlementExceptionCode.SEARCH_ACCOUNT_NOT);
        resDto.setUserCId(sellerAccount.getBindAccountNo());
        resDto.setUserCNm(sellerAccount.getAccountName());
        resDto.setUserCAmt(dto.getTradeFlow().getTradeAmount().toString());
        resDto.setTransAmt(dto.getTradeFlow().getTradeAmount().toString());
        resDto.setpSelfFlag(CiticSelfTransTypeEnum.UNCHANGED.key);
        resDto.setpSelfAmt("0.00");
        resDto.setBussId(dto.getTradeFlow().getTradeNo());
        resDto.setBussSubId(dto.getTradeFlow().getTradeNo());
        resDto.setTransDt(DateUtil.getTransDate());
        resDto.setTransTm(DateUtil.getTransTime());
        resDto.setFundTp(CiticFundTypeEnum.TRADE.key);
        resDto.setMemo(null);
        RestResponse accountPayRest = null;
        try {
            this.logger.info("\u94b1\u5305\u652f\u4ed8\u5206\u8d26\uff0c\u8bf7\u6c42\u767b\u8bb0\u7c3f\u5212\u8d26\uff1a{}", (Object)JSON.toJSONString((Object)resDto));
            accountPayRest = this.citicApi.accountPay(resDto);
            this.logger.info("\u94b1\u5305\u652f\u4ed8\u5206\u8d26\uff0c\u8bf7\u6c42\u767b\u8bb0\u7c3f\u5212\u8d26\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)accountPayRest));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BizException("-1", "\u53d1\u8d77\u5212\u8d26\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (!accountPayRest.getResultCode().equals("0") || ObjectUtils.isEmpty((Object)accountPayRest.getData())) {
            throw new BizException("-1", "\u53d1\u8d77\u5212\u8d26\u5f02\u5e38\uff1a" + accountPayRest.getResultMsg());
        }
        if (!((CiticAccountPayResDto)accountPayRest.getData()).getRspCode().equals(CiticRspCodeEnum.SUCCESS.key)) {
            throw new BizException("-1", "\u94b1\u5305\u652f\u4ed8\u8bf7\u6c42\u767b\u8bb0\u7c3f\u5212\u8d26\u5931\u8d25");
        }
        TradeSettlementFlowEo updateTrade = new TradeSettlementFlowEo();
        updateTrade.setId(dto.getTradeFlow().getId());
        updateTrade.setTradePaidAmount(dto.getTradeFlow().getTradeAmount());
        updateTrade.setTradePayTradeId(((CiticAccountPayResDto)accountPayRest.getData()).getReqSsn());
        super.updateTradeFlow(updateTrade);
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TradeBaseResponse<TransferBaseDto> after(TransferBaseDto dto) {
        this.logger.info("\u3010\u4f59\u989d\u5212\u8d26\u3011after\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        TradeSettlementFlowRespDto updateTradeSuccess = new TradeSettlementFlowRespDto();
        updateTradeSuccess.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
        updateTradeSuccess.setTradeEntireStatus(SettlementTradeEntireStatusEnum.COMPLETE.getCode());
        updateTradeSuccess.setTradeEntireSucTime(new Date());
        updateTradeSuccess.setId(dto.getTradeFlow().getId());
        super.updateTradeFlow(updateTradeSuccess, SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        dto.getOptAccountFlowList().forEach(flow -> {
            AccountOptReqDto releaseAccount = new AccountOptReqDto();
            releaseAccount.setAccountFlowNoId(flow.getId());
            releaseAccount.setAccountNo(flow.getAccountNo());
            releaseAccount.setRouteFrozen(dto.getTradeFlow().getTradeAmount());
            releaseAccount.setRouteBalance(dto.getTradeFlow().getTradeAmount());
            releaseAccount.setType(Integer.valueOf(-1));
            this.settlementAccountOptService.optAccountUpdate(releaseAccount);
        });
        dto.getOptAccountFlowList().forEach(flow -> {
            AccountOptReqDto addAccount = new AccountOptReqDto();
            addAccount.setAccountNo(dto.getTradeFlow().getSettlementAccountNo());
            addAccount.setAccountFlowType(SettlementAccountFlowTypeEnum.SALES.getCode());
            addAccount.setChangeBalance(flow.getChangeBalance());
            addAccount.setChangeType(SettlementAccountFlowChangeTypeEnum.INCOME.getCode());
            addAccount.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.BALANCE.getCode());
            addAccount.setLinkedTradeNo(dto.getTradeFlow().getTradeNo());
            addAccount.setLinkedParentTradeNo(dto.getTradeFlow().getParentTradeNo());
            addAccount.setBalance(dto.getTradeFlow().getTradeAmount());
            addAccount.setType(Integer.valueOf(1));
            this.settlementAccountOptService.optAccountFinish(addAccount);
        });
        try {
            SettlementArrivalUploadEo createEo = new SettlementArrivalUploadEo();
            createEo.setAccountNo(dto.getTradeFlow().getSettlementAccountNo());
            createEo.setLinkedTradeNo(dto.getTradeFlow().getTradeNo());
            createEo.setUploadStatus(ArrivalUploadStatusEnum.SUCCESS.getCode());
            createEo.setAccountFlowNo(dto.getTradeFlow().getSettlementAccountFlowNo());
            this.settlementArrivalUploadDas.insert((BaseEo)createEo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

