/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.util.IdGenrator;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TradeUtil {
    private static int maxPerMSECSize = 1000;
    @Resource
    ICacheService cacheService;
    private static TradeUtil tradeUtil;
    private static final String TRADENO = "TRADENO";
    private static final String REFUND_NO_PREFIX = "TK_";

    @PostConstruct
    public void init() {
        tradeUtil = this;
        TradeUtil.tradeUtil.cacheService = this.cacheService;
    }

    public static String generateTradeFlowNo(String tradeType) {
        if (StringUtils.isEmpty((CharSequence)tradeType)) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        long id = IdGenrator.getDistributedId();
        if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY.getCode())) {
            return "PAY" + id;
        }
        if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
            return "REF" + id;
        }
        if (tradeType.equals(SettlementFlowTradeTypeEnum.WITHDRAW.getCode())) {
            return "WIT" + id;
        }
        if (tradeType.equals(SettlementFlowTradeTypeEnum.WITHDRAW_RETURN.getCode())) {
            return "WRE" + id;
        }
        if (tradeType.equals(SettlementFlowTradeTypeEnum.OFFLINE_RECHARGE.getCode())) {
            return "ORE" + id;
        }
        if (tradeType.equals(SettlementFlowTradeTypeEnum.ROUTING.getCode())) {
            return "ROU" + id;
        }
        if (tradeType.equals(SettlementFlowTradeTypeEnum.TRANSFER.getCode())) {
            return "TRA" + id;
        }
        return String.valueOf(id);
    }

    public static String generateAccountFlowNo() {
        return String.valueOf(IdGenrator.getDistributedId());
    }

    public static String generateTradeParentFlowNo() {
        return "FJ" + IdGenrator.getDistributedId();
    }

    public static int nextInt(int begin, int end) {
        return new Random().nextInt(end) + begin;
    }

    public static String generateRefundNo(String orderNo) {
        if (StringUtils.isEmpty((CharSequence)orderNo)) {
            throw new BizException("\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        return REFUND_NO_PREFIX + orderNo;
    }
}

