/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.tcbj.api.ICiticNotifyApi;
import com.dtyunxi.tcbj.api.dto.response.CiticNotifyRespDto;
import com.dtyunxi.tcbj.api.query.ICiticNotifyQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.PayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentRefundStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeBalanceTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowRefundTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.AccountOptReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PayNotifyReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PayRefundNotifyReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.RefundParamReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.center.settlement.biz.constant.SettlementTradeEntireStatusEnum;
import com.dtyunxi.tcbj.center.settlement.biz.mq.PayOrderMqProducerService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementNotifyService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IShareBenefitService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.PayRefundService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaymentBatchOfOnlineService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.SettlementAccountOptService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.vo.BaseVo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SettlementNotifyServiceImpl
implements ISettlementNotifyService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;
    @Resource
    private ISettlementAccountService settlementAccountService;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private SettlementAccountFlowDas settlementAccountFlowDas;
    @Resource
    private PayOrderMqProducerService payOrderMqProducerService;
    @Resource
    private SettlementAccountDas settlementAccountDas;
    @Resource
    private ICiticNotifyQueryApi citicNotifyQueryApi;
    @Resource
    private ICiticNotifyApi citicNotifyApi;
    @Resource
    private ILockService lockService;
    @Resource
    private SettlementAccountOptService settlementAccountOptService;
    @Resource
    private PayRefundService payRefundService;
    @Resource
    private IShareBenefitService shareBenefitService;
    @Resource
    private PaymentBatchOfOnlineService paymentBatchOfOnlineService;
    @Resource
    private ISettlementAccountFlowService settlementAccountFlowService;
    @Resource
    private DingdingSender dingdingSender;

    /*
     * Exception decompiling
     */
    @Override
    public void recordedNotify() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Transactional(rollbackFor={Exception.class})
    public Long recordedNotifyProcess(SettlementAccountRespDto account, CiticNotifyRespDto dto) {
        TradeSettlementFlowEo flowEo = new TradeSettlementFlowEo();
        flowEo.setOptTradeNo(dto.getNotifySsn());
        flowEo.setLaunchUserId("\u7cfb\u7edf\u5b9a\u65f6");
        flowEo.setOptAccountNo(account.getAccountNo());
        flowEo.setOptAccountType(account.getAccountType());
        flowEo.setOptAccountName(account.getAccountName());
        flowEo.setSettlementAccountNo(account.getAccountNo());
        flowEo.setSettlementAccountName(account.getAccountName());
        flowEo.setSettlementAccountType(account.getAccountType());
        flowEo.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
        flowEo.setTradeType(SettlementFlowTradeTypeEnum.OFFLINE_RECHARGE.getCode());
        flowEo.setLaunchTradeAmount(new BigDecimal(dto.getTransAmt()));
        flowEo.setTradeAmount(flowEo.getLaunchTradeAmount());
        flowEo.setTradePaidAmount(flowEo.getTradeAmount());
        flowEo.setTradePayStoreCode("");
        flowEo.setTradePayAppCode("");
        flowEo.setTradePayPartnerId("");
        flowEo.setTradePayType("");
        flowEo.setTradeNo(TradeUtil.generateTradeFlowNo(flowEo.getTradeType()));
        flowEo.setParentTradeNo(TradeUtil.generateTradeParentFlowNo());
        flowEo.setTradeEntireStatus(SettlementTradeEntireStatusEnum.COMPLETE.getCode());
        flowEo.setTradeEntireSucTime(new Date());
        AccountOptReqDto optReqDto = new AccountOptReqDto();
        optReqDto.setAccountNo(account.getAccountNo());
        optReqDto.setAccountFlowType(SettlementAccountFlowTypeEnum.OFFLINE_RECHARGE.getCode());
        optReqDto.setChangeBalance(flowEo.getTradePaidAmount());
        optReqDto.setChangeType(SettlementAccountFlowChangeTypeEnum.INCOME.getCode());
        optReqDto.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.BALANCE.getCode());
        optReqDto.setLinkedTradeNo(flowEo.getTradeNo());
        optReqDto.setLinkedParentTradeNo(flowEo.getParentTradeNo());
        optReqDto.setBalance(optReqDto.getChangeBalance());
        optReqDto.setType(Integer.valueOf(1));
        String accountFlow = this.settlementAccountOptService.optAccountFinish(optReqDto);
        flowEo.setOptAccountFlowNo(accountFlow);
        this.tradeSettlementFlowDas.insert((BaseEo)flowEo);
        return flowEo.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchPayNotify(PayNotifyReqDto dto) {
        Mutex mutex;
        block8: {
            List<TradeSettlementFlowRespDto> tradeSettlementFlowRespDtoList;
            block7: {
                this.logger.info("\u6279\u91cf\u5728\u7ebf\u652f\u4ed8\u56de\u8c03\uff1a{}", (Object)JSON.toJSONString((Object)dto));
                if (ObjectUtils.isEmpty((Object)dto) || StringUtils.isEmpty((CharSequence)dto.getStoreOrderId())) {
                    throw new BizException("-1", "\u6279\u91cf\u652f\u4ed8\u56de\u8c03\u53c2\u6570\u5f02\u5e38");
                }
                mutex = null;
                try {
                    mutex = this.lockService.lock("st_settlement_callBack_doing", dto.getStoreOrderId(), 10, 10, TimeUnit.SECONDS);
                    tradeSettlementFlowRespDtoList = this.paymentBatchOfOnlineService.callBackCheckAndBuild(dto);
                    if (!CollectionUtil.isEmpty(tradeSettlementFlowRespDtoList)) break block7;
                    this.logger.info("\u65e0\u652f\u4ed8\u4ea4\u6613\u6d41\u6c34\u9700\u8981\u5904\u7406");
                }
                catch (Throwable throwable) {
                    this.lockService.unlock(mutex);
                    throw throwable;
                }
                this.lockService.unlock(mutex);
                return;
            }
            if (dto.getOrderStatus().equals("S")) {
                tradeSettlementFlowRespDtoList.forEach(trade -> {
                    try {
                        this.logger.info("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u5904\u7406\u652f\u4ed8\u4ea4\u6613\u6d41\u6c34\uff1a{}", (Object)JSON.toJSONString((Object)trade));
                        trade = this.paymentBatchOfOnlineService.updateSuccessCallBack((TradeSettlementFlowRespDto)trade, dto);
                        if (trade.getTradeStatus().equals(SettlementFlowTradeStatusEnum.SUCCESS.getCode())) {
                            this.payOrderMqProducerService.dispatchPayOrderInform((TradeSettlementFlowRespDto)trade, PayEnum.SUCCESS.getCode());
                            TradeSettlementFlowRespDto uploadPayDtp = trade;
                            ExecutorUtils.execute(() -> {
                                this.logger.info("\u5b8c\u6210\u5728\u7ebf\u652f\u4ed8\uff0c\u5f02\u6b65\u4e0a\u4f20\u6e05\u5206\u660e\u7ec6");
                                this.shareBenefitService.uploadPayShareBenefit(uploadPayDtp);
                            });
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        this.dingdingSender.sendMessage("com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaymentBatchOfOnlineService.callBack\u6279\u91cf\u5728\u7ebf\u652f\u4ed8\u56de\u8c03\uff0c\u56de\u8c03\u6210\u529f\u5904\u7406\u5f02\u5e38" + e.getMessage());
                    }
                });
                break block8;
            }
            try {
                this.paymentBatchOfOnlineService.updateFailCallBack(tradeSettlementFlowRespDtoList, dto);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                this.dingdingSender.sendMessage("com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaymentBatchOfOnlineService.callBack\u6279\u91cf\u5728\u7ebf\u652f\u4ed8\u56de\u8c03\uff0c\u56de\u8c03\u5931\u8d25\u5904\u7406\u5f02\u5e38" + e.getMessage());
            }
        }
        this.lockService.unlock(mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refundNotify(PayRefundNotifyReqDto dto) {
        block8: {
            block7: {
                this.logger.info("\u6536\u5230\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42{}", (Object)JSON.toJSONString((Object)dto));
                if (!ObjectUtils.isNotEmpty((Object)dto) || !dto.getRefundStatus().equals(PaymentRefundStatusEnum.SUCCESS.getCode())) break block7;
                TradeSettlementFlowEo flowParamEo = new TradeSettlementFlowEo();
                flowParamEo.setTradeNo(dto.getStoreRefundId());
                flowParamEo.setTradeStatus(SettlementFlowTradeStatusEnum.ACCEPT.getCode());
                TradeSettlementFlowEo tradeFlow = (TradeSettlementFlowEo)this.tradeSettlementFlowDas.selectOne((BaseEo)flowParamEo);
                this.logger.info("\u9000\u6b3e\u4ea4\u6613\u6d41\u6c34\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)tradeFlow));
                if (ObjectUtils.isEmpty((Object)tradeFlow)) {
                    throw new BizException(SettlementExceptionCode.SEARCH_PAY_REFUND_FLOW_NOT.getCode(), SettlementExceptionCode.SEARCH_PAY_REFUND_FLOW_NOT.getMsg());
                }
                TradeSettlementFlowEo payFlowParamEo = new TradeSettlementFlowEo();
                payFlowParamEo.setTradeNo(tradeFlow.getFormerTradeNo());
                TradeSettlementFlowEo formerTradeFlow = (TradeSettlementFlowEo)this.tradeSettlementFlowDas.selectOne((BaseEo)payFlowParamEo);
                if (ObjectUtils.isEmpty((Object)formerTradeFlow)) {
                    throw new BizException(SettlementExceptionCode.SEARCH_PAY_TRADE_FLOW_NOT.getCode(), SettlementExceptionCode.SEARCH_PAY_TRADE_FLOW_NOT.getMsg());
                }
                List<SettlementAccountFlowRespDto> accountFlowList = this.settlementAccountFlowService.queryListByTradeFlow(tradeFlow.getTradeNo(), tradeFlow.getParentTradeNo());
                if (CollectionUtil.isEmpty(accountFlowList)) {
                    throw new BizException(SettlementExceptionCode.SEARCH_ACCOUNT_FLOW_NOT.getCode(), SettlementExceptionCode.SEARCH_ACCOUNT_FLOW_NOT.getMsg());
                }
                TradeSettlementFlowRespDto tradeFlowDto = new TradeSettlementFlowRespDto();
                DtoHelper.eo2Dto((BaseEo)tradeFlow, (BaseVo)tradeFlowDto);
                tradeFlow.setTradePayTradeChannelId(dto.getPartnerOrderId());
                TradeSettlementFlowRespDto formerTradeFlowDto = new TradeSettlementFlowRespDto();
                DtoHelper.eo2Dto((BaseEo)formerTradeFlow, (BaseVo)formerTradeFlowDto);
                Mutex mutex = null;
                try {
                    mutex = this.lockService.lock("st_order_settlement_doing", tradeFlowDto.getOptTradeNo(), 10, 10, TimeUnit.SECONDS);
                    RefundParamReqDto reqDto = new RefundParamReqDto();
                    tradeFlowDto.setTradePayFinishTime(new Date());
                    reqDto.setTradeFlow(tradeFlowDto);
                    reqDto.setFormerTradeFlow(formerTradeFlowDto);
                    reqDto.setSettlementAccountFlowList(accountFlowList);
                    reqDto.setPaymentType(Integer.valueOf(2));
                    reqDto.setRefundType(SettlementFlowRefundTypeEnum.ORIGINAL.getCode());
                    this.payRefundService.after(reqDto);
                }
                catch (Throwable throwable) {
                    this.lockService.unlock(mutex);
                    throw throwable;
                }
                this.lockService.unlock(mutex);
                break block8;
            }
            if (ObjectUtils.isNotEmpty((Object)dto) && dto.getRefundStatus().equals(PaymentRefundStatusEnum.FAIL.getCode())) {
                this.logger.info("\u9000\u6b3e\u5931\u8d25");
            } else {
                this.logger.info("\u9000\u6b3e\u672a\u5b8c\u6210");
            }
        }
    }
}

