/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.settlement.api.constant.PayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.PayBaseDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.TradeBaseResponse;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PaymentBatchParamBaseDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PaymentOrderReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountPasswordReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TradeSettlementFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.constant.SettlementTradeEntireStatusEnum;
import com.dtyunxi.tcbj.center.settlement.biz.mq.PayOrderMqProducerService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountPasswordService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaymentBatchOfOnlineService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.vo.BaseVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaySettlementHelperAbstract<R extends PayBaseDto> {
    private Logger logger = LoggerFactory.getLogger(PaymentBatchOfOnlineService.class);
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private PayOrderMqProducerService payOrderMqProducerService;
    @Resource
    private ISettlementAccountService settlementAccountService;
    @Resource
    private ISettlementAccountPasswordService settlementAccountPasswordService;

    public TradeBaseResponse<R> checkAndBuild(R r) {
        return new TradeBaseResponse(r);
    }

    protected void execute(R r) {
        this.executeProcess(r);
    }

    public TradeBaseResponse<R> executeProcess(R r) {
        return null;
    }

    public abstract TradeBaseResponse<R> before(R var1);

    public abstract TradeBaseResponse<R> run(R var1);

    public abstract TradeBaseResponse<R> after(R var1);

    protected void baseCheck() {
    }

    public boolean checkOrderIfPayRes(String orderNo) {
        this.logger.info("\u6821\u9a8c\u8ba2\u5355\u662f\u5426\u5df2\u7ecf\u652f\u4ed8\uff08\u8fd4\u56de\u6821\u9a8c\u7ed3\u679c\uff09\uff1a{}", (Object)orderNo);
        try {
            this.checkOrderIfPay(orderNo);
            return false;
        }
        catch (BizException bizException) {
            if (bizException.getCode().equals(SettlementExceptionCode.ORDER_PAY_SUCCESS.getCode())) {
                return true;
            }
            throw new BizException(bizException.getCode(), bizException.getMessage());
        }
    }

    public void checkOrderIfPay(String orderNo) {
        this.logger.info("\u6821\u9a8c\u8ba2\u5355\u662f\u5426\u5df2\u7ecf\u652f\u4ed8\uff1a{}", (Object)orderNo);
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            TradeSettlementFlowReqDto paramDto = new TradeSettlementFlowReqDto();
            paramDto.setOptTradeNo(orderNo);
            paramDto.setTradeType(SettlementFlowTradeTypeEnum.PAY.getCode());
            paramDto.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
            List<TradeSettlementFlowRespDto> list = this.tradeSettlementFlowService.queryList(paramDto);
            if (CollectionUtil.isNotEmpty(list)) {
                this.payOrderMqProducerService.dispatchPayOrderInform(list.get(0), PayEnum.SUCCESS.getCode());
                throw new BizException(SettlementExceptionCode.ORDER_PAY_SUCCESS.getCode(), SettlementExceptionCode.ORDER_PAY_SUCCESS.getMsg());
            }
            return;
        }
        throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
    }

    public boolean checkAccountNo(SettlementAccountRespDto account) {
        if (ObjectUtils.isEmpty((Object)account)) {
            return false;
        }
        return ObjectUtils.isNotEmpty((Object)account.getAccountStatus()) && account.getAccountStatus().equals(SettlementAccountStatusEnum.ENABLED.getCode());
    }

    public SettlementAccountRespDto checkAccount(String accountNo, Integer type) {
        this.logger.info("\u6839\u636e\u7f16\u53f7\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u5e76\u6821\u9a8c\u72b6\u6001\uff1a{}=={}", (Object)accountNo, (Object)type);
        if (StringUtils.isNotEmpty((CharSequence)accountNo) && ObjectUtils.isNotEmpty((Object)type)) {
            SettlementAccountRespDto accountRespDto = this.settlementAccountService.queryByAccountNo(accountNo);
            if (ObjectUtils.isNotEmpty((Object)accountRespDto)) {
                if (accountRespDto.getAccountStatus().equals(SettlementAccountStatusEnum.ENABLED.getCode())) {
                    return accountRespDto;
                }
                if (1 == type) {
                    throw new BizException(SettlementExceptionCode.BUYER_ACCOUNT_EXCEPTION.getCode(), SettlementExceptionCode.BUYER_ACCOUNT_EXCEPTION.getMsg());
                }
                throw new BizException(SettlementExceptionCode.SELLER_ACCOUNT_EXCEPTION.getCode(), SettlementExceptionCode.SELLER_ACCOUNT_EXCEPTION.getMsg());
            }
            throw new BizException(SettlementExceptionCode.SEARCH_ACCOUNT_NOT.getCode(), SettlementExceptionCode.SEARCH_ACCOUNT_NOT.getMsg());
        }
        throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
    }

    public boolean checkPaymentPassword(Long orgId, String password) {
        SettlementAccountPasswordReqDto reqDto = new SettlementAccountPasswordReqDto();
        reqDto.setOrgId(orgId);
        reqDto.setUserPassword(password);
        return this.settlementAccountPasswordService.checkPasswork(reqDto);
    }

    public void checkBalance(SettlementAccountRespDto account, BigDecimal amount) {
        this.logger.info("\u6821\u9a8c\u4f59\u989d\u662f\u5426\u5145\u8db3\uff1a{}=={}", (Object)JSON.toJSONString((Object)account), (Object)amount);
        if (ObjectUtils.isNotEmpty((Object)account) && ObjectUtils.isNotEmpty((Object)amount) && amount.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal usable = account.getBalance().subtract(account.getFrozen());
            if (usable.compareTo(amount) > -1) {
                return;
            }
            throw new BizException(SettlementExceptionCode.BALANCE_LACK.getCode(), SettlementExceptionCode.BALANCE_LACK.getMsg());
        }
        throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
    }

    public TradeSettlementFlowEo createTradeFlow(R r) {
        TradeSettlementFlowEo tradeSettlementFlowEo = new TradeSettlementFlowEo();
        DtoHelper.dto2Eo((BaseVo)r.getTradeFlowParam(), (BaseEo)tradeSettlementFlowEo);
        tradeSettlementFlowEo.setLaunchUserId(r.getUserId().toString());
        tradeSettlementFlowEo.setLaunchUserName(r.getUserName());
        tradeSettlementFlowEo.setLaunchUserType(r.getUserType());
        tradeSettlementFlowEo.setTradeNo(TradeUtil.generateTradeFlowNo(tradeSettlementFlowEo.getTradeType()));
        tradeSettlementFlowEo.setParentTradeNo(TradeUtil.generateTradeParentFlowNo());
        if (ObjectUtils.isNotEmpty((Object)r.getPaymentWay())) {
            tradeSettlementFlowEo.setTradePayStoreCode(r.getPaymentWay().getStoreCode());
            tradeSettlementFlowEo.setTradePayAppCode(r.getPaymentWay().getAppCode());
            tradeSettlementFlowEo.setTradePayPartnerId(r.getPaymentWay().getPayPartnerCode());
            tradeSettlementFlowEo.setTradePayType(r.getPaymentWay().getPayTypeCode());
        }
        if (ObjectUtils.isNotEmpty((Object)r.getFormerTradeFlow())) {
            tradeSettlementFlowEo.setFormerTradeNo(r.getFormerTradeFlow().getTradeNo());
            tradeSettlementFlowEo.setFormerParentTradeNo(r.getFormerTradeFlow().getParentTradeNo());
            tradeSettlementFlowEo.setFormerOptOrderNo(r.getFormerTradeFlow().getOptTradeNo());
            tradeSettlementFlowEo.setFormerPayBalancetradeId(r.getFormerTradeFlow().getTradePayTradeId());
            tradeSettlementFlowEo.setTradePayStoreCode(r.getFormerTradeFlow().getTradePayStoreCode());
            tradeSettlementFlowEo.setTradePayAppCode(r.getFormerTradeFlow().getTradePayAppCode());
            tradeSettlementFlowEo.setTradePayPartnerId(r.getFormerTradeFlow().getTradePayPartnerId());
            tradeSettlementFlowEo.setTradePayType(r.getFormerTradeFlow().getTradePayType());
            tradeSettlementFlowEo.setTradePayParnterRate(r.getFormerTradeFlow().getTradePayParnterRate());
            tradeSettlementFlowEo.setTradePayParnterPoundage(r.getFormerTradeFlow().getTradePayParnterPoundage());
        }
        this.tradeSettlementFlowDas.insert((BaseEo)tradeSettlementFlowEo);
        return tradeSettlementFlowEo;
    }

    public TradeSettlementFlowRespDto updateTradeFlow(TradeSettlementFlowEo eo) {
        this.logger.info("\u66f4\u65b0\u4ea4\u6613\u6d41\u6c34\u8bf7\u6c42\u53c2\u6570eo\uff1a{}", (Object)JSON.toJSONString((Object)eo));
        TradeSettlementFlowRespDto dto = new TradeSettlementFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        return this.updateTradeFlow(dto, null);
    }

    public TradeSettlementFlowRespDto updateTradeFlow(TradeSettlementFlowRespDto dto, String tradeStatusWhere) {
        this.logger.info("\u66f4\u65b0\u4ea4\u6613\u6d41\u6c34\u8bf7\u6c42\u53c2\u6570\uff1a{}=={}", (Object)JSON.toJSONString((Object)dto), (Object)tradeStatusWhere);
        if (ObjectUtils.isNotEmpty((Object)dto) && ObjectUtils.isNotEmpty((Object)dto.getId())) {
            TradeSettlementFlowEo eo = new TradeSettlementFlowEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.eq((String)"id", (Object)dto.getId()));
            if (StringUtils.isNotEmpty((CharSequence)tradeStatusWhere)) {
                sqlFilters.add(SqlFilter.eq((String)"trade_status", (Object)tradeStatusWhere));
            }
            eo.setSqlFilters(sqlFilters);
            int i = this.tradeSettlementFlowDas.updateSelective((BaseEo)eo);
            if (i == 1) {
                TradeSettlementFlowRespDto respDto = new TradeSettlementFlowRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)respDto);
                return respDto;
            }
            throw new BizException(SettlementExceptionCode.UPDATE_TRADE_FLOW_FAIL.getCode(), SettlementExceptionCode.UPDATE_TRADE_FLOW_FAIL.getMsg());
        }
        throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
    }

    public void batchUpdateTradeFlow(TradeSettlementFlowReqDto dto, List<String> tradeNoList, String whereTradeStatus) {
        this.logger.info("\u6279\u91cf\u66f4\u65b0\u4ea4\u6613\u6d41\u6c34\u8bf7\u6c42\u53c2\u6570\uff1a{}=={}=={}", new Object[]{JSON.toJSONString((Object)dto), tradeNoList, whereTradeStatus});
        if (ObjectUtils.isNotEmpty((Object)dto) || CollectionUtil.isNotEmpty(tradeNoList)) {
            TradeSettlementFlowEo eo = new TradeSettlementFlowEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"trade_no", tradeNoList));
            if (StringUtils.isNotEmpty((CharSequence)whereTradeStatus)) {
                sqlFilters.add(SqlFilter.eq((String)"trade_status", (Object)whereTradeStatus));
            }
            eo.setSqlFilters(sqlFilters);
            int i = this.tradeSettlementFlowDas.updateSelective((BaseEo)eo);
            if (tradeNoList.size() == i) {
                return;
            }
            throw new BizException(SettlementExceptionCode.UPDATE_TRADE_FLOW_FAIL.getCode(), SettlementExceptionCode.UPDATE_TRADE_FLOW_FAIL.getMsg());
        }
        throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
    }

    public TradeSettlementFlowEo buildCreatePayTradeFlow(PaymentOrderReqDto paymentOrder, PaymentBatchParamBaseDto dto) {
        this.logger.info("\u6784\u5efa\u521b\u5efa\u4ea4\u6613\u6d41\u6c34\u8bf7\u6c42\u53c2\u6570\uff1a{}=={}", (Object)JSON.toJSONString((Object)paymentOrder), (Object)JSON.toJSONString((Object)dto));
        TradeSettlementFlowEo eo = new TradeSettlementFlowEo();
        eo.setLaunchTradeAmount(paymentOrder.getLaunchAmount());
        eo.setTradeAmount(paymentOrder.getTradeAmount());
        eo.setSettlementAccountNo(paymentOrder.getRecordedAccount());
        eo.setSettlementAccountName(paymentOrder.getRecordedAccountName());
        eo.setSettlementAccountType(paymentOrder.getRecordedAccountType());
        eo.setOptAccountNo(dto.getChargeOffAccount());
        eo.setOptAccountName(dto.getChargeOffAccountName());
        eo.setOptAccountType(dto.getChargeOffAccountType());
        eo.setOptTradeNo(paymentOrder.getOrderNo());
        eo.setTradePayParnterPoundage(paymentOrder.getTradePayParnterPoundage());
        eo.setTradePayParnterRate(dto.getServiceChargeRate());
        eo.setTradeType(SettlementFlowTradeTypeEnum.PAY.getCode());
        eo.setTradeStatus(SettlementFlowTradeStatusEnum.CREATED.getCode());
        eo.setTradeEntireStatus(SettlementTradeEntireStatusEnum.NOTSTART.getCode());
        eo.setParentTradeNo(dto.getParentOrderNo());
        eo.setTradePoundage(paymentOrder.getPoundageAmount());
        eo.setTradePoundageRate(dto.getServiceChargeRate());
        eo.setLaunchUserId(dto.getUserId().toString());
        eo.setLaunchUserName(dto.getUserName());
        eo.setLaunchUserType(dto.getUserType());
        eo.setTradePayStoreCode(dto.getPaymentWayReqDto().getStoreCode());
        eo.setTradePayAppCode(dto.getPaymentWayReqDto().getAppCode());
        eo.setTradePayPartnerId(dto.getPaymentWayReqDto().getPayPartnerCode());
        eo.setTradePayType(dto.getPaymentWayReqDto().getPayTypeCode());
        eo.setTradeNo(TradeUtil.generateTradeFlowNo(eo.getTradeType()));
        eo.setParentTradeNo(dto.getParentOrderNo());
        return eo;
    }

    public List<TradeSettlementFlowRespDto> batchCreateTradeFlow(List<TradeSettlementFlowEo> eoList) {
        this.tradeSettlementFlowDas.insertBatch(eoList);
        ArrayList<TradeSettlementFlowRespDto> tradeFlowList = new ArrayList<TradeSettlementFlowRespDto>();
        for (TradeSettlementFlowEo eo : eoList) {
            TradeSettlementFlowRespDto flowRespDto = new TradeSettlementFlowRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)flowRespDto);
            tradeFlowList.add(flowRespDto);
        }
        return tradeFlowList;
    }

    public PaymentBatchParamBaseDto calculateTradeAmount(PaymentBatchParamBaseDto baseDto) {
        this.logger.info("\u8ba1\u7b97\u652f\u4ed8\u7684\u76f8\u5173\u91d1\u989d\uff1a{}", (Object)JSON.toJSONString((Object)baseDto));
        if (ObjectUtils.isNotEmpty((Object)baseDto) && CollectionUtil.isNotEmpty((Collection)baseDto.getPaymentOrderList())) {
            baseDto.setLaunchTotalAmount(BigDecimal.ZERO);
            baseDto.setTradeTotalAmount(BigDecimal.ZERO);
            baseDto.getPaymentOrderList().forEach(trade -> {
                if (!ObjectUtils.isNotEmpty((Object)trade.getLaunchAmount()) || trade.getLaunchAmount().compareTo(BigDecimal.ZERO) <= 0) {
                    throw new BizException(SettlementExceptionCode.AMOUNT_NOT_ZERO.getCode(), SettlementExceptionCode.AMOUNT_NOT_ZERO.getMsg());
                }
                baseDto.setTradeTotalAmount(baseDto.getTradeTotalAmount().add(trade.getTradeAmount()));
            });
            return baseDto;
        }
        throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
    }
}

