/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.mq;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MqRetryHelper {
    private static final String RETRY_TEIMS = "5m,10m,10m,15m,30m,1h,2h,3h,5h,8h,12h";
    private static final List<Long> RETRY_TEIMS_LIST = new ArrayList<Long>(10);
    private static final String MINUTES_UNIT = "m";
    private static final String HOURS_UNIT = "h";

    public static MqRetryHelper getSingle() {
        return SingletonHolder.mSington;
    }

    public MqRetryHelper() {
        this.parseTime();
    }

    private void parseTime() {
        String[] timeArr = RETRY_TEIMS.split(",");
        for (int i = 0; i < timeArr.length - 1; ++i) {
            String timeStr = timeArr[i].substring(0, timeArr[i].length() - 1);
            if (timeArr[i].contains(MINUTES_UNIT)) {
                long secondsOfMinutes = TimeUnit.MINUTES.toSeconds(Long.parseLong(timeStr));
                RETRY_TEIMS_LIST.add(secondsOfMinutes);
                continue;
            }
            long secondsOfHours = TimeUnit.HOURS.toSeconds(Long.parseLong(timeStr));
            RETRY_TEIMS_LIST.add(secondsOfHours);
        }
    }

    public Long getRetryTime(int tryTimes) {
        if (tryTimes > RETRY_TEIMS_LIST.size()) {
            return null;
        }
        return RETRY_TEIMS_LIST.get(tryTimes);
    }

    private static class SingletonHolder {
        private static final MqRetryHelper mSington = new MqRetryHelper();

        private SingletonHolder() {
        }
    }
}

