/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeBalanceTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.TradeBaseResponse;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.AccountOptReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PaymentBatchParamBaseDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PaymentOrderReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TradeSettlementFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.constant.SettlementTradeEntireStatusEnum;
import com.dtyunxi.tcbj.center.settlement.biz.mq.PayOrderMqProducerService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaySettlementHelperAbstract;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.SettlementAccountOptService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PaymentBatchOfBalanceService
extends PaySettlementHelperAbstract<PaymentBatchParamBaseDto> {
    private Logger logger = LoggerFactory.getLogger(PaymentBatchOfBalanceService.class);
    @Resource
    private ILockService lockService;
    @Resource
    private PayOrderMqProducerService payOrderMqProducerService;
    @Resource
    private SettlementAccountOptService settlementAccountOptService;

    @Override
    public TradeBaseResponse<PaymentBatchParamBaseDto> checkAndBuild(PaymentBatchParamBaseDto dto) {
        this.logger.info("\u3010\u6279\u91cf\u94b1\u5305\u652f\u4ed8\u3011\u6821\u9a8c\u548c\u6784\u5efa\u5206\u652f\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (!super.checkPaymentPassword(dto.getChargeOffAccountOrgId(), dto.getPassword())) {
            throw new BizException(SettlementExceptionCode.PASSWORD_ERROR.getCode(), SettlementExceptionCode.PASSWORD_ERROR.getMsg());
        }
        SettlementAccountRespDto buyerAccount = super.checkAccount(dto.getChargeOffAccount(), 1);
        dto = super.calculateTradeAmount(dto);
        super.checkBalance(buyerAccount, dto.getTradeTotalAmount());
        for (PaymentOrderReqDto paymentOrder : dto.getPaymentOrderList()) {
            super.checkOrderIfPay(paymentOrder.getOrderNo());
            super.checkAccount(paymentOrder.getRecordedAccount(), 2);
        }
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    public TradeBaseResponse<PaymentBatchParamBaseDto> executeProcess(PaymentBatchParamBaseDto dto) {
        this.logger.info("\u5df2\u5f03\u7528");
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TradeBaseResponse<PaymentBatchParamBaseDto> before(PaymentBatchParamBaseDto dto) {
        this.logger.info("\u3010\u6279\u91cf\u94b1\u5305\u652f\u4ed8\u3011\u521b\u5efa\u652f\u4ed8\u4ea4\u6613\u6d41\u6c34\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        dto.setParentOrderNo(TradeUtil.generateTradeParentFlowNo());
        ArrayList<TradeSettlementFlowEo> createTradeFlowEoList = new ArrayList<TradeSettlementFlowEo>();
        for (PaymentOrderReqDto paymentOrder : dto.getPaymentOrderList()) {
            TradeSettlementFlowEo eo = super.buildCreatePayTradeFlow(paymentOrder, dto);
            createTradeFlowEoList.add(eo);
        }
        List<TradeSettlementFlowRespDto> tradeFlowList = super.batchCreateTradeFlow(createTradeFlowEoList);
        dto.setTradeFlowList(tradeFlowList);
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TradeBaseResponse<PaymentBatchParamBaseDto> run(PaymentBatchParamBaseDto dto) {
        this.logger.info("\u3010\u6279\u91cf\u94b1\u5305\u652f\u4ed8\u3011\u66f4\u65b0\u652f\u4ed8\u4ea4\u6613\uff0c\u51bb\u7ed3\u4e70\u5bb6\u8d26\u6237\u4f59\u989d\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        for (TradeSettlementFlowRespDto trade : dto.getTradeFlowList()) {
            TradeSettlementFlowRespDto updateDipFlow = new TradeSettlementFlowRespDto();
            updateDipFlow.setTradeStatus(SettlementFlowTradeStatusEnum.ACCEPT.getCode());
            updateDipFlow.setTradePaidAmount(trade.getTradeAmount());
            updateDipFlow.setId(trade.getId());
            super.updateTradeFlow(updateDipFlow, SettlementFlowTradeStatusEnum.CREATED.getCode());
        }
        AccountOptReqDto buyerAccount = new AccountOptReqDto();
        buyerAccount.setAccountNo(dto.getChargeOffAccount());
        buyerAccount.setAccountFlowType(SettlementAccountFlowTypeEnum.ORDER_GOODS.getCode());
        buyerAccount.setChangeBalance(dto.getTradeTotalAmount());
        buyerAccount.setChangeType(SettlementAccountFlowChangeTypeEnum.EXPENSE.getCode());
        buyerAccount.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.BALANCE.getCode());
        buyerAccount.setLinkedTradeNo(null);
        buyerAccount.setLinkedParentTradeNo(dto.getParentOrderNo());
        buyerAccount.setFrozen(buyerAccount.getChangeBalance());
        buyerAccount.setType(Integer.valueOf(1));
        dto.setOptAccountFlow(this.settlementAccountOptService.optAccountFrozen(buyerAccount));
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TradeBaseResponse<PaymentBatchParamBaseDto> after(PaymentBatchParamBaseDto dto) {
        this.logger.info("\u3010\u6279\u91cf\u94b1\u5305\u652f\u4ed8\u3011\u66f4\u65b0\u652f\u4ed8\u4ea4\u6613\uff0c\u91ca\u653e\u5e76\u6263\u9664\u5ba2\u6237\u8d26\u6237\u4f59\u989d\uff0c\u589e\u52a0\u5546\u5bb6\u8d26\u6237\u5728\u9014\u6b3e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        List<String> tradeNoList = dto.getTradeFlowList().stream().map(TradeSettlementFlowRespDto::getTradeNo).collect(Collectors.toList());
        TradeSettlementFlowReqDto updateTradeSuccess = new TradeSettlementFlowReqDto();
        updateTradeSuccess.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
        updateTradeSuccess.setTradeEntireStatus(SettlementTradeEntireStatusEnum.COMPLETE.getCode());
        updateTradeSuccess.setTradeEntireSucTime(new Date());
        updateTradeSuccess.setTradePayFinishTime(new Date());
        super.batchUpdateTradeFlow(updateTradeSuccess, tradeNoList, SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        AccountOptReqDto buyerAccount = new AccountOptReqDto();
        buyerAccount.setAccountNo(dto.getChargeOffAccount());
        buyerAccount.setAccountFlowNoId(dto.getOptAccountFlow().getId());
        buyerAccount.setBalance(dto.getOptAccountFlow().getChangeBalance());
        buyerAccount.setFrozen(dto.getOptAccountFlow().getChangeBalance());
        buyerAccount.setChangTime(new Date());
        buyerAccount.setType(Integer.valueOf(-1));
        this.settlementAccountOptService.optAccountUpdate(buyerAccount);
        for (TradeSettlementFlowRespDto trade : dto.getTradeFlowList()) {
            AccountOptReqDto sellerOptReqDto = new AccountOptReqDto();
            sellerOptReqDto.setAccountNo(trade.getSettlementAccountNo());
            sellerOptReqDto.setAccountFlowType(SettlementAccountFlowTypeEnum.SALES.getCode());
            sellerOptReqDto.setChangeBalance(trade.getTradeAmount());
            sellerOptReqDto.setChangeType(SettlementAccountFlowChangeTypeEnum.INCOME.getCode());
            sellerOptReqDto.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.ROUTE_BALANCE.getCode());
            sellerOptReqDto.setLinkedTradeNo(trade.getTradeNo());
            sellerOptReqDto.setLinkedParentTradeNo(dto.getParentOrderNo());
            sellerOptReqDto.setRouteBalance(sellerOptReqDto.getChangeBalance());
            sellerOptReqDto.setType(Integer.valueOf(1));
            trade.setSettlementAccountFlowNo(this.settlementAccountOptService.optAccountFinish(sellerOptReqDto));
        }
        return new TradeBaseResponse((Object)dto);
    }
}

