/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICiticApi;
import com.dtyunxi.tcbj.api.dto.request.CiticUserAddReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticUserCancelReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticUserModifyReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticUserAddResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticUserCancelResDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticBankTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticRspCodeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticUserIdTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticUserRoleEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticUserTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.OperateTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.ProtocolTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettleAccBindCardStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettleAccOrgTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettleAccRegiBusLineEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettleAccRegiStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyFlagEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountLogoutReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountPasswordReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountRegisterRelationReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountRegisterReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountBindCardRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRegisterRelationRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRegisterRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountZhongXingRespDto;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountPasswordService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountRegisterRelationService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountService;
import com.dtyunxi.tcbj.center.settlement.dao.das.ProtocolSignDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountBindCardDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountRegisterRecordDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountRegisterRelationDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.ProtocolSignEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountBindCardEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountRegisterRecordEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountRegisterRelationEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.tcbj.center.settlement.dao.mapper.SettlementAccountRegisterRecordMapper;
import com.dtyunxi.tcbj.center.settlement.dao.mapper.SettlementAccountRegisterRelationMapper;
import com.dtyunxi.tcbj.center.settlement.dao.mapper.TradeSettlementFlowMapper;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SettlementAccountRegisterRelationServiceImpl
implements ISettlementAccountRegisterRelationService {
    private static final Logger logger = LoggerFactory.getLogger(SettlementAccountRegisterRelationServiceImpl.class);
    @Resource
    private SettlementAccountRegisterRelationDas settlementAccountRegisterRelationDas;
    @Autowired
    private SettlementAccountRegisterRelationMapper settlementAccountRegisterRelationMapper;
    @Autowired
    private SettlementAccountRegisterRecordDas settlementAccountRegisterRecordDas;
    @Autowired
    private SettlementAccountDas settlementAccountDas;
    @Resource
    private ICiticApi iCiticApi;
    @Resource
    private SettlementAccountRegisterRecordMapper recordMapper;
    @Resource
    private SettlementAccountBindCardDas bindCardDas;
    @Resource
    private IEmployeeQueryApi employeeQueryApi;
    @Resource
    private ProtocolSignDas protocolSignDas;
    @Resource
    private ISettlementAccountService settlementAccountService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ISettlementAccountPasswordService passwordService;
    @Resource
    private TradeSettlementFlowMapper tradeSettlementFlowMapper;

    @Override
    public Long addSettlementAccountRegisterRelation(SettlementAccountRegisterRelationReqDto addReqDto) {
        SettlementAccountRegisterRelationEo settlementAccountRegisterRelationEo = new SettlementAccountRegisterRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)settlementAccountRegisterRelationEo);
        this.settlementAccountRegisterRelationDas.insert((BaseEo)settlementAccountRegisterRelationEo);
        return settlementAccountRegisterRelationEo.getId();
    }

    @Override
    public void modifySettlementAccountRegisterRelation(SettlementAccountRegisterRelationReqDto modifyReqDto) {
        SettlementAccountRegisterRelationEo settlementAccountRegisterRelationEo = new SettlementAccountRegisterRelationEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)settlementAccountRegisterRelationEo);
        this.settlementAccountRegisterRelationDas.updateSelective((BaseEo)settlementAccountRegisterRelationEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSettlementAccountRegisterRelation(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.settlementAccountRegisterRelationDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SettlementAccountRegisterRespDto queryById(Long id) {
        SettlementAccountRegisterRespDto respDto = new SettlementAccountRegisterRespDto();
        SettlementAccountRegisterRelationEo relationEo = (SettlementAccountRegisterRelationEo)this.settlementAccountRegisterRelationDas.selectByPrimaryKey(id);
        SettlementAccountRegisterRecordEo recordEo = this.recordMapper.queryMaxTimeByRelationId(id);
        DtoHelper.eo2Dto((BaseEo)recordEo, (BaseVo)respDto);
        DtoHelper.eo2Dto((BaseEo)relationEo, (BaseVo)respDto);
        if (respDto != null && StringUtils.isNotEmpty((CharSequence)respDto.getAccountNo())) {
            SettlementAccountRespDto accountRespDto = this.settlementAccountService.queryByAccountNo(respDto.getAccountNo());
            respDto.setAccountRespDto(accountRespDto);
            SettlementAccountBindCardEo searchBindCardEo = new SettlementAccountBindCardEo();
            searchBindCardEo.setAccountNo(respDto.getAccountNo());
            searchBindCardEo.setBindStatus(SettleAccBindCardStatusEnum.SUCCESS.getCode());
            List isExistBindEoList = this.bindCardDas.selectList((BaseEo)searchBindCardEo);
            ArrayList bindCardRespDtos = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)isExistBindEoList, bindCardRespDtos, SettlementAccountBindCardRespDto.class);
            respDto.getAccountRespDto().setBindCardList(bindCardRespDtos);
            ProtocolSignEo pSignEo = new ProtocolSignEo();
            pSignEo.setBusinessId(id);
            List signEoList = this.protocolSignDas.selectList((BaseEo)pSignEo);
            if (!CollectionUtils.isEmpty((Collection)signEoList)) {
                Date lastestDate = ((ProtocolSignEo)signEoList.get(0)).getCreateTime();
                respDto.setProtocolId(((ProtocolSignEo)signEoList.get(0)).getProtocolId());
                for (ProtocolSignEo signEo : signEoList) {
                    if (lastestDate.compareTo(signEo.getCreateTime()) < 0) continue;
                    respDto.setProtocolId(signEo.getProtocolId());
                }
            }
        }
        return respDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> logoutSettlementAccount(SettlementAccountLogoutReqDto logoutReqDto) {
        RestResponse resp = new RestResponse();
        SettlementAccountRegisterRelationEo relationEo = (SettlementAccountRegisterRelationEo)this.settlementAccountRegisterRelationDas.selectByPrimaryKey(logoutReqDto.getId());
        if (relationEo.getId() == null) {
            throw new BizException("\u5f53\u524d\u7ed3\u7b97\u8d26\u6237\u4e0d\u5b58\u5728\uff0c\u4e0d\u9700\u6ce8\u9500\uff0c\u8bf7\u6253\u5f00\u91cd\u65b0\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        if (!SettleAccRegiStatusEnum.SUCCESS.getCode().equals(relationEo.getRegisterStatus())) {
            throw new BizException("\u5f53\u524d\u7ed3\u7b97\u8d26\u6237\u5df2\u6ce8\u9500\u6216\u6ce8\u9500\u4e2d\uff0c\u4e0d\u9700\u6ce8\u9500\uff0c\u8bf7\u6253\u5f00\u91cd\u65b0\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        SettlementAccountBindCardEo searchBindCardEo = new SettlementAccountBindCardEo();
        searchBindCardEo.setAccountNo(relationEo.getAccountNo());
        searchBindCardEo.setBindStatus(SettleAccBindCardStatusEnum.SUCCESS.getCode());
        List isExistBindEoList = this.bindCardDas.selectList((BaseEo)searchBindCardEo);
        logger.info("isExistBindEoList={}", (Object)JSONObject.toJSONString((Object)isExistBindEoList));
        if (isExistBindEoList != null && isExistBindEoList.size() > 0) {
            throw new BizException("\u8bf7\u5148\u89e3\u7ed1\u94f6\u884c\u5361\u518d\u8fdb\u884c\u6ce8\u9500");
        }
        OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)this.organizationQueryApi.queryOrgAndOrgInfo(relationEo.getOrganizationId()).getData();
        SettlementAccountPasswordReqDto passwordReqDto = new SettlementAccountPasswordReqDto();
        passwordReqDto.setUserPassword(logoutReqDto.getPayPassword());
        passwordReqDto.setOrgId(relationEo.getOrganizationId());
        passwordReqDto.setOrgCode(orgInfoRespDto.getOrganizationInfoDto().getOrgCode());
        passwordReqDto.setOrgInfoId(orgInfoRespDto.getOrganizationInfoDto().getId());
        if (!this.passwordService.checkPasswork(passwordReqDto).booleanValue()) {
            throw new BizException("\u652f\u4ed8\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        List<SettlementAccountZhongXingRespDto> accountList = this.settlementAccountService.queryZhongXinMoneyByAccountNo(relationEo.getAccountNo(), 1, 10);
        if (accountList == null || accountList.size() != 1) {
            throw new BizException(relationEo.getAccountNo() + "\u65e0\u6cd5\u627e\u5230\u767b\u8bb0\u7c3f\u8d26\u6237\u8fdb\u884c\u6ce8\u9500\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        SettlementAccountZhongXingRespDto accountNoDto = accountList.get(0);
        if (SettleAccOrgTypeEnum.CUSTOMER.getCode().equals(relationEo.getOrganizationType())) {
            if (accountNoDto.getBalance().compareTo(BigDecimal.ZERO) != 0) {
                throw new BizException("\u4f59\u989d\u4e0d\u4e3a\u7a7a\uff0c\u9700\u8981\u63d0\u73b0\u5b8c\u6bd5\u6216\u6d88\u8d39\u5b8c\u6bd5\u518d\u6ce8\u9500");
            }
            if (accountNoDto.getFrozen().compareTo(BigDecimal.ZERO) != 0) {
                throw new BizException("\u5728\u9014\u6b3e\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u5728\u9014\u6b3e\u5904\u7406\u5b8c\u6bd5\u540e\u6ce8\u9500");
            }
            if (accountNoDto.getRouteBalance().compareTo(BigDecimal.ZERO) != 0 || accountNoDto.getRouteFrozen().compareTo(BigDecimal.ZERO) != 0) {
                throw new BizException("\u5b58\u5728\u4e0d\u53ef\u63d0\u73b0\u91d1\u989d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u540e\u518d\u8fdb\u884c\u6ce8\u9500");
            }
            if (accountNoDto.getZxBalance() != null && BigDecimal.ZERO.compareTo(accountNoDto.getZxBalance()) != 0) {
                throw new BizException("\u4e2d\u4fe1\u767b\u8bb0\u7c3f\u4f59\u989d\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u63d0\u73b0\u540e\u518d\u884c\u6ce8\u9500");
            }
            TradeSettlementFlowEo sflowEo = new TradeSettlementFlowEo();
            sflowEo.setVerifyFlag(VerifyFlagEnum.NO.getCode());
            sflowEo.setTradeType(SettlementFlowTradeTypeEnum.PAY.getCode());
            sflowEo.setTradePayType(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode());
            sflowEo.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
            sflowEo.setOptAccountNo(relationEo.getAccountNo());
            List tradeSettlementFlowEoList = this.tradeSettlementFlowMapper.queryNoVerifyDjbPayFLowAndRoutingFlow(sflowEo);
            if (tradeSettlementFlowEoList != null && tradeSettlementFlowEoList.size() > 0) {
                throw new BizException("\u5b58\u5728\u94b1\u5305\u652f\u4ed8\u672a\u53d1\u8d27\u7684\u8ba2\u5355\uff0c\u8bf7\u7b49\u5f85\u53d1\u8d27\u540e\u518d\u6ce8\u9500");
            }
            this.logoutBank(relationEo.getId(), accountNoDto, SettleAccRegiStatusEnum.LOGOUT.getCode(), SettlementAccountStatusEnum.LOGOUT.getCode());
            resp.setResultMsg("\u6ce8\u9500\u6210\u529f\uff0c\u540e\u7eed\u5982\u9700\u4f7f\u7528\u94b1\u5305\u8bf7\u91cd\u65b0\u7533\u8bf7");
        } else if (SettleAccOrgTypeEnum.DEALER.getCode().equals(relationEo.getOrganizationType())) {
            if (accountNoDto.getBalance().compareTo(BigDecimal.ZERO) != 0) {
                throw new BizException("\u4f59\u989d\u4e0d\u4e3a\u7a7a\uff0c\u9700\u8981\u63d0\u73b0\u5b8c\u6bd5\u6216\u6d88\u8d39\u5b8c\u6bd5\u518d\u6ce8\u9500");
            }
            if (accountNoDto.getFrozen().compareTo(BigDecimal.ZERO) != 0) {
                throw new BizException("\u5728\u9014\u6b3e\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u5728\u9014\u6b3e\u5904\u7406\u5b8c\u6bd5\u540e\u6ce8\u9500");
            }
            if (accountNoDto.getRouteBalance().compareTo(BigDecimal.ZERO) != 0 || accountNoDto.getRouteFrozen().compareTo(BigDecimal.ZERO) != 0) {
                throw new BizException("\u5b58\u5728\u4e0d\u53ef\u63d0\u73b0\u91d1\u989d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u540e\u518d\u8fdb\u884c\u6ce8\u9500");
            }
            if (accountNoDto.getZxBalance() != null && BigDecimal.ZERO.compareTo(accountNoDto.getZxBalance()) != 0) {
                throw new BizException("\u4e2d\u4fe1\u767b\u8bb0\u7c3f\u4f59\u989d\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u63d0\u73b0\u540e\u518d\u884c\u6ce8\u9500");
            }
            this.logoutBank(relationEo.getId(), accountNoDto, SettleAccRegiStatusEnum.LOGOUT.getCode(), SettlementAccountStatusEnum.LOGOUT.getCode());
            resp.setResultMsg("\u6ce8\u9500\u6210\u529f\uff0c\u540e\u7eed\u5982\u9700\u4f7f\u7528\u94b1\u5305\u8bf7\u91cd\u65b0\u7533\u8bf7\u3002\u672a\u63d0\u73b0\u91d1\u989d\u4ecd\u53ef\u63d0\u73b0");
        } else {
            throw new BizException("[id=" + relationEo.getId() + "]\u767b\u8bb0\u7c3f\u7ec4\u7ec7\u7c7b\u578b\u53d1\u751f\u9519\u8bef");
        }
        return resp;
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public void logoutDealer() {
        SettlementAccountRegisterRelationEo searchEo = new SettlementAccountRegisterRelationEo();
        searchEo.setRegisterStatus(SettleAccRegiStatusEnum.OUTING.getCode());
        List relationEoList = this.settlementAccountRegisterRelationDas.selectList((BaseEo)searchEo);
        for (SettlementAccountRegisterRelationEo relationEo : relationEoList) {
            List<SettlementAccountZhongXingRespDto> accountList = this.settlementAccountService.queryZhongXinMoneyByAccountNo(relationEo.getAccountNo(), 1, 10);
            if (accountList != null && accountList.size() == 1) {
                SettlementAccountZhongXingRespDto accountNoDto = accountList.get(0);
                if (!SettleAccOrgTypeEnum.DEALER.getCode().equals(relationEo.getOrganizationType()) || accountNoDto.getBalance().compareTo(BigDecimal.ZERO) != 0 || accountNoDto.getFrozen().compareTo(BigDecimal.ZERO) != 0 || accountNoDto.getRouteBalance().compareTo(BigDecimal.ZERO) != 0 || accountNoDto.getRouteFrozen().compareTo(BigDecimal.ZERO) != 0 || BigDecimal.ZERO.compareTo(accountNoDto.getZxBalance() == null ? BigDecimal.ZERO : accountNoDto.getZxBalance()) != 0) continue;
                this.logoutBank(relationEo.getId(), accountNoDto, SettleAccRegiStatusEnum.LOGOUT.getCode(), SettlementAccountStatusEnum.LOGOUT.getCode());
                logger.warn("\u5927B\u6ce8\u9500\u5b9a\u65f6\u5668\uff1a\u7ed3\u7b97\u8d26\u6237" + relationEo.getAccountNo() + "\u6ce8\u9500\u6210\u529f");
                continue;
            }
            logger.warn("\u5927B\u6ce8\u9500\u5b9a\u65f6\u5668\uff1a\u7ed3\u7b97\u8d26\u6237" + relationEo.getAccountNo() + "\u6ce8\u9500\u5931\u8d25");
        }
    }

    private void logoutBank(Long relationId, SettlementAccountZhongXingRespDto accDto, String relationStatus, String accountStatus) {
        if (SettleAccRegiStatusEnum.LOGOUT.getCode().equals(relationStatus)) {
            CiticUserCancelReqDto reqDto = new CiticUserCancelReqDto();
            reqDto.setUserId(accDto.getBindAccountNo());
            reqDto.setUserNm(accDto.getAccountName());
            CiticUserCancelResDto cancelResDto = (CiticUserCancelResDto)RestResponseHelper.extractData((RestResponse)this.iCiticApi.userCancel(reqDto));
            if (!CiticRspCodeEnum.SUCCESS.key.equals(cancelResDto.getRspCode()) && !cancelResDto.getRspCode().equals("JU227")) {
                throw new BizException(cancelResDto.getRspCode(), cancelResDto.getRspMsg());
            }
        }
        SettlementAccountRegisterRelationEo updateRelationEo = new SettlementAccountRegisterRelationEo();
        updateRelationEo.setId(relationId);
        updateRelationEo.setRegisterStatus(relationStatus);
        updateRelationEo.setLogoutDate(new Date());
        updateRelationEo.setLogoutPerson((String)ServiceContext.getContext().getKeys().get("yes.req.userId"));
        int logoutNum = this.settlementAccountRegisterRelationDas.updateSelective((BaseEo)updateRelationEo);
        if (logoutNum == 0) {
            logger.warn("\u6ce8\u9500\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + updateRelationEo.toString());
            throw new BizException("\u6ce8\u9500\u8fdb\u4ef6\u8d26\u6237\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406");
        }
        SettlementAccountEo upSettAcEo = new SettlementAccountEo();
        upSettAcEo.setId(accDto.getId());
        upSettAcEo.setAccountStatus(accountStatus);
        logoutNum = this.settlementAccountDas.updateSelective((BaseEo)upSettAcEo);
        if (logoutNum == 0) {
            logger.warn("\u6ce8\u9500\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + upSettAcEo.toString());
            throw new BizException("\u6ce8\u9500\u7ed3\u7b97\u8d26\u6237\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406");
        }
    }

    @Override
    public SettlementAccountRegisterRespDto queryByRelationId(Long id) {
        SettlementAccountRegisterRespDto registerRespDto = new SettlementAccountRegisterRespDto();
        SettlementAccountRegisterRelationEo relationEo = (SettlementAccountRegisterRelationEo)this.settlementAccountRegisterRelationDas.selectByPrimaryKey(id);
        SettlementAccountRegisterRecordEo recordEo = this.recordMapper.queryMaxTimeByRelationId(id);
        DtoHelper.eo2Dto((BaseEo)recordEo, (BaseVo)registerRespDto);
        DtoHelper.eo2Dto((BaseEo)relationEo, (BaseVo)registerRespDto);
        if (registerRespDto != null && StringUtils.isNotEmpty((CharSequence)registerRespDto.getAccountNo())) {
            SettlementAccountRespDto accountRespDto = this.settlementAccountService.queryByAccountNo(registerRespDto.getAccountNo());
            registerRespDto.setAccountRespDto(accountRespDto);
        }
        return registerRespDto;
    }

    @Override
    public PageInfo<SettlementAccountRegisterRelationRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SettlementAccountRegisterRelationReqDto settlementAccountRegisterRelationReqDto = (SettlementAccountRegisterRelationReqDto)JSON.parseObject((String)filter, SettlementAccountRegisterRelationReqDto.class);
        SettlementAccountRegisterRelationEo settlementAccountRegisterRelationEo = new SettlementAccountRegisterRelationEo();
        DtoHelper.dto2Eo((BaseVo)settlementAccountRegisterRelationReqDto, (BaseEo)settlementAccountRegisterRelationEo);
        PageInfo eoPageInfo = this.settlementAccountRegisterRelationDas.selectPage((BaseEo)settlementAccountRegisterRelationEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SettlementAccountRegisterRelationRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public SettlementAccountRegisterRespDto queryByOrgId(SettlementAccountRegisterReqDto sReqDto) {
        SettlementAccountRegisterRespDto settleResult = null;
        SettlementAccountRegisterRelationEo searchRelationEo = new SettlementAccountRegisterRelationEo();
        SettlementAccountRegisterRelationEo resRelationEo = null;
        searchRelationEo.setRegisterStatus(SettleAccRegiStatusEnum.SUCCESS.getCode());
        searchRelationEo.setOrganizationType(sReqDto.getOrganizationType());
        if (SettleAccOrgTypeEnum.CUSTOMER.getCode().equals(sReqDto.getOrganizationType())) {
            if (sReqDto.getOrganizationId() != null) {
                searchRelationEo.setOrganizationId(sReqDto.getOrganizationId());
                resRelationEo = (SettlementAccountRegisterRelationEo)this.settlementAccountRegisterRelationDas.selectOne((BaseEo)searchRelationEo);
            }
        } else if (SettleAccOrgTypeEnum.DEALER.getCode().equals(sReqDto.getOrganizationType()) && StringUtils.isNotEmpty((CharSequence)sReqDto.getOrganizationCreditCode())) {
            searchRelationEo.setOrganizationCreditCode(sReqDto.getOrganizationCreditCode());
            List eoList = this.settlementAccountRegisterRelationDas.selectList((BaseEo)searchRelationEo);
            if (eoList.size() > 0) {
                if (SettleAccRegiBusLineEnum.ONLY.getCode().equals(((SettlementAccountRegisterRelationEo)eoList.get(0)).getBusnessLine())) {
                    resRelationEo = (SettlementAccountRegisterRelationEo)eoList.get(0);
                } else if (SettleAccRegiBusLineEnum.MANY.getCode().equals(((SettlementAccountRegisterRelationEo)eoList.get(0)).getBusnessLine())) {
                    for (SettlementAccountRegisterRelationEo fEo : eoList) {
                        if (!fEo.getOrganizationId().equals(sReqDto.getOrganizationId())) continue;
                        resRelationEo = fEo;
                    }
                }
            }
        }
        if (resRelationEo != null) {
            SettlementAccountRegisterRecordEo recordEo = this.recordMapper.queryMaxTimeByRelationId(resRelationEo.getId());
            settleResult = new SettlementAccountRegisterRespDto();
            DtoHelper.eo2Dto((BaseEo)recordEo, (BaseVo)settleResult);
            DtoHelper.eo2Dto((BaseEo)resRelationEo, (BaseVo)settleResult);
        }
        logger.info("\u83b7\u53d6\u4e2d\u4fe1\u8d26\u6237\u6ce8\u518c\u4fe1\u606f-\u8f93\u51fa:{}", settleResult);
        if (settleResult != null && StringUtils.isNotEmpty((CharSequence)settleResult.getAccountNo())) {
            SettlementAccountRespDto accountRespDto = this.settlementAccountService.queryByAccountNo(settleResult.getAccountNo());
            settleResult.setAccountRespDto(accountRespDto);
        }
        return settleResult;
    }

    @Override
    public PageInfo<SettlementAccountRegisterRespDto> queryByOrgIdBatch(List<SettlementAccountRegisterReqDto> sDtoList) {
        logger.info("\u83b7\u53d6\u4e2d\u4fe1\u8d26\u6237\u6ce8\u518c\u4fe1\u606f-\u7ec4\u7ec7id\u6279\u91cf-\u8f93\u5165:{}", (Object)JSON.toJSONString(sDtoList));
        ArrayList<SettlementAccountRegisterRespDto> settleList = new ArrayList<SettlementAccountRegisterRespDto>();
        for (SettlementAccountRegisterReqDto sDto : sDtoList) {
            SettlementAccountRegisterRespDto respDto = this.queryByOrgId(sDto);
            if (respDto == null) continue;
            settleList.add(respDto);
        }
        PageInfo info = new PageInfo(settleList);
        logger.info("\u83b7\u53d6\u4e2d\u4fe1\u8d26\u6237\u6ce8\u518c\u4fe1\u606f-\u7ec4\u7ec7id\u6279\u91cf-\u8f93\u51fa:{}", (Object)info);
        return info;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addSettlementAccountRegister(SettlementAccountRegisterReqDto sDto) {
        logger.info("\u4e2d\u4fe1\u8d26\u6237\u6ce8\u518c\u7533\u8bf7\u4fe1\u606f-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)sDto));
        SettlementAccountRegisterRespDto registerRespDto = this.queryByOrgId(sDto);
        if (registerRespDto != null && registerRespDto.getId() != null) {
            throw new BizException("\u5f53\u524d\u5df2\u5b58\u5728\u53ef\u7528\u94b1\u5305\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u7533\u8bf7\u65b0\u7684\u94b1\u5305\u8d26\u6237");
        }
        RestResponse result = new RestResponse();
        SettlementAccountRegisterRelationEo settlementRelationEo = new SettlementAccountRegisterRelationEo();
        SettlementAccountRegisterRecordEo registerRecordEo = new SettlementAccountRegisterRecordEo();
        CiticUserAddReqDto cDto = new CiticUserAddReqDto();
        SettlementAccountEo accountEo = new SettlementAccountEo();
        String accountNo = this.generAcNo(sDto);
        this.verifyAddData(sDto, settlementRelationEo, registerRecordEo, cDto, accountNo);
        RestResponse citicAddResp = this.iCiticApi.addUser(cDto);
        if (!"0".equals(citicAddResp.getResultCode())) {
            throw new BizException(citicAddResp.getResultCode(), citicAddResp.getResultMsg());
        }
        CiticUserAddResDto citicUserAddResDto = (CiticUserAddResDto)RestResponseHelper.extractData((RestResponse)citicAddResp);
        if (!citicUserAddResDto.getRspCode().equals(CiticRspCodeEnum.SUCCESS.key)) {
            throw new BizException(citicUserAddResDto.getRspCode(), citicUserAddResDto.getRspMsg());
        }
        String bind_account_no = ((CiticUserAddResDto)citicAddResp.getData()).getUserId();
        settlementRelationEo.setAccountNo(accountNo);
        settlementRelationEo.setBindAccountNo(bind_account_no);
        settlementRelationEo.setRegisterStatus(SettleAccRegiStatusEnum.SUCCESS.getCode());
        this.settlementAccountRegisterRelationDas.insert((BaseEo)settlementRelationEo);
        registerRecordEo.setRelationId(settlementRelationEo.getId());
        this.settlementAccountRegisterRecordDas.insert((BaseEo)registerRecordEo);
        this.createAccountNo(settlementRelationEo, registerRecordEo, accountEo);
        this.signAccountProtocol(sDto.getProtocolId(), settlementRelationEo.getId());
        result.setData((Object)settlementRelationEo.getId());
        logger.info("\u4e2d\u4fe1\u8d26\u6237\u6ce8\u518c\u7533\u8bf7\u4fe1\u606f-\u8f93\u51fa:{}", (Object)result);
        return result;
    }

    private void signAccountProtocol(Long protocolId, Long businessId) {
        ProtocolSignEo protocolSignEo = new ProtocolSignEo();
        protocolSignEo.setProtocolId(protocolId);
        String userId = (String)ServiceContext.getContext().getKeys().get("yes.req.userId");
        EmployeeRespDto employeeRespDto = (EmployeeRespDto)RestResponseHelper.extractData((RestResponse)this.employeeQueryApi.queryByUserId());
        protocolSignEo.setSignUserId(userId);
        if (employeeRespDto != null) {
            protocolSignEo.setSignPersonName(employeeRespDto.getName());
        }
        protocolSignEo.setSignTime(new Date());
        protocolSignEo.setIsAgree(Boolean.valueOf(true));
        protocolSignEo.setBusinessType(ProtocolTypeEnum.YHXY.getCode());
        protocolSignEo.setBusinessId(businessId);
        this.protocolSignDas.insert((BaseEo)protocolSignEo);
    }

    private void createAccountNo(SettlementAccountRegisterRelationEo sRelationEo, SettlementAccountRegisterRecordEo recordEo, SettlementAccountEo accountEo) {
        accountEo.setAccountNo(sRelationEo.getAccountNo());
        accountEo.setAccountName(recordEo.getRegisterName().trim());
        accountEo.setAccountType(recordEo.getRegisterType().toString());
        accountEo.setBindAccountNo(sRelationEo.getBindAccountNo());
        accountEo.setAccountStatus(SettlementAccountStatusEnum.ENABLED.getCode());
        accountEo.setBalance(new BigDecimal(0));
        accountEo.setFrozen(new BigDecimal(0));
        accountEo.setRouteFrozen(new BigDecimal(0));
        accountEo.setRouteBalance(new BigDecimal(0));
        accountEo.setCreatePerson(ServiceContext.getContext().getRequestUserIdString());
        accountEo.setUpdatePerson(ServiceContext.getContext().getRequestUserIdString());
        this.settlementAccountDas.insert((BaseEo)accountEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Integer> modifySettlementAccountRegister(SettlementAccountRegisterReqDto sDto) {
        Pattern pattern;
        logger.info("\u4e2d\u4fe1\u8d26\u6237\u8d44\u6599\u4fee\u6539\u7533\u8bf7\u4fe1\u606f-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)sDto));
        if (sDto.getId() == null) {
            throw new BizException("\u4e0d\u5b58\u5728\u8be5\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
        }
        SettlementAccountRegisterRespDto relationEo = this.queryById(sDto.getId());
        if (relationEo == null) {
            throw new BizException("\u4e0d\u5b58\u5728\u8be5\u6570\u636e\uff0c\u65e0\u6cd5\u4fee\u6539");
        }
        if (!SettleAccRegiStatusEnum.SUCCESS.getCode().equals(relationEo.getRegisterStatus())) {
            throw new BizException("\u8be5\u767b\u8bb0\u7c3f\u975e\u6709\u6548\u72b6\u6001\uff0c\u65e0\u6cd5\u4fee\u6539");
        }
        SettlementAccountRegisterRecordEo hisEo = this.recordMapper.queryMaxTimeByRelationId(sDto.getId());
        if (StringUtils.isEmpty((CharSequence)sDto.getRegisterName())) {
            throw new BizException("\u65b0\u586b\u5199\u4f01\u4e1a/\u4e2a\u4eba\u540d\u79f0\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        }
        if (!sDto.getRegisterName().trim().equals(hisEo.getRegisterName())) {
            SettlementAccountBindCardEo searchBindCardEo = new SettlementAccountBindCardEo();
            searchBindCardEo.setAccountNo(relationEo.getAccountNo());
            searchBindCardEo.setBindStatus(SettleAccBindCardStatusEnum.SUCCESS.getCode());
            List isExistBindEoList = this.bindCardDas.selectList((BaseEo)searchBindCardEo);
            if (isExistBindEoList != null && isExistBindEoList.size() > 0) {
                throw new BizException("\u7cfb\u7edf\u68c0\u6d4b\u5230\u5f53\u524d\u7ed3\u7b97\u8d26\u6237\u6ce8\u518c\u540d\u79f0\u53d1\u751f\u53d8\u5316\uff0c\u5e76\u5df2\u7ed1\u5b9a\u94f6\u884c\u5361\u53f7\uff0c\u8bf7\u5148\u89e3\u7ed1\u94f6\u884c\u5361\u540e\u63d0\u4ea4\u4fee\u6539\u8d44\u6599");
            }
        }
        SettlementAccountRegisterRecordEo srEo = new SettlementAccountRegisterRecordEo();
        if (CiticUserTypeEnum.PERSONAL.getKey().equals(sDto.getRegisterType().toString())) {
            if (StringUtils.isEmpty((CharSequence)sDto.getPhone())) {
                throw new BizException("\u7c7b\u578b\u4e3a\u4e2a\u4eba\u65f6\uff0c\u624b\u673a\u53f7\u5fc5\u586b");
            }
            srEo.setCardType(sDto.getCardType());
            srEo.setCardCode(sDto.getCardCode());
        } else {
            if (StringUtils.isEmpty((CharSequence)sDto.getLegalName())) {
                throw new BizException("\u4f01\u4e1a\u6cd5\u4eba\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
            }
            if (StringUtils.isEmpty((CharSequence)sDto.getLegalIdCard())) {
                throw new BizException("\u4f01\u4e1a\u6cd5\u4eba\u8eab\u4efd\u8bc1\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
            }
            srEo.setCardType(hisEo.getCardType());
            srEo.setCardCode(hisEo.getCardCode());
            if (!CiticUserIdTypeEnum.SOCIAL_CREDIT_CODE.getKey().equals(srEo.getCardType()) && !CiticUserIdTypeEnum.BUSINESS_LICENSE_NO.getKey().equals(srEo.getCardType())) {
                throw new BizException("\u6ce8\u518c\u7c7b\u578b\u4e3a\u4f01\u4e1a\u6216\u4e2a\u4f53\u5de5\u5546\u6237\u7684\u8bc1\u4ef6\u7c7b\u578b\u53ea\u80fd\u4e3a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801");
            }
            if (!(!CiticUserTypeEnum.INDIVIDUAL_BUSINESS.getKey().equals(hisEo.getRegisterType().toString()) || hisEo.getLegalName().equals(sDto.getLegalName()) && hisEo.getLegalIdCard().equals(sDto.getLegalIdCard()))) {
                SettlementAccountBindCardEo bindCardEo = new SettlementAccountBindCardEo();
                bindCardEo.setAccountNo(relationEo.getAccountNo());
                bindCardEo.setBindStatus(SettleAccBindCardStatusEnum.SUCCESS.getCode());
                for (String bankType : CiticBankTypeEnum.providePerson().keySet()) {
                    bindCardEo.setBankType(bankType);
                    if (this.bindCardDas.selectList((BaseEo)bindCardEo).size() <= 0) continue;
                    throw new BizException("\u6cd5\u4eba\u4fe1\u606f\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5148\u89e3\u7ed1\u5bf9\u79c1\u94f6\u884c\u8d26\u6237");
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)sDto.getPhone()) && !(pattern = Pattern.compile("[1]\\d{10}$")).matcher(sDto.getPhone()).matches()) {
            throw new BizException("\u8bf7\u586b\u519911\u4f4d\u6b63\u786e\u624b\u673a\u53f7\u7801");
        }
        String user = (String)ServiceContext.getContext().getKeys().get("yes.req.userId");
        srEo.setRegisterName(sDto.getRegisterName().trim());
        srEo.setLegalName(sDto.getLegalName());
        srEo.setLegalIdCard(sDto.getLegalIdCard());
        srEo.setPhone(sDto.getPhone());
        srEo.setRelationId(sDto.getRelationId());
        srEo.setRegisterType(sDto.getRegisterType());
        srEo.setCreatePerson(user);
        srEo.setUpdatePerson(user);
        CiticUserModifyReqDto cuModifyDto = new CiticUserModifyReqDto();
        cuModifyDto.setUserId(relationEo.getBindAccountNo());
        cuModifyDto.setUserNm(srEo.getRegisterName().trim());
        cuModifyDto.setUserRole(SettleAccOrgTypeEnum.DEALER.getCode().equals(relationEo.getOrganizationType()) ? CiticUserRoleEnum.SELLER_USER.key : CiticUserRoleEnum.TRADE_USER.key);
        cuModifyDto.setUserCardTp(srEo.getCardType());
        cuModifyDto.setUserCardNo(srEo.getCardCode());
        cuModifyDto.setUserPhone(srEo.getPhone());
        cuModifyDto.setCorpNm(srEo.getLegalName());
        cuModifyDto.setCorpIdType(srEo.getLegalIdCard());
        RestResponse citicResp = this.iCiticApi.modifyUser(cuModifyDto);
        if (!"0".equals(citicResp.getResultCode())) {
            throw new BizException(citicResp.getResultCode(), citicResp.getResultMsg());
        }
        if (!((CiticResDto)citicResp.getData()).getRspCode().equals(CiticRspCodeEnum.SUCCESS.key)) {
            throw new BizException(((CiticResDto)citicResp.getData()).getRspCode(), ((CiticResDto)citicResp.getData()).getRspMsg());
        }
        int num = this.settlementAccountRegisterRecordDas.insert((BaseEo)srEo);
        RestResponse response = new RestResponse((Object)num);
        if (num > 0 && !sDto.getRegisterName().equals(hisEo.getRegisterName())) {
            SettlementAccountEo searchEo = new SettlementAccountEo();
            searchEo.setAccountNo(relationEo.getAccountNo());
            SettlementAccountEo resultEo = (SettlementAccountEo)this.settlementAccountDas.selectOne((BaseEo)searchEo);
            if (resultEo != null && resultEo.getId() != null) {
                SettlementAccountEo updateEo = new SettlementAccountEo();
                updateEo.setId(resultEo.getId());
                updateEo.setAccountName(sDto.getRegisterName());
                this.settlementAccountDas.updateSelective((BaseEo)updateEo);
                response.setResultCode("0");
                response.setResultMsg("success");
            }
        }
        logger.info("\u4e2d\u4fe1\u8d26\u6237\u8d44\u6599\u4fee\u6539\u7533\u8bf7\u4fe1\u606f-\u8f93\u51fa\u4fee\u6539\u6210\u529f\u6570\u91cf\u4e3a:{}", (Object)num);
        return response;
    }

    private void verifyAddData(SettlementAccountRegisterReqDto reqDto, SettlementAccountRegisterRelationEo relationEo, SettlementAccountRegisterRecordEo recordEo, CiticUserAddReqDto cDto, String accountNo) {
        if (!ObjectUtils.isEmpty((Object)this.queryByOrgId(reqDto))) {
            throw new BizException("45000001", "\u5f53\u524d\u7ec4\u7ec7\u5df2\u5b58\u5728\u8fdb\u4ef6\u8d26\u6237\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7");
        }
        if (ObjectUtils.isEmpty((Object)reqDto.getOrganizationType())) {
            throw new BizException("45000003", "\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqDto.getOrganizationId())) {
            throw new BizException("45000018", "\u7ec4\u7ec7ID\u4e3a\u7a7a");
        }
        if (SettleAccOrgTypeEnum.DEALER.getCode().equals(reqDto.getOrganizationType())) {
            if (StringUtils.isEmpty((CharSequence)reqDto.getBusnessLine())) {
                throw new BizException("45000004", "\u5927B\u7ec4\u7ec7\u7684\u4e1a\u52a1\u7ebf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!reqDto.getBusnessLine().equals(SettleAccRegiBusLineEnum.ONLY.getCode()) && !reqDto.getBusnessLine().equals(SettleAccRegiBusLineEnum.MANY.getCode())) {
                throw new BizException("45000014", "\u4e1a\u52a1\u7ebf\u7c7b\u578b\u503c\u6709\u8bef");
            }
            relationEo.setBusnessLine(reqDto.getBusnessLine());
            if (!CiticUserTypeEnum.CORP.getKey().equals(reqDto.getRegisterType().toString())) {
                throw new BizException("45000013", "\u5927B\u6ce8\u518c\u7c7b\u578b\u53ea\u80fd\u4e3a\u4f01\u4e1a");
            }
            SettlementAccountRegisterRelationEo searchEo = new SettlementAccountRegisterRelationEo();
            searchEo.setRegisterStatus(SettleAccRegiStatusEnum.SUCCESS.getCode());
            searchEo.setBusnessLine(SettleAccRegiBusLineEnum.MANY.getCode());
            searchEo.setOrganizationCreditCode(reqDto.getOrganizationCreditCode());
            SettlementAccountRegisterRelationEo resEo = (SettlementAccountRegisterRelationEo)this.settlementAccountRegisterRelationDas.selectOne((BaseEo)searchEo);
            if (resEo != null && reqDto.getBusnessLine().equals(SettleAccRegiBusLineEnum.ONLY.getCode())) {
                throw new BizException("4500023", "\u8bf7\u9009\u62e9\u591a\u4e1a\u52a1\u7ebf");
            }
        }
        if (ObjectUtils.isEmpty((Object)reqDto.getRegisterType())) {
            throw new BizException("45000005", "\u6ce8\u518c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CiticUserTypeEnum.PERSONAL.getKey().equals(reqDto.getRegisterType().toString())) {
            throw new BizException("45000105", "\u6ce8\u518c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u4e2a\u4eba");
        }
        if (ObjectUtils.isEmpty((Object)reqDto.getRegisterName())) {
            throw new BizException("45000011", "\u4f01\u4e1a/\u4e2a\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u82e5\u6ce8\u518c\u7c7b\u578b\u4e3a\u4f01\u4e1a/\u4e2a\u4f53\u5de5\u5546\u6237\u7c7b\u578b\uff0c\u8bf7\u5728\u7ef4\u62a4\u6863\u6848\u4fe1\u606f\u540e\u518d\u7533\u8bf7\u8fdb\u4ef6");
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getCardType())) {
            throw new BizException("45000006", "\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getCardCode())) {
            throw new BizException("45000007", "\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CiticUserTypeEnum.PERSONAL.getKey().equals(reqDto.getRegisterType().toString())) {
            if (StringUtils.isEmpty((CharSequence)reqDto.getPhone())) {
                throw new BizException("\u7c7b\u578b\u4e3a\u4e2a\u4eba\u65f6\uff0c\u624b\u673a\u53f7\u5fc5\u586b");
            }
            Pattern pattern = Pattern.compile("[1]\\d{10}$");
            if (!pattern.matcher(reqDto.getPhone()).matches()) {
                throw new BizException("\u8bf7\u586b\u519911\u4f4d\u6b63\u786e\u624b\u673a\u53f7\u7801");
            }
        } else {
            if (StringUtils.isEmpty((CharSequence)reqDto.getLegalName())) {
                throw new BizException("45000009", "\u4f01\u4e1a\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u7ef4\u62a4\u6863\u6848\u4fe1\u606f\u540e\u518d\u7533\u8bf7\u8fdb\u4ef6");
            }
            if (StringUtils.isEmpty((CharSequence)reqDto.getLegalIdCard())) {
                throw new BizException("45000010", "\u6cd5\u4eba\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u7ef4\u62a4\u6863\u6848\u4fe1\u606f\u540e\u518d\u7533\u8bf7\u8fdb\u4ef6");
            }
            if (StringUtils.isEmpty((CharSequence)reqDto.getOrganizationCreditCode())) {
                throw new BizException("45000002", "\u6ce8\u518c\u7c7b\u578b\u4e3a\u4f01\u4e1a\u548c\u4e2a\u4f53\u5de5\u5546\u6237\u65f6\uff0c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5728\u7ef4\u62a4\u6863\u6848\u4fe1\u606f\u540e\u518d\u7533\u8bf7\u8fdb\u4ef6");
            }
            if (!CiticUserIdTypeEnum.SOCIAL_CREDIT_CODE.getKey().equals(reqDto.getCardType())) {
                throw new BizException("\u6ce8\u518c\u7c7b\u578b\u4e3a\u4f01\u4e1a\u6216\u4e2a\u4f53\u5de5\u5546\u6237\u7684\u8bc1\u4ef6\u7c7b\u578b\u53ea\u80fd\u4e3a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801");
            }
        }
        if (ObjectUtils.isEmpty((Object)reqDto.getIsAgree())) {
            throw new BizException("45000020", "\u8bf7\u52fe\u9009\u540c\u610f\u534f\u8bae");
        }
        if (reqDto.getIsAgree() != 1) {
            throw new BizException("45000021", "\u8bf7\u540c\u610f\u534f\u8bae");
        }
        if (ObjectUtils.isEmpty((Object)reqDto.getProtocolId())) {
            throw new BizException("45000022", "\u534f\u8bae\u5185\u5bb9\u4e3a\u7a7a");
        }
        String user = (String)ServiceContext.getContext().getKeys().get("yes.req.userId");
        relationEo.setOrganizationType(reqDto.getOrganizationType());
        relationEo.setOrganizationCreditCode(reqDto.getOrganizationCreditCode());
        relationEo.setRegisterStatus(SettleAccRegiStatusEnum.ACCEPT.getCode());
        relationEo.setOrganizationId(reqDto.getOrganizationId());
        relationEo.setOperator(user);
        relationEo.setCreatePerson(user);
        relationEo.setUpdatePerson(user);
        if (reqDto.getOperateType() != null && reqDto.getOperateType().equals(OperateTypeEnum.OTHER.getCode())) {
            relationEo.setOperateType(reqDto.getOperateType());
        }
        recordEo.setRegisterType(reqDto.getRegisterType());
        recordEo.setRegisterName(reqDto.getRegisterName().trim());
        recordEo.setCardType(reqDto.getCardType());
        recordEo.setCardCode(reqDto.getCardCode());
        recordEo.setPhone(StringUtils.isEmpty((CharSequence)reqDto.getPhone()) ? "" : reqDto.getPhone());
        recordEo.setCreatePerson(user);
        recordEo.setUpdatePerson(user);
        if (!CiticUserTypeEnum.PERSONAL.getKey().equals(reqDto.getRegisterType().toString())) {
            recordEo.setLegalName(reqDto.getLegalName());
            recordEo.setLegalIdCard(reqDto.getLegalIdCard());
            cDto.setCorpNm(reqDto.getLegalName());
            cDto.setCorpIdNo(reqDto.getLegalIdCard());
        }
        cDto.setMchntUserId(accountNo);
        cDto.setUserType(reqDto.getRegisterType().toString());
        cDto.setUserNm(reqDto.getRegisterName().trim());
        if (SettleAccOrgTypeEnum.DEALER.getCode().equals(reqDto.getOrganizationType())) {
            cDto.setUserRole(CiticUserRoleEnum.SELLER_USER.key);
        } else if (SettleAccOrgTypeEnum.CUSTOMER.getCode().equals(reqDto.getOrganizationType())) {
            cDto.setUserRole(CiticUserRoleEnum.TRADE_USER.key);
        }
        cDto.setUserIdType(reqDto.getCardType());
        cDto.setUserIdNo(reqDto.getCardCode());
        cDto.setUserPhone(reqDto.getPhone());
    }

    private synchronized String generAcNo(SettlementAccountRegisterReqDto sDto) {
        Long orgId = sDto.getOrganizationId();
        int waterNo = this.settlementAccountRegisterRelationMapper.queryOrgIdNum(orgId) + 1;
        return orgId.toString() + String.format("%03d", waterNo);
    }

    @Override
    public List<SettlementAccountRegisterRespDto> querySettAccoList(SettlementAccountRegisterReqDto sReqDto) {
        ArrayList<SettlementAccountRegisterRespDto> respDtoList = new ArrayList<SettlementAccountRegisterRespDto>();
        List<SettlementAccountRegisterRelationEo> eoList = null;
        SettlementAccountRegisterRelationEo searchRelationEo = new SettlementAccountRegisterRelationEo();
        searchRelationEo.setOrganizationType(sReqDto.getOrganizationType());
        if (SettleAccOrgTypeEnum.CUSTOMER.getCode().equals(sReqDto.getOrganizationType())) {
            if (sReqDto.getOrganizationId() != null) {
                searchRelationEo.setOrganizationId(sReqDto.getOrganizationId());
                eoList = this.settlementAccountRegisterRelationDas.selectList((BaseEo)searchRelationEo, Integer.valueOf(1), Integer.valueOf(9999));
            }
        } else if (SettleAccOrgTypeEnum.DEALER.getCode().equals(sReqDto.getOrganizationType()) && StringUtils.isNotEmpty((CharSequence)sReqDto.getOrganizationCreditCode())) {
            eoList = new ArrayList();
            searchRelationEo.setOrganizationCreditCode(sReqDto.getOrganizationCreditCode());
            List dealerList = this.settlementAccountRegisterRelationDas.selectList((BaseEo)searchRelationEo, Integer.valueOf(1), Integer.valueOf(9999));
            for (SettlementAccountRegisterRelationEo eo : dealerList) {
                if (SettleAccRegiBusLineEnum.ONLY.getCode().equals(eo.getBusnessLine())) {
                    eoList.add(eo);
                    continue;
                }
                if (!SettleAccRegiBusLineEnum.MANY.getCode().equals(eo.getBusnessLine()) || !eo.getOrganizationId().equals(sReqDto.getOrganizationId())) continue;
                eoList.add(eo);
            }
        }
        if (eoList == null) {
            throw new BizException("\u5f53\u524d\u673a\u6784\u672a\u586b\u5199\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\uff0c\u65e0\u6cd5\u67e5\u8be2\u94b1\u5305\u8d26\u6237");
        }
        Collections.sort(eoList, new Comparator<SettlementAccountRegisterRelationEo>(){

            @Override
            public int compare(SettlementAccountRegisterRelationEo o1, SettlementAccountRegisterRelationEo o2) {
                return o2.getCreateTime().compareTo(o1.getCreateTime());
            }
        });
        for (SettlementAccountRegisterRelationEo relationEo : eoList) {
            SettlementAccountRegisterRecordEo recordEo = this.recordMapper.queryMaxTimeByRelationId(relationEo.getId());
            SettlementAccountRegisterRespDto respDto = new SettlementAccountRegisterRespDto();
            DtoHelper.eo2Dto((BaseEo)recordEo, (BaseVo)respDto);
            DtoHelper.eo2Dto((BaseEo)relationEo, (BaseVo)respDto);
            if (respDto != null && StringUtils.isNotEmpty((CharSequence)respDto.getAccountNo())) {
                SettlementAccountRespDto accountRespDto = this.settlementAccountService.queryByAccountNo(respDto.getAccountNo());
                respDto.setAccountRespDto(accountRespDto);
            }
            respDtoList.add(respDto);
        }
        return respDtoList;
    }
}

