/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICiticApi;
import com.dtyunxi.tcbj.api.dto.response.CiticUserBalanceQueryResDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticRspCodeEnum;
import com.dtyunxi.tcbj.api.query.ICiticQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.PoundageAgencyEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.DepositBalanceReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.FlowVo;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.ReexchangeReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountZhongXingRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountPasswordService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IWithdrawBalanceService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountBindCardDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SettlementAccountServiceImpl
implements ISettlementAccountService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String LOCK_KEY = "settlement:withdrawBalance";
    @Resource
    private SettlementAccountDas settlementAccountDas;
    @Resource
    private SettlementAccountBindCardDas bindCardDas;
    @Resource
    private ISettlementAccountPasswordService passwordService;
    @Resource
    private IWithdrawBalanceService withdrawBalanceService;
    @Resource
    private ILockService lockService;
    @Resource
    private ICiticApi citicApi;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICiticQueryApi citicQueryApi;

    @Override
    public Long addSettlementAccount(SettlementAccountReqDto addReqDto) {
        SettlementAccountEo settlementAccountEo = new SettlementAccountEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)settlementAccountEo);
        this.settlementAccountDas.insert((BaseEo)settlementAccountEo);
        return settlementAccountEo.getId();
    }

    @Override
    public void modifySettlementAccount(SettlementAccountReqDto modifyReqDto) {
        SettlementAccountEo settlementAccountEo = new SettlementAccountEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)settlementAccountEo);
        this.settlementAccountDas.updateSelective((BaseEo)settlementAccountEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSettlementAccount(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.settlementAccountDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SettlementAccountRespDto queryById(Long id) {
        SettlementAccountEo settlementAccountEo = (SettlementAccountEo)this.settlementAccountDas.selectByPrimaryKey(id);
        SettlementAccountRespDto settlementAccountRespDto = new SettlementAccountRespDto();
        DtoHelper.eo2Dto((BaseEo)settlementAccountEo, (BaseVo)settlementAccountRespDto);
        return settlementAccountRespDto;
    }

    @Override
    public PageInfo<SettlementAccountRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SettlementAccountReqDto settlementAccountReqDto = (SettlementAccountReqDto)JSON.parseObject((String)filter, SettlementAccountReqDto.class);
        SettlementAccountEo settlementAccountEo = new SettlementAccountEo();
        DtoHelper.dto2Eo((BaseVo)settlementAccountReqDto, (BaseEo)settlementAccountEo);
        PageInfo eoPageInfo = this.settlementAccountDas.selectPage((BaseEo)settlementAccountEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SettlementAccountRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public SettlementAccountRespDto queryByAccountNo(String accountNo) {
        SettlementAccountEo settlementAccountEo = new SettlementAccountEo();
        settlementAccountEo.setAccountNo(accountNo);
        SettlementAccountEo accountEo = (SettlementAccountEo)this.settlementAccountDas.selectOne((BaseEo)settlementAccountEo);
        SettlementAccountRespDto settlementAccountRespDto = new SettlementAccountRespDto();
        DtoHelper.eo2Dto((BaseEo)accountEo, (BaseVo)settlementAccountRespDto);
        settlementAccountRespDto.setRemainBalance(settlementAccountRespDto.getBalance().subtract(settlementAccountRespDto.getRouteBalance()));
        return settlementAccountRespDto;
    }

    @Override
    public void depositBalance(DepositBalanceReqDto reqDto) {
        throw new BizException("\u63d0\u73b0\u529f\u80fd\u6682\u4e0d\u53ef\u7528");
    }

    @Override
    public void reexchangeBalance(ReexchangeReqDto reqDto) {
        AssertUtils.notBlank((String)reqDto.getOptTradeNo(), (String)"\u539f\u63d0\u73b0\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TradeSettlementFlowEo tradeSettlementFlowQueryEo = new TradeSettlementFlowEo();
        tradeSettlementFlowQueryEo.setOptTradeNo(reqDto.getOptTradeNo());
        tradeSettlementFlowQueryEo.setTradeType(SettlementFlowTradeTypeEnum.WITHDRAW.getCode());
        TradeSettlementFlowEo tradeSettlementFlowEo = (TradeSettlementFlowEo)this.tradeSettlementFlowDas.selectOne((BaseEo)tradeSettlementFlowQueryEo);
        AssertUtils.notNull((Object)tradeSettlementFlowEo, (String)String.format("\u63d0\u73b0\u6d41\u6c34\u53f7\uff08%s\uff09\u4e0d\u5b58\u5728", reqDto.getOptTradeNo()));
        if (!SettlementAccountFlowStatusEnum.SUCCESS.getCode().equals(tradeSettlementFlowEo.getTradeStatus())) {
            this.logger.error("\u3010\u9000\u6c47\u3011\u9000\u6c47\u5f02\u5e38\uff0c\u63d0\u73b0\u6d41\u6c34\u5e76\u672a\u5c5e\u4e8e\u5b8c\u6210\u72b6\u6001\u3002\u63d0\u73b0\u6d41\u6c34\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)tradeSettlementFlowEo));
            throw SettlementExceptionCode.REEXCHANGE_BALANCE_FAIL.getException();
        }
        if (!tradeSettlementFlowEo.getLaunchTradeAmount().equals(reqDto.getTradeAmount())) {
            this.logger.error("\u3010\u9000\u6c47\u3011\u9000\u6c47\u5f02\u5e38\uff0c\u63d0\u73b0\u91d1\u989d\u4e0e\u9000\u6c47\u91d1\u989d\u4e0d\u4e00\u81f4\u3002\u9000\u6c47\u91d1\u989d\u4e3a\uff1a{}\uff0c\u63d0\u73b0\u6d41\u6c34\u4fe1\u606f\uff1a{}", (Object)reqDto.getTradeAmount(), (Object)JSON.toJSONString((Object)tradeSettlementFlowEo));
            throw SettlementExceptionCode.REEXCHANGE_BALANCE_FAIL.getException();
        }
        String tradeNo = TradeUtil.generateTradeFlowNo(SettlementFlowTradeTypeEnum.WITHDRAW_RETURN.getCode());
        FlowVo flowVo = new FlowVo();
        flowVo.setOptTradeNo(tradeNo);
        flowVo.setAccountNo(tradeSettlementFlowEo.getOptAccountNo());
        flowVo.setBalance(reqDto.getTradeAmount());
        this.withdrawBalanceService.reexchangeBalance(flowVo);
    }

    @Override
    public List<SettlementAccountRespDto> queryListByBindNo(List<String> bindAccountNoList) {
        if (CollectionUtil.isEmpty(bindAccountNoList)) {
            return new ArrayList<SettlementAccountRespDto>();
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"bind_account_no", bindAccountNoList));
        SettlementAccountEo paramEo = new SettlementAccountEo();
        paramEo.setSqlFilters(sqlFilters);
        List select = this.settlementAccountDas.select((BaseEo)paramEo);
        ArrayList<SettlementAccountRespDto> list = new ArrayList<SettlementAccountRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, list, SettlementAccountRespDto.class);
        return list;
    }

    @Override
    public List<SettlementAccountZhongXingRespDto> queryZhongXinMoneyByAccountNo(String accountNo, Integer pageNum, Integer pageSize) {
        ArrayList<SettlementAccountZhongXingRespDto> list = new ArrayList<SettlementAccountZhongXingRespDto>();
        if (StringUtils.isNotEmpty((CharSequence)accountNo)) {
            SettlementAccountRespDto scRespDto = this.queryByAccountNo(accountNo);
            SettlementAccountZhongXingRespDto zxRespDto = new SettlementAccountZhongXingRespDto();
            CubeBeanUtils.copyProperties((Object)zxRespDto, (Object)scRespDto, (String[])new String[0]);
            if (zxRespDto.getId() == null) {
                zxRespDto.setAccountNo(accountNo);
                zxRespDto.setRemark("\u65e0\u8d26\u53f7\u8bf7\u6ce8\u610f");
            } else {
                this.calculate(zxRespDto);
                list.add(zxRespDto);
            }
        } else {
            SettlementAccountEo settEo = new SettlementAccountEo();
            List accountRespDtos = this.settlementAccountDas.selectList((BaseEo)settEo, pageNum, pageSize);
            for (SettlementAccountEo eo : accountRespDtos) {
                SettlementAccountZhongXingRespDto zhongXingRespDto = new SettlementAccountZhongXingRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)zhongXingRespDto);
                this.calculate(zhongXingRespDto);
                list.add(zhongXingRespDto);
            }
        }
        return list;
    }

    private void calculate(SettlementAccountZhongXingRespDto zxRespDto) {
        try {
            RestResponse cuqResp = this.citicQueryApi.queryUserBalance(zxRespDto.getBindAccountNo());
            CiticUserBalanceQueryResDto cubqDto = (CiticUserBalanceQueryResDto)RestResponseHelper.extractData((RestResponse)cuqResp);
            if (CiticRspCodeEnum.SUCCESS.key.equals(cubqDto.getRspCode())) {
                zxRespDto.setZxBalance(cubqDto.getAmount());
                BigDecimal diffBalance = zxRespDto.getBalance().subtract(cubqDto.getAmount());
                zxRespDto.setDiffBalance(diffBalance);
                int diffResult = zxRespDto.getBalance().compareTo(cubqDto.getAmount());
                if (diffResult == 0) {
                    zxRespDto.setCompareResult("\u4f59\u989d\u76f8\u7b49");
                } else if (diffResult > 0) {
                    zxRespDto.setCompareResult("\u4e2d\u53f0\u4f59\u989d > \u4e2d\u4fe1\u4f59\u989d");
                } else {
                    zxRespDto.setCompareResult("\u4e2d\u53f0\u4f59\u989d < \u4e2d\u4fe1\u4f59\u989d");
                }
                zxRespDto.setRemainBalance(zxRespDto.getBalance().subtract(zxRespDto.getRouteBalance()));
            } else {
                zxRespDto.setRemark(cubqDto.getRspMsg());
                if (cubqDto.getRspCode().equals("ME001")) {
                    zxRespDto.setCompareResult("\u4e2d\u4fe1\u767b\u8bb0\u7c3f\u8d26\u6237\u4e0d\u5b58\u5728");
                } else {
                    zxRespDto.setCompareResult("\u4f59\u989d\u5bf9\u6bd4\u5931\u8d25");
                }
            }
        }
        catch (BizException e) {
            zxRespDto.setRemark(e.getMessage());
            if (e.getCode().equals("ME001")) {
                zxRespDto.setCompareResult("\u4e2d\u4fe1\u767b\u8bb0\u7c3f\u8d26\u6237\u4e0d\u5b58\u5728");
            }
            zxRespDto.setCompareResult("\u4f59\u989d\u5bf9\u6bd4\u5931\u8d25");
        }
    }

    @Override
    public void modifyPoundageAgency(Long id, Integer poundageAgency) {
        if ("".equals(PoundageAgencyEnum.getName((Integer)poundageAgency))) {
            throw new BizException("\u4fee\u6539\u624b\u7eed\u8d39\u627f\u62c5\u65b9\u5931\u8d25\uff0c\u503c\u5fc5\u987b\u4e3a\u5546\u5bb6\u6216\u4e70\u5bb6");
        }
        SettlementAccountEo upEo = new SettlementAccountEo();
        upEo.setId(id);
        upEo.setPoundageAgency(poundageAgency);
        this.settlementAccountDas.updateSelective((BaseEo)upEo);
    }
}

