/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TradeSettlementFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TradeSettlementFlowServiceImpl
implements ITradeSettlementFlowService {
    private static final Logger logger = LoggerFactory.getLogger(TradeSettlementFlowServiceImpl.class);
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;

    @Override
    public Long addTradeSettlementFlow(TradeSettlementFlowReqDto addReqDto) {
        TradeSettlementFlowEo tradeSettlementFlowEo = new TradeSettlementFlowEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)tradeSettlementFlowEo);
        this.tradeSettlementFlowDas.insert((BaseEo)tradeSettlementFlowEo);
        return tradeSettlementFlowEo.getId();
    }

    @Override
    public void modifyTradeSettlementFlow(TradeSettlementFlowReqDto modifyReqDto) {
        TradeSettlementFlowEo tradeSettlementFlowEo = new TradeSettlementFlowEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)tradeSettlementFlowEo);
        this.tradeSettlementFlowDas.updateSelective((BaseEo)tradeSettlementFlowEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTradeSettlementFlow(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.tradeSettlementFlowDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public TradeSettlementFlowRespDto queryById(Long id) {
        TradeSettlementFlowEo tradeSettlementFlowEo = (TradeSettlementFlowEo)this.tradeSettlementFlowDas.selectByPrimaryKey(id);
        TradeSettlementFlowRespDto tradeSettlementFlowRespDto = new TradeSettlementFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)tradeSettlementFlowEo, (BaseVo)tradeSettlementFlowRespDto);
        return tradeSettlementFlowRespDto;
    }

    @Override
    public PageInfo<TradeSettlementFlowRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        TradeSettlementFlowReqDto tradeSettlementFlowReqDto = (TradeSettlementFlowReqDto)JSON.parseObject((String)filter, TradeSettlementFlowReqDto.class);
        TradeSettlementFlowEo tradeSettlementFlowEo = new TradeSettlementFlowEo();
        DtoHelper.dto2Eo((BaseVo)tradeSettlementFlowReqDto, (BaseEo)tradeSettlementFlowEo);
        PageInfo eoPageInfo = this.tradeSettlementFlowDas.selectPage((BaseEo)tradeSettlementFlowEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TradeSettlementFlowRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<TradeSettlementFlowRespDto> queryList(TradeSettlementFlowReqDto dto) {
        if (ObjectUtils.isEmpty((Object)dto) || StringUtils.isEmpty((CharSequence)dto.getParentTradeNo()) && StringUtils.isEmpty((CharSequence)dto.getTradeNo()) && StringUtils.isEmpty((CharSequence)dto.getOptTradeNo())) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38\uff0c\u5b50/\u7236\u6d41\u6c34\u53f7\u4e0e\u5355\u53f7\u5fc5\u4f20\u5176\u4e00");
        }
        TradeSettlementFlowEo tradeSettlementFlowEoParam = new TradeSettlementFlowEo();
        if (StringUtils.isNotEmpty((CharSequence)dto.getTradeNo())) {
            tradeSettlementFlowEoParam.setTradeNo(dto.getTradeNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getParentTradeNo())) {
            tradeSettlementFlowEoParam.setParentTradeNo(dto.getParentTradeNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getOptTradeNo())) {
            tradeSettlementFlowEoParam.setOptTradeNo(dto.getOptTradeNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getTradeStatus())) {
            tradeSettlementFlowEoParam.setTradeStatus(dto.getTradeStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getTradeType())) {
            tradeSettlementFlowEoParam.setTradeType(dto.getTradeType());
        }
        List select = this.tradeSettlementFlowDas.select((BaseEo)tradeSettlementFlowEoParam);
        ArrayList<TradeSettlementFlowRespDto> dtoList = new ArrayList<TradeSettlementFlowRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, dtoList, TradeSettlementFlowRespDto.class);
        return dtoList;
    }

    @Override
    public TradeSettlementFlowRespDto queryPayTrade(String orderNo) {
        TradeSettlementFlowEo params = new TradeSettlementFlowEo();
        params.setOptTradeNo(orderNo);
        params.setTradeType(SettlementFlowTradeTypeEnum.PAY.getCode());
        params.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
        List select = this.tradeSettlementFlowDas.select((BaseEo)params);
        if (CollectionUtil.isEmpty((Collection)select)) {
            return null;
        }
        TradeSettlementFlowRespDto respDto = new TradeSettlementFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)select.get(0)), (BaseVo)respDto);
        return respDto;
    }

    @Override
    public List<TradeSettlementFlowRespDto> queryStayDisposeRoutingFlow() {
        logger.info("\u83b7\u53d6\u5f85\u5904\u7406\u5206\u8d26\u7ed3\u679c\u7684\u4ea4\u6613\u6d41\u6c34");
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_status", (Object)SettlementFlowTradeStatusEnum.ACCEPT.getCode()));
        sqlFilters.add(SqlFilter.eq((String)"trade_type", (Object)SettlementFlowTradeTypeEnum.ROUTING.getCode()));
        sqlFilters.add(SqlFilter.le((String)"routing_timer", (Object)new Date()));
        TradeSettlementFlowEo tradeSettlementFlowEo = new TradeSettlementFlowEo();
        tradeSettlementFlowEo.setSqlFilters(sqlFilters);
        List select = this.tradeSettlementFlowDas.select((BaseEo)tradeSettlementFlowEo);
        ArrayList<TradeSettlementFlowRespDto> list = new ArrayList<TradeSettlementFlowRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, list, TradeSettlementFlowRespDto.class);
        logger.info("\u83b7\u53d6\u5f85\u5904\u7406\u5206\u8d26\u7ed3\u679c\u7684\u4ea4\u6613\u6d41\u6c34\uff0c\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(list));
        return list;
    }

    @Override
    public List<TradeSettlementFlowRespDto> queryStayCallbackFlow() {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(SettlementFlowTradeTypeEnum.PAY.getCode());
        typeList.add(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"trade_status", (Object)SettlementFlowTradeStatusEnum.ACCEPT.getCode()));
        sqlFilters.add(SqlFilter.in((String)"trade_type", typeList));
        sqlFilters.add(SqlFilter.eq((String)"trade_pay_partner_id", (Object)PaymentWayEnum.WFT_WX_GZH.getPayPartnerCode()));
        TradeSettlementFlowEo paramsEo = new TradeSettlementFlowEo();
        paramsEo.setSqlFilters(sqlFilters);
        List select = this.tradeSettlementFlowDas.select((BaseEo)paramsEo);
        if (CollectionUtil.isEmpty((Collection)select)) {
            return new ArrayList<TradeSettlementFlowRespDto>();
        }
        ArrayList<TradeSettlementFlowRespDto> list = new ArrayList<TradeSettlementFlowRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, list, TradeSettlementFlowRespDto.class);
        return list;
    }
}

