/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IPaymentCheckOrderApi;
import com.dtyunxi.tcbj.api.dto.response.SplitOrderRespDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticSplitDealStatusEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticSplitOrderResultEnum;
import com.dtyunxi.tcbj.api.query.ISplitOrderQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.config.PaymentWayConfig;
import com.dtyunxi.tcbj.center.settlement.api.constant.PayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeBalanceTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowRefundTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.TradeBaseResponse;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.LaunchSettlementReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PaymentBatchParamBaseDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PaymentBatchParamReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.RefundParamReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.PaymentWayRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.config.PayCommonConfig;
import com.dtyunxi.tcbj.center.settlement.biz.mq.PayOrderMqProducerService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.PayRefundService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaymentBatchOfBalanceService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaymentBatchOfOnlineService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.yx.tcbj.center.rebate.api.IOfflineBalanceBillApi;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceBillReqDto;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillSourceEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillTypeEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBusinessEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SettlementServiceImpl
implements ISettlementService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private PayRefundService payRefundService;
    @Resource
    private PaymentBatchOfBalanceService paymentBatchOfBalanceService;
    @Resource
    private PaymentBatchOfOnlineService paymentBatchOfOnlineService;
    @Resource
    private PayCommonConfig payCommonConfig;
    @Resource
    private ILockService lockService;
    @Resource
    private PayOrderMqProducerService payOrderMqProducerService;
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;
    @Resource
    private IPaymentCheckOrderApi paymentCheckOrderApi;
    @Resource
    private ISettlementAccountFlowService settlementAccountFlowService;
    @Resource
    private ISplitOrderQueryApi splitOrderQueryApi;
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IOfflineBalanceBillApi offlineBalanceBillApi;
    @Resource
    private PaymentWayConfig paymentWayConfig;
    @Value(value="${citic.enable:true}")
    Boolean citicIsEnable;

    @Override
    public List<PaymentWayRespDto> paymentWay(String typeStr, String terminal) {
        ArrayList<PaymentWayRespDto> respDtoList = new ArrayList<PaymentWayRespDto>();
        String[] arr = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)typeStr)) {
            arr = typeStr.split(",");
        }
        for (PaymentWayEnum wayEnum : PaymentWayEnum.values()) {
            boolean ifPass = false;
            if (CollectionUtil.isNotEmpty(Arrays.asList(arr))) {
                for (String str : arr) {
                    if (!str.equals(wayEnum.getTypeStr())) continue;
                    ifPass = true;
                    break;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)terminal)) {
                boolean bl = ifPass = terminal.equals(wayEnum.getSupportTerminal()) || wayEnum.getSupportTerminal().equals("all");
            }
            if (!ifPass) continue;
            PaymentWayRespDto paymentWayRespDto = (PaymentWayRespDto)wayEnum.toClass(PaymentWayRespDto.class);
            paymentWayRespDto.setPoundageRate(this.paymentWayConfig.getPoundageRate(paymentWayRespDto.getPayPartnerCode(), paymentWayRespDto.getPayTypeCode()));
            respDtoList.add(paymentWayRespDto);
        }
        return respDtoList;
    }

    @Override
    public Map<Object, Object> queryEnum(Integer type, String enums) {
        String[] arr = enums.split(",");
        HashMap<Object, Object> resMap = new HashMap<Object, Object>();
        for (String str : arr) {
            Map maps;
            if (str.equals("AccountFlowTypeEnum")) {
                maps = SettlementAccountFlowTypeEnum.provideMap((Integer)type);
                resMap.put(str, maps);
                continue;
            }
            if (str.equals("AccountFlowChangeTypeEnum")) {
                maps = SettlementAccountFlowChangeTypeEnum.provideMap();
                resMap.put(str, maps);
                continue;
            }
            if (str.equals("AccountFlowChangeBalanceTypeEnum")) {
                maps = SettlementAccountFlowChangeBalanceTypeEnum.provideMap();
                resMap.put(str, maps);
                continue;
            }
            if (!str.equals("AccountFlowStatusEnum")) continue;
            maps = SettlementAccountFlowStatusEnum.provideMap();
            resMap.put(str, maps);
        }
        return resMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TradeSettlementFlowRespDto refundOfBacktrack(LaunchSettlementReqDto dto) {
        TradeSettlementFlowRespDto tradeSettlementFlowRespDto;
        this.logger.info("\u7533\u8bf7\u9000\u6b3e\uff08\u539f\u8def\u9000\uff09\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("st_order_settlement_doing", dto.getOrderNo(), 10, 10, TimeUnit.SECONDS);
            RefundParamReqDto reqDto = new RefundParamReqDto();
            CubeBeanUtils.copyProperties((Object)reqDto, (Object)dto, (String[])new String[0]);
            if (dto.getIfNextRefund().booleanValue()) {
                reqDto.setRefundType(SettlementFlowRefundTypeEnum.OFFLINE_BALANCE.getCode());
            } else {
                reqDto.setRefundType(SettlementFlowRefundTypeEnum.ORIGINAL.getCode());
            }
            TradeBaseResponse<RefundParamReqDto> checkAndBuildDto = this.payRefundService.checkAndBuild(reqDto);
            TradeBaseResponse<RefundParamReqDto> beforeResponse = this.payRefundService.before((RefundParamReqDto)checkAndBuildDto.getRequestData());
            TradeBaseResponse<RefundParamReqDto> runResponse = this.payRefundService.run((RefundParamReqDto)beforeResponse.getRequestData());
            if (((RefundParamReqDto)runResponse.getRequestData()).getPaymentType() == 1) {
                this.payRefundService.after((RefundParamReqDto)runResponse.getRequestData());
            }
            if (((RefundParamReqDto)runResponse.getRequestData()).getRefundType().intValue() == SettlementFlowRefundTypeEnum.OFFLINE_BALANCE.getCode().intValue()) {
                TradeSettlementFlowRespDto flowRespDto = this.tradeSettlementFlowService.queryById(((RefundParamReqDto)runResponse.getRequestData()).getTradeFlow().getId());
                this.addOfflineBalance(flowRespDto);
            }
            tradeSettlementFlowRespDto = this.tradeSettlementFlowService.queryById(((RefundParamReqDto)runResponse.getRequestData()).getTradeFlow().getId());
        }
        catch (Throwable throwable) {
            this.lockService.unlock(mutex);
            throw throwable;
        }
        this.lockService.unlock(mutex);
        return tradeSettlementFlowRespDto;
    }

    @Override
    public void ShareBenefitOfOnlinePay() {
    }

    @Override
    public void ShareBenefitOfBalancePay() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object paymentBatchOfBalance(PaymentBatchParamReqDto dto) {
        Iterator iterator;
        if (!this.citicIsEnable.booleanValue()) {
            throw new BizException("\u4e2d\u4fe1e\u7ba1\u5bb6\u670d\u52a1\u7ef4\u62a4\u4e2d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u54a8\u8be2\u3002");
        }
        this.logger.info("\u6279\u91cf\u4f59\u989d\u652f\u4ed8\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PaymentBatchParamBaseDto baseDto = new PaymentBatchParamBaseDto();
        CubeBeanUtils.copyProperties((Object)baseDto, (Object)dto, (String[])new String[0]);
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("st_order_settlement_doing", dto.getChargeOffAccount(), 10, 10, TimeUnit.SECONDS);
            TradeBaseResponse<PaymentBatchParamBaseDto> checkAndBuildDto = this.paymentBatchOfBalanceService.checkAndBuild(baseDto);
            TradeBaseResponse<PaymentBatchParamBaseDto> beforeDto = this.paymentBatchOfBalanceService.before((PaymentBatchParamBaseDto)checkAndBuildDto.getRequestData());
            TradeBaseResponse<PaymentBatchParamBaseDto> runDto = this.paymentBatchOfBalanceService.run((PaymentBatchParamBaseDto)beforeDto.getRequestData());
            TradeBaseResponse<PaymentBatchParamBaseDto> afterDto = this.paymentBatchOfBalanceService.after((PaymentBatchParamBaseDto)runDto.getRequestData());
            for (TradeSettlementFlowRespDto trade : ((PaymentBatchParamBaseDto)afterDto.getRequestData()).getTradeFlowList()) {
                this.payOrderMqProducerService.dispatchPayOrderInform(this.tradeSettlementFlowService.queryById(trade.getId()), PayEnum.SUCCESS.getCode());
            }
            iterator = null;
        }
        catch (Throwable throwable) {
            this.lockService.unlock(mutex);
            throw throwable;
        }
        this.lockService.unlock(mutex);
        return iterator;
    }

    @Override
    public Object paymentBatchOfOnline(PaymentBatchParamReqDto dto) {
        this.logger.info("\u6279\u91cf\u5728\u7ebf\u652f\u4ed8\uff1a{}", JSONObject.toJSON((Object)dto));
        if (this.payCommonConfig.getIfCheckWxOpenId().booleanValue() && dto.getPaymentWayReqDto().getPayTypeCode().equals(PaymentWayEnum.WFT_WX_GZH.getPayTypeCode()) && StringUtils.isEmpty((CharSequence)dto.getPaymentWayReqDto().getOpenId())) {
            throw new BizException(SettlementExceptionCode.LAUNCH_WX_PAY_PARAM_EXCEPTION.getCode(), SettlementExceptionCode.LAUNCH_WX_PAY_PARAM_EXCEPTION.getMsg());
        }
        PaymentBatchParamBaseDto baseDto = new PaymentBatchParamBaseDto();
        CubeBeanUtils.copyProperties((Object)baseDto, (Object)dto, (String[])new String[0]);
        TradeBaseResponse<PaymentBatchParamBaseDto> checkAndBuildDto = this.paymentBatchOfOnlineService.checkAndBuild(baseDto);
        TradeBaseResponse<PaymentBatchParamBaseDto> beforeDto = this.paymentBatchOfOnlineService.before((PaymentBatchParamBaseDto)checkAndBuildDto.getRequestData());
        TradeBaseResponse<PaymentBatchParamBaseDto> runDto = this.paymentBatchOfOnlineService.run((PaymentBatchParamBaseDto)beforeDto.getRequestData());
        if (ObjectUtils.isNotEmpty(runDto) && runDto.getGlobalResultCode().equals(PayEnum.SUCCESS.getCode())) {
            return runDto.getGlobalResulData();
        }
        this.logger.error("\u53d1\u8d77\u5728\u7ebf\u652f\u4ed8\u5f02\u5e38\uff1a{}", (Object)JSONObject.toJSONString(runDto));
        throw new BizException(SettlementExceptionCode.LAUNCH_PAY_EXCEPTION.getCode(), SettlementExceptionCode.LAUNCH_PAY_EXCEPTION.getMsg());
    }

    @Override
    public void tradeCallbackCheck(TradeSettlementFlowRespDto respDto) {
        if (ObjectUtils.isEmpty((Object)respDto) || StringUtils.isBlank((CharSequence)respDto.getTradeType())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        if (respDto.getTradeType().equals(SettlementFlowTradeTypeEnum.PAY.getCode())) {
            this.paymentCheckOrderApi.checkPayOrder(respDto.getParentTradeNo());
        }
        if (respDto.getTradeType().equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
            this.paymentCheckOrderApi.checkRefundOrder(respDto.getTradeNo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alternateRefundDispose(TradeSettlementFlowRespDto reqDto) {
        Mutex mutex;
        block9: {
            this.logger.info("\u5904\u7406\u5728\u7ebf\u652f\u4ed8\u9694\u5929\u9000\u6b3e\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            mutex = null;
            try {
                mutex = this.lockService.lock("st_order_settlement_doing", reqDto.getOptTradeNo(), 10, 10, TimeUnit.SECONDS);
                TradeSettlementFlowRespDto refundTrade = this.tradeSettlementFlowService.queryById(reqDto.getId());
                this.logger.info("\u9000\u6b3e\u4ea4\u6613\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)refundTrade));
                if (ObjectUtils.isEmpty((Object)refundTrade)) {
                    throw new BizException("-1", "\u627e\u4e0d\u5230\u9000\u6b3e\u4ea4\u6613");
                }
                if (refundTrade.getRefundType().intValue() != SettlementFlowRefundTypeEnum.OFFLINE_BALANCE.getCode().intValue() || !refundTrade.getTradeStatus().equals(SettlementFlowTradeStatusEnum.ACCEPT.getCode())) {
                    throw new BizException("-1", "\u9000\u6b3e\u4ea4\u6613\u6d41\u6c34\u5f02\u5e38");
                }
                TradeSettlementFlowRespDto payTrade = this.tradeSettlementFlowService.queryPayTrade(refundTrade.getFormerOptOrderNo());
                if (ObjectUtils.isEmpty((Object)payTrade) || ObjectUtils.isEmpty((Object)payTrade.getPaymentUploadFlowId())) {
                    throw new BizException("-1", "\u627e\u4e0d\u5230\u539f\u652f\u4ed8\u4ea4\u6613");
                }
                SplitOrderRespDto splitOrderRespDto = (SplitOrderRespDto)RestResponseHelper.extractData((RestResponse)this.splitOrderQueryApi.queryById(Long.valueOf(payTrade.getPaymentUploadFlowId())));
                if (ObjectUtils.isNotEmpty((Object)splitOrderRespDto)) {
                    if (splitOrderRespDto.getDealStatus().equals(CiticSplitDealStatusEnum.COMPLETE.key) && splitOrderRespDto.getDealResult().equals(CiticSplitOrderResultEnum.SUCCESS.key)) {
                        List<SettlementAccountFlowRespDto> accountFlowList = this.settlementAccountFlowService.queryListByTradeFlow(refundTrade.getTradeNo(), refundTrade.getParentTradeNo());
                        if (CollectionUtil.isEmpty(accountFlowList)) {
                            throw new BizException("-1", "\u627e\u4e0d\u5230\u9000\u6b3e\u4ea4\u6613\u76f8\u5173\u8d26\u6237\u6d41\u6c34");
                        }
                        RefundParamReqDto refundParamReqDto = new RefundParamReqDto();
                        refundParamReqDto.setTradeFlow(refundTrade);
                        refundParamReqDto.setFormerTradeFlow(payTrade);
                        refundParamReqDto.setSettlementAccountFlowList(accountFlowList);
                        this.payRefundService.after(refundParamReqDto);
                    } else {
                        this.logger.info("\u6e05\u5206\u5c1a\u672a\u6709\u7ed3\u679c");
                    }
                    break block9;
                }
                throw new BizException("-1", "\u627e\u4e0d\u5230\u6e05\u5206\u8bb0\u5f55");
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
    }

    @Override
    public void addOfflineBalance(TradeSettlementFlowRespDto reqDto) {
        this.logger.info("\u9694\u5929\u9000\u6b3e\u589e\u52a0\u4f59\u989d\u8d26\u6237\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        OrderDetailRespDto orderDetail = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)this.orderBizQueryApi.getOrderDetail(reqDto.getFormerOptOrderNo(), null));
        if (ObjectUtils.isEmpty((Object)orderDetail) || StringUtils.isBlank((CharSequence)orderDetail.getCustomerId())) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(Long.valueOf(orderDetail.getCustomerId())));
        if (ObjectUtils.isEmpty((Object)customerRespDto)) {
            throw new BizException("-1", "\u5ba2\u6236\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OfflineBalanceBillReqDto addReqDto = new OfflineBalanceBillReqDto();
        addReqDto.setBillDate(new Date());
        addReqDto.setBillType(OfflineBalanceBillTypeEnum.RECEIPT.getCode());
        addReqDto.setBusinessContent(OfflineBalanceBusinessEnum.ORDER_REFUND.getCode());
        addReqDto.setCustomerId(Long.valueOf(orderDetail.getCustomerId()));
        addReqDto.setCustomerCode(customerRespDto.getCode());
        addReqDto.setCustomerName(customerRespDto.getName());
        addReqDto.setAmount(reqDto.getTradeAmount());
        addReqDto.setPaymentAccountName("");
        addReqDto.setReceiptAccountName("");
        addReqDto.setBillSource(OfflineBalanceBillSourceEnum.ALTERNATE_REFUND.getCode());
        addReqDto.setRemark("\u5728\u7ebf\u652f\u4ed8\uff08\u5fae\u4fe1/\u652f\u4ed8\u5b9d\uff09\u4e0b\u5355\u9694\u5929\u9000\u6b3e");
        addReqDto.setRelationNo(reqDto.getTradeNo());
        addReqDto.setReceiptRecordsNo(null);
        addReqDto.setMerchantId(customerRespDto.getMerchantId());
        this.logger.info("\u8bf7\u6c42\u589e\u52a0\u7ebf\u4e0b\u4f59\u989d\u8d26\u6237\u91d1\u989d\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        this.offlineBalanceBillApi.addOfflineBalanceBill(addReqDto);
    }

    @Override
    public PaymentWayRespDto queryPaymentWay(String payTypeCode, String supportTerminal) {
        this.logger.info("\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\uff1a{}=={}", (Object)payTypeCode, (Object)supportTerminal);
        PaymentWayEnum paymentWayEnum = PaymentWayEnum.fromCode((String)payTypeCode);
        if (ObjectUtils.isEmpty((Object)paymentWayEnum)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)supportTerminal) && !supportTerminal.equals(paymentWayEnum.getSupportTerminal())) {
            return null;
        }
        PaymentWayRespDto paymentWayRespDto = (PaymentWayRespDto)paymentWayEnum.toClass(PaymentWayRespDto.class);
        paymentWayRespDto.setPoundageRate(this.paymentWayConfig.getPoundageRate(paymentWayRespDto.getPayPartnerCode(), paymentWayRespDto.getPayTypeCode()));
        return paymentWayRespDto;
    }
}

