/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.apiimpl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.config.ApiNoticeConfig;
import com.dtyunxi.tcbj.app.open.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.BrandRateVo;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.ItemUpdatePriceVo;
import com.dtyunxi.tcbj.app.open.biz.service.ISellerSkuPriceService;
import com.dtyunxi.tcbj.app.open.biz.service.ZsjQueryPriceService;
import com.dtyunxi.tcbj.app.open.dao.eo.MpPriceAdjustDetailGroupEo;
import com.dtyunxi.tcbj.app.open.dao.eo.MpPriceAdjustEo;
import com.dtyunxi.tcbj.app.open.dao.eo.MpPricePackMainEo;
import com.dtyunxi.tcbj.app.open.dao.eo.MpProductVo;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.openapi.api.IErpPriceApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.mdm.MdmRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.mdm.request.MdmBasePriceReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.mdm.request.MdmReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.mdm.response.MdmTaskRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.price.BasePriceApplyReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.price.ItemUpdatePriceReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.price.PriceSyncReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.price.PullSuggestedPriceDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.IBasePriceApplyApi;
import com.dtyunxi.yundt.cube.center.price.api.ISyncPriceDataApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.BasePriceApplySkuInfo;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceApplyAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceItemDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceAdjustReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.price.api.IPrBaseDiscountApi;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountAddEditReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountBrandReqDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpPriceApiImpl
implements IErpPriceApi {
    private static final Logger log = LoggerFactory.getLogger(ErpPriceApiImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(ErpPriceApiImpl.class);
    @Autowired
    private IBasePriceApplyApi basePriceApplyApi;
    @Autowired
    private IShopExtQueryApi shopExtQueryApi;
    @Autowired
    private IBizOrganizationQueryApi organizationQueryApi;
    @Autowired
    private IItemSkuQueryApi itemSkuQueryApi;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private ICacheService cacheService;
    @Resource
    private DingdingSender dingdingSender;
    @Resource
    private ApiNoticeConfig apiNoticeConfig;
    @Resource
    private ZsjQueryPriceService zsjQueryPriceService;
    private static final Long DEFAULT_TENANT_ID = 1L;
    private static final Long DEFAULT_INSTANCE_ID = 1254039287584232622L;
    private static final String DEFAULT_STATUS = "WAIT_AUDIT";
    private static final String FORMAT = "yyyyMMddHHmmss";
    private static final String PRE = "\u8c03\u4ef7\u5355";
    private static final String CACHE_KEY = "ERP_PRICE_APPLY_NAME";
    @Resource
    private ISellerSkuPriceService sellerSkuPriceService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private IPrBaseDiscountApi prBaseDiscountApi;
    @Resource
    private ISyncPriceDataApi syncPriceDataApi;

    public void syncSupplierBasePrice(PriceSyncReqDto reqDto) {
        AssertUtils.notBlank((String)reqDto.getOrgCode(), (String)"\u79df\u6237Code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)reqDto.getShopId(), (String)"\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)reqDto.getOrgId(), (String)"\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        List<MpProductVo> mpProductVoList = this.sellerSkuPriceService.selectMpProductByOrgId(reqDto.getOrgCode());
        if (CollectionUtils.isNotEmpty(mpProductVoList)) {
            List basePriceItemDtoList = mpProductVoList.stream().map(vo -> {
                BasePriceItemDto dto = new BasePriceItemDto();
                dto.setItemBrand(vo.getItemBrand());
                dto.setItemCode(vo.getItemCode());
                dto.setItemName(vo.getItemName());
                dto.setSkuCode(vo.getSkuCode());
                dto.setItemPrice(vo.getItemPrice());
                dto.setRenewTime(vo.getRenewTime());
                dto.setShopId(Long.valueOf(reqDto.getShopId()));
                dto.setOrganizationId(Long.valueOf(reqDto.getOrgId()));
                return dto;
            }).collect(Collectors.toList());
            this.syncPriceDataApi.batchSyncBasePriceItems(basePriceItemDtoList);
        } else {
            log.info("syncSupplierBasePrice:mpProductVoList is NULL organizationCode={}", (Object)reqDto.getOrgCode());
        }
    }

    public void initSupplierPriceRule(PriceSyncReqDto reqDto) {
        AssertUtils.notBlank((String)reqDto.getOrgCode(), (String)"\u79df\u6237Code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)reqDto.getShopId(), (String)"\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)reqDto.getOrgId(), (String)"\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        List<MpPriceAdjustEo> mpPriceAdjustEoList = this.sellerSkuPriceService.selectMpPriceAdjustByOrgId(reqDto.getOrgCode());
        if (CollectionUtils.isNotEmpty(mpPriceAdjustEoList)) {
            ArrayList priceAdjustReqDtoList = Lists.newArrayList();
            mpPriceAdjustEoList.stream().forEach(adjustEo -> {
                PriceAdjustReqDto dto = this.getPriceAdjustReqDto((MpPriceAdjustEo)adjustEo);
                Map<String, List<String>> detailMap = this.queryDetailMap((MpPriceAdjustEo)adjustEo);
                if (Objects.nonNull(detailMap)) {
                    dto.setDetailMap(detailMap);
                    priceAdjustReqDtoList.add(dto);
                } else {
                    log.info("initSupplierPriceRule:detailMap is NULL adjustEo={}", adjustEo);
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)priceAdjustReqDtoList)) {
                this.syncPriceDataApi.batchSyncPriceRules(Long.valueOf(reqDto.getShopId()), Long.valueOf(reqDto.getOrgId()), reqDto.getOrgName(), (List)priceAdjustReqDtoList);
            } else {
                log.info("initSupplierPriceRule:priceAdjustReqDtoList is NULL organizationCode={}", (Object)reqDto.getOrgCode());
            }
        } else {
            log.info("initSupplierPriceRule:mpPriceAdjustEoList is NULL organizationCode={}", (Object)reqDto.getOrgCode());
        }
    }

    private Map<String, List<String>> queryDetailMap(MpPriceAdjustEo adjustEo) {
        HashMap detailMap = null;
        String groupKey = null;
        if ("applyer".equals(adjustEo.getControlScope())) {
            groupKey = "CUSTOMER_ID";
        } else if ("area".equals(adjustEo.getControlScope())) {
            groupKey = "AREA_ID";
        } else if ("bigArea".equals(adjustEo.getControlScope())) {
            groupKey = "BIGAREA_ID";
        } else if ("channel".equals(adjustEo.getControlScope())) {
            groupKey = "CHANNEL_ID";
        }
        if (Objects.nonNull(groupKey)) {
            List<MpPriceAdjustDetailGroupEo> priceAdjustDetailGroupEoList = this.sellerSkuPriceService.selectAdjustDetailGroupEos(adjustEo.getRowId1(), groupKey);
            if (CollectionUtils.isNotEmpty(priceAdjustDetailGroupEoList)) {
                detailMap = Maps.newHashMap();
                for (MpPriceAdjustDetailGroupEo eo : priceAdjustDetailGroupEoList) {
                    List groupKeyList = (List)detailMap.get(eo.getSkuCodes());
                    if (CollectionUtils.isNotEmpty((Collection)groupKeyList)) {
                        groupKeyList.add(eo.getGroupFlag());
                        continue;
                    }
                    groupKeyList = Lists.newArrayList((Object[])new String[]{eo.getGroupFlag()});
                    detailMap.put(eo.getSkuCodes(), groupKeyList);
                }
            } else {
                log.error("initSupplierPriceRule:priceAdjustDetailGroupEoList adjustEo={}", (Object)adjustEo);
            }
        } else {
            log.error("initSupplierPriceRule:controlScope ERROR adjustEo.getControlScope()={}", (Object)adjustEo.getControlScope());
        }
        return detailMap;
    }

    private PriceAdjustReqDto getPriceAdjustReqDto(MpPriceAdjustEo eo) {
        PriceAdjustReqDto dto = new PriceAdjustReqDto();
        dto.setRowId1(eo.getRowId1());
        dto.setAdjustmentName(eo.getAdjustmentName());
        dto.setStartDate(eo.getStartDate());
        dto.setEndDate(eo.getEndDate());
        dto.setControlScope(eo.getControlScope());
        return dto;
    }

    public void handleBaseDiscount(ItemUpdatePriceReqDto dto) {
        ItemUpdatePriceVo itemUpdatePriceVo = new ItemUpdatePriceVo();
        AssertUtils.notBlank((String)dto.getSupplierId(), (String)"\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        itemUpdatePriceVo.setTenantId(dto.getSupplierId());
        if (Objects.nonNull(dto.getLastUpdateTime())) {
            itemUpdatePriceVo.setLastUpdateTime(dto.getLastUpdateTime());
        } else {
            itemUpdatePriceVo.setLastUpdateTime("2000-01-01 00:00:00");
        }
        List<MpPricePackMainEo> mpPricePackMainEos = this.sellerSkuPriceService.selectPricePackBySupplierId(itemUpdatePriceVo);
        if (CollectionUtils.isNotEmpty(mpPricePackMainEos)) {
            List applierIds = mpPricePackMainEos.stream().map(MpPricePackMainEo::getApplierId).collect(Collectors.toList());
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByThirdPartyIds(applierIds));
            if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                List<PrBaseDiscountAddEditReqDto> dtoList = this.prepareBaseDiscoutList(mpPricePackMainEos, customerRespDtos);
                this.prBaseDiscountApi.updateOrInsert(dtoList);
            } else {
                log.info("handleBaseDiscount customerRespDtos is NULL applierIds={}", applierIds);
            }
        } else {
            log.info("handleBaseDiscount mpPricePackMainEos is NULL itemUpdatePriceVo={}", (Object)itemUpdatePriceVo);
        }
    }

    private List<PrBaseDiscountAddEditReqDto> prepareBaseDiscoutList(List<MpPricePackMainEo> mpPricePackMainEos, List<CustomerRespDto> customerRespDtos) {
        ArrayList retList = Lists.newArrayList();
        HashMap cacheBrandMap = Maps.newHashMap();
        mpPricePackMainEos.stream().forEach(mainEo -> customerRespDtos.stream().filter(customer -> customer.getThirdPartyId().equals(mainEo.getApplierId())).forEach(customer -> {
            PrBaseDiscountAddEditReqDto retDto = new PrBaseDiscountAddEditReqDto();
            retDto.setCustomerId(customer.getId());
            retDto.setCustomerCode(customer.getCode());
            retDto.setCustomerName(customer.getCustomerName());
            retDto.setOrgInfoId(customer.getOrgInfoId());
            retDto.setMerchantId(customer.getMerchantId());
            retDto.setStandardDiscount(mainEo.getSettleRate());
            retDto.setBrandDiscountList(this.dealBrand((MpPricePackMainEo)mainEo, cacheBrandMap));
            retList.add(retDto);
        }));
        return retList;
    }

    private List<PrBaseDiscountBrandReqDto> dealBrand(MpPricePackMainEo mpPricePackMainEo, Map<String, BrandRespDto> cacheBrandMap) {
        ArrayList newBrands = Lists.newArrayList();
        List brandRateVos = JSONObject.parseArray((String)mpPricePackMainEo.getBrandRateList(), BrandRateVo.class);
        if (CollectionUtils.isNotEmpty((Collection)brandRateVos)) {
            for (BrandRateVo brandRateVo : brandRateVos) {
                BrandRespDto brandRespDto = cacheBrandMap.get(brandRateVo.getBrand());
                if (Objects.isNull(brandRespDto)) {
                    if ("JGS".equals(brandRateVo.getBrand())) {
                        brandRateVo.setBrand("JAS");
                    }
                    if (Objects.isNull(brandRespDto = (BrandRespDto)RestResponseHelper.extractData((RestResponse)this.brandQueryApi.queryCode(brandRateVo.getBrand())))) {
                        String str = "\u57fa\u7840\u6263\u7387\u540c\u6b65\u5f02\u5e38:\u79df\u6237\u7f16\u7801[" + mpPricePackMainEo.getSupplierId() + "]\u540c\u6b65\u6263\u7387-\u89e3\u6790\u54c1\u724c\u7f16\u7801[" + brandRateVo.getBrand() + "]\u65f6\u62a5\u9519\uff0c\u54c1\u724c\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u8fdb\u884c\u5904\u7406\uff0c\u5904\u7406\u5b8c\u6210\u540e\u91cd\u65b0\u540c\u6b65\u8be5\u79df\u6237\u6263\u7387\u3002";
                        logger.info(str);
                        DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                        msgReqDto.setRemindPhones(this.apiNoticeConfig.getCommonList());
                        msgReqDto.setRemindType(1);
                        msgReqDto.setSendMessage(str);
                        this.dingdingSender.sendMessage(msgReqDto);
                        log.error("handleBaseDiscount:brandRateVos is NULL brandRateVo={}", (Object)brandRateVo);
                        continue;
                    }
                    cacheBrandMap.put(brandRateVo.getBrand(), brandRespDto);
                }
                PrBaseDiscountBrandReqDto brandDiscount = new PrBaseDiscountBrandReqDto();
                brandDiscount.setBrandId(brandRespDto.getId());
                brandDiscount.setBrandName(brandRespDto.getName());
                brandDiscount.setBrandDiscount(brandRateVo.getRate());
                newBrands.add(brandDiscount);
            }
        } else {
            log.info("handleBaseDiscount brandRateVos is NULL MpPricePackMainEo={}", (Object)mpPricePackMainEo);
        }
        return newBrands;
    }

    public MdmRespDto addBasePriceApplyAndAudit(MdmReqDto<MdmBasePriceReqDto> mdmReqDto) {
        log.info("[\u65b0\u589e\u57fa\u7840\u4ef7\u8c03\u4ef7\u7533\u8bf7\u5e76\u5ba1\u6838]\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(mdmReqDto));
        ArrayList result = Lists.newArrayList();
        List skuCodes = mdmReqDto.getLIST().stream().map(MdmBasePriceReqDto::getPROD_ORG_REL).map(BasePriceApplyReqDto::getSKUCODE).collect(Collectors.toList());
        List itemSkuRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.queryBySkuCode(skuCodes));
        Map<String, ItemSkuRespDto> itemSkuRespDtoMap = itemSkuRespDtos.stream().collect(Collectors.toMap(ItemSkuRespDto::getCargoCode, e -> e, (e1, e2) -> e1));
        List thirdOrgId = mdmReqDto.getLIST().stream().map(MdmBasePriceReqDto::getPROD_ORG_REL).map(BasePriceApplyReqDto::getTHIRDORGID).collect(Collectors.toList());
        List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.getOrganizations(thirdOrgId));
        if (CollectionUtils.isEmpty((Collection)organizationDtos)) {
            throw new BizException("\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Map<String, OrganizationDto> organizationDtoMap = organizationDtos.stream().collect(Collectors.toMap(OrganizationDto::getCode, e -> e, (e1, e2) -> e1));
        Map<String, List<MdmBasePriceReqDto>> basePriceApplyGroup = mdmReqDto.getLIST().stream().collect(Collectors.groupingBy(e -> e.getPROD_ORG_REL().getTHIRDORGID()));
        for (Map.Entry<String, List<MdmBasePriceReqDto>> entry : basePriceApplyGroup.entrySet()) {
            ArrayList taskResults = Lists.newArrayList();
            BasePriceApplyReqDto prodOrgRel = entry.getValue().get(0).getPROD_ORG_REL();
            String errorMessge = "";
            try {
                ArrayList skuList = Lists.newArrayList();
                for (MdmBasePriceReqDto mdmBasePriceReqDto : entry.getValue()) {
                    BasePriceApplyReqDto reqDto = mdmBasePriceReqDto.getPROD_ORG_REL();
                    String taskId = mdmBasePriceReqDto.getCIDP_TASK_UUID();
                    ItemSkuRespDto itemSkuRespDto = itemSkuRespDtoMap.get(reqDto.getSKUCODE());
                    if (itemSkuRespDto == null) {
                        String str = "[\u65b0\u589e\u57fa\u7840\u4ef7\u8c03\u4ef7\u7533\u8bf7\u5e76\u5ba1\u6838]:taskId=[" + taskId + "],\u5546\u54c1SKU\u7f16\u7801=[" + reqDto.getSKUCODE() + "]\u4e0d\u5b58\u5728\uff0c\u5df2\u81ea\u52a8\u7565\u8fc7\u3002\u8bf7\u6ce8\u610f\u5546\u54c1\u57fa\u8868\u4e2d\u662f\u5426\u5b58\u5728";
                        logger.info(str);
                        DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                        msgReqDto.setRemindPhones(this.apiNoticeConfig.getCommonList());
                        msgReqDto.setRemindType(1);
                        msgReqDto.setSendMessage(str);
                        this.dingdingSender.sendMessage(msgReqDto);
                        continue;
                    }
                    BasePriceApplySkuInfo basePriceApplySkuInfo = new BasePriceApplySkuInfo();
                    basePriceApplySkuInfo.setSkuId(itemSkuRespDto.getId());
                    HashMap skuPrice = Maps.newHashMap();
                    skuPrice.put(reqDto.getPRICETYPE(), reqDto.getPRICE());
                    basePriceApplySkuInfo.setSkuPrice((Map)skuPrice);
                    skuList.add(basePriceApplySkuInfo);
                    taskResults.add(new MdmTaskRespDto(taskId, (Object)""));
                }
                OrganizationDto organizationDto = organizationDtoMap.get(entry.getKey());
                if (organizationDto == null) {
                    log.info("[\u65b0\u589e\u57fa\u7840\u4ef7\u8c03\u4ef7\u7533\u8bf7\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728]\uff1a{}", (Object)entry.getKey());
                    throw new BizException(entry.getKey() + ",\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                BasePriceApplyAddReqDto basePriceApplyAddReqDto = new BasePriceApplyAddReqDto();
                basePriceApplyAddReqDto.setChannel(prodOrgRel.getChannel());
                basePriceApplyAddReqDto.setApplyName(this.generateApplyName());
                basePriceApplyAddReqDto.setEffectTime(new Date());
                basePriceApplyAddReqDto.setOrganizationId(organizationDto.getId());
                basePriceApplyAddReqDto.setTenantId(DEFAULT_TENANT_ID);
                basePriceApplyAddReqDto.setInstanceId(DEFAULT_INSTANCE_ID);
                basePriceApplyAddReqDto.setSkuList((List)skuList);
                basePriceApplyAddReqDto.setStatus(DEFAULT_STATUS);
                Long l = (Long)RestResponseHelper.extractData((RestResponse)this.basePriceApplyApi.syncErpBasePriceApplyAndAudit(basePriceApplyAddReqDto));
            }
            catch (BizException e3) {
                log.error("[erp\u8c03\u4ef7\u5355]\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Throwable)e3);
                for (MdmTaskRespDto taskResult : taskResults) {
                    taskResult.setType("failure");
                    taskResult.setReason((Object)e3.getMessage());
                }
            }
            result.addAll(taskResults);
        }
        return new MdmRespDto((Object)result);
    }

    private String generateApplyName() {
        Long result = this.cacheService.incrBy(CACHE_KEY, 1L);
        log.info("[erp\u8c03\u4ef7\u5355],\u540d\u79f0\u81ea\u589e\u7ed3\u679c\uff1a{}", (Object)result);
        return PRE + DateUtil.format((Date)new Date(), (String)FORMAT) + result;
    }

    public MdmRespDto pullSuggestedPrice(List<PullSuggestedPriceDto> dtoList) {
        ArrayList<BasePriceApplyReqDto> pullDate = new ArrayList<BasePriceApplyReqDto>();
        dtoList.forEach(e -> {
            BigDecimal price = this.zsjQueryPriceService.querySuggestedPrice(e.getLongCode(), e.getThirdPartyId());
            if (price == null) {
                logger.info("\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u5efa\u8bae\u96f6\u552e\u4ef7\u4ef7\u683c \u8df3\u8fc7");
                return;
            }
            BasePriceApplyReqDto basePriceApplyReqDto = BasePriceApplyReqDto.builder().PRICE(price).SKUCODE(e.getLongCode()).THIRDORGID(e.getThirdPartyId()).build();
            logger.info("\u4e3b\u6570\u636e\u5b58\u5728\u5efa\u8bae\u96f6\u552e\u4ef7\u4ef7\u683c add to list. basePriceApplyReqDto={}", (Object)JSONObject.toJSONString((Object)basePriceApplyReqDto));
            pullDate.add(basePriceApplyReqDto);
        });
        if (!pullDate.isEmpty()) {
            MdmReqDto<MdmBasePriceReqDto> paramData = this.zsjQueryPriceService.getAddPriceParam(pullDate);
            logger.info("\u5199\u5165\u4ece\u4e3b\u6570\u636e\u540c\u6b65\u7684\u5efa\u8bae\u96f6\u552e\u4ef7 paramData={}", (Object)JSONObject.toJSONString(paramData));
            return this.addBasePriceApplyAndAudit(paramData);
        }
        logger.info("\u9700\u8981\u4ece\u4e3b\u6570\u636e\u540c\u6b65\u7684\u5efa\u8bae\u96f6\u552e\u4ef7\u4e3a\u7a7a \u4e0d\u5904\u7406");
        return null;
    }
}

