/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.config.ApiNoticeConfig;
import com.dtyunxi.tcbj.app.open.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.BrandRateVo;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.ItemUpdatePriceVo;
import com.dtyunxi.tcbj.app.open.biz.service.ISellerSkuPriceService;
import com.dtyunxi.tcbj.app.open.dao.eo.MpPricePackMainEo;
import com.dtyunxi.tcbj.app.open.dao.eo.SellerSkuPriceEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.IInitDataApi;
import com.dtyunxi.yundt.cube.center.price.api.ISyncPriceDataApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.InitDataReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.ISellerSkuPriceApi;
import com.yx.tcbj.center.api.dto.response.ProductPriceRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.price.api.IPrBaseDiscountApi;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountAddEditReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountBrandReqDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ItemUpdatePriceProcessor
implements IMessageProcessor<Object> {
    private static final Logger log = LoggerFactory.getLogger(ItemUpdatePriceProcessor.class);
    @Resource
    private ISellerSkuPriceApi sellerSkuPriceApi;
    @Value(value="${customer.price.relation.pageSize:5000}")
    private Integer pageSize;
    @Value(value="${customer.price.relation.limitCount:15}")
    private Integer limitCount;
    @Resource
    private ISellerSkuPriceService sellerSkuPriceService;
    @Value(value="${customer.price.relation.sync:false}")
    private boolean syncOpen;
    @Resource
    private ICommonsMqService commonsMqService;
    @Value(value="${customer.price.relation.updateapi:false}")
    private Boolean updatePrice;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ISyncPriceDataApi syncPriceDataApi;
    @Resource
    private IInitDataApi initDataApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private IPrBaseDiscountApi prBaseDiscountApi;
    @Resource
    private DingdingSender dingdingSender;
    @Resource
    private ApiNoticeConfig apiNoticeConfig;
    public static final String SPLIT = "itemUpdatePriceVo";
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 2, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(2, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public MessageResponse process(Object message) {
        MDC.put((String)"yes.req.requestId", (String)UUID.randomUUID().toString().replace("-", ""));
        log.info("\u63a5\u6536\u5230\u4ef7\u683c\u4fee\u6539MQ\u6570\u636e:{}", message);
        ItemUpdatePriceVo itemUpdatePriceVo = (ItemUpdatePriceVo)JSONObject.parseObject((String)message.toString(), ItemUpdatePriceVo.class);
        if (!this.syncOpen && !itemUpdatePriceVo.isTouchSync()) {
            log.info("\u6682\u65f6\u5148\u4e0d\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        if (Objects.isNull(itemUpdatePriceVo.getTenantId())) {
            log.info("\u53c2\u6570\u65e0\u79df\u6237id");
            return MessageResponse.SUCCESS;
        }
        int sec = 60;
        List itemList = this.cacheService.getList("PRICE_TENANT:UPDATE", String.class);
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            if (itemList.stream().noneMatch(x -> x.startsWith(itemUpdatePriceVo.getTenantId() + SPLIT))) {
                this.cacheService.lpushx("PRICE_TENANT:UPDATE", (List)Lists.newArrayList((Object[])new String[]{itemUpdatePriceVo.getTenantId() + SPLIT + JSONObject.toJSONString((Object)itemUpdatePriceVo)}));
            }
        } else {
            this.cacheService.lpush("PRICE_TENANT:UPDATE", (List)Lists.newArrayList((Object[])new String[]{itemUpdatePriceVo.getTenantId() + SPLIT + JSONObject.toJSONString((Object)itemUpdatePriceVo)}));
        }
        try {
            this.handleBaseDiscount(itemUpdatePriceVo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return MessageResponse.SUCCESS;
    }

    public void execute(ItemUpdatePriceVo itemUpdatePriceVo) {
        this.executorService.execute(() -> {
            try {
                log.info("\u4ef7\u683c\u4fee\u6539\u6570\u636eJSON\u8f6c\u6362\u540e:{}", (Object)itemUpdatePriceVo);
                List<String> applierIds = this.sellerSkuPriceService.selectApplierIdsBySupplierId(itemUpdatePriceVo.getTenantId());
                if (CollectionUtils.isEmpty(applierIds)) {
                    return;
                }
                ItemUpdatePriceVo itemUpdatePriceCopyVo = (ItemUpdatePriceVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)itemUpdatePriceVo), ItemUpdatePriceVo.class);
                HashSet thirdPartyIdSet = Sets.newHashSet();
                Stream.iterate(0, n -> n + 1).limit(this.getCount(applierIds.size()).intValue()).forEach(i -> {
                    List<String> limitApplierIds = applierIds.stream().skip((long)i.intValue() * (long)this.limitCount.intValue()).limit(this.limitCount.intValue()).collect(Collectors.toList());
                    itemUpdatePriceCopyVo.setApplierIds(limitApplierIds);
                    this.handle(this.sellerSkuPriceService.selectListNoLimit(itemUpdatePriceCopyVo), thirdPartyIdSet);
                });
            }
            catch (Exception e) {
                log.error("\u76d1\u542c\u5668\u63a5\u6536\u5230\u6d88\u606f\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
            }
        });
    }

    public void handleBaseDiscount(ItemUpdatePriceVo itemUpdatePriceVo) {
        List<MpPricePackMainEo> mpPricePackMainEos = this.sellerSkuPriceService.selectPricePackBySupplierId(itemUpdatePriceVo);
        if (CollectionUtils.isNotEmpty(mpPricePackMainEos)) {
            List applierIds = mpPricePackMainEos.stream().map(MpPricePackMainEo::getApplierId).collect(Collectors.toList());
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByThirdPartyIds(applierIds));
            if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                List<PrBaseDiscountAddEditReqDto> dtoList = this.prepareBaseDiscoutList(mpPricePackMainEos, customerRespDtos);
                this.prBaseDiscountApi.updateOrInsert(dtoList);
            } else {
                log.info("handleBaseDiscount customerRespDtos is NULL applierIds={}", applierIds);
            }
        } else {
            log.info("handleBaseDiscount mpPricePackMainEos is NULL itemUpdatePriceVo={}", (Object)itemUpdatePriceVo);
        }
    }

    private List<PrBaseDiscountAddEditReqDto> prepareBaseDiscoutList(List<MpPricePackMainEo> mpPricePackMainEos, List<CustomerRespDto> customerRespDtos) {
        ArrayList retList = Lists.newArrayList();
        HashMap cacheBrandMap = Maps.newHashMap();
        mpPricePackMainEos.stream().forEach(mainEo -> customerRespDtos.stream().filter(customer -> customer.getThirdPartyId().equals(mainEo.getApplierId())).forEach(customer -> {
            PrBaseDiscountAddEditReqDto retDto = new PrBaseDiscountAddEditReqDto();
            retDto.setCustomerId(customer.getId());
            retDto.setCustomerCode(customer.getCode());
            retDto.setCustomerName(customer.getCustomerName());
            retDto.setOrgInfoId(customer.getOrgInfoId());
            retDto.setMerchantId(customer.getMerchantId());
            retDto.setStandardDiscount(mainEo.getSettleRate());
            retDto.setBrandDiscountList(this.dealBrand((MpPricePackMainEo)mainEo, cacheBrandMap));
            retList.add(retDto);
        }));
        return retList;
    }

    private List<PrBaseDiscountBrandReqDto> dealBrand(MpPricePackMainEo mpPricePackMainEo, Map<String, BrandRespDto> cacheBrandMap) {
        ArrayList newBrands = Lists.newArrayList();
        List brandRateVos = JSONObject.parseArray((String)mpPricePackMainEo.getBrandRateList(), BrandRateVo.class);
        if (CollectionUtils.isNotEmpty((Collection)brandRateVos)) {
            for (BrandRateVo brandRateVo : brandRateVos) {
                BrandRespDto brandRespDto = cacheBrandMap.get(brandRateVo.getBrand());
                if (Objects.isNull(brandRespDto)) {
                    if ("JGS".equals(brandRateVo.getBrand())) {
                        brandRateVo.setBrand("JAS");
                    }
                    if (Objects.isNull(brandRespDto = (BrandRespDto)RestResponseHelper.extractData((RestResponse)this.brandQueryApi.queryCode(brandRateVo.getBrand())))) {
                        log.error("handleBaseDiscount:brandRateVos is NULL brandRateVo={}", (Object)brandRateVo);
                        String str = "\u57fa\u7840\u6263\u7387\u540c\u6b65\u5f02\u5e38:\u79df\u6237\u7f16\u7801[" + mpPricePackMainEo.getSupplierId() + "]\u540c\u6b65\u6263\u7387-\u89e3\u6790\u54c1\u724c\u7f16\u7801[" + brandRateVo.getBrand() + "]\u65f6\u62a5\u9519\uff0c\u54c1\u724c\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u8fdb\u884c\u5904\u7406\uff0c\u5904\u7406\u5b8c\u6210\u540e\u91cd\u65b0\u540c\u6b65\u8be5\u79df\u6237\u6263\u7387\u3002";
                        log.info(str);
                        DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                        msgReqDto.setRemindPhones(this.apiNoticeConfig.getCommonList());
                        msgReqDto.setRemindType(1);
                        msgReqDto.setSendMessage(str);
                        this.dingdingSender.sendMessage(msgReqDto);
                        continue;
                    }
                    cacheBrandMap.put(brandRateVo.getBrand(), brandRespDto);
                }
                PrBaseDiscountBrandReqDto brandDiscount = new PrBaseDiscountBrandReqDto();
                brandDiscount.setBrandId(brandRespDto.getId());
                brandDiscount.setBrandName(brandRespDto.getName());
                brandDiscount.setBrandDiscount(brandRateVo.getRate());
                newBrands.add(brandDiscount);
            }
        } else {
            log.info("handleBaseDiscount:brandRateVos is NULL MpPricePackMainEo={}", (Object)mpPricePackMainEo);
        }
        return newBrands;
    }

    private void initAndEnablePricePolicy(String tenantId, Set<String> thirdPartyIdSet) {
        if (this.updatePrice.booleanValue()) {
            InitDataReqDto initDataReqDto = new InitDataReqDto();
            OrganizationDto organizationDto = (OrganizationDto)this.organizationQueryApi.queryOneByOrgCode(null, tenantId).getData();
            log.info("\u540c\u6b65\u4ef7\u683c\u7ec4\u7ec7\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)organizationDto));
            if (!Objects.isNull(organizationDto)) {
                initDataReqDto.setOrgId(organizationDto.getId());
                initDataReqDto.setThirdPartyIdSet(thirdPartyIdSet);
                String initReqId = (String)RestResponseHelper.extractData((RestResponse)this.initDataApi.initDealerDataExt((List)Lists.newArrayList((Object[])new InitDataReqDto[]{initDataReqDto})));
                log.info("\u521d\u59cb\u5316\u4ef7\u683c\u653f\u7b56\u7ed3\u679c\uff0c\u79df\u6237[{}], \u8bf7\u6c42id\uff1a{}", (Object)tenantId, (Object)initReqId);
            }
        }
    }

    private Integer getCount(Integer size) {
        return (this.limitCount + size - 1) / this.limitCount;
    }

    private void handle(List<SellerSkuPriceEo> sellerSkuPriceEo, Set<String> thirdPartyIdSet) {
        if (CollectionUtils.isEmpty(sellerSkuPriceEo)) {
            return;
        }
        this.sellerSkuPriceApi.updatePriceList(sellerSkuPriceEo.stream().map(eo -> {
            ProductPriceRespDto productPriceRespDto = new ProductPriceRespDto();
            BeanUtil.copyProperties((Object)eo, (Object)productPriceRespDto, (String[])new String[0]);
            return productPriceRespDto;
        }).collect(Collectors.toList()));
    }

    private void sendMessage(ProductPriceRespDto productPriceRespDto) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)productPriceRespDto);
        log.info("\u53d1\u9001\u4ef7\u683c\u540c\u6b65mq\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.sendSingleMessageAsync("ITEM_UPDATE_PRICE_TOPIC", "ITEM_UPDATE_PRICE_TAG", (Object)messageVo);
    }
}

