/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleRouteService;
import com.dtyunxi.tcbj.app.open.biz.service.IDataDistributeService;
import com.dtyunxi.tcbj.app.open.biz.service.impl.CenterHandleCustomerMaterialRelServiceImpl;
import com.dtyunxi.tcbj.app.open.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.tcbj.app.open.biz.utils.WebServiceUtil;
import com.dtyunxi.tcbj.app.open.dao.das.DataDistributeDas;
import com.dtyunxi.tcbj.app.open.dao.das.DbDataDistributeDas;
import com.dtyunxi.tcbj.app.open.dao.das.OpTempItemDas;
import com.dtyunxi.tcbj.app.open.dao.eo.YxyInventoryVo;
import com.dtyunxi.tcbj.app.open.dao.mapper.SellerSkuPriceMapper;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.DataDistributeReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.TouchSyncMainDataExtReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.TouchSyncMainDataReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ViewDateReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.MainDataResult;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.YxyInventoryExportDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.RandomCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCompareReqDto;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DS(value="slave_1")
public class DataDistributeImpl
implements IDataDistributeService {
    private static Logger logger = LoggerFactory.getLogger(DataDistributeImpl.class);
    @Autowired
    private ICenterHandleRouteService centerHandleRouteService;
    @Autowired
    private DataDistributeDas dataDistributeDas;
    @Autowired
    private ITcbjInventoryApi iTcbjInventoryApi;
    @Resource
    private SellerSkuPriceMapper sellerSkuPriceMapper;
    @Autowired
    private OpTempItemDas opTempItemDas;
    @Resource
    private CenterHandleCustomerMaterialRelServiceImpl centerHandleCustomerMaterialRelService;
    @Autowired
    private DbDataDistributeDas dbDataDistributeDas;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    private static final String VIEW_COLUMN_PREFIX = "D_";

    @Override
    public MainDataResult updateData(DataDistributeReqDto dto) {
        logger.info("\u8bf7\u6c42\u6570\u636e {} ", (Object)dto.toString());
        if (ModelCodeEnum.MATERIAL.name().equals(dto.getModelCode()) || ModelCodeEnum.CUSTOMER_MATERIAL_REL.name().equals(dto.getModelCode()) || ModelCodeEnum.CUSTOMER.name().equals(dto.getModelCode())) {
            return new MainDataResult();
        }
        MainDataResult result = new MainDataResult();
        ModelInfoReqDto modelInfoReqDto = new ModelInfoReqDto();
        modelInfoReqDto.setDataType(dto.getDataType());
        modelInfoReqDto.setDataStr(DataDistributeImpl.getDataStr(dto.getDataStr(), dto.getModelCode()));
        result.setResult(this.centerHandleRouteService.route(dto.getModelCode()).handle(modelInfoReqDto));
        return result;
    }

    @Override
    public String touchSyncMainData(TouchSyncMainDataReqDto reqDto) {
        logger.info("1\u3001WebService \u4e3b\u6570\u636e\u8bf7\u6c42\u53c2\u6570 {}", (Object)JSONObject.toJSONString((Object)reqDto));
        TouchSyncMainDataReqDto newReqDto = null;
        ArrayList<TouchSyncMainDataReqDto> reqDtoList = new ArrayList<TouchSyncMainDataReqDto>();
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getOrgId())) {
            List easNoList = this.dataDistributeDas.selectDealerItem(reqDto.getOrgId());
            if (CollectionUtils.isEmpty((Collection)easNoList)) {
                return null;
            }
            for (String easNo : easNoList) {
                newReqDto = new TouchSyncMainDataReqDto();
                CubeBeanUtils.copyProperties((Object)newReqDto, (Object)reqDto, (String[])new String[0]);
                newReqDto.setQueryCondition("FNUMBER=" + easNo);
                reqDtoList.add(newReqDto);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)reqDto.getQueryCondition())) {
            String[] mainConditionList;
            String[] queryConditions = reqDto.getQueryCondition().split(";");
            String conditions = "";
            for (int i = 1; i < queryConditions.length; ++i) {
                conditions = conditions + ";" + queryConditions[i];
            }
            String mainName = queryConditions[0].split("=")[0];
            for (String mainCondition : mainConditionList = queryConditions[0].split("=")[1].split("\\|")) {
                newReqDto = new TouchSyncMainDataReqDto();
                CubeBeanUtils.copyProperties((Object)newReqDto, (Object)reqDto, (String[])new String[0]);
                newReqDto.setQueryCondition(mainName + "=" + mainCondition + conditions);
                reqDtoList.add(newReqDto);
            }
        }
        logger.info("2\u3001WebService \u4e3b\u6570\u636e\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(reqDtoList));
        ModelInfoReqDto modelInfoReqDto = null;
        for (TouchSyncMainDataReqDto dto : reqDtoList) {
            try {
                modelInfoReqDto = new ModelInfoReqDto();
                modelInfoReqDto.setDataType(dto.getDataType());
                JSONObject jsonObject = WebServiceUtil.invokeRemoteMethod(dto);
                logger.info("3\u3001WebService \u4e3b\u6570\u636e\u8bf7\u6c42\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)jsonObject);
                String toJSONString = jsonObject.toJSONString();
                modelInfoReqDto.setDataStr(DataDistributeImpl.getSyncDataStr(toJSONString, dto.getModelCode()));
                logger.info("4\u3001WebService \u4e3b\u6570\u636e\u6267\u884c\u8c03\u7528\u53c2\u6570\uff1a{}, \u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
                this.centerHandleRouteService.route(dto.getModelCode()).handle(modelInfoReqDto);
            }
            catch (Exception e) {
                logger.info("\u6267\u884c\u9519\u8bef , {} ", (Object)dto);
            }
        }
        return "success";
    }

    @Override
    public List<String> queryByMasterData(TouchSyncMainDataExtReqDto reqDto) {
        this.examineData(reqDto);
        logger.info("1\u3001\u67e5\u8be2WebService \u4e3b\u6570\u636e\u8bf7\u6c42\u53c2\u6570 {}", (Object)JSONObject.toJSONString((Object)reqDto));
        String[] queryConditions = reqDto.getQueryCondition().split(";");
        String conditions = "";
        for (int i = 1; i < queryConditions.length; ++i) {
            conditions = conditions + ";" + queryConditions[i];
        }
        String mainName = queryConditions[0].split("=")[0];
        String[] mainConditionList = queryConditions[0].split("=")[1].split("\\|");
        ArrayList<TouchSyncMainDataReqDto> reqDtoList = new ArrayList<TouchSyncMainDataReqDto>();
        TouchSyncMainDataReqDto newReqDto = null;
        for (String mainCondition : mainConditionList) {
            newReqDto = new TouchSyncMainDataReqDto();
            CubeBeanUtils.copyProperties((Object)newReqDto, (Object)reqDto, (String[])new String[0]);
            newReqDto.setQueryCondition(mainName + "=" + mainCondition + conditions);
            reqDtoList.add(newReqDto);
        }
        logger.info("2\u3001\u67e5\u8be2WebService \u4e3b\u6570\u636e\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(reqDtoList));
        ArrayList<String> list = new ArrayList<String>();
        ModelInfoReqDto modelInfoReqDto = null;
        for (TouchSyncMainDataReqDto dto : reqDtoList) {
            modelInfoReqDto = new ModelInfoReqDto();
            modelInfoReqDto.setDataType(dto.getDataType());
            JSONObject jsonObject = WebServiceUtil.invokeRemoteMethod(dto);
            logger.info("3\u3001\u67e5\u8be2WebService \u4e3b\u6570\u636e\u8bf7\u6c42\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)jsonObject);
            String toJSONString = jsonObject.toJSONString();
            String dataStr = DataDistributeImpl.getSyncDataStr(toJSONString, dto.getModelCode());
            list.add(dataStr);
            logger.info("4\u3001\u67e5\u8be2WebService \u4e3b\u6570\u636e\u8f6c\u6362\u683c\u5f0f\u540e\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)dataStr));
        }
        return list;
    }

    public void examineData(TouchSyncMainDataExtReqDto reqDto) {
        reqDto.setQueryField("");
        if (StringUtils.isEmpty((CharSequence)reqDto.getDataType())) {
            reqDto.setDataType("JSON");
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getIsVague())) {
            reqDto.setIsVague("yes");
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getUserName())) {
            reqDto.setUserName("cps");
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getPassword())) {
            reqDto.setPassword("Csp12345");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getQueryCondition())) {
            reqDto.setQueryCondition(this.modelCodeEnum(reqDto.getQueryCondition()));
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getUrl())) {
            reqDto.setUrl("http://10.8.0.115:9119/cidp/ws/intfsServiceWS");
        }
    }

    public String modelCodeEnum(String modelCode) {
        switch (modelCode) {
            case "MATERIAL": {
                return "FNUMBER=" + modelCode;
            }
        }
        return modelCode;
    }

    private static String getDataStr(String dataStr, String modelCode) {
        ArrayList list = new ArrayList();
        Map maps = (Map)JSONArray.parseObject((String)dataStr, Map.class);
        String modelData = maps.get("LIST").toString();
        List modelMaps = JSONArray.parseArray((String)modelData, Map.class);
        modelMaps.stream().forEach(t -> {
            List mapList = JSONArray.parseArray((String)("[" + t.get(modelCode).toString() + "]"), Map.class);
            for (Map data : mapList) {
                data.put(ModelCodeEnum.CIDP_TASK_UUID.name(), ObjectUtil.isEmpty(t.get(ModelCodeEnum.CIDP_TASK_UUID.name())) ? RandomCodeUtil.generateTextCode((int)0, (int)10) : t.get(ModelCodeEnum.CIDP_TASK_UUID.name()).toString());
                DataDistributeImpl.transDate2Long(data, modelCode);
                list.add(data);
            }
        });
        return JSONArray.toJSONString(list);
    }

    private static void transDate2Long(Map<String, Object> data, String modelCode) {
        if (!modelCode.equals(ModelCodeEnum.OUTSIDER.name())) {
            logger.info("modelCode\u4e0d\u4e3aOUTSIDER\uff0c\u8df3\u8fc7\u65e5\u671f\u5b57\u6bb5\u683c\u5f0f\u8f6c\u6362");
            return;
        }
        logger.info("modelCode\u4e3aOUTSIDER\uff0c\u8f6c\u6362\u65e5\u671f\u5b57\u6bb5\u683c\u5f0f\u4e3a: String->Long; \u8f6c\u6362\u524d\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(data));
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String value;
            if (!entry.getKey().contains("DATE") || entry.getValue() == null || !(entry.getValue() instanceof String) || StringUtils.isEmpty((CharSequence)(value = (String)entry.getValue()))) continue;
            try {
                Date endDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(value);
                entry.setValue(endDate.getTime());
            }
            catch (ParseException e) {}
        }
        logger.info("modelCode\u4e3aOUTSIDER\uff0c\u8f6c\u6362\u65e5\u671f\u5b57\u6bb5\u683c\u5f0f\u4e3a: String->Long; \u8f6c\u6362\u540e\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(data));
    }

    private static String getSyncDataStr(String dataStr, String modelCode) {
        if (dataStr == null) {
            return null;
        }
        ArrayList<Map> list = new ArrayList<Map>();
        Map maps = (Map)JSONArray.parseObject((String)dataStr, Map.class);
        String modelData = maps.get("LIST").toString();
        List modelMaps = JSONArray.parseArray((String)modelData, Map.class);
        Map map = null;
        for (Map data : modelMaps) {
            map = (Map)data.get(modelCode);
            data.put(ModelCodeEnum.CIDP_TASK_UUID.name(), RandomCodeUtil.generateTextCode((int)0, (int)6));
            list.add(map);
        }
        return JSONArray.toJSONString(list);
    }

    @Override
    public MainDataResult synViewData(String modelCode, Map params, String order, Integer pageNum, Integer pageSize, boolean selectOne) {
        if (pageSize > 1000 || pageSize < 1) {
            pageSize = 1000;
        }
        if (pageNum < 1) {
            pageNum = 1;
        }
        try {
            logger.info("====================\u5f00\u59cb\u67e5\u8be2\u8425\u9500\u4e91\u89c6\u56fe=====================");
            List list = null;
            if (StringUtils.equals((CharSequence)ModelCodeEnum.NEW_CUSTOMER_MATERIAL_REL.name(), (CharSequence)modelCode)) {
                List partnerIdList = this.dataDistributeDas.selectCustomerData(String.valueOf(params.get("d_master_ou_id")));
                pageSize = partnerIdList.size();
                MainDataResult result = new MainDataResult();
                ModelInfoReqDto modelInfoReqDto = new ModelInfoReqDto();
                modelCode = ModelCodeEnum.NEW_CUSTOMER_MATERIAL_REL.name();
                params = new HashMap<String, String>();
                for (String partnerId : partnerIdList) {
                    params.put("D_PARTNER_ID", partnerId);
                    list = this.dataDistributeDas.selectViewData(modelCode, params, order, pageNum, pageSize);
                    modelInfoReqDto.setDataStr(DataDistributeImpl.getViewData(modelCode, list));
                    result.setResult(this.centerHandleRouteService.route(modelCode).handle(modelInfoReqDto));
                }
                return result;
            }
            list = this.dataDistributeDas.selectViewData(modelCode, (Map)params, order, pageNum, pageSize);
            MainDataResult result = new MainDataResult();
            while (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                ModelInfoReqDto modelInfoReqDto = new ModelInfoReqDto();
                modelInfoReqDto.setDataStr(DataDistributeImpl.getViewData(modelCode, list));
                result.setResult(this.centerHandleRouteService.route(modelCode).handle(modelInfoReqDto));
                Integer n = pageNum;
                Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
                list = StringUtils.equals((CharSequence)"MATERIAL", (CharSequence)modelCode) ? this.syncItem(modelCode, params, order, pageNum, pageSize) : this.dataDistributeDas.selectViewData(modelCode, params, order, pageNum, pageSize);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    logger.info("\u67e5\u8be2\u6570\u636e\u4e3a0\uff0c\u540c\u6b65\u5b8c\u6210");
                }
                logger.info("\u540c\u6b65\u89c6\u56fe\uff0c\u5f53\u524d\u9875\uff1a{}", (Object)pageNum);
            }
            return result;
        }
        catch (Exception e) {
            logger.error(" \u67e5\u8be2\u9519\u8bef -->>> {}", (Object)JSONObject.toJSONString((Object)e, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return null;
        }
    }

    public MainDataResult synDbViewData(String modelCode, Map params, String order, Integer pageNum, Integer pageSize, boolean selectOne) {
        if (pageSize > 1000 || pageSize < 1) {
            pageSize = 1000;
        }
        if (pageNum < 1) {
            pageNum = 1;
        }
        try {
            logger.info("====================\u5f00\u59cb\u67e5\u8be2openapi\u8868\u89c6\u56fe=====================");
            List list = this.dbDataDistributeDas.selectDbViewData(modelCode, params, order, pageNum, pageSize);
            if (CollectionUtils.isEmpty((Collection)list)) {
                logger.info("\u67e5\u8be2\u6570\u636e\u4e3a0\uff0c\u540c\u6b65\u5b8c\u6210");
            }
            MainDataResult result = new MainDataResult();
            while (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                ModelInfoReqDto modelInfoReqDto = new ModelInfoReqDto();
                modelInfoReqDto.setDataStr(DataDistributeImpl.getViewData(modelCode, list));
                String modelCodeRoute = modelCode;
                if (Objects.equals(ModelCodeEnum.MP_CX_AWK_PARTNER.name(), modelCode)) {
                    modelCodeRoute = ModelCodeEnum.CUSTOMER.name();
                } else if (Objects.equals(ModelCodeEnum.MP_CX_AWK_PERSON.name(), modelCode)) {
                    modelCodeRoute = ModelCodeEnum.OUTSIDER.name();
                } else if (Objects.equals(ModelCodeEnum.MP_CX_DISTRIBU_REL.name(), modelCode)) {
                    modelCodeRoute = ModelCodeEnum.CUSTOMER_MATERIAL_REL.name();
                }
                result.setResult(this.centerHandleRouteService.route(modelCodeRoute).handle(modelInfoReqDto));
                logger.info("\u540c\u6b65\u89c6\u56fe\uff0c\u5f53\u524d\u9875\uff1a{}", (Object)pageNum);
                Integer n = pageNum;
                Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
                list = this.dbDataDistributeDas.selectDbViewData(modelCode, params, order, pageNum, pageSize);
                if (!CollectionUtils.isEmpty((Collection)list)) continue;
                logger.info("\u67e5\u8be2\u6570\u636e\u4e3a0\uff0c\u540c\u6b65\u5b8c\u6210");
                break;
            }
            return result;
        }
        catch (Exception e) {
            logger.error(" \u67e5\u8be2\u9519\u8bef -->>> {}", (Object)JSONObject.toJSONString((Object)e, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return null;
        }
    }

    @Override
    public List<Map<String, String>> selectViewData(String modelCode, Map params, String order, Integer pageNum, Integer pageSize) {
        if (pageSize > 100 || pageSize < 1) {
            pageSize = 100;
        }
        if (pageNum < 1) {
            pageNum = 1;
        }
        List list = null;
        list = StringUtils.equals((CharSequence)"MATERIAL", (CharSequence)modelCode) ? this.syncItem(modelCode, params, order, pageNum, pageSize) : this.dataDistributeDas.selectViewData(modelCode, params, order, pageNum, pageSize);
        return list;
    }

    @Override
    public MainDataResult synViewDataReq(ViewDateReqDto reqDto) {
        logger.info("\u6267\u884c\u540c\u6b65\u89c6\u56fe\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        Integer pageSize = reqDto.getPageSize();
        Integer pageNum = reqDto.getPageNum();
        String modelCode = reqDto.getModelCode();
        if (pageSize > 1000 || pageSize < 1) {
            pageSize = 1000;
        }
        if (pageNum < 1) {
            pageNum = 1;
        }
        if (Objects.equals(reqDto.getDbModelCode(), ModelCodeEnum.DB_MAIN_DATA.name())) {
            this.synDbViewData(modelCode, reqDto.getParams(), reqDto.getOrder(), pageNum, pageSize, reqDto.isSelectOne());
        } else if (reqDto.getModelCode().equals(ModelCodeEnum.CUSTOMER_MATERIAL_REL.name()) || reqDto.getModelCode().equals(ModelCodeEnum.NEW_CUSTOMER_MATERIAL_REL.name())) {
            this.centerHandleCustomerMaterialRelService.handle(reqDto.getParams());
        } else if (reqDto.getModelCode().equals(ModelCodeEnum.CUSTOMER_ZB.name())) {
            ModelInfoReqDto modelInfoReqDto = new ModelInfoReqDto();
            modelInfoReqDto.setDataStr(JSON.toJSONString((Object)reqDto.getParams()));
            this.centerHandleRouteService.route(reqDto.getModelCode()).handle(modelInfoReqDto);
        } else {
            this.synViewData(modelCode, reqDto.getParams(), reqDto.getOrder(), pageNum, pageSize, reqDto.isSelectOne());
        }
        return null;
    }

    @Override
    public List<List<Object>> downloadViewData(ViewDateReqDto reqDto) {
        Integer pageSize = reqDto.getPageSize();
        Integer pageNum = reqDto.getPageNum();
        String modelCode = reqDto.getModelCode();
        Map params = reqDto.getParams();
        String order = reqDto.getOrder();
        if (pageSize > 1000000 || pageSize < 1) {
            pageSize = 1000000;
        }
        if (pageNum < 1) {
            pageNum = 1;
        }
        List list = this.dataDistributeDas.downloadViewData(modelCode, params, order, pageNum, pageSize);
        List<Object> headList = Arrays.asList(params.keySet().toArray());
        ArrayList<List<Object>> dataList = new ArrayList<List<Object>>();
        ArrayList content = null;
        for (Map map : list) {
            content = new ArrayList();
            for (Object head : headList) {
                if (map.get(head) == null) continue;
                content.add(map.get(head));
            }
            dataList.add(content);
        }
        return dataList;
    }

    @Override
    public List<Map<String, String>> selectPersonViewData(List<String> idList) {
        List list = this.dataDistributeDas.selectPersonViewData(idList);
        return list;
    }

    @Override
    public List<Map<String, String>> selectCustomerViewData(List<String> idList) {
        List list = this.dataDistributeDas.selectCustomerViewData(idList);
        return list;
    }

    @Override
    public List<Map<String, String>> selectCustomerItemViewData(List<String> dealerIdList) {
        return this.dataDistributeDas.selectCustomerItemList(dealerIdList);
    }

    @Override
    @DS(value="slave_2")
    public String touchSyncInventory(TouchSyncMainDataReqDto reqDto) {
        List orgIdList = reqDto.getOrgIdList();
        if (CollectionUtils.isEmpty((Collection)orgIdList)) {
            return "";
        }
        for (String orgId : orgIdList) {
            TcbjCompareReqDto tcbjCompareReqDto = new TcbjCompareReqDto();
            tcbjCompareReqDto.setId("INIT" + System.currentTimeMillis());
            tcbjCompareReqDto.setTenantId(orgId);
            List yxyInventoryVoList = this.sellerSkuPriceMapper.selectListByOrgIdList((List)Lists.newArrayList((Object[])new String[]{orgId}));
            if (CollectionUtils.isEmpty((Collection)yxyInventoryVoList)) {
                logger.info("\u79df\u6237id\u4e3a:{}\uff0c\u5e93\u5b58\u6570\u636e\u4e3a\u7a7a", (Object)orgId);
                continue;
            }
            logger.info("yxyInventoryVoList---\u300bsize\uff1a{}", (Object)yxyInventoryVoList.size());
            ArrayList cargos = Lists.newArrayList();
            yxyInventoryVoList.forEach(n -> {
                TcbjCompareReqDto.TcbjCompareReqItemDto tcbjCompareReqItemDto = new TcbjCompareReqDto.TcbjCompareReqItemDto();
                String baseqty = n.getBaseqty();
                tcbjCompareReqItemDto.setAfterNum(Integer.valueOf(baseqty.split("\\.")[0]));
                tcbjCompareReqItemDto.setBatch(n.getLot());
                tcbjCompareReqItemDto.setCargoCode(n.getMaterialNo());
                tcbjCompareReqItemDto.setExpireDate(DateUtil.parseDate((String)n.getExp(), (String)"yyyy-MM-dd"));
                tcbjCompareReqItemDto.setProductDate(DateUtil.parseDate((String)n.getMfg(), (String)"yyyy-MM-dd"));
                tcbjCompareReqItemDto.setWarehouseCode(n.getDepotNo());
                tcbjCompareReqItemDto.setBeforeNum(Integer.valueOf(0));
                cargos.add(tcbjCompareReqItemDto);
            });
            tcbjCompareReqDto.setCargos((List)cargos);
            this.executorService.execute(new Thread(() -> {
                RestResponse adjust = this.iTcbjInventoryApi.adjust(tcbjCompareReqDto);
                logger.info("\u521d\u59cb\u5316\u5e93\u5b58\u5b8c\u6210:{}", (Object)JacksonUtil.toJson((Object)adjust));
            }));
        }
        return null;
    }

    @Override
    public void synItemViewData(ViewDateReqDto reqDto) {
        try {
            String modelCode = reqDto.getModelCode();
            Map params = reqDto.getParams();
            Integer pageNum = reqDto.getPageNum();
            Integer pageSize = reqDto.getPageSize();
            String order = reqDto.getOrder();
            logger.info("====================\u5f00\u59cb\u67e5\u8be2\u8425\u9500\u4e91\u89c6\u56fe=====================");
            List<Map<String, String>> list = this.syncItem(modelCode, params, order, pageNum, pageSize);
            while (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
                MainDataResult result = new MainDataResult();
                ModelInfoReqDto modelInfoReqDto = new ModelInfoReqDto();
                modelInfoReqDto.setDataStr(DataDistributeImpl.getViewData(modelCode, list));
                result.setResult(this.centerHandleRouteService.route(modelCode).handle(modelInfoReqDto));
                Integer n = pageNum;
                Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
                list = this.syncItem(modelCode, params, order, pageNum, pageSize);
                if (CollectionUtils.isEmpty(list)) {
                    logger.info("\u67e5\u8be2\u6570\u636e\u4e3a0\uff0c\u540c\u6b65\u5b8c\u6210");
                }
                logger.info("\u540c\u6b65\u89c6\u56fe\uff0c\u5f53\u524d\u9875\uff1a{}", (Object)pageNum);
            }
        }
        catch (Exception e) {
            logger.error(" \u67e5\u8be2\u9519\u8bef -->>> {}", (Object)JSONObject.toJSONString((Object)e, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
    }

    @Override
    public void synCustomerItemViewDataByOrgId(ViewDateReqDto reqDto) {
    }

    @Override
    @DS(value="slave_2")
    public List<List<Object>> downloadInventoryViewData(ViewDateReqDto reqDto) {
        if (StringUtils.equals((CharSequence)"syncInventory", (CharSequence)reqDto.getModelCode())) {
            List objects = this.sellerSkuPriceMapper.selectListByYxyTenantIdList(reqDto.getOrgIdList());
            ArrayList newArrayList = Lists.newArrayList();
            newArrayList.add(objects);
            return newArrayList;
        }
        return null;
    }

    private static String getViewData(String modelCode, List<Map<String, String>> list) {
        ArrayList dataList = new ArrayList();
        for (Map<String, String> map : list) {
            HashMap<String, String> fileds = new HashMap<String, String>();
            for (String key : map.keySet()) {
                if (key.startsWith(VIEW_COLUMN_PREFIX)) {
                    fileds.put(key.substring(2), map.get(key));
                    continue;
                }
                fileds.put(key, map.get(key));
            }
            fileds.put("CIDP_TASK_UUID", RandomCodeUtil.generateTextCode((int)0, (int)6));
            dataList.add(fileds);
        }
        return JSONArray.toJSONString(dataList);
    }

    private List<Map<String, String>> syncItem(String modelCode, Map params, String order, Integer pageNum, Integer pageSize) {
        if (MapUtils.isEmpty((Map)params)) {
            return this.opTempItemDas.selectAllMaterial(Integer.valueOf((pageNum - 1) * pageSize), Integer.valueOf(pageNum * pageSize));
        }
        return this.opTempItemDas.selectMaterial(params, order, Integer.valueOf((pageNum - 1) * pageSize), Integer.valueOf(pageNum * pageSize));
    }

    @Override
    @DS(value="slave_2")
    public String exportInventory(ViewDateReqDto reqDto) {
        logger.info("\u5bfc\u51fa\u8425\u9500\u4e91\u7684\u89c6\u56fe\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        if (!StringUtils.equals((CharSequence)"syncInventory", (CharSequence)reqDto.getModelCode())) {
            return "";
        }
        List yxyInventoryVoList = this.sellerSkuPriceMapper.selectListByOrgIdList(reqDto.getOrgIdList());
        if (CollectionUtils.isEmpty((Collection)yxyInventoryVoList)) {
            logger.info("\u79df\u6237id\u4e3a\u6570\u636e\u4e3a\u7a7a");
            return "";
        }
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)yxyInventoryVoList, YxyInventoryExportDto.class);
        String title = "\u8425\u9500\u4e91\u89c6\u56fe";
        String fileName = title + System.currentTimeMillis();
        try {
            logger.info("\u5bfc\u51fa\u8425\u9500\u4e91\u89c6\u56fedate\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            return EasyPoiExportUtil.getExportUrl(list, YxyInventoryExportDto.class, "", fileName, "xls");
        }
        catch (Exception e) {
            logger.info("\u5bfc\u51fa\u8425\u9500\u4e91\u89c6\u56fe\u5f02\u5e38date\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            e.printStackTrace();
            throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Override
    @DS(value="slave_2")
    public String exportOccupyInventory(ViewDateReqDto reqDto) {
        logger.info("\u5bfc\u51fa\u8425\u9500\u4e91\u7684\u89c6\u56fe\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        if (!StringUtils.equals((CharSequence)"syncInventory", (CharSequence)reqDto.getModelCode())) {
            return "";
        }
        List yxyInventoryVoList = this.sellerSkuPriceMapper.selectOccupyListByOrgIdList(reqDto.getOrgIdList());
        if (CollectionUtils.isEmpty((Collection)yxyInventoryVoList)) {
            logger.info("\u79df\u6237id\u4e3a\u6570\u636e\u4e3a\u7a7a");
            return "";
        }
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)yxyInventoryVoList, YxyInventoryExportDto.class);
        String title = "\u8425\u9500\u4e91\u6709\u9884\u5360\u7684\u89c6\u56fe";
        String fileName = title + System.currentTimeMillis();
        try {
            logger.info("\u5bfc\u51fa\u8425\u9500\u4e91\u89c6\u56fedate\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            return EasyPoiExportUtil.getExportUrl(list, YxyInventoryExportDto.class, "", fileName, "xls");
        }
        catch (Exception e) {
            logger.info("\u5bfc\u51fa\u8425\u9500\u4e91\u89c6\u56fe\u5f02\u5e38date\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            e.printStackTrace();
            throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Override
    @DS(value="slave_2")
    public List<YxyInventoryVo> queryOccupyInventoryByNumberList(List<String> numberList) {
        return CollectionUtils.isEmpty(numberList) ? null : this.sellerSkuPriceMapper.selectOccupyInventoryByNumberList(numberList);
    }

    @Override
    @DS(value="slave_2")
    public List<YxyInventoryVo> queryListByOrgIdList(List<String> orgIdList) {
        return CollectionUtils.isEmpty(orgIdList) ? null : this.sellerSkuPriceMapper.selectListByOrgIdList(orgIdList);
    }

    @Override
    @DS(value="slave_1")
    public List<Map<String, String>> selectOrganizationPartner(Map params) {
        return this.dataDistributeDas.selectOrganizationPartner(params);
    }
}

