/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.pay.AbstractPayHelp;
import com.dtyunxi.tcbj.app.open.biz.pay.PayFactory;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.pay.AddPayRecordReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.pay.OrderPayRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.pay.PayRecordToBRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.pay.SimplePayReqDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.PayMethodEnum;
import com.dtyunxi.yundt.cube.center.trade.api.IPayApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PayRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IPayQueryApi;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.rebate.api.IOfflineBalanceBillApi;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceBillReqDto;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillSourceEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillTypeEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBusinessEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayHelp {
    private static final Logger log = LoggerFactory.getLogger(PayHelp.class);
    private static final String WECHAT = "101";
    @Resource
    private ILockService lockService;
    @Autowired
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private IPayApi payApi;
    @Resource
    private IPayQueryApi payQueryApi;
    @Autowired
    private IOfflineBalanceBillApi offlineBalanceBillApi;
    @Resource
    private PayFactory payFactory;

    public void pay(OrderReqDto orderReqDto, Integer payStatus, String payType) {
        if (Objects.equals(payStatus, 1)) {
            try {
                AbstractPayHelp abstractPayHelp = this.payFactory.create(payType);
                SimplePayReqDto simplePayReqDto = abstractPayHelp.initParam(orderReqDto);
                simplePayReqDto.setPayMethod(payType);
                abstractPayHelp.successCallBack(simplePayReqDto);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("[erp\u63d0\u4ea4\u8ba2\u5355][\u652f\u4ed8\u5931\u8d25]:{}", (Object)e.getMessage());
            }
        }
    }

    public String orderPay(AddPayRecordReqDto addPayRecordReqDto) {
        String payRequest;
        if (StringUtils.isBlank((CharSequence)addPayRecordReqDto.getOrderNo())) {
            throw new BizException("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), addPayRecordReqDto.getOrderNo(), 1500, 1500, TimeUnit.MILLISECONDS);
        try {
            OrderDetailRespDto orderDetailRespDto = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)this.orderBizQueryApi.getOrderDetail(addPayRecordReqDto.getOrderNo()));
            if (!this.validateAmount(addPayRecordReqDto.getOrderNo(), addPayRecordReqDto.getPayAmount()).booleanValue()) {
                throw new BizException("12025", "\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba2\u5355\u91d1\u989d");
            }
            PayMethodReqDto payMethodReqDto = new PayMethodReqDto();
            payMethodReqDto.setFlowDefId(Long.valueOf(0L));
            payMethodReqDto.setOrderNo(addPayRecordReqDto.getOrderNo());
            payMethodReqDto.setPayFlowName("PAY_TOB");
            payMethodReqDto.setPayMethod(addPayRecordReqDto.getPayMethod());
            payMethodReqDto.setTradeNo(addPayRecordReqDto.getOrderNo());
            payMethodReqDto.setOpenId(addPayRecordReqDto.getOpenId());
            HashMap<String, Object> addrExtFields = new HashMap<String, Object>();
            addrExtFields.put("account", addPayRecordReqDto.getAccount());
            addrExtFields.put("attachements", addPayRecordReqDto.getAttachmentList());
            addrExtFields.put("confirmTime", new Date());
            addrExtFields.put("creditAmount", addPayRecordReqDto.getCreditPayAmount());
            addrExtFields.put("payAmount", addPayRecordReqDto.getPayAmount());
            addrExtFields.put("payTime", addPayRecordReqDto.getPayDate());
            addrExtFields.put("remark", addPayRecordReqDto.getRemark());
            addrExtFields.put("storeAmount", addPayRecordReqDto.getStorePayAmount());
            String payMeth = "";
            switch (addPayRecordReqDto.getPayMethod()) {
                case "1": {
                    payMeth = PayMethodEnum.OFFLINE_AMOUNT_PAY.getCode();
                    break;
                }
                case "2": {
                    payMeth = PayMethodEnum.OFFLINE_PUBLIC_REMIT_PAY.getCode();
                    break;
                }
                case "3": {
                    payMeth = PayMethodEnum.CREDIT_PAY.getCode();
                    break;
                }
                case "4": {
                    payMeth = PayMethodEnum.STORED_AMOUNT_PAY.getCode();
                    break;
                }
                case "5": {
                    payMeth = WECHAT;
                    break;
                }
                case "8": {
                    payMeth = PayMethodEnum.ACCOUNT_PERIOD.getCode();
                    break;
                }
                case "10": {
                    payMeth = PayMethodEnum.NORMAL_PAY_HELP.getCode();
                    break;
                }
                case "15": {
                    payMeth = PayMethodEnum.OFFLINE_ACCOUNT_PAY.getCode();
                }
            }
            payMethodReqDto.setPayMethod(payMeth);
            payMethodReqDto.setExtFields(addrExtFields);
            if (StringUtils.isEmpty((CharSequence)addPayRecordReqDto.getDeviceType())) {
                addPayRecordReqDto.setDeviceType("PC");
            }
            payMethodReqDto.setDeviceType(ServiceContext.getContext().getAttachment("Application-Key"));
            log.info("\u53d1\u8d77modifyPayMethod\u8bf7\u6c42\u8c03\u7528\u8ba2\u5355\u652f\u4ed8\u63a5\u53e3,\u89e3\u6790\u7ed3\u679c\u4e3a{}", (Object)JSON.toJSONString((Object)payMethodReqDto));
            RestResponse restResponse = this.payApi.modifyPayMethod(addPayRecordReqDto.getOrderNo(), payMethodReqDto);
            payRequest = (String)RestResponseHelper.extractData((RestResponse)restResponse);
            if (!PayMethodEnum.OFFLINE_ACCOUNT_PAY.getCode().equals(payMeth) && BigDecimal.ZERO.compareTo(addPayRecordReqDto.getPayAmount()) < 0 && StringUtil.isNotBlank((CharSequence)payRequest)) {
                OfflineBalanceBillReqDto billReqDto = new OfflineBalanceBillReqDto();
                billReqDto.setBillDate(addPayRecordReqDto.getPayDate());
                billReqDto.setBillType(OfflineBalanceBillTypeEnum.RECEIPT.getCode());
                billReqDto.setBusinessContent(OfflineBalanceBusinessEnum.BUSINESS_ORDER.getCode());
                billReqDto.setCustomerId(Long.valueOf(orderDetailRespDto.getCustomerId()));
                billReqDto.setAmount(addPayRecordReqDto.getPayAmount());
                billReqDto.setBillSource(OfflineBalanceBillSourceEnum.ORDER_OFF_SUBMIT.getCode());
                billReqDto.setRelationNo(addPayRecordReqDto.getOrderNo());
                billReqDto.setReceiptRecordsNo(payRequest);
                log.info("\u7ebf\u4e0b\u652f\u4ed8\u65b0\u589e\u4f59\u989d\u5355\u636e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)billReqDto));
                RestResponseHelper.extractData((RestResponse)this.offlineBalanceBillApi.addOfflineBalanceBill(billReqDto));
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u652f\u4ed8\u8bb0\u5f55\u5f02\u5e38,\u539f\u56e0:" + e.getMessage());
            e.printStackTrace();
            throw new BizException("\u521b\u5efa\u652f\u4ed8\u8bb0\u5f55\u5f02\u5e38,\u539f\u56e0 " + e.getMessage());
        }
        finally {
            this.lockService.unlock(lock);
        }
        return payRequest;
    }

    public Boolean validateAmount(String orderNo, BigDecimal currentPayAmount) {
        try {
            RestResponse restResponse = this.orderBizQueryApi.getOrderDetail(orderNo);
            OrderDetailRespDto orderData = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
            if (null != orderData) {
                BigDecimal payAmount = orderData.getPayAmount();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("orderNo", (Object)orderNo);
                OrderPayRespDto orderPayRespDto = new OrderPayRespDto();
                BigDecimal alreadyPayAmount = this.buildPayRecord(jsonObject, orderPayRespDto);
                if (null != payAmount && null != currentPayAmount && null != alreadyPayAmount && alreadyPayAmount.add(currentPayAmount).compareTo(payAmount) > 0) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            log.info("\u4ed8\u6b3e\u65f6\u8ba2\u5355\u91d1\u989d\u6821\u9a8c\u5f02\u5e38\uff0corderNo:{}", (Object)orderNo);
        }
        return true;
    }

    private BigDecimal buildPayRecord(JSONObject jsonObject, OrderPayRespDto orderPayRespDto) {
        RestResponse pageInfoRestResponse = this.payQueryApi.queryByPage(jsonObject.toJSONString(), Integer.valueOf(1), Integer.valueOf(1000));
        PageInfo payRecordRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        BigDecimal alreadyPayAmount = new BigDecimal("0");
        if (payRecordRespDtoPageInfo != null && ((PageInfo)pageInfoRestResponse.getData()).getList() != null && ((PageInfo)pageInfoRestResponse.getData()).getList().size() > 0) {
            List list = ((PageInfo)pageInfoRestResponse.getData()).getList();
            List supplierReturnList = list.stream().map(this::buildPayRecordToBRespDto).collect(Collectors.toList());
            orderPayRespDto.setPayRecordList(supplierReturnList);
            alreadyPayAmount = this.countAlreadyPayAmount(list);
        }
        return alreadyPayAmount;
    }

    private PayRecordToBRespDto buildPayRecordToBRespDto(PayRecordRespDto payRecordRespDto) {
        Map extFields = payRecordRespDto.getExtFields();
        String storeAmount = extFields.get("storeAmount") + "";
        String payTime = extFields.get("payTime") + "";
        String confirmTime = extFields.get("confirmTime") + "";
        String remark = extFields.get("remark") + "";
        String creditAmount = extFields.get("creditAmount") + "";
        String account = extFields.get("account") + "";
        PayRecordToBRespDto payRecordToBRespDto = new PayRecordToBRespDto();
        payRecordToBRespDto.setPayTime(payTime);
        payRecordToBRespDto.setCreditPayAmount(creditAmount);
        payRecordToBRespDto.setStorePayAmount(storeAmount);
        payRecordToBRespDto.setAccount(account.equals("null") ? "\u7a7a" : account);
        payRecordToBRespDto.setRemark(remark);
        payRecordToBRespDto.setConfirmTime(payRecordRespDto.getPayStartTime());
        payRecordToBRespDto.setCreateTime(payRecordRespDto.getPayStartTime());
        payRecordToBRespDto.setPayAmount(payRecordRespDto.getPayAmount());
        payRecordToBRespDto.setPayMethod(payRecordRespDto.getPayMethod());
        payRecordToBRespDto.setPayMethodName(null == PayMethodEnum.toName((String)payRecordRespDto.getPayMethod()) ? "\u5176\u4ed6" : PayMethodEnum.toName((String)payRecordRespDto.getPayMethod()));
        payRecordToBRespDto.setPayNo(payRecordRespDto.getPayNo());
        payRecordToBRespDto.setPayStatus("SUCCESS".equals(payRecordRespDto.getPayStatus()) ? "2" : "1");
        payRecordToBRespDto.setPayStatusForALl(payRecordRespDto.getPayStatus());
        PayStatusEnum byName = PayStatusEnum.getByName((String)payRecordRespDto.getPayStatus());
        payRecordToBRespDto.setPayStatusForALlName(null != byName ? byName.getMsg() : null);
        return payRecordToBRespDto;
    }

    private BigDecimal countAlreadyPayAmount(List<PayRecordRespDto> list) {
        BigDecimal alreadyPayAmount = null;
        try {
            alreadyPayAmount = list.stream().filter(data -> "SUCCESS".equals(data.getPayStatus())).collect(Collectors.toList()).stream().map(item -> item.getPayAmount() == null ? BigDecimal.ZERO : item.getPayAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            alreadyPayAmount = alreadyPayAmount.setScale(2, 1);
        }
        catch (Exception e) {
            log.info("\u7d2f\u52a0\u5df2\u652f\u4ed8\u91d1\u989d\u5931\u8d25:{}" + JSON.toJSONString(list));
            log.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
            e.printStackTrace();
            throw new BizException("\u7d2f\u52a0\u5df2\u652f\u4ed8\u91d1\u989d\u5931\u8d25");
        }
        return alreadyPayAmount;
    }
}

