/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl.db;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.enums.DBOrganizationColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAndOrgInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="centerHandleOrgDBServiceImpl")
public class CenterHandleOrgDBServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleOrgDBServiceImpl.class);
    @Autowired
    private IOrganizationApi organizationApi;
    @Autowired
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Autowired
    private IBizOrganizationQueryApi bizOrganizationQueryApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.MP_CX_ORGANIZATION.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        ArrayList<DataDistributeRespDto> respDtoList = null;
        try {
            logger.info("\u7ec4\u7ec7\u6a21\u578b\u6570\u636e\u5206\u53d1:{}", (Object)JSON.toJSONString((Object)modelInfoReqDto));
            List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
            logger.info("\u7ec4\u7ec7\u6a21\u578b\u6570\u636emap\u8f6c\u6362\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)maps));
            ArrayList<String> listCode = new ArrayList<String>();
            for (Map map : maps) {
                String code = map.get(DBOrganizationColumnEnum.ORGCODE.getName()).toString();
                listCode.add(code);
            }
            List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.bizOrganizationQueryApi.getOrganizations(listCode));
            Map<Object, Object> orgMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)organizationDtos)) {
                orgMap = organizationDtos.stream().collect(Collectors.toMap(OrganizationDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            respDtoList = new ArrayList<DataDistributeRespDto>();
            for (Map map : maps) {
                OrganizationInfoDto infoDto = new OrganizationInfoDto();
                OrganizationDto organizationDto = new OrganizationDto();
                String taskId = String.valueOf(map.get(ModelCodeEnum.CIDP_TASK_UUID.getValue()));
                DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
                dataDistributeRespDto.setTask_id(taskId);
                OrgAndOrgInfoReqDto orgAndOrgInfoReqDto = this.enumCopyObject(infoDto, organizationDto, map);
                String code = map.get(DBOrganizationColumnEnum.ORGCODE.getName()).toString();
                if (orgMap.containsKey(code)) {
                    OrganizationDto datum = (OrganizationDto)orgMap.get(code);
                    respDtoList.add(dataDistributeRespDto);
                    continue;
                }
                orgAndOrgInfoReqDto.setOrganizationDto(organizationDto);
                orgAndOrgInfoReqDto.setOrganizationInfoDto(infoDto);
                RestResponse longRestResponse = this.organizationApi.addOrgAndOrgInfo(orgAndOrgInfoReqDto);
                dataDistributeRespDto.setType(longRestResponse.getResultCode());
                dataDistributeRespDto.setReason(longRestResponse.getResultMsg());
                respDtoList.add(dataDistributeRespDto);
            }
            logger.info("\u7ec4\u7ec7\u6a21\u578b\u6570\u636e\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString(respDtoList));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return respDtoList;
    }

    public OrgAndOrgInfoReqDto enumCopyObject(OrganizationInfoDto infoDto, OrganizationDto organizationDto, Map map) {
        OrgAndOrgInfoReqDto orgAndOrgInfoReqDto = new OrgAndOrgInfoReqDto();
        String code = map.get(DBOrganizationColumnEnum.ORGCODE.getName()).toString();
        infoDto.setOrgCode(code);
        if (StringUtils.isNotEmpty((CharSequence)String.valueOf(map.get(DBOrganizationColumnEnum.ORGNAME.getName())))) {
            infoDto.setOrgName(String.valueOf(map.get(DBOrganizationColumnEnum.ORGNAME.getName())));
        }
        infoDto.setSimpleName(String.valueOf(map.get(DBOrganizationColumnEnum.SHORTNAME.getName())));
        organizationDto.setCode(code);
        organizationDto.setType(String.valueOf(map.get(DBOrganizationColumnEnum.ORGTYPE.getName())));
        organizationDto.setName(String.valueOf(map.get(DBOrganizationColumnEnum.ORGNAME.getName())));
        organizationDto.setName_i1(String.valueOf(map.get(DBOrganizationColumnEnum.SHORTNAME.getName())));
        orgAndOrgInfoReqDto.setOrganizationDto(organizationDto);
        orgAndOrgInfoReqDto.setOrganizationInfoDto(infoDto);
        return orgAndOrgInfoReqDto;
    }
}

