/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import com.dtyunxi.tcbj.app.open.biz.utils.WebServiceUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTimeOutUtil {
    private static Logger logger = LoggerFactory.getLogger(WebServiceUtil.class);

    public static String post(String url, String body, Map<String, String> headers) throws IOException {
        return HttpTimeOutUtil.post(url, body, headers, null);
    }

    public static String post(String url, String body, Map<String, String> headers, Integer timeOutSecond) throws IOException {
        if (timeOutSecond == null || timeOutSecond <= 0) {
            timeOutSecond = 10;
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeOutSecond * 1000).setConnectionRequestTimeout(timeOutSecond * 1000).setSocketTimeout(timeOutSecond * 1000).setRedirectsEnabled(true).build();
        httpPost.setConfig(requestConfig);
        if (headers != null) {
            for (String charset : headers.keySet()) {
                httpPost.addHeader(charset, headers.get(charset));
            }
        }
        httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.create((String)"application/json", (String)"utf-8")));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        if (response != null && response.getStatusLine().getStatusCode() == 200) {
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        return null;
    }
}

