/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl.db;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.enums.DBOrganizationColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.price.api.ISyncPriceDataApi;
import com.dtyunxi.yundt.cube.center.shop.api.ISellerApi;
import com.dtyunxi.yundt.cube.center.shop.api.IShopApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAndOrgInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.yx.demo.center.xx.api.ISellerExtendsApi;
import com.yx.demo.center.xx.api.dto.request.SellerBizStatusReqDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="centerHandleOrgDBServiceImpl")
public class CenterHandleOrgDBServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleOrgDBServiceImpl.class);
    @Autowired
    private IOrganizationApi organizationApi;
    @Autowired
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Autowired
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private IShopApi shopApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerApi sellerApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private ISellerExtendsApi sellerExtendsApi;
    @Resource
    private ISyncPriceDataApi syncPriceDataApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.MP_CX_ORGANIZATION.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        ArrayList<DataDistributeRespDto> respDtoList = null;
        try {
            logger.info("\u7ec4\u7ec7\u6a21\u578b\u6570\u636e\u5206\u53d1:{}", (Object)JSON.toJSONString((Object)modelInfoReqDto));
            List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
            logger.info("\u7ec4\u7ec7\u6a21\u578b\u6570\u636emap\u8f6c\u6362\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)maps));
            ArrayList<String> listCode = new ArrayList<String>();
            for (Map map : maps) {
                String code = map.get(DBOrganizationColumnEnum.ORGCODE.getName()).toString();
                listCode.add(code);
            }
            List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.bizOrganizationQueryApi.getOrganizations(listCode));
            Map<Object, Object> orgMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)organizationDtos)) {
                orgMap = organizationDtos.stream().collect(Collectors.toMap(OrganizationDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            MDC.put((String)"yes.req.userCode", (String)"csp-sync");
            ServiceContext.getContext().set("yes.req.userCode", (Object)"csp-sync");
            Long orgId = null;
            respDtoList = new ArrayList<DataDistributeRespDto>();
            for (Map map : maps) {
                OrganizationInfoDto infoDto = new OrganizationInfoDto();
                OrganizationDto organizationDto = new OrganizationDto();
                String taskId = String.valueOf(map.get(ModelCodeEnum.CIDP_TASK_UUID.getValue()));
                DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
                dataDistributeRespDto.setTask_id(taskId);
                OrgAndOrgInfoReqDto orgAndOrgInfoReqDto = this.enumCopyObject(infoDto, organizationDto, map);
                String code = map.get(DBOrganizationColumnEnum.ORGCODE.getName()).toString();
                if (orgMap.containsKey(code)) {
                    OrganizationDto datum = (OrganizationDto)orgMap.get(code);
                    orgId = datum.getId();
                    respDtoList.add(dataDistributeRespDto);
                } else {
                    orgAndOrgInfoReqDto.setOrganizationDto(organizationDto);
                    orgAndOrgInfoReqDto.setOrganizationInfoDto(infoDto);
                    RestResponse longRestResponse = this.organizationApi.addOrgAndOrgInfo(orgAndOrgInfoReqDto);
                    orgId = (Long)longRestResponse.getData();
                    dataDistributeRespDto.setType(longRestResponse.getResultCode());
                    dataDistributeRespDto.setReason(longRestResponse.getResultMsg());
                    respDtoList.add(dataDistributeRespDto);
                }
                if (orgId == null) continue;
                this.handleSellerShop(map, orgId);
            }
            logger.info("\u7ec4\u7ec7\u6a21\u578b\u6570\u636e\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString(respDtoList));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return respDtoList;
    }

    public OrgAndOrgInfoReqDto enumCopyObject(OrganizationInfoDto infoDto, OrganizationDto organizationDto, Map map) {
        OrgAndOrgInfoReqDto orgAndOrgInfoReqDto = new OrgAndOrgInfoReqDto();
        String code = map.get(DBOrganizationColumnEnum.ORGCODE.getName()).toString();
        infoDto.setOrgCode(code);
        if (StringUtils.isNotEmpty((CharSequence)String.valueOf(map.get(DBOrganizationColumnEnum.ORGNAME.getName())))) {
            infoDto.setOrgName(String.valueOf(map.get(DBOrganizationColumnEnum.ORGNAME.getName())));
        }
        infoDto.setSimpleName(String.valueOf(map.get(DBOrganizationColumnEnum.SHORTNAME.getName())));
        organizationDto.setCode(code);
        organizationDto.setType(String.valueOf(map.get(DBOrganizationColumnEnum.ORGTYPE.getName())));
        organizationDto.setName(String.valueOf(map.get(DBOrganizationColumnEnum.ORGNAME.getName())));
        organizationDto.setName_i1(String.valueOf(map.get(DBOrganizationColumnEnum.SHORTNAME.getName())));
        orgAndOrgInfoReqDto.setOrganizationDto(organizationDto);
        orgAndOrgInfoReqDto.setOrganizationInfoDto(infoDto);
        return orgAndOrgInfoReqDto;
    }

    private void handleSellerShop(Map<String, String> map, Long orgId) {
        List respDtos;
        SellerQueryReqDto dto = new SellerQueryReqDto();
        String orgCode = map.get("ORG_CODE");
        String orgName = map.get("ORG_NAME");
        dto.setCode(orgCode);
        RestResponse restResponse = this.sellerQueryApi.queryList(dto);
        logger.info("\u67e5\u8be2\u7ecf\u9500\u5546\u5bf9\u5e94\u7684\u5e97\u94fa\uff1a{},  {}", (Object)JSONObject.toJSONString((Object)restResponse), (Object)JSONObject.toJSONString((Object)dto));
        Long sellerId = null;
        if (CollectionUtil.isNotEmpty((Collection)((Collection)restResponse.getData())) && !CollectionUtil.isEmpty(respDtos = ((List)restResponse.getData()).stream().filter(t -> t.getCode().equals(orgCode)).collect(Collectors.toList()))) {
            sellerId = ((SellerRespDto)respDtos.get(0)).getId();
        }
        SellerReqDto sellerReqDto = new SellerReqDto();
        sellerReqDto.setCode(orgCode);
        sellerReqDto.setName(orgName);
        sellerReqDto.setThirdSellerId(orgCode);
        sellerReqDto.setOwnerId(Long.valueOf(1L));
        sellerReqDto.setTenantId(Long.valueOf(1L));
        sellerReqDto.setInstanceId(Long.valueOf(2L));
        sellerReqDto.setStatus("NORMAL");
        sellerReqDto.setOrganizationName(orgName);
        sellerReqDto.setId(sellerId);
        if (sellerId == null) {
            sellerReqDto.setOrganizationId(orgId);
            logger.info("\u65b0\u589e\u5546\u94fa\uff1asellerReqDto = {}", (Object)JSONObject.toJSONString((Object)sellerReqDto));
            sellerId = (Long)this.sellerApi.addSeller(sellerReqDto, false).getData();
        } else {
            logger.info("\u4fee\u6539\uff1asellerReqDto = {}", (Object)JSONObject.toJSONString((Object)sellerReqDto));
            this.sellerApi.modifySeller(sellerReqDto, false);
        }
        SellerBizStatusReqDto sellerBizStatusReqDto = new SellerBizStatusReqDto();
        sellerBizStatusReqDto.setStatus("NORMAL");
        sellerBizStatusReqDto.setCode(sellerReqDto.getCode());
        this.sellerExtendsApi.changeStatus(sellerBizStatusReqDto);
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryByCode(orgCode).getData();
        logger.info("\u67e5\u8be2\u5230\u5e97\u94fa\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)shopDto));
        if (ObjectUtil.isEmpty((Object)shopDto)) {
            ShopDto shopReqDto = new ShopDto();
            shopReqDto.setCode(orgCode);
            shopReqDto.setName(orgName);
            shopReqDto.setType(Long.valueOf(1L));
            shopReqDto.setTenantId(Long.valueOf(1L));
            shopReqDto.setInstanceId(Long.valueOf(2L));
            shopReqDto.setOrganizationId(orgId);
            shopReqDto.setOrganizationCode(orgCode);
            shopReqDto.setOrganizationName(orgName);
            shopReqDto.setSellerId(sellerId);
            RestResponse shopResponse = this.shopApi.addShop(shopReqDto, false);
            logger.info("\u65b0\u589e\u5e97\u94fa\u4fe1\u606f {}", (Object)JSONObject.toJSONString((Object)shopResponse));
            try {
                this.initDefaultPrice((RestResponse<Long>)shopResponse, orgId, shopReqDto.getOrganizationName());
            }
            catch (Exception e) {
                logger.error("initDefaultPrice:Exception shopResponse={}", (Object)shopResponse);
                e.printStackTrace();
            }
        }
    }

    private void initDefaultPrice(RestResponse<Long> shopResponse, Long orgId, String orgName) {
        Long shopId = (Long)shopResponse.getData();
        this.syncPriceDataApi.initDefaultPrice(shopId, orgId, orgName);
    }
}

