/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.service.IOpenOrderService;
import com.dtyunxi.tcbj.app.open.biz.service.impl.order.OrderServiceImpl;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.OpenOrderPayRecordReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.OpenApiRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.OpenOrderPayRecordRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.OpenOrderUploadFileRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.pay.AddPayRecordReqDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class IOpenOrderServiceImpl
implements IOpenOrderService {
    private static final Logger log = LoggerFactory.getLogger(IOpenOrderServiceImpl.class);
    @Autowired
    OrderServiceImpl orderServiceImpl;

    @Override
    public OpenOrderPayRecordRespDto payRecord(OpenOrderPayRecordReqDto reqDto) {
        log.info("payRecord reqDto:{}", (Object)JSONObject.toJSONString((Object)reqDto));
        BigDecimal payAmount = reqDto.getPayAmount();
        if (payAmount.scale() > 2) {
            throw new BizException("payAmount\u5b57\u6bb5\u5c0f\u6570\u4f4d\u6570\u4e0d\u80fd\u8d85\u8fc72\u4f4d");
        }
        payAmount = payAmount.setScale(2, RoundingMode.HALF_UP);
        reqDto.setPayAmount(payAmount);
        Date payDate = this.parseDate(reqDto.getPayDate());
        if (payDate == null) {
            throw new BizException("payDate\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef \u683c\u5f0f: yyyy-MM-dd HH:mm:ss");
        }
        try {
            String payRequest = this.orderServiceImpl.orderPay(AddPayRecordReqDto.builder().orderNo(reqDto.getOrderNo()).payAmount(reqDto.getPayAmount()).payDate(payDate).payMethod(reqDto.getPayMethod()).remark(reqDto.getRemark()).build());
            log.info("payRecord payRequest:{}", (Object)payRequest);
        }
        catch (Exception e) {
            log.error("payRecord error", (Throwable)e);
            throw new BizException("\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5f02\u5e38" + e.getMessage());
        }
        return OpenOrderPayRecordRespDto.builder().orderNo(reqDto.getOrderNo()).build();
    }

    private Date parseDate(String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setLenient(false);
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public OpenOrderUploadFileRespDto uploadFile(MultipartFile file) {
        log.info("uploadFile file:{}", (Object)file.toString());
        String fileUrl = "";
        return OpenOrderUploadFileRespDto.builder().fileUrl(fileUrl).openApiRespDto(OpenApiRespDto.success()).build();
    }
}

