/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.constant;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.payment.util.HttpUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class DingdingSender {
    private Logger logger = LoggerFactory.getLogger(DingdingSender.class);
    @Value(value="${tcbj.dingding.url:}")
    private String url;
    @Value(value="${tcbj.dingding.accessToken:}")
    private String accessToken;
    @Value(value="${cube.global.profile:}")
    private String profile;
    @Value(value="${tcbj.dingding.tcbjAccessToken:}")
    private String tcbjAccessToken;

    public void sendMessage(String sendMessage) {
        SendDingDingMsgReqDto sendDingDingMsgReqDto = new SendDingDingMsgReqDto();
        sendDingDingMsgReqDto.setRemindType(1);
        sendDingDingMsgReqDto.setSendMessage(sendMessage);
        this.sendMessage(sendDingDingMsgReqDto);
    }

    public void sendMessage(SendDingDingMsgReqDto reqDto) {
        try {
            String url = this.url + "?access_token=" + this.tcbjAccessToken;
            this.logger.info("SendDingDingMsgReqDto={}, \u8bf7\u6c42url:{}", (Object)JSON.toJSONString((Object)((Object)reqDto)), (Object)url);
            String requestJson = this.getRequest(reqDto);
            this.logger.info("\u53d1\u8d77\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)requestJson);
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Content-Type", "application/json");
            String result = HttpUtil.post((String)url, (String)requestJson, headMap);
            this.logger.info("\u8bf7\u6c42\u8fd4\u56de\u4fe1\u606f\u4e3a:{}", (Object)result);
        }
        catch (Exception e) {
            this.logger.error("\u9489\u9489\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a{}" + e.getMessage(), (Throwable)e);
        }
    }

    private String getRequest(SendDingDingMsgReqDto reqDto) {
        RobotRequestParamDto paramDto = this.buildRequestParam(reqDto);
        return JSON.toJSONString((Object)((Object)paramDto));
    }

    private RobotRequestParamDto buildRequestParam(SendDingDingMsgReqDto reqDto) {
        return new RobotRequestParamDto().instance("text", this.profile + "\u73af\u5883openApi,reqId=" + MDC.get((String)"yes.req.requestId") + ":" + reqDto.getSendMessage(), reqDto.getRemindPhones(), reqDto.getRemindType() == 2);
    }

    public static class RobotRequestParamDto
    extends BaseVo {
        private String msgtype;
        private Text text;
        private At at;

        public RobotRequestParamDto instance(String msgtype, String content, List<String> atMobiles, Boolean isAtAll) {
            this.msgtype = msgtype;
            this.text = new Text(content);
            this.at = new At(atMobiles, isAtAll);
            return this;
        }

        public String getMsgtype() {
            return this.msgtype;
        }

        public void setMsgtype(String msgtype) {
            this.msgtype = msgtype;
        }

        public Text getText() {
            return this.text;
        }

        public void setText(Text text) {
            this.text = text;
        }

        public At getAt() {
            return this.at;
        }

        public void setAt(At at) {
            this.at = at;
        }

        class At {
            List<String> atMobiles;
            Boolean isAtAll;

            public At(List<String> atMobiles, Boolean isAtAll) {
                this.atMobiles = atMobiles;
                this.isAtAll = isAtAll;
            }

            public List<String> getAtMobiles() {
                return this.atMobiles;
            }

            public void setAtMobiles(List<String> atMobiles) {
                this.atMobiles = atMobiles;
            }

            public Boolean getIsAtAll() {
                return this.isAtAll;
            }

            public void setIsAtAll(Boolean atAll) {
                this.isAtAll = atAll;
            }
        }

        class Text {
            String content;

            public String getContent() {
                return this.content;
            }

            public void setContent(String content) {
                this.content = content;
            }

            public Text(String content) {
                this.content = content;
            }
        }
    }

    @ApiModel(value="SendDingDingMsgReqDto", description="\u53d1\u9001\u9489\u9489\u6d88\u606f\u8bf7\u6c42")
    public static class SendDingDingMsgReqDto
    extends BaseVo {
        @ApiModelProperty(name="sendPhones", value="\u9700\u8981@\u4eba\u7684\u624b\u673a\u53f7")
        private List<String> remindPhones;
        @ApiModelProperty(name="remindType", value="\u63d0\u9192\u6a21\u5f0f\uff1a0\uff1a\u4e0d\u8fdb\u884c\u63d0\u9192\uff1b1\uff1a\u4f7f\u7528remindPhones\u63d0\u9192\uff1b2\uff1a@\u6240\u6709\u4eba")
        private Integer remindType;
        @ApiModelProperty(name="sendMessage", value="\u53d1\u9001\u7684\u6d88\u606f\u4f53")
        private String sendMessage;

        public List<String> getRemindPhones() {
            return this.remindPhones;
        }

        public void setRemindPhones(List<String> remindPhones) {
            this.remindPhones = remindPhones;
        }

        public Integer getRemindType() {
            return this.remindType;
        }

        public void setRemindType(Integer remindType) {
            this.remindType = remindType;
        }

        public String getSendMessage() {
            return this.sendMessage;
        }

        public void setSendMessage(String sendMessage) {
            this.sendMessage = sendMessage;
        }
    }
}

