/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.service.IStringMatchService;
import com.dtyunxi.tcbj.app.open.biz.service.MarketingCloudService;
import com.dtyunxi.tcbj.app.open.biz.utils.StringMatchUtils;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.StringMatchReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.StringMatchRespDto;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StringMatchServiceImpl
implements IStringMatchService {
    private static final Logger logger = LoggerFactory.getLogger(StringMatchServiceImpl.class);
    @Resource
    private MarketingCloudService marketingCloudService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringMatchRespDto approximateMatch(StringMatchReqDto dto) {
        logger.info("\u3010\u5b57\u7b26\u4e32\u5339\u914d\u3011\u5b57\u7b26\u4e32\u6a21\u7cca\u5339\u914d\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        if (Objects.isNull(dto.getStrSource()) || Objects.isNull(dto.getStrTarget())) {
            throw new BizException("\u5173\u952e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringMatchRespDto respDto = new StringMatchRespDto();
        respDto.setErrorCode("00");
        respDto.setErrorMessage("\u6210\u529f");
        try {
            Double result = StringMatchUtils.pickAlgorithm(dto.getStrSource(), dto.getStrTarget(), dto.getStrAlgorithm());
            respDto.setResult(result * 100.0 + "%");
            logger.info("\u3010\u5b57\u7b26\u4e32\u5339\u914d\u3011\u5b57\u7b26\u4e32\u6a21\u7cca\u5339\u914d\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)respDto));
        }
        catch (Exception e) {
            respDto.setErrorCode("99");
            respDto.setErrorMessage("\u7b97\u6cd5\u8ba1\u7b97\u5f02\u5e38");
            respDto.setResult("\u7b97\u6cd5\u8ba1\u7b97\u5f02\u5e38");
            logger.error("\u3010\u5b57\u7b26\u4e32\u5339\u914d\u3011\u7b97\u6cd5\u8ba1\u7b97\u5f02\u5e38");
            e.printStackTrace();
        }
        finally {
            return respDto;
        }
    }
}

