/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.apiimpl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.constant.CommonConstant;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.BaseResponse;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.CspUserDto;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.DataSyncRequest;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.Role;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.RoleResourceRelation;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.TenantUserRelation;
import com.dtyunxi.tcbj.app.open.biz.csp.service.DataSyncService;
import com.dtyunxi.tcbj.center.openapi.api.IDataSyncExtApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.user.CreOrUpdRoleDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.user.CreOrUpdUserDto;
import com.dtyunxi.util.Base64;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.ITokenApi;
import com.dtyunxi.yundt.cube.center.identity.api.IUserLoginConfigApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginConfigReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IOrgRoleApi;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserOrgExpandApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.OrgRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserExtQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Service
public class DataSyncExtApiImpl
implements IDataSyncExtApi {
    private static final Logger log = LoggerFactory.getLogger(DataSyncExtApiImpl.class);
    @Resource
    private IOrgRoleApi orgRoleApi;
    @Resource
    private IUserApi userApi;
    @Resource
    private ITokenApi tokenApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private DataSyncService dataSyncService;
    @Autowired
    private IUserExtQueryApi userExtQueryApi;
    @Autowired
    private ISecurityApi securityApi;
    @Autowired
    private IUserLoginConfigApi userLoginConfigApi;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private IUserOrgExpandApi userOrgExpandApi;
    private final String mappingCacheKey = "data:mapping:org";
    @Value(value="${data.sync.batch.size:100}")
    private int batchSize;
    private final ExecutorService roleSyncExecutor = new ThreadPoolExecutor(5, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(500), r -> new Thread(r, "role-sync-thread-" + UUID.randomUUID().toString().substring(0, 8)), new ThreadPoolExecutor.CallerRunsPolicy());
    private final ExecutorService userSyncExecutor = new ThreadPoolExecutor(10, 20, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), r -> new Thread(r, "user-sync-thread-" + UUID.randomUUID().toString().substring(0, 8)), new ThreadPoolExecutor.CallerRunsPolicy());

    public RestResponse<String> creOrUpdRole(CreOrUpdRoleDto dto) {
        StopWatch stopWatch = new StopWatch("\u89d2\u8272\u540c\u6b65");
        stopWatch.start("\u6570\u636e\u83b7\u53d6");
        try {
            DataSyncRequest syncRequest = new DataSyncRequest();
            syncRequest.setLastSyncTime(dto.getLastSyncTime());
            String seq = this.getSeq();
            BaseResponse<List<Role>> rolesResponse = this.dataSyncService.syncRoles(seq, syncRequest);
            if (rolesResponse.getCode() != 0 || rolesResponse.getData() == null) {
                return new RestResponse((Object)("\u89d2\u8272\u6570\u636e\u540c\u6b65\u5931\u8d25: " + rolesResponse.getMsg()));
            }
            BaseResponse<List<RoleResourceRelation>> syncRoleResources = this.dataSyncService.syncRoleResources(seq, syncRequest);
            List<RoleResourceRelation> syncRoleResourcesData = syncRoleResources.getData();
            Map<String, List<RoleResourceRelation>> roleResourceMap = syncRoleResourcesData.stream().collect(Collectors.groupingBy(RoleResourceRelation::getRoleId));
            stopWatch.stop();
            stopWatch.start("\u89d2\u8272\u5904\u7406");
            List<Role> allRoles = rolesResponse.getData();
            int totalRoles = allRoles.size();
            log.info("\u5f00\u59cb\u5206\u6279\u540c\u6b65\u89d2\u8272\u6570\u636e\uff0c\u603b\u6570: {}", (Object)totalRoles);
            ArrayList<CompletableFuture<Void>> roleFutures = new ArrayList<CompletableFuture<Void>>();
            for (int i = 0; i < totalRoles; i += this.batchSize) {
                int endIndex = Math.min(i + this.batchSize, totalRoles);
                List<Role> batchRoles = allRoles.subList(i, endIndex);
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.processBatchRoles(batchRoles, roleResourceMap), this.roleSyncExecutor);
                roleFutures.add(future);
            }
            CompletableFuture.allOf(roleFutures.toArray(new CompletableFuture[0])).join();
            stopWatch.stop();
            log.info("\u89d2\u8272\u540c\u6b65\u5b8c\u6210\uff0c\u8017\u65f6\u7edf\u8ba1: {}", (Object)stopWatch.prettyPrint());
            return new RestResponse((Object)("\u89d2\u8272\u540c\u6b65\u6210\u529f\uff0c\u5171\u540c\u6b65\u89d2\u8272: " + totalRoles));
        }
        catch (Exception e) {
            log.error("\u89d2\u8272\u540c\u6b65\u5931\u8d25", (Throwable)e);
            return new RestResponse((Object)("\u89d2\u8272\u540c\u6b65\u5931\u8d25: " + e.getMessage()));
        }
    }

    private void processBatchRoles(List<Role> batchRoles, Map<String, List<RoleResourceRelation>> roleResourceMap) {
        log.info("\u5904\u7406\u89d2\u8272\u6279\u6b21\uff0c\u6570\u91cf: {}", (Object)batchRoles.size());
        for (Role cspRole : batchRoles) {
            try {
                OrgRoleReqDto orgRoleReqDto = new OrgRoleReqDto();
                orgRoleReqDto.setName(cspRole.getRoleName());
                orgRoleReqDto.setCode(cspRole.getRoleCode());
                orgRoleReqDto.setDescription(cspRole.getRoleDescription());
                orgRoleReqDto.setStatus(Integer.valueOf(cspRole.getEnableStatus() == 1 ? 1 : 0));
                orgRoleReqDto.setRoleType(Integer.valueOf(1));
                Optional.ofNullable(roleResourceMap.get(cspRole.getCspRoleId())).ifPresent(r -> orgRoleReqDto.setAccessCodes(r.stream().map(RoleResourceRelation::getRsId).distinct().collect(Collectors.toList())));
                RestResponseHelper.checkOrThrow((RestResponse)this.orgRoleApi.createOrUpdate(orgRoleReqDto));
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u89d2\u8272\u5931\u8d25: {}, \u9519\u8bef: {}", (Object)cspRole.getRoleCode(), (Object)e.getMessage());
            }
        }
    }

    public RestResponse<String> creOrUpdUser(CreOrUpdUserDto dto) {
        StopWatch stopWatch = new StopWatch("\u7528\u6237\u540c\u6b65");
        stopWatch.start("\u6570\u636e\u83b7\u53d6");
        try {
            DataSyncRequest syncRequest = new DataSyncRequest();
            syncRequest.setSyncDate(dto.getLastSyncTime());
            String seq = this.getSeq();
            BaseResponse<List<CspUserDto>> usersResponse = this.dataSyncService.syncUsers(seq, syncRequest);
            if (usersResponse.getCode() != 0 || usersResponse.getData() == null) {
                return new RestResponse((Object)("\u7528\u6237\u6570\u636e\u540c\u6b65\u5931\u8d25: " + usersResponse.getMsg()));
            }
            BaseResponse<List<TenantUserRelation>> syncUserTenants = this.dataSyncService.syncUserTenants(seq, syncRequest);
            List<TenantUserRelation> userTenantsData = syncUserTenants.getData();
            Map<String, List<TenantUserRelation>> tenantUserMap = userTenantsData.stream().collect(Collectors.groupingBy(TenantUserRelation::getUserId));
            List<CspUserDto> allUsers = usersResponse.getData();
            Set allUsernames = allUsers.stream().map(CspUserDto::getUsername).collect(Collectors.toSet());
            UserQueryReqDto userQueryReqDto = new UserQueryReqDto();
            userQueryReqDto.setUserNames(new ArrayList(allUsernames));
            List existingUsers = (List)RestResponseHelper.extractData((RestResponse)this.userExtQueryApi.queryUserByUserNames(userQueryReqDto));
            Map existingUserMap = existingUsers.stream().collect(Collectors.toMap(UserRespDto::getUserName, Function.identity()));
            stopWatch.stop();
            stopWatch.start("\u7528\u6237\u5904\u7406");
            int totalUsers = allUsers.size();
            log.info("\u5f00\u59cb\u5206\u6279\u540c\u6b65\u7528\u6237\u6570\u636e\uff0c\u603b\u6570: {}", (Object)totalUsers);
            CountDownLatch latch = new CountDownLatch((totalUsers + this.batchSize - 1) / this.batchSize);
            for (int i = 0; i < totalUsers; i += this.batchSize) {
                int startIndex = i;
                int endIndex = Math.min(i + this.batchSize, totalUsers);
                List<CspUserDto> batchUsers = allUsers.subList(startIndex, endIndex);
                this.userSyncExecutor.submit(() -> {
                    try {
                        this.processBatchUsers(batchUsers, tenantUserMap, existingUserMap);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            boolean completed = latch.await(30L, TimeUnit.MINUTES);
            if (!completed) {
                log.warn("\u7528\u6237\u540c\u6b65\u8d85\u65f6\uff0c\u90e8\u5206\u6279\u6b21\u53ef\u80fd\u672a\u5b8c\u6210");
            }
            stopWatch.stop();
            log.info("\u7528\u6237\u540c\u6b65\u5b8c\u6210\uff0c\u8017\u65f6\u7edf\u8ba1: {}", (Object)stopWatch.prettyPrint());
            return new RestResponse((Object)("\u7528\u6237\u540c\u6b65\u6210\u529f\uff0c\u5171\u540c\u6b65\u7528\u6237: " + totalUsers));
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u540c\u6b65\u5931\u8d25", (Throwable)e);
            return new RestResponse((Object)("\u7528\u6237\u540c\u6b65\u5931\u8d25: " + e.getMessage()));
        }
    }

    private void processBatchUsers(List<CspUserDto> batchUsers, Map<String, List<TenantUserRelation>> tenantUserMap, Map<String, UserRespDto> existingUserMap) {
        log.info("\u5904\u7406\u7528\u6237\u6279\u6b21\uff0c\u6570\u91cf: {}", (Object)batchUsers.size());
        for (CspUserDto cspUserDto : batchUsers) {
            try {
                UserRespDto existingUser = existingUserMap.get(cspUserDto.getUsername());
                Long userId = existingUser == null ? this.addUserInfo(cspUserDto) : this.updateUserInfo(existingUser, cspUserDto);
                this.updateUserOrgRelation(userId, cspUserDto.getUserId(), tenantUserMap);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u7528\u6237\u5931\u8d25: {}, \u9519\u8bef: {}", (Object)cspUserDto.getUsername(), (Object)e.getMessage());
            }
        }
    }

    private Long updateUserInfo(UserRespDto existingUser, CspUserDto cspUserDto) {
        Long userId = existingUser.getId();
        UserDto userDto = new UserDto();
        userDto.setId(userId);
        userDto.setUserName(cspUserDto.getUsername());
        userDto.setAccount(cspUserDto.getEmployeeNumber());
        userDto.setPhone(cspUserDto.getMobile());
        userDto.setEmail(cspUserDto.getEmail());
        userDto.setStatus(Integer.valueOf(cspUserDto.getEnableStatus() == 1 ? 1 : 0));
        userDto.setUserType(Integer.valueOf(cspUserDto.getUserType()));
        RestResponse updateResponse = this.userApi.update(userId, userDto);
        log.debug("\u66f4\u65b0\u7528\u6237\u7ed3\u679c: {}", (Object)JSONObject.toJSONString((Object)updateResponse));
        if (Objects.equals(cspUserDto.getEnableStatus(), 0)) {
            this.tokenApi.deleteToken(userId.toString());
        }
        return userId;
    }

    private void updateUserOrgRelation(Long userId, String cspUserId, Map<String, List<TenantUserRelation>> tenantUserMap) {
        List<TenantUserRelation> tenantUserRelations = tenantUserMap.get(cspUserId);
        if (CollectionUtils.isEmpty(tenantUserRelations)) {
            log.warn("\u7528\u6237[{}]\u6ca1\u6709\u5173\u8054\u7684\u79df\u6237\u4fe1\u606f", (Object)cspUserId);
            return;
        }
        UserOrgRelationReqDto userOrgRelationReqDto = new UserOrgRelationReqDto();
        userOrgRelationReqDto.setUserId(userId);
        ArrayList<Long> orgList = new ArrayList<Long>();
        ConcurrentHashMap<String, Long> orgIdCache = new ConcurrentHashMap<String, Long>();
        for (TenantUserRelation tenantUserRelation : tenantUserRelations) {
            String tenantId = tenantUserRelation.getTenantId();
            Long orgId = this.getOrgIdWithCache(tenantId, orgIdCache);
            if (orgId == null) continue;
            orgList.add(orgId);
        }
        userOrgRelationReqDto.setOrgIds(orgList);
        this.userOrgExpandApi.addOrUpdateUserOrgInfo(userOrgRelationReqDto);
    }

    private Long getOrgIdWithCache(String code, Map<String, Long> localCache) {
        if (localCache.containsKey(code)) {
            return localCache.get(code);
        }
        Long orgId = this.getOrgId(code);
        if (orgId != null) {
            localCache.put(code, orgId);
        }
        return orgId;
    }

    private Long addUserInfo(CspUserDto cspUserDto) {
        UserDto userDto = new UserDto();
        userDto.setUserName(cspUserDto.getUsername());
        userDto.setExtension(cspUserDto.getUserId());
        userDto.setNickName(cspUserDto.getEmployeeNumber());
        userDto.setPhone(cspUserDto.getMobile());
        userDto.setEmail(cspUserDto.getEmail());
        userDto.setValidType(Integer.valueOf(1));
        userDto.setTenantId(CommonConstant.TENANT_ID);
        userDto.setInstanceId(CommonConstant.INSTANCE_ID);
        userDto.setPassword(Base64.encodeString((String)"ZJJK123456").replace("==", ""));
        userDto.setUserType(Integer.valueOf(1));
        userDto.setStatus(cspUserDto.getEnableStatus());
        ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.TOB_DEALER_ADMIN_INSTANCE_ID.toString());
        RestResponse userRestResponse = this.userApi.addUser(CommonConstant.INSTANCE_ID, userDto);
        Long userId = (Long)userRestResponse.getData();
        this.securityApi.resetPasswordByAdmin(userId, userDto.getPassword());
        UserLoginConfigReqDto userLoginConfigReqDto = new UserLoginConfigReqDto();
        userLoginConfigReqDto.setLoginConfig("1,2");
        userLoginConfigReqDto.setUserId(userId);
        this.userLoginConfigApi.putUserLoginConfig(userId, userLoginConfigReqDto);
        this.cacheMaintain(userDto, userId);
        return userId;
    }

    public Long getOrgId(String code) {
        Long cache = (Long)this.cacheService.getCache("data:mapping:org", code, Long.class);
        if (Objects.nonNull(cache)) {
            return cache;
        }
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryOneByOrgCode(null, code);
        if (organizationDtoRestResponse.getData() != null) {
            Long orgId = ((OrganizationDto)organizationDtoRestResponse.getData()).getId();
            this.cacheService.setCache("data:mapping:org", code, (Object)orgId);
            return orgId;
        }
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(code);
        RestResponse response = this.customerQueryApi.queryByThirdPartyIds(list1);
        if (!CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            Long orgId = ((CustomerRespDto)((List)response.getData()).get(0)).getOrgInfoId();
            this.cacheService.setCache("data:mapping:org", code, (Object)orgId);
            return orgId;
        }
        return null;
    }

    private void cacheMaintain(UserDto userDto, Long id) {
        if (userDto.getUserType().equals(11)) {
            this.cacheService.hset("COMMON", "USER_ADMIN_KEY", id + "", (Object)1, 0);
        } else {
            this.cacheService.hdel("COMMON", "USER_ADMIN_KEY", new String[]{id + ""});
        }
    }

    private String getSeq() {
        return RequestId.createReqId();
    }
}

