/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl.db;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.enums.ProdOrgRelEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.app.open.biz.service.IDataDistributeService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ViewDateReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.MainDataResult;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IItemAuthApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.query.IItemExtQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service(value="centerHandleProdOrgRelDBServiceImpl")
public class CenterHandleProdOrgRelDBServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleProdOrgRelDBServiceImpl.class);
    @Resource
    private IItemAuthApi itemAuthApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IItemApi itemApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IItemExtQueryApi iItemExtQueryApi;
    @Resource
    private IDataDistributeService dataDistributeService;

    @Override
    public String getModelType() {
        return ModelCodeEnum.MP_CX_PROD_ORG_REL.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        MDC.put((String)"yes.req.userCode", (String)"csp-sync");
        ServiceContext.getContext().set("yes.req.userCode", (Object)"csp-sync");
        logger.info("\u7269\u6599\u79df\u6237\u5173\u7cfb\u6570\u636e\u5206\u53d1:{}", (Object)JacksonUtil.toJson((Object)modelInfoReqDto));
        List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        ArrayList<DataDistributeRespDto> responseList = new ArrayList<DataDistributeRespDto>();
        ArrayList itemCodes = new ArrayList();
        ArrayList orgIdList = Lists.newArrayList();
        for (Map map : maps) {
            if (!orgIdList.contains(ProdOrgRelEnum.ORGID.name())) {
                orgIdList.add(map.get(ProdOrgRelEnum.ORGID.name()));
            }
            if (itemCodes.contains(map.get(ProdOrgRelEnum.EASNO.name()))) continue;
            itemCodes.add(map.get(ProdOrgRelEnum.EASNO.name()));
        }
        logger.info("\u83b7\u53d6\u7269\u6599\u957f\u7f16\u7801\uff1a{}", (Object)JSONObject.toJSONString(itemCodes));
        List itemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemLongCodes(itemCodes));
        HashMap itemListMap = new HashMap();
        HashMap itemSkuIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)itemRespDtoList)) {
            itemRespDtoList.forEach(itemRespDto -> {
                itemListMap.put(itemRespDto.getLongCode(), itemRespDto.getId());
                itemSkuIdMap.put(itemRespDto.getLongCode(), itemRespDto.getSkuId());
            });
        }
        ShopQueryReqDto shopQueryDto = new ShopQueryReqDto();
        shopQueryDto.setCodes((List)orgIdList);
        logger.info("\u5e97\u94fa\u4fe1\u606f\u6761\u4ef6\uff1a{}", (Object)JSONObject.toJSONString((Object)shopQueryDto));
        List shopDtoList = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryShopByCode(shopQueryDto));
        if (CollectionUtils.isEmpty((Collection)shopDtoList)) {
            throw new BizException("\u6ca1\u6709\u5bf9\u5e94\u7684\u5e97\u94fa\u4fe1\u606f");
        }
        Map<Object, Object> itemAuthRespMap = new HashMap();
        List shopIds = shopDtoList.stream().map(ShopDto::getId).collect(Collectors.toList());
        ItemAuthReqDto queryCondition = new ItemAuthReqDto();
        queryCondition.setTargetIdList(shopIds);
        queryCondition.setTargetType(Integer.valueOf(2));
        List itemAuthRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemAuthQueryApi.queryByTargetIds(queryCondition));
        if (CollectionUtils.isNotEmpty((Collection)itemAuthRespDtoList)) {
            itemAuthRespMap = itemAuthRespDtoList.stream().collect(Collectors.toMap(t -> t.getTargetId() + "-" + t.getBusinessId(), t -> t, (last, next) -> next));
        }
        ArrayList authItemKey = Lists.newArrayList();
        for (ShopDto shopDto : shopDtoList) {
            HashMap<String, List<Long>> onShelfShopMap;
            ArrayList upItemIds = Lists.newArrayList();
            ArrayList downItemIds = Lists.newArrayList();
            ArrayList itemAuthReqDtoList = Lists.newArrayList();
            for (Map map : maps) {
                ItemAuthReqDto itemAuthReqDto;
                logger.info("\u5904\u7406\u540c\u6b65\u6388\u6743\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)map));
                if (ObjectUtil.isEmpty(map.get(ProdOrgRelEnum.ORGID.name())) || !((String)map.get(ProdOrgRelEnum.ORGID.name())).equals(shopDto.getCode())) continue;
                logger.info("\u5339\u914d\u5e97\u94fa\uff0c\u8fdb\u884c\u5904\u7406\u5546\u54c1");
                Long skuId = null;
                Long itemId = (Long)itemListMap.get(map.get(ProdOrgRelEnum.EASNO.name()));
                if (ObjectUtil.isEmpty(itemListMap) || ObjectUtil.isEmpty((Object)itemId)) {
                    logger.info("\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u65b0\u589e\u5546\u54c1");
                    itemId = this.syncItem(map);
                    if (ObjectUtil.isNull((Object)itemId)) {
                        logger.info("\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u65b0\u589e\u5546\u54c1\uff0c\u67e5\u8be2\u89c6\u56fe\u67e5\u8be2\u4e0d\u5230\u6570\u636e");
                        continue;
                    }
                    ItemSkuRespDto itemSkuRespDto = null;
                    try {
                        List data = (List)this.iItemSkuQueryApi.queryByItemId(itemId).getData();
                        if (CollectionUtils.isNotEmpty((Collection)data)) {
                            itemSkuRespDto = (ItemSkuRespDto)data.get(0);
                        }
                    }
                    catch (Exception e) {
                        logger.info("\u67e5\u8be2\u5546\u54c1SKU\u9519\u8bef={}", (Object)e.getMessage());
                    }
                    if (ObjectUtil.isNull(itemSkuRespDto)) {
                        logger.info("\u5546\u54c1\u4e0d\u5b58\u5728,\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684sku\u4fe1\u606f");
                        continue;
                    }
                    skuId = itemSkuRespDto.getId();
                    itemListMap.put(map.get(ProdOrgRelEnum.EASNO.name()), itemId);
                    itemSkuIdMap.put(map.get(ProdOrgRelEnum.EASNO.name()), skuId);
                } else {
                    itemId = (Long)itemListMap.get(map.get(ProdOrgRelEnum.EASNO.name()));
                    skuId = (Long)itemSkuIdMap.get(map.get(ProdOrgRelEnum.EASNO.name()));
                    if (ObjectUtil.isEmpty(itemSkuIdMap) || ObjectUtil.isEmpty((Object)skuId)) {
                        logger.info("SKU\u4e0d\u5b58\u5728");
                        continue;
                    }
                }
                boolean itemStatusToB = false;
                if (ObjectUtil.isNotEmpty(map.get(ProdOrgRelEnum.STATUS.name())) && "active".equals(((String)map.get(ProdOrgRelEnum.STATUS.name())).toLowerCase())) {
                    itemStatusToB = true;
                }
                boolean ifHave = false;
                String key = shopDto.getId() + "-" + skuId;
                if (authItemKey.contains(key)) {
                    logger.info("\u91cd\u590d\u5e97\u94fa\u5546\u54c1\u6388\u6743\u4e0d\u505a\u5904\u7406={}", (Object)key);
                    continue;
                }
                authItemKey.add(key);
                ItemAuthRespDto itemAuthRespDto = (ItemAuthRespDto)itemAuthRespMap.get(key);
                if (ObjectUtil.isNotEmpty((Object)itemAuthRespDto)) {
                    ifHave = true;
                }
                if (!ifHave) {
                    itemAuthReqDto = new ItemAuthReqDto();
                    itemAuthReqDto.setTargetType(Integer.valueOf(2));
                    itemAuthReqDto.setTargetId(shopDto.getId());
                    itemAuthReqDto.setBusinessType("SKU");
                    itemAuthReqDto.setBusinessId(skuId);
                    itemAuthReqDto.setStatus(Integer.valueOf(itemStatusToB ? 1 : 0));
                    itemAuthReqDto.setInstanceId(this.requestBaseData.getInstanceId());
                    itemAuthReqDto.setTenantId(this.requestBaseData.getTenantId());
                    itemAuthReqDto.setExternalCode((String)map.get(ProdOrgRelEnum.PRODNUM.name()));
                    itemAuthReqDtoList.add(itemAuthReqDto);
                    if (!itemStatusToB) continue;
                    upItemIds.add(itemListMap.get(map.get(ProdOrgRelEnum.EASNO.name())));
                    continue;
                }
                itemAuthReqDto = new ItemAuthReqDto();
                itemAuthReqDto.setId(itemAuthRespDto.getId());
                itemAuthReqDto.setStatus(Integer.valueOf(itemStatusToB ? 1 : 0));
                itemAuthReqDto.setExternalCode((String)map.get(ProdOrgRelEnum.PRODNUM.name()));
                try {
                    RestResponseHelper.extractData((RestResponse)this.itemAuthApi.modifyItemAuth(itemAuthReqDto));
                    HashMap<String, List<Long>> onShelfShopMap2 = new HashMap<String, List<Long>>();
                    ArrayList<Long> longs = new ArrayList<Long>();
                    logger.info("itemStatusToB={},Status={}", (Object)itemStatusToB, (Object)itemAuthRespDto.getStatus());
                    if (!itemStatusToB || itemAuthRespDto.getStatus() == 0) {
                        longs.add(itemId);
                        onShelfShopMap2.put(shopDto.getId().toString(), longs);
                        logger.info("\u4fee\u6539\u5546\u54c1\uff0c\u4e0b\u67b6\uff1a{}", (Object)JSON.toJSONString(onShelfShopMap2));
                        this.sendMqOnDownShelf(onShelfShopMap2);
                        continue;
                    }
                    if (!itemStatusToB || itemAuthRespDto.getStatus() != 1) continue;
                    longs.add(itemId);
                    onShelfShopMap2.put(shopDto.getId().toString(), longs);
                    logger.info("\u4fee\u6539\u5546\u54c1\uff0c\u4e0a\u67b6\uff1a{}", (Object)JSON.toJSONString(onShelfShopMap2));
                    this.sendMqOnUpShelf(onShelfShopMap2);
                }
                catch (Exception e) {
                    logger.info("\u4fee\u6539\u5546\u54c1\u6388\u6743\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)itemAuthReqDto));
                    e.printStackTrace();
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)upItemIds)) {
                logger.info("\u6267\u884c\u624b\u52a8\u4e0a\u67b6\uff1a{}", (Object)JSONObject.toJSONString((Object)upItemIds));
                onShelfShopMap = new HashMap<String, List<Long>>();
                onShelfShopMap.put(shopDto.getId().toString(), upItemIds);
                this.sendMqOnUpShelf(onShelfShopMap);
            }
            if (!CollectionUtils.isNotEmpty((Collection)downItemIds)) continue;
            logger.info("\u6267\u884c\u624b\u52a8\u4e0b\u67b6\uff1a{}", (Object)JSON.toJSONString((Object)downItemIds));
            onShelfShopMap = new HashMap();
            onShelfShopMap.put(shopDto.getId().toString(), downItemIds);
            this.sendMqOnDownShelf(onShelfShopMap);
        }
        logger.info("\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONObject.toJSONString(responseList));
        return responseList;
    }

    private Long syncItem(Map<String, String> map) {
        ViewDateReqDto reqDto = new ViewDateReqDto();
        reqDto.setAdd(Boolean.valueOf(true));
        reqDto.setModelCode("MP_CX_AWK_PRODUCT");
        reqDto.setDbModelCode("DB_MAIN_DATA");
        reqDto.setOrder("D_PRODNO");
        HashMap<String, String> mapPrams = new HashMap<String, String>();
        mapPrams.put("D_EASNO", map.get(ProdOrgRelEnum.EASNO.name()));
        reqDto.setParams(mapPrams);
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1));
        reqDto.setSelectOne(false);
        logger.info("\u65b0\u589e\u5546\u54c1\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        MainDataResult mainDataResult = this.dataDistributeService.synViewDataReq(reqDto);
        if (mainDataResult != null && CollectionUtils.isNotEmpty((Collection)mainDataResult.getResult())) {
            Long itemId = ((DataDistributeRespDto)mainDataResult.getResult().get(0)).getItemId();
            return itemId;
        }
        return null;
    }

    private DataDistributeRespDto dataResp(String taskId, String type, String reason) {
        DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
        dataDistributeRespDto.setTask_id(taskId);
        dataDistributeRespDto.setType(type);
        dataDistributeRespDto.setReason(reason);
        return dataDistributeRespDto;
    }

    private void sendMqOnUpShelf(Map<String, List<Long>> onShelfShopMap) {
        this.commonsMqService.sendSingleMessageAsync("ITEM-SYNC-ONSHELF", onShelfShopMap);
    }

    private void sendMqOnDownShelf(Map<String, List<Long>> onShelfShopMap) {
        this.commonsMqService.sendSingleMessageAsync("ITEM-SYNC-OFFSHELF", onShelfShopMap);
    }
}

