/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler.db;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.app.open.biz.service.IDataDistributeService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ViewDateReqDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SyncDBProductEvent")
@Scope(value="prototype")
public class SyncDBProductEvent
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(SyncDBProductEvent.class);
    @Resource
    private IDataDistributeService dataDistributeService;
    @Autowired
    private ICacheService cacheService;
    public static final String SYNC_DATE_KEY = "MP_CX_AWK_PRODUCT_LAST_DATE";

    public void before(TaskMsg taskMsg) {
        logger.info("\u540c\u6b65\u8425\u9500\u4e91\u5927B\u89c6\u56fe\u57fa\u7840\u7269\u6599\u6570\u636e\u8c03\u5ea6\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        ViewDateReqDto reqDto = new ViewDateReqDto();
        reqDto.setAdd(Boolean.valueOf(true));
        reqDto.setModelCode(ModelCodeEnum.MP_CX_AWK_PRODUCT.name());
        reqDto.setOrder(null);
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(100));
        reqDto.setParams(null);
        reqDto.setSelectOne(false);
        reqDto.setDbModelCode(ModelCodeEnum.DB_MAIN_DATA.name());
        String cache = (String)this.cacheService.getCache(SYNC_DATE_KEY, String.class);
        if (StrUtil.isNotBlank((CharSequence)cache)) {
            DateTime parse = DateUtil.parse((CharSequence)cache, (String)"yyyy-MM-dd HH:mm:ss");
            DateTime dateTime = DateUtil.offsetMinute((Date)parse, (int)-10);
            String format = DateUtil.format((Date)dateTime, (String)"yyyy-MM-dd HH:mm:ss");
            reqDto.setSyncLastDate(format);
        }
        logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        try {
            this.dataDistributeService.synViewDataReq(reqDto);
        }
        catch (Exception e) {
            logger.info("\u540c\u6b65\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        String nowDate = DateUtil.format((Date)DateUtil.date(), (String)"yyyy-MM-dd HH:mm:ss");
        this.cacheService.setCache(SYNC_DATE_KEY, (Object)nowDate);
        return true;
    }

    public static void main(String[] args) {
        String format = DateUtil.format((Date)DateUtil.date(), (String)"yyyy-MM-dd HH:mm:ss");
        System.out.println(format);
        DateTime parse = DateUtil.parse((CharSequence)format, (String)"yyyy-MM-dd HH:mm:ss");
        DateTime dateTime = DateUtil.offsetMinute((Date)parse, (int)-10);
        System.out.println(dateTime);
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u540c\u6b65\u8425\u9500\u4e91\u5927B\u89c6\u56fe\u57fa\u7840\u7269\u6599\u6570\u636e\u8c03\u5ea6\u7ed3\u675f");
    }
}

