/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.response.CustomerServiceRespDto;
import com.dtyunxi.tcbj.app.open.biz.service.ICustomerServiceService;
import com.dtyunxi.tcbj.app.open.dao.mapper.DataDistributeMapper;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.payment.util.HttpUtil;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomerServiceServiceImpl
implements ICustomerServiceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerServiceServiceImpl.class);
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Value(value="${tcbj.customer.service.url}")
    private String customerServiceUrl;
    @Resource
    private DataDistributeMapper dataDistributeMapper;

    @Override
    public List<Map<String, String>> getOrganizationPartnersByIds(List<String> partnerIds) {
        if (partnerIds == null || partnerIds.isEmpty()) {
            throw new BizException("PARTNER_ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataDistributeMapper.selectOrganizationPartnerByIds(partnerIds);
    }

    @Override
    public String customerServiceUrl(String orgId, String shopId) {
        RestResponse shopBaseDtoRestResponse = this.shopQueryApi.queryBaseById(Long.valueOf(shopId));
        ShopBaseDto shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)shopBaseDtoRestResponse);
        RestResponse listRestResponse = this.customerQueryApi.queryCustomerByOrgId(Arrays.asList(shopBaseDto.getOrganizationId()));
        final List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)customerRespDtos), (String)"\u5f53\u524d\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728");
        RestResponse userDtoRestResponse = this.userQueryApi.queryById();
        final UserDto userDto = (UserDto)RestResponseHelper.extractData((RestResponse)userDtoRestResponse);
        LOGGER.info("\u5f53\u524d\u8bf7\u6c42\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)userDtoRestResponse));
        HashMap<String, String> paramMap = new HashMap<String, String>(3){
            {
                super(x0);
                this.put("tenantId", ((CustomerRespDto)customerRespDtos.stream().findFirst().get()).getThirdPartyId());
                this.put("account", userDto.getUserName());
                this.put("mobile", userDto.getPhone());
            }
        };
        LOGGER.info("\u8bf7\u6c42\u8425\u9500\u4e91\u83b7\u53d6\u667a\u80fd\u5ba2\u670d param => {}", (Object)JSON.toJSONString((Object)paramMap));
        HashMap<String, String> mapHeaders = new HashMap<String, String>(1){
            {
                this.put("Content-Type", "application/json");
            }
        };
        String result = null;
        try {
            result = HttpUtil.post((String)this.customerServiceUrl, (String)JSON.toJSONString((Object)paramMap), (Map)mapHeaders);
        }
        catch (IOException e) {
            LOGGER.error("\u8bf7\u6c42\u8425\u9500\u4e91\u83b7\u53d6\u6c64\u5c0f\u4e8c\u5ba2\u670d\u5730\u5740\u5f02\u5e38");
            e.printStackTrace();
        }
        LOGGER.info("\u8bf7\u6c42\u8425\u9500\u4e91\u83b7\u53d6\u667a\u80fd\u5ba2\u670d response => {}", (Object)result);
        CustomerServiceRespDto customerServiceRespDto = (CustomerServiceRespDto)JSON.parseObject((String)result, CustomerServiceRespDto.class);
        Assert.isTrue((boolean)customerServiceRespDto.getCode().equals(0), (String)"0001", (String)"\u83b7\u53d6\u6c64\u5c0f\u4e8c\u670d\u52a1\u5730\u5740\u5f02\u5e38\uff01\uff01\uff01");
        return customerServiceRespDto.getData();
    }
}

