/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.dispatch.rabbit;

import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.rabbit.AliyunCredentialsProvider;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.rabbit.DispatchMessageListener;
import com.rabbitmq.client.impl.CredentialsProvider;
import javax.annotation.Resource;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    @Resource
    private RabbitProperties rabbitProperties;
    @Value(value="${aliyunmq.instanceid:amqp-cn-st21wg1a100h}")
    private String instanceId;

    @Bean
    public ConnectionFactory rabbitConnectionFactory() {
        com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory = new com.rabbitmq.client.ConnectionFactory();
        rabbitConnectionFactory.setHost(this.rabbitProperties.getHost());
        rabbitConnectionFactory.setPort(this.rabbitProperties.getPort().intValue());
        rabbitConnectionFactory.setUsername(this.rabbitProperties.getUsername());
        rabbitConnectionFactory.setPassword(this.rabbitProperties.getPassword());
        rabbitConnectionFactory.setVirtualHost(this.rabbitProperties.getVirtualHost());
        String un = "-1";
        if (!un.equals(this.instanceId)) {
            AliyunCredentialsProvider credentialsProvider = new AliyunCredentialsProvider(this.rabbitProperties.getUsername(), this.rabbitProperties.getPassword(), this.instanceId);
            rabbitConnectionFactory.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        rabbitConnectionFactory.setAutomaticRecoveryEnabled(true);
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(rabbitConnectionFactory);
        connectionFactory.setPublisherReturns(this.rabbitProperties.isPublisherReturns());
        connectionFactory.setPublisherConfirmType(CachingConnectionFactory.ConfirmType.CORRELATED);
        return connectionFactory;
    }

    @Bean
    public RabbitAdmin rabbitAdmin(ConnectionFactory connectionFactory) {
        RabbitAdmin rabbitAdmin = new RabbitAdmin(connectionFactory);
        rabbitAdmin.setAutoStartup(true);
        return rabbitAdmin;
    }

    @Bean
    public DispatchMessageListener dispatchMessageListener() {
        return new DispatchMessageListener();
    }

    @Bean
    public SimpleMessageListenerContainer dispatchMessageContainer(ConnectionFactory rabbitConnectionFactory, DispatchMessageListener dispatchMessageListener) throws AmqpException {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer(rabbitConnectionFactory);
        container.setConsumerStartTimeout(3000L);
        container.setExposeListenerChannel(true);
        container.setAcknowledgeMode(AcknowledgeMode.AUTO);
        container.setMessageListener((MessageListener)dispatchMessageListener);
        container.start();
        return container;
    }
}

