/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqMessageHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMqMessageHelper.class);
    @Resource
    private RabbitTemplate rabbitTemplate;

    public void convertAndSend(String exchange, String routeingKey, MessageResponse messageResponse) {
        LOGGER.info("rabbitMQ ==> \u6d88\u606f\u63a8\u9001\u5185\u5bb9 content -> {}", (Object)JSON.toJSONString((Object)messageResponse));
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType("application/json");
        Message message = new Message(JSON.toJSONString((Object)messageResponse).getBytes(), messageProperties);
        this.rabbitTemplate.convertAndSend(exchange, routeingKey, (Object)message);
    }

    public void convertAndSend(String exchange, String routeingKey, Object object) {
        LOGGER.info("rabbitMQ ==> \u6d88\u606f\u63a8\u9001\u5185\u5bb9 content -> {}", (Object)JSON.toJSONString((Object)object));
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType("application/json");
        Message message = new Message(JSON.toJSONString((Object)object).getBytes(), messageProperties);
        this.rabbitTemplate.convertAndSend(exchange, routeingKey, (Object)message);
    }
}

