/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.service.IBarcodeService;
import com.dtyunxi.tcbj.app.open.biz.service.MarketingCloudService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.barcode.BarcodeReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.barcode.BarcodeResultDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.barcode.BarcodeResultDto2;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BarcodeServiceImpl
implements IBarcodeService {
    private static final Logger logger = LoggerFactory.getLogger(BarcodeServiceImpl.class);
    @Value(value="${barcode.cuanhuo.url}")
    private String url;
    @Resource
    private MarketingCloudService marketingCloudService;
    @Autowired
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private HttpServletRequest request;

    @Override
    public BarcodeResultDto queryBarcodeBizFlow(BarcodeReqDto dto) {
        this.checkParam(dto);
        return this.queryBarCodeFlowByCSP(dto);
    }

    private BarcodeResultDto queryBarCodeFlowByCSP(BarcodeReqDto dto) {
        logger.info("\u3010\u9632\u4f2a\u7801\u3011\u83b7\u53d6\u4e32\u8d27\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        JSONObject param = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dto));
        BarcodeResultDto2 result = this.httpPost("http://csp.by-health.com/openApi/findOrderDataFace.do", param, BarcodeResultDto2.class);
        logger.info("\u3010\u9632\u4f2a\u7801\u3011\u83b7\u53d6\u4e32\u8d27\u67e5\u8be2\u54cd\u5e94\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
        if ("0".equals(result.getCode())) {
            return BarcodeResultDto.builder().returnObject(result.getData()).build();
        }
        return BarcodeResultDto.builder().returnObject(result.getData()).errorCode(result.getCode()).errorMessage(result.getMsg()).build();
    }

    private void checkParam(BarcodeReqDto dto) {
        String token = ServiceContext.getContext().getAttachment("access-token");
        logger.info("\u83b7\u53d6 access-token={}", (Object)token);
        if (token == null) {
            throw new BizException("token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDate = now.format(formatter);
        String token2 = token.split("\\.")[1];
        byte[] decodedBytes = Base64.getDecoder().decode(token2);
        String decodedStr = new String(decodedBytes);
        JSONObject loginInfo = JSONObject.parseObject((String)decodedStr);
        String loginName = loginInfo.get((Object)"loginName").toString();
        logger.info("\u4eba\u5458\u8d26\u53f7: {}  \u67e5\u8be2\u65f6\u95f4: {}  \u67e5\u8be2\u7801: {}", new Object[]{loginName, formattedDate, dto.getBarcodes().get(0)});
        dto.setLoginAccount(loginName);
        String orgid = this.request.getHeader("yes-req-cus-b2b-sellerorgid");
        logger.info("\u83b7\u53d6 sellerorgid={}", (Object)orgid);
        if (orgid == null) {
            throw new BizException("sellerorgid\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        List cusList = (List)this.customerExtThreeQueryApi.queryByOrgIdList(Collections.singletonList(Long.valueOf(orgid))).getData();
        logger.info("\u83b7\u53d6 cusList={}", (Object)JSONObject.toJSONString((Object)cusList));
        dto.setJxsId(((CustomerExtRespDto)cusList.get(0)).getThirdPartyId());
    }

    public <T> T httpPost(String url, JSONObject json, Class<T> clazz) {
        HttpPost httppost = new HttpPost(url);
        httppost.setHeader("Content-Type", "application/json;charset=utf-8");
        HttpResponse response = null;
        try {
            logger.info("json: {}", (Object)json);
            StringEntity entity = new StringEntity(json.toString(), "UTF-8");
            httppost.setEntity((HttpEntity)entity);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            response = httpClient.execute((HttpUriRequest)httppost);
            logger.info("response: {}", (Object)response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (response != null);
        HttpEntity httpEntity = response.getEntity();
        logger.info("httpEntity: {}", (Object)httpEntity);
        String result = null;
        try {
            result = EntityUtils.toString((HttpEntity)httpEntity);
            logger.info("result: {}", (Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)JSONObject.parseObject((String)result, clazz);
    }
}

