/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.apiimpl.query;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BasePageDto;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OutResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.StringCheckResultReqDto;
import com.dtyunxi.tcbj.api.dto.response.CsOutResultOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.StringCheckResultRespDto;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.tcbj.api.query.ISaleOrderReportQueryApi;
import com.dtyunxi.tcbj.api.query.IStringCheckResultQueryApi;
import com.dtyunxi.tcbj.app.open.biz.service.FetchDataService;
import com.dtyunxi.tcbj.app.open.biz.service.ILimitsService;
import com.dtyunxi.tcbj.app.open.biz.service.IStringCodeService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ILimitsQueryReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.StringCodeCheckReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.StringCodeCheckRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.StringCodeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.query.IStringCodeQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.commons.utils.LogUtils;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class StringCodeQueryApiImpl
implements IStringCodeQueryApi {
    private static final Logger log = LoggerFactory.getLogger(StringCodeQueryApiImpl.class);
    @Resource
    private IStringCodeService stringCodeService;
    @Resource
    private IPcpItemQueryApi itemExtendQueryApi;
    @Value(value="${openapi.stringCode.check:false}")
    private boolean codeCheck;
    @Resource
    private ILimitsService iLimitsService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IStringCheckResultQueryApi stringCheckResultQueryApi;
    @Resource
    private IOutResultOrderQueryApi outResultOrderQueryApi;
    @Resource
    private ISaleOrderReportQueryApi saleOrderReportQueryApi;
    @Autowired
    ILockService lockService;
    @Autowired
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Autowired
    private ISaleOrderQueryApi saleOrderQueryApi;

    public RestResponse<StringCodeRespDto> queryById(Long id) {
        return new RestResponse((Object)this.stringCodeService.queryById(id));
    }

    public RestResponse<PageInfo<StringCodeRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.stringCodeService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<List<StringCodeCheckRespDto>> check(List<StringCodeCheckReqDto> list) {
        log.info("\u4e32\u7801\u6821\u9a8c\u5165\u53c2list:{}", (Object)JSON.toJSONString(list));
        if (CollectionUtil.isEmpty(list)) {
            return new RestResponse(null);
        }
        List respList = list.stream().collect(Collectors.groupingBy(StringCodeCheckReqDto::getEasSaleOrderNo)).entrySet().stream().flatMap(entry -> this.doCheck((List)entry.getValue(), 1).stream()).collect(Collectors.toList());
        respList.stream().filter(r -> r.isCheckResult() && r.isSyncView()).forEach(r -> Optional.ofNullable(this.saleOrderReportQueryApi.getTransferSaleOrder(r.getEasSaleOrderNo()).getData()).ifPresent(d -> {
            try {
                this.stringCodeService.syncView(r.getEasSaleOrderNo(), (SaleOrderRespDto)d);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u89c6\u56fe\u5f02\u5e38:{},:{}", (Object)e.getMessage(), (Object)r.getEasSaleOrderNo());
            }
        }));
        return new RestResponse(respList);
    }

    private void preHandler(List<StringCodeCheckRespDto> respList) {
        Map<String, PcpItemRespDto> itemMap = this.getPcpItemMap(respList);
        respList.forEach(i -> {
            String itemLongCode = i.getItemLongCode();
            if (CollectionUtil.isNotEmpty((Map)itemMap) && itemMap.containsKey(itemLongCode)) {
                PcpItemRespDto item = (PcpItemRespDto)itemMap.get(itemLongCode);
                if (Objects.equals("Y", item.getImeiCodeFlag())) {
                    i.setAntiFakeCode(item.getSecurityCode());
                    i.setBigRatio(item.getBigRatio());
                    i.setMiddleRatio(item.getMiddleRatio());
                    i.setSmallRatio(item.getSmallRatio());
                } else {
                    i.setCheckResult(true);
                }
            }
        });
    }

    private List<StringCodeCheckRespDto> doCheck(List<StringCodeCheckReqDto> list, Integer handlerMode) {
        log.info("\u5408\u5e76\u524d\u4e32\u7801:{}", (Object)JSONObject.toJSONString(list));
        list = new ArrayList(list.stream().collect(Collectors.toMap(k -> k.getEasSaleOrderNo() + "_" + k.getItemLongCode(), Function.identity(), (o, o1) -> {
            o.setNum(Integer.valueOf(o.getNum() + o1.getNum()));
            return o;
        })).values());
        log.info("\u5408\u5e76\u540e\u4e32\u7801:{}", (Object)JSONObject.toJSONString(list));
        ArrayList respList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respList, list, StringCodeCheckRespDto.class);
        this.preHandler(respList);
        this.compare(handlerMode, respList);
        return this.groupData(respList);
    }

    private <R extends StringCodeCheckReqDto> Map<String, PcpItemRespDto> getPcpItemMap(List<R> list) {
        Set itemLongCodes = list.stream().map(StringCodeCheckReqDto::getItemLongCode).collect(Collectors.toSet());
        List items = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryItemByItemLongCodes((List)Lists.newArrayList(itemLongCodes)));
        return items.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, Function.identity(), (k1, k2) -> k1));
    }

    private void compare(Integer handlerMode, List<StringCodeCheckRespDto> respList) {
        log.info("\u67e5\u8be2\u4e32\u7801\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSONObject.toJSONString(respList));
        List<String> queryNos = respList.stream().filter(r -> !r.isCheckResult()).map(StringCodeCheckReqDto::getEasSaleOrderNo).distinct().collect(Collectors.toList());
        if (CollectionUtil.isEmpty(queryNos)) {
            this.sendLogMsg(respList.stream().map(r -> this.buildLog((StringCodeCheckRespDto)r, (long)r.getNum())).collect(Collectors.toList()));
            return;
        }
        Set set = respList.stream().map(StringCodeCheckReqDto::getDocumentNo).collect(Collectors.toSet());
        OutResultOrderReqDto reqDto = new OutResultOrderReqDto();
        reqDto.setPreOrderNoSet(new ArrayList(set));
        reqDto.setOrderType("out");
        reqDto.setOrderStatus(BaseOrderStatusEnum.ORO_DONE_OUT.getCode());
        FetchDataService resultDetailFetch = req -> (PageInfo)this.outResultOrderQueryApi.queryDetailByPage(req).getData();
        Map batchSet = resultDetailFetch.fetchAll(reqDto).stream().collect(Collectors.groupingBy(d -> d.getPreOrderNo() + "_" + d.getLongCode(), Collectors.mapping(CsOutResultOrderDetailRespDto::getBatch, Collectors.toSet())));
        respList.forEach(reset -> reset.setBatchSet((Set)batchSet.get(reset.getDocumentNo() + "_" + reset.getItemLongCode())));
        log.info("\u67e5\u8be2\u4e32\u7801\u7684\u53c2\u6570handlerMode\u4e3a\uff1a{},\u5355\u53f7\u4e3a:{}:", (Object)handlerMode, (Object)JSONObject.toJSONString(set));
        if (Objects.equals(handlerMode, 1)) {
            Optional.of(queryNos).filter(CollUtil::isNotEmpty).map(r -> (String)r.get(0)).ifPresent(r -> this.singleOrderCheck(respList, (String)r));
        } else {
            List<StringCodeRespDto> stringCodeList = this.stringCodeService.queryByStringList(queryNos);
            Map<String, List<StringCodeRespDto>> stringListMap = stringCodeList.stream().collect(Collectors.groupingBy(StringCodeRespDto::getUniqueKey));
            log.info("\u4e32\u7801\u89c6\u56fe\u67e5\u8be2\u7ed3\u679c:{},\u6821\u9a8c\u7ed3\u679c\u6570\u636e:{}", (Object)JSONObject.toJSONString(stringCodeList), (Object)JSONObject.toJSONString(respList));
            this.sendLogMsg(this.calculation(respList, stringListMap, 1));
        }
    }

    private void singleOrderCheck(List<StringCodeCheckRespDto> respList, String r) {
        List<StringCodeRespDto> stringCodeList = this.loadViewStringCode(r);
        log.info("\u4e32\u7801\u7684\u7ed3\u679c\u4e3a:{}", (Object)stringCodeList.size());
        log.info("stringCodeList\u4e32\u7801\u7684\u7ed3\u679c\u4e3a:{},\u5165\u53c2easCode\u4e3a:{}", (Object)JSON.toJSONString(stringCodeList), (Object)JSON.toJSONString((Object)r));
        if (CollectionUtil.isEmpty(stringCodeList)) {
            this.sendLogMsg(respList.stream().map(check -> this.buildLog((StringCodeCheckRespDto)check, 0L)).collect(Collectors.toList()));
            return;
        }
        List easCodeList = stringCodeList.stream().map(StringCodeRespDto::getEasCode).distinct().collect(Collectors.toList());
        log.info("singleOrderCheck easCodeList:{}", (Object)LogUtils.buildLogContent(easCodeList));
        Map<Object, Object> stringListMap = Maps.newHashMap();
        ArrayList executeList = Lists.newArrayList();
        for (StringCodeRespDto codeRespDto : stringCodeList) {
            String easCode = codeRespDto.getEasCode();
            if (executeList.contains(easCode)) continue;
            executeList.add(easCode);
            if (StringUtils.equals((CharSequence)easCode, (CharSequence)r)) {
                stringListMap = stringCodeList.stream().filter(sting -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sting.getAntiFakeCode()})).collect(Collectors.groupingBy(StringCodeRespDto::getAntiFakeCode));
                this.sendLogMsg(this.calculation(respList, stringListMap, 0));
                log.info("\u4e32\u7801\u89c6\u56fe\u67e5\u8be2\u7ed3\u679c:{},\u6821\u9a8c\u7ed3\u679c\u6570\u636e:{}, \u6b63\u5e38\u5339\u914d", (Object)JSONObject.toJSONString(stringCodeList), (Object)JSONObject.toJSONString(respList));
                continue;
            }
            stringListMap = stringCodeList.stream().filter(sting -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sting.getAntiFakeCode()})).filter(target -> Stream.of(target.getEasCode().split("_")).collect(Collectors.toList()).contains(r)).collect(Collectors.groupingBy(StringCodeRespDto::getAntiFakeCode));
            log.info("\u4e32\u7801\u7684\u7ed3\u679cstringListMap\u4e3a:{}", (Object)JSONObject.toJSONString((Object)stringListMap));
            if (CollectionUtil.isEmpty((Map)stringListMap)) continue;
            this.singCheckMergeOrderPoint(respList, r, stringCodeList, easCode, stringListMap);
        }
    }

    private void singCheckMergeOrderPoint(List<StringCodeCheckRespDto> respList, String r, List<StringCodeRespDto> stringCodeList, String easCode, Map<String, List<StringCodeRespDto>> stringListMap) {
        log.info("\u4e32\u7801\u5355\u53f7\u62c6\u5206\u524dr\uff1a{}", (Object)JSON.toJSONString((Object)easCode));
        Set stringSet = Arrays.stream(easCode.split("_")).collect(Collectors.toSet());
        log.info("\u4e32\u7801\u5355\u53f7\u62c6\u5206\u540estringSet:{}", (Object)JSON.toJSONString(stringSet));
        StringCheckResultReqDto reqDto = new StringCheckResultReqDto();
        reqDto.setEasSaleOrderNos(new ArrayList(stringSet));
        FetchDataService fetchDataService = req -> (PageInfo)this.stringCheckResultQueryApi.queryByPage(req).getData();
        log.info("\u4e32\u7801\u6821\u9a8c\u7ed3\u679c\u67e5\u8be2fetchDataService:{}", (Object)JSON.toJSONString(fetchDataService));
        List<StringCheckResultRespDto> stringCheckResultRespDtos = fetchDataService.fetchAll(reqDto);
        Set existNos = stringCheckResultRespDtos.stream().map(StringCheckResultRespDto::getEasSaleOrderNo).collect(Collectors.toSet());
        existNos.add(r);
        log.info("singCheckMergeOrderPoint existNos\u4e3a:{}", (Object)JSON.toJSONString(existNos));
        log.info("\u4e32\u7801\u7684\u7ed3\u679cstringCheckResultRespDtos\u4e3a:{}", (Object)JSONObject.toJSONString(stringCheckResultRespDtos));
        if (stringCheckResultRespDtos.size() > 0 && existNos.size() == stringSet.size()) {
            this.mergeOrderDetail(respList, r, stringCheckResultRespDtos);
            ArrayList<StringCodeCheckRespDto> list = new ArrayList<StringCodeCheckRespDto>(respList.stream().map(data -> (StringCodeCheckRespDto)BeanUtil.copyProperties((Object)data, StringCodeCheckRespDto.class, (String[])new String[0])).collect(Collectors.toMap(StringCodeCheckReqDto::getItemLongCode, Function.identity(), (o, o1) -> {
                o.setNum(Integer.valueOf(o.getNum() + o1.getNum()));
                if (o.getBatchSet() == null) {
                    o.setBatchSet(new HashSet());
                }
                if (CollectionUtil.isNotEmpty((Collection)o1.getBatchSet())) {
                    o.getBatchSet().addAll(o1.getBatchSet());
                }
                return o;
            })).values());
            List<StringCheckResultVo> calculation = this.calculation(list, stringListMap, 2);
            HashMap calculationMap = new HashMap();
            if (CollectionUtil.isNotEmpty(calculation)) {
                Map resultVoMap = calculation.stream().collect(Collectors.toMap(StringCheckResultVo::getStringCode, Function.identity(), (k1, k2) -> k1));
                calculationMap.putAll(resultVoMap);
            }
            boolean b = calculation.stream().allMatch(d -> Objects.equals(d.getStatus(), 1));
            respList.forEach(resp -> resp.setCheckResult(b));
            this.sendLogMsg(respList.stream().map(resp -> {
                long easNum = 0L;
                StringCheckResultVo stringCheckResultVos = (StringCheckResultVo)((Object)((Object)calculationMap.get(resp.getAntiFakeCode())));
                if (ObjectUtil.isNotEmpty((Object)((Object)stringCheckResultVos))) {
                    easNum = stringCheckResultVos.getEasNum();
                }
                log.info("{}, calculationMap: {}", (Object)LogUtils.buildLogContent((Object)resp), (Object)LogUtils.buildLogContent((Object)calculationMap));
                return this.buildLog((StringCodeCheckRespDto)resp, easNum);
            }).peek(resp -> resp.setExtension(easCode)).collect(Collectors.toList()));
            log.info("\u4e32\u7801\u89c6\u56fe\u67e5\u8be2\u7ed3\u679c:{},\u6821\u9a8c\u7ed3\u679c\u6570\u636e:{}, \u5408\u5355\u5b8c\u5168\u5339\u914d", (Object)JSONObject.toJSONString(stringCodeList), (Object)JSONObject.toJSONString(respList));
            return;
        }
        log.info("\u4e32\u7801\u89c6\u56fe\u67e5\u8be2\u7ed3\u679c:{},\u6821\u9a8c\u7ed3\u679c\u6570\u636e:{}, \u5408\u5355\u672a\u5b8c\u5168\u5339\u914d", (Object)JSONObject.toJSONString(stringCodeList), (Object)JSONObject.toJSONString(respList));
        this.sendLogMsg(this.calculation(respList, stringListMap, 3).stream().peek(d -> d.setExtension(easCode)).collect(Collectors.toList()));
    }

    private List<StringCodeRespDto> loadViewStringCode(String r) {
        List<StringCodeRespDto> stringCodeList = this.stringCodeService.queryByStringNo(r);
        if (CollectionUtil.isEmpty(stringCodeList) && CollectionUtil.isEmpty(stringCodeList = this.stringCodeService.queryByEasNo(r))) {
            return Collections.emptyList();
        }
        return stringCodeList;
    }

    private void mergeOrderDetail(List<StringCodeCheckRespDto> respList, String r, List<StringCheckResultRespDto> stringCheckResultRespDtos) {
        List<StringCodeCheckRespDto> dataList = stringCheckResultRespDtos.stream().filter(s -> !s.getEasSaleOrderNo().equals(r)).map(data -> {
            StringCodeCheckRespDto respDto = new StringCodeCheckRespDto();
            respDto.setNum(Integer.valueOf(Math.toIntExact(data.getPcpNum())));
            respDto.setAntiFakeCode(data.getStringCode());
            respDto.setItemLongCode(data.getLongCode());
            respDto.setDocumentNo(data.getDocumentNo());
            respDto.setEasSaleOrderNo(data.getEasSaleOrderNo());
            return respDto;
        }).collect(Collectors.toList());
        this.preHandler(dataList);
        respList.addAll(dataList);
    }

    private List<StringCodeCheckRespDto> groupData(List<StringCodeCheckRespDto> respList) {
        return new ArrayList<StringCodeCheckRespDto>(respList.stream().collect(Collectors.toMap(StringCodeCheckReqDto::getEasSaleOrderNo, Function.identity(), (o, o1) -> {
            o.setCheckResult(o.isCheckResult() && o1.isCheckResult());
            return o;
        })).values());
    }

    private List<StringCheckResultVo> calculation(List<StringCodeCheckRespDto> respList, Map<String, List<StringCodeRespDto>> stringListMap, Integer mode) {
        return respList.stream().map(i -> this.doCalculation(stringListMap, mode, (StringCodeCheckRespDto)i)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private StringCheckResultVo doCalculation(Map<String, List<StringCodeRespDto>> stringListMap, Integer mode, StringCodeCheckRespDto i) {
        String uniqueKey;
        if (i.isCheckResult()) {
            return null;
        }
        if (!this.codeCheck) {
            i.setCheckResult(true);
            StringCheckResultVo resultVo = this.buildLog(i, (long)i.getNum());
            resultVo.setExtension("\u4e32\u7801\u6821\u9a8c\u672a\u5f00\u542f");
            return resultVo;
        }
        String string = uniqueKey = Objects.equals(mode, 1) ? i.getUniqueKey() : i.getAntiFakeCode();
        if (CollectionUtil.isNotEmpty(stringListMap) && stringListMap.containsKey(uniqueKey)) {
            Integer num = this.calculationStringCodeNum(stringListMap.get(uniqueKey), i);
            i.setCheckResult(this.getResult(i, num, mode));
            log.info("\u4e32\u7801\u6821\u9a8c\u5355\u53f7:{}, \u54c1:{},\u4e09\u65b9\u6570\u91cf:{}, pcp\u6570\u91cf:{}, \u662f\u5426\u5bf9\u9f50:{}", new Object[]{i.getEasSaleOrderNo(), i.getItemLongCode(), num, i.getNum(), i.isCheckResult() ? "\u662f" : "\u5426"});
            log.info("\u4e32\u7801\u8d4b\u503c\u540e\u5217\u8868\u6570\u636e:{}", (Object)JSON.toJSONString((Object)i));
            return this.buildLog(i, (long)num);
        }
        i.setCheckResult(i.getNum().equals(0));
        return this.buildLog(i, 0L);
    }

    private boolean getResult(StringCodeCheckRespDto i, Integer num, Integer mode) {
        if (Objects.equals(mode, 3)) {
            return false;
        }
        return Objects.equals(i.getNum(), num) || num > i.getNum() && (long)(num - i.getNum()) < i.getBigRatio() * (long)Optional.ofNullable(i.getBatchSet()).map(Set::size).map(size -> Math.max(size, 1)).orElse(1).intValue();
    }

    private StringCheckResultVo buildLog(StringCodeCheckRespDto i, Long l) {
        StringCheckResultVo resultVo = new StringCheckResultVo();
        resultVo.setDocumentNo(i.getDocumentNo());
        resultVo.setEasNum(l);
        resultVo.setPcpNum((long)i.getNum());
        resultVo.setLongCode(i.getItemLongCode());
        resultVo.setStatus(i.isCheckResult() ? 1 : 0);
        resultVo.setEasSaleOrderNo(i.getEasSaleOrderNo());
        resultVo.setStringCode(i.getAntiFakeCode());
        resultVo.setSerialNoList(i.getSerialNoList());
        return resultVo;
    }

    private void sendLogMsg(List<StringCheckResultVo> respList) {
        this.commonsMqService.sendSingleMessage("STRING_CODE_LOG_SYNC", (Object)JSONObject.toJSONString(respList));
    }

    public RestResponse<List<StringCodeRespDto>> queryByList(List<StringCodeCheckReqDto> list) {
        return new RestResponse(this.stringCodeService.queryByList(list));
    }

    public RestResponse<List<StringCodeRespDto>> queryByStringList(List<String> list) {
        return new RestResponse(this.stringCodeService.queryByStringList(list));
    }

    public RestResponse<Void> syncLimits(ILimitsQueryReqDto reqDto) {
        this.iLimitsService.syncReportInspected(reqDto.getSyncStartTime(), reqDto.getSyncEndTime());
        return RestResponse.VOID;
    }

    private Integer calculationStringCodeNum(List<StringCodeRespDto> scList, StringCodeCheckRespDto i) {
        if (CollectionUtil.isEmpty(scList)) {
            return 0;
        }
        List nos = scList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getSerialno())).map(StringCodeRespDto::getSerialno).collect(Collectors.toList());
        i.setSerialNoList(nos);
        return Math.toIntExact(scList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getSerialno())).collect(Collectors.toMap(StringCodeRespDto::getSerialno, Function.identity(), (o, o1) -> o)).values().stream().mapToLong(sc -> this.parseNum((StringCodeRespDto)sc, i)).sum());
    }

    private Long parseNum(StringCodeRespDto sc, StringCodeCheckRespDto i) {
        Integer length = StringUtils.length((CharSequence)sc.getSerialno());
        if (Objects.equals(length, 12)) {
            return 1L;
        }
        if (Objects.equals(length, 18)) {
            return i.getMiddleRatio();
        }
        if (Objects.equals(length, 20)) {
            return i.getBigRatio();
        }
        return 0L;
    }

    public static class StringCheckResultVo
    extends BasePageDto {
        private Long id;
        private String easSaleOrderNo;
        private String documentNo;
        private String longCode;
        private String stringCode;
        private Long pcpNum;
        private Long easNum;
        private Integer status;
        private String extension;
        @ApiModelProperty(name="serialNoList", value="\u4e32\u7801\u5217\u8868")
        private List<String> serialNoList;

        public Long getId() {
            return this.id;
        }

        public String getEasSaleOrderNo() {
            return this.easSaleOrderNo;
        }

        public String getDocumentNo() {
            return this.documentNo;
        }

        public String getLongCode() {
            return this.longCode;
        }

        public String getStringCode() {
            return this.stringCode;
        }

        public Long getPcpNum() {
            return this.pcpNum;
        }

        public Long getEasNum() {
            return this.easNum;
        }

        public Integer getStatus() {
            return this.status;
        }

        public String getExtension() {
            return this.extension;
        }

        public List<String> getSerialNoList() {
            return this.serialNoList;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setEasSaleOrderNo(String easSaleOrderNo) {
            this.easSaleOrderNo = easSaleOrderNo;
        }

        public void setDocumentNo(String documentNo) {
            this.documentNo = documentNo;
        }

        public void setLongCode(String longCode) {
            this.longCode = longCode;
        }

        public void setStringCode(String stringCode) {
            this.stringCode = stringCode;
        }

        public void setPcpNum(Long pcpNum) {
            this.pcpNum = pcpNum;
        }

        public void setEasNum(Long easNum) {
            this.easNum = easNum;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public void setSerialNoList(List<String> serialNoList) {
            this.serialNoList = serialNoList;
        }
    }
}

