/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IBudgetItemApi;
import com.dtyunxi.tcbj.api.dto.request.BudgetItemReqDto;
import com.dtyunxi.tcbj.api.dto.response.BudgetItemRespDto;
import com.dtyunxi.tcbj.api.query.IBudgetItemQueryApi;
import com.dtyunxi.tcbj.app.open.biz.enums.PcpSupplierColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ISapCenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapModelTypeEnum;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="SapCenterHandleBudgetItemServiceImpl")
public class SapCenterHandleBudgetItemServiceImpl
implements ISapCenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(SapCenterHandleBudgetItemServiceImpl.class);
    @Resource
    private IBudgetItemQueryApi budgetItemQueryApi;
    @Resource
    private IBudgetItemApi budgetItemApi;

    @Override
    public String getModelType() {
        return SapModelTypeEnum.BUDGETITEM.getValue();
    }

    @Override
    public void handle(Map<String, Object> reqDto) {
        logger.info("\u9884\u7b97\u9879\u76ee\u6570\u636e\u5206\u53d1:{}", (Object)JSON.toJSONString(reqDto));
        long startTime = System.currentTimeMillis();
        String obj = JSONObject.toJSONString((Object)reqDto.get("data"));
        JSONObject dataObj = JSONObject.parseObject((String)obj);
        BudgetItemReqDto queryReqDto = new BudgetItemReqDto();
        queryReqDto.setBudgetItemCode(dataObj.getString("number"));
        PageInfo resPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.budgetItemQueryApi.queryByPageByPost(queryReqDto));
        List items = resPage.getList();
        try {
            if (CollectionUtils.isNotEmpty((Collection)items)) {
                BudgetItemRespDto resDto = (BudgetItemRespDto)items.get(0);
                BudgetItemReqDto budgetItemReqDto = new BudgetItemReqDto();
                budgetItemReqDto.setId(resDto.getId());
                budgetItemReqDto.setBudgetItemCode(dataObj.getString("number"));
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                budgetItemReqDto.setBudgetItemName(dataObj.getString("name"));
                budgetItemReqDto.setStartDate(format.parse(dataObj.getString("begindate")));
                budgetItemReqDto.setEndDate(format.parse(dataObj.getString("enddate")));
                this.budgetItemApi.modifyBudgetItem(budgetItemReqDto);
            } else {
                BudgetItemReqDto budgetItemReqDto = new BudgetItemReqDto();
                budgetItemReqDto.setBudgetItemCode(dataObj.getString("number"));
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                budgetItemReqDto.setBudgetItemName(dataObj.getString("name"));
                budgetItemReqDto.setStartDate(format.parse(dataObj.getString("begindate")));
                budgetItemReqDto.setEndDate(format.parse(dataObj.getString("enddate")));
                this.budgetItemApi.addBudgetItem(budgetItemReqDto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        logger.info("\u3010\u9884\u7b97\u9879\u76ee\u65b0\u589e\u540c\u6b65\u3011\u8017\u65f6\uff1a{}", (Object)(endTime - startTime + "ms"));
        logger.info("\u3010\u9884\u7b97\u9879\u76ee\u65b0\u589e\u540c\u6b65\u3011\u7ed3\u675f\u540c\u6b65--------->");
    }

    private String validaData(List<Map> dataMap) {
        if (dataMap == null || dataMap.size() <= 0) {
            return "\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (Map map : dataMap) {
            for (Object s : map.keySet()) {
                if (Objects.isNull(s)) {
                    return "\u540c\u6b65\u6570\u636e\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a";
                }
                PcpSupplierColumnEnum pcpSupplierColumnEnum = PcpSupplierColumnEnum.getByField(s.toString());
                if (pcpSupplierColumnEnum == null || pcpSupplierColumnEnum.validate(s.toString()).booleanValue()) continue;
                return String.format("%s\u4e0d\u80fd\u4e3a\u7a7a", pcpSupplierColumnEnum.getFieldName());
            }
        }
        return null;
    }
}

