/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ISaleOrderMergeDataApi;
import com.dtyunxi.tcbj.api.dto.SaleOrderMergeDataDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckEasReqDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckItem;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckReqDto;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionDataReqDto;
import com.dtyunxi.tcbj.api.dto.request.RpInventoryPreemptionQueryDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderResultReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleTransferReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.ShInventoryPreemptionQueryDto;
import com.dtyunxi.tcbj.api.dto.request.TransferOrderReportExtReqDto;
import com.dtyunxi.tcbj.api.dto.response.CsLogisticsInfoRespDto;
import com.dtyunxi.tcbj.api.dto.response.CsOutResultOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryCheckRespDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInspectionDataRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleResultOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleResultOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleTransferReportRespDto;
import com.dtyunxi.tcbj.api.query.ICsInventoryPreemptionQueryApi;
import com.dtyunxi.tcbj.api.query.ICsLogisticsInfoQueryApi;
import com.dtyunxi.tcbj.api.query.IDeliveryResultOrderQueryApi;
import com.dtyunxi.tcbj.api.query.IInventoryCheckApi;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.tcbj.api.query.IQualityInspectionDataQueryApi;
import com.dtyunxi.tcbj.api.query.ISaleTransferReportApi;
import com.dtyunxi.tcbj.api.query.IShInventoryPreemptionQueryApi;
import com.dtyunxi.tcbj.api.query.ITransferOrderReportQueryApi;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.tcbj.api.vo.InTransitInNoticeDetailVo;
import com.dtyunxi.tcbj.app.open.biz.convert.TransferOrderConvert;
import com.dtyunxi.tcbj.app.open.biz.dto.response.RpLogisticsDeliveredInfoDetailRespDto;
import com.dtyunxi.tcbj.app.open.biz.service.IApiLogService;
import com.dtyunxi.tcbj.app.open.biz.service.IDataDistributeService;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalDataService;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalInPutService;
import com.dtyunxi.tcbj.app.open.biz.service.IFileTranslationService;
import com.dtyunxi.tcbj.app.open.biz.service.IGiftPackageInfoService;
import com.dtyunxi.tcbj.app.open.biz.service.IMultiAllotOrderService;
import com.dtyunxi.tcbj.app.open.biz.utils.AssertUtil;
import com.dtyunxi.tcbj.app.open.biz.utils.DateUtils;
import com.dtyunxi.tcbj.app.open.biz.utils.ParamUtil;
import com.dtyunxi.tcbj.app.open.dao.das.ExternalApiInLogDas;
import com.dtyunxi.tcbj.app.open.dao.das.LimitsDas;
import com.dtyunxi.tcbj.app.open.dao.eo.ExternalApiInLogEo;
import com.dtyunxi.tcbj.app.open.dao.eo.LimitsEo;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ApiLogReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.GiftPackageInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.OrderCancelReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.SaleOrderCarryToReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.AllotOrderDetailDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.AllotOrderDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.BusinessContextDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.CallbackHeaderDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.CallbackRequestDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.EasSaleVerifyOrderDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.EasSaleVerifyOrderItemDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.FhAllotOrderDetailDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.FhAllotOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.yyj.YyjOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.CspTransformStatusDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.LimsQualityInfoRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.external.InventoryQueryRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.store.CsInventoryPreemptionOrderRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ExternalChannelType;
import com.dtyunxi.tcbj.center.openapi.api.enums.ExternalPlatformOrderStatusEnum;
import com.dtyunxi.tcbj.center.openapi.api.enums.ExternalSystenEnum;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalCspApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalOutEasApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.csp.constant.CspOrderStatusEnum;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateCspOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateSpecialChannelOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.RouteMultiAllotNodeEnum;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsInSendBackDetailReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsInSendBackReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsOrderCancelReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsOutSendBackDetailReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsOutSendBackReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsShippingInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.response.WmsBaseRespDto;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.external.eas.ICsEasApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.external.wms.ICsWmsApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryTotalQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.external.ICsInventoryExposedExternalApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsRelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IInternalTradeApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.InternalTradeStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.constant.SendBackBizTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsCancelTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderEditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.InternalTradeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTotalQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderClosedReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateDetailExposedReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderGenerateExposedReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsOutSendBackDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsOutSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryPreemptionRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleRefundOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.EasVerifyStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.LockStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.LockTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleRefundTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CspUpdateEasOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderSapAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.IPcpOrderApi;
import com.dtyunxi.yundt.cube.center.transform.api.IPcpSaleRefundApi;
import com.dtyunxi.yundt.cube.center.transform.api.IPlatformOrderApi;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformOrderSource;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformTransformOrderStatus;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderCancelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderPcpExtendReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.SaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderPcpExtendRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.ThirdSaleOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformAssert;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderItemQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderPcpExtendQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpDictQueryApi;
import com.yunxi.dg.base.center.inventory.api.entity.IReceiveDeliveryResultOrderApi;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInfoQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryResultOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryResultOrderPageReqDto;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.report.api.share.IDgChannelInventoryApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.center.report.dto.share.DgChannelInventoryPageReqDto;
import com.yunxi.dg.base.center.share.dto.InventoryQueryReqDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.UpdatePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExternalInPutServiceImpl
implements IExternalInPutService {
    private static final Logger log = LoggerFactory.getLogger(ExternalInPutServiceImpl.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private ICsLogisticsInfoQueryApi logisticsInfoQueryApi;
    @Autowired
    private ICsLogicInventoryTotalQueryApi csLogicInventoryTotalQueryApi;
    @Autowired
    private ICsLogicInventoryQueryApi iCsLogicInventoryQueryApi;
    @Autowired
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Autowired
    private IPcpOrderApi pcpOrderApi;
    @Autowired
    private IDataDistributeService dataDistributeService;
    @Autowired
    private IShInventoryPreemptionQueryApi shInventoryPreemptionQueryApi;
    @Autowired
    private ICsInventoryPreemptionQueryApi csInventoryPreemptionQueryApi;
    @Autowired
    private ICsWmsApi wmsApi;
    @Autowired
    private ICsInventoryExposedExternalApi inventoryExposedExternalQueryApi;
    @Autowired
    private IPcpSaleRefundApi saleRefundApi;
    @Autowired
    private ISaleRefundOptApi saleRefundOptApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private LimitsDas limitsDas;
    @Resource
    private ExternalApiInLogDas externalApiInLogDas;
    @Resource
    private IOutResultOrderQueryApi outResultOrderQueryApis;
    @Resource
    private IDeliveryResultOrderQueryApi deliveryResultOrderQueryApi;
    @Resource
    private ICsInventoryExposedApi csInventoryExposedApi;
    private ICsLogicInventoryExposedApi csLogicInventoryExposedApi;
    @Resource
    private ICsEasApi csEasApi;
    @Autowired
    private ICsTransferOrderApi transferOrderApi;
    @Autowired
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private IChannelInventoryExposedApi channelInventoryExposedApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleOrderApi saleOrderApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IInternalTradeApi internalTradeApi;
    @Resource
    private IExternalCspApi externalCspRest;
    @Resource
    private ILockService lockService;
    @Resource
    private IGiftPackageInfoService giftPackageInfoService;
    @Resource
    private IQualityInspectionDataQueryApi qualityInspectionDataQueryApi;
    @Resource
    private IPlatformOrderPcpExtendQueryApi platformOrderPcpExtendQueryApi;
    @Resource
    private TransferOrderConvert transferOrderConvert;
    @Resource
    private ISaleTransferReportApi saleTransferReportApi;
    @Resource
    private ITransferOrderReportQueryApi transferOrderReportQueryApi;
    public static final String SALE_ORDER_NO_KEY = "platform-sale-order";
    public static final String YYJ_CHILD_ORDER_NUM_GROUP = "yyj-child-order-num";
    public static final String YYJ_PARENT_ORDER_TYPE = "yyj-parent-order-type";
    @Autowired
    private IExternalOutEasApi externalOutEasRest;
    @Autowired
    private IPlatformOrderApi platformOrderApi;
    @Resource
    private ICsRelWarehouseApi csRelWarehouseApi;
    @Resource
    private IChannelWarehouseApi channelWarehouseApi;
    @Resource
    private ICsLogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private IVirtualInventoryApi virtualInventoryApi;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;
    @Resource
    private IDgChannelInventoryApi dgChannelInventoryApi;
    @Resource
    private IExternalDataService externalDataService;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private IFileTranslationService fileTranslationService;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private ICsOutResultOrderQueryApi csOutResultOrderQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi outNoticeOrderQueryApi;
    @Value(value="${yundt.com.default.warehouseCode:true}")
    private Boolean isDefaultShareWarehouseCode;
    @Value(value="${yundt.com.csp.intercept:true}")
    private Boolean isCspInterceptStatus = true;
    @Resource
    private IInventoryCheckApi inventoryCheckApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private ICsTransferOrderDetailApi csTransferOrderDetailQueryApi;
    @Resource
    private IItemExtendQueryApi itemExtendQueryApi;
    @Autowired
    private IPlatformOrderItemQueryApi platformOrderItemQueryApi;
    @Resource
    private IPcpDictQueryApi pcpDictApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private IMultiAllotOrderService multiAllotOrderService;
    @Resource
    private IApiLogService apiLogService;
    @Resource
    private IDgLogicWarehouseApi dgLogicWarehouseApi;
    @Resource
    private ICsOutPlannedOrderQueryApi csOutPlannedOrderQueryApi;
    @Resource
    private ICsInPlannedOrderQueryApi csInPlannedOrderQueryApi;
    @Resource(name="externalWmsRest")
    private IExternalWmsApi externalWmsApi;
    @Resource
    private ICsInPlannedOrderApi csInPlannedOrderApi;
    @Resource
    private ISaleOrderMergeDataApi saleOrderMergeDataApi;
    @Resource
    private IReceiveDeliveryResultOrderApi receiveDeliveryResultOrderApi;
    @Resource
    private IAdjustmentInventoryApi adjustmentInventoryApi;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;
    public static final List<String> whitePlatformNoList = Lists.newArrayList();

    @Override
    public void addProcess(Map<String, Object> dto) {
        log.info("isCspInterceptStatus=={}", (Object)this.isCspInterceptStatus);
        AssertUtil.isTrue(this.isCspInterceptStatus, "PCP\u7cfb\u7edf\u7ef4\u62a4\u4e2d...");
        log.info("\u65b0\u589e\u9500\u552e\u8ba2\u5355\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        ParamUtil.mustCheck(dto, "platformOrderNo", "orderChannelCode", "orderType", "easOrgId", "orderSource", "isOnline", "thirdOrgID", "easOrgId", "thirdPartyId", "channelWarehouseCode");
        ParamUtil.mustCheckKeyList(dto, "itemReqDtoList", "itemNum", "skuCode", "saleUnitPrice", "salePrice", "gift", "orderTotalAmount", "payAmount");
        ParamUtil.mustCheckKey(dto, "platformOrderAddrReqDto", "receivePhone", "receiveName");
        String orderType = dto.get("orderType").toString();
        String platformOrderNo = dto.get("platformOrderNo").toString();
        if (whitePlatformNoList.contains(platformOrderNo)) {
            log.info("csp\u6e20\u9053\u5355\u53f7\u767d\u540d\u5355=={}", (Object)platformOrderNo);
            return;
        }
        this.externalDataService.checkChannelWarehouse(dto);
        if (Objects.equals(orderType, SaleOrderTypeEnum.BAIJIAN_DIRECT_SALES.getType())) {
            this.externalDataService.queryAndCheckAddressNameInfo(dto);
        }
        ParamUtil.mustCheckKey(dto, "platformOrderAddrReqDto", "provinceCode", "cityCode", "receiveAddress");
        if (!Objects.equals(orderType, SaleOrderTypeEnum.BAIJIAN_DIRECT_SALES.getType())) {
            this.externalDataService.setAddressCountyName(dto);
        }
        String orderStatus = "platformOrderStatus";
        dto.putIfAbsent(orderStatus, "submit");
        dto.putIfAbsent("releaseState", 1);
        if (Objects.equals(orderType, SaleOrderTypeEnum.PRESALE_ORDER.getType())) {
            dto.put("releaseState", 0);
        }
        if (Objects.equals(orderType, SaleOrderTypeEnum.SPECIAL_CHANNEL_ORDER.getType())) {
            DictDto dictDto = (DictDto)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "SPECIAL_CHANNEL_ORDER_VIRTUAL_WAREHOUSE").getData();
            log.info("\u83b7\u53d6\u7279\u6e20\u8ba2\u5355\u5bf9\u5e94\u4f9b\u8d27\u4ed3:{}", (Object)JSON.toJSONString((Object)dictDto));
            if (Objects.nonNull(dictDto)) {
                Map map = (Map)JSON.parseObject((String)dictDto.getValue(), Map.class);
                Object easOrgId = dto.get("easOrgId");
                if (easOrgId != null && map.containsKey(String.valueOf(easOrgId))) {
                    dto.put("storagePlace", map.get(String.valueOf(easOrgId)));
                }
            }
        }
        this.doAddProcess(dto, dto.get(orderStatus).toString());
    }

    private void doAddProcess(Map<String, Object> dto, String orderStatus) {
        JSONObject data = new JSONObject(dto);
        String platformOrderNo = data.getString("platformOrderNo");
        String orderChannelCode = data.getString("orderChannelCode");
        String orderType = data.getString("orderType");
        Integer releaseState = data.getInteger("releaseState");
        Integer negativeValidate = YesOrNoEnum.YES.getType();
        String nothingCanOrderFlg = data.getString("nothingCanOrderFlg");
        if (Objects.equals(nothingCanOrderFlg, "Y")) {
            negativeValidate = YesOrNoEnum.NO.getType();
        }
        if (orderChannelCode.equals("CSP")) {
            dto.put("sellerRemark", dto.get("remark"));
            dto.put("remark", "");
        }
        dto.put("saleChannel", dto.get("marketChannel"));
        SaleOrderTypeEnum saleOrderTypeEnum = SaleOrderTypeEnum.enumOf((String)orderType);
        block5 : switch (orderStatus) {
            case "submit": {
                switch (saleOrderTypeEnum) {
                    case AGENCY_ORDER: 
                    case COMPENSATION_ORDER: 
                    case CUSTOMER_REFUNDING_ORDER: 
                    case QUALITY_REFUNDING_ORDER: 
                    case REPLENISH_ORDER: 
                    case SHOPPE_ORDER: 
                    case OTHER_OUT_STOCK: 
                    case INTERNAL_DISTRIBUTION: 
                    case SECONDARY_DISTRIBUTION: 
                    case CHILD_DIRECT_SALES: 
                    case PRESALE_ORDER: 
                    case COMPENSATION_NOT_ORDER: 
                    case BAIJIAN_DIRECT_SALES: 
                    case MAIYOU_ALLOT: 
                    case SPECIAL_CHANNEL_ORDER: 
                    case CLAIM_REISSUE: 
                    case CLAIM_POSTING: 
                    case BB_TRANSFER_CLAIM_NOT_REISSUE: 
                    case DS_TRANSFER_CLAIMS_NOT_REISSUE: {
                        PlatformOrderRespDto orderRespDto = (PlatformOrderRespDto)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryByPlatformNo(platformOrderNo));
                        if (orderRespDto != null) {
                            if (Objects.equals(orderRespDto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_0.getCode())) {
                                throw new BizException("\u6e20\u9053\u5355\u5df2\u8f6c\u5355\uff0c\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4");
                            }
                            if (Objects.equals(orderRespDto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_5.getCode())) {
                                throw new BizException("\u7d22\u8d54\u5355\u5df2\u7269\u6d41\u521d\u5ba1\uff0c\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4");
                            }
                            if (Objects.equals(orderRespDto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_6.getCode())) {
                                throw new BizException("\u7d22\u8d54\u5355\u5df2\u5ba1\u6838\uff0c\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4");
                            }
                            try {
                                log.info("csp\u518d\u6b21\u63d0\u4ea4\u4f5c\u5e9f\u539f\u6709\u7684\u6e20\u9053\u8ba2\u5355\u548c\u9500\u552e\u8ba2\u5355");
                                RestResponseHelper.extractData((RestResponse)this.platformOrderApi.invalidPlatformOrderByPlatform(platformOrderNo));
                            }
                            catch (Exception e) {
                                log.info("csp\u518d\u6b21\u63d0\u4ea4\u4f5c\u5e9f\u539f\u6709\u7684\u6e20\u9053\u8ba2\u5355\u548c\u9500\u552e\u8ba2\u5355\u5f02\u5e38:{}", (Object)e.getMessage());
                            }
                        }
                        if (SaleOrderTypeEnum.BB_TRANSFER_CLAIM_NOT_REISSUE.getType().equals(orderType) || SaleOrderTypeEnum.DS_TRANSFER_CLAIMS_NOT_REISSUE.getType().equals(orderType)) {
                            String saleOrderNo = this.getSaleOrderNo(platformOrderNo);
                            dto.put("saleOrderNo", saleOrderNo);
                            CsInventoryOperateReqDto inventoryOperateReqDto = this.getCheckInventoryReqDto(dto);
                            inventoryOperateReqDto.setSourceNo(saleOrderNo);
                            inventoryOperateReqDto.setSourceType(orderType);
                            inventoryOperateReqDto.setPlatformOrderNo(platformOrderNo);
                            inventoryOperateReqDto.setSourceSystem(CsSourceSystemEnum.CSP.getCode());
                            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.CLAIM_REISSUE.getCode());
                            inventoryOperateReqDto.setBusinessType(orderType);
                            inventoryOperateReqDto.setBatchCalculate(Boolean.valueOf(true));
                            inventoryOperateReqDto.setNegativeValidate(Integer.valueOf(1));
                            if (SaleOrderTypeEnum.DS_TRANSFER_CLAIMS_NOT_REISSUE.getType().equals(orderType)) {
                                inventoryOperateReqDto.setNegativeValidate(Integer.valueOf(0));
                            }
                            inventoryOperateReqDto.setDisablePreemptionFlag(Boolean.valueOf(true));
                            log.info("placeOrderPreempt==>\u4e0b\u5355\u9884\u5360\u5e93\u5b58,csInventoryOperateReqDto:{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
                            RestResponse booleanRestResponse = this.csInventoryExposedApi.preemptInventory(inventoryOperateReqDto);
                            log.info("placeOrderPreempt==>\u4e0b\u5355\u9884\u5360\u5e93\u5b58\u8fd4\u56de\u7684\u7ed3\u679c,booleanRestResponse:{}", (Object)JSON.toJSONString((Object)booleanRestResponse));
                            Boolean preemptResult = (Boolean)RestResponseHelper.extractData((RestResponse)booleanRestResponse);
                            AssertUtil.isTrue(preemptResult, "\u5e93\u5b58\u4e0d\u8db3");
                        }
                    }
                    case INTEGRAL_ORDER: {
                        if (releaseState == 1) {
                            boolean inventoryResult = this.preemptInventory(dto, platformOrderNo, orderChannelCode, orderType);
                            AssertUtil.isTrue(inventoryResult, "\u5e93\u5b58\u4e0d\u8db3");
                        }
                        log.info("\u53d1\u9001\u9500\u552e\u8ba2\u5355MQ");
                        this.sendMessage("ORDER_ADD_PROCESS", dto);
                        break block5;
                    }
                }
                log.info("\u53d1\u9001\u9500\u552e\u8ba2\u5355MQ");
                this.sendMessage("ORDER_ADD_PROCESS", dto);
                break;
            }
            case "audit_pass": {
                SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
                saleOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
                saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode(), SaleOrderStatusEnum.SPLIT.getCode()}));
                List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
                if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                    List cspCancelSaleOrderList = saleOrderRespDtos.stream().filter(sale -> !Objects.equals(sale.getLockType(), LockTypeEnum.CSP_CANCEL.getType())).collect(Collectors.toList());
                    AssertUtil.isTrue(CollectionUtils.isEmpty(cspCancelSaleOrderList), "\u6d41\u7a0b\u9519\u8bef\uff0c\u5355\u636e\u672a\u53cd\u5ba1");
                }
                if (releaseState == 1) {
                    log.info("\u66f4\u65b0\u6e20\u9053\u4ed3\u9884\u5360\u5e93\u5b58");
                    this.releaseChildAndPreemptChild(dto, platformOrderNo, orderType, negativeValidate);
                }
                this.sendMessage("ORDER_ADD_PROCESS", dto);
                break;
            }
        }
    }

    private void abolishPcpOrder(String platformOrderNo, Integer orderSource, Long platformOrderId) {
        PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
        pcpOrderReqDto.setPlatformOrderNo(platformOrderNo);
        pcpOrderReqDto.setOrderSource(orderSource);
        pcpOrderReqDto.setId(platformOrderId);
        pcpOrderReqDto.setObsoleteReason("\u5916\u90e8\u7cfb\u7edf\u8c03\u7528(\u63d0\u4ea4)\u4f5c\u5e9f\u5355\u636e");
        RestResponseHelper.extractData((RestResponse)this.pcpOrderApi.abolishPcpOrder(pcpOrderReqDto));
        String redisKey = platformOrderNo;
        this.cacheService.delCache(SALE_ORDER_NO_KEY, redisKey);
    }

    private Boolean preemptInventory(Map<String, Object> dto, String platformOrderNo, String orderChannelCode, String orderType) {
        String saleOrderNo = this.getSaleOrderNo(platformOrderNo);
        dto.put("saleOrderNo", saleOrderNo);
        PreemptDto csInventoryOperateReqDto = new PreemptDto();
        csInventoryOperateReqDto.setIsShoutVirtualWarehouse(Boolean.FALSE);
        if (this.isYyJOrder(orderType)) {
            if (this.isDefaultShareWarehouseCode.booleanValue()) {
                Integer canSplitFlag;
                DictDto dictDto = (DictDto)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "YYJ_VIRTUAL_WAREHOUSE").getData();
                log.info("\u83b7\u53d6\u8425\u517b\u5bb6\u7ec4\u7ec7\u5bf9\u5e94\u4f9b\u8d27\u4ed3:{}", (Object)JSON.toJSONString((Object)dictDto));
                if (Objects.nonNull(dictDto)) {
                    Map map = (Map)JSON.parseObject((String)dictDto.getValue(), Map.class);
                    if (!Objects.isNull(dto.get("easOrgId")) && map.containsKey(String.valueOf(dto.get("easOrgId")))) {
                        csInventoryOperateReqDto.setShoutVirtualWarehouseCode((String)map.get(dto.get("easOrgId")));
                    }
                }
                if (Objects.equals(canSplitFlag = (Integer)dto.getOrDefault("canSplitFlag", 0), YesOrNoEnum.NO.getType()) && StringUtils.isNotEmpty((CharSequence)csInventoryOperateReqDto.getShoutVirtualWarehouseCode())) {
                    csInventoryOperateReqDto.setIsShoutVirtualWarehouse(Boolean.TRUE);
                }
            }
        } else {
            Integer canSplitFlag = (Integer)dto.getOrDefault("canSplitFlag", 0);
            if (Objects.equals(canSplitFlag, YesOrNoEnum.NO.getType()) && Objects.nonNull(dto.get("storagePlace"))) {
                csInventoryOperateReqDto.setIsShoutVirtualWarehouse(Boolean.TRUE);
                String storagePlace = dto.get("storagePlace").toString();
                csInventoryOperateReqDto.setShoutVirtualWarehouseCode(storagePlace);
            }
            Boolean negativeValidate = Boolean.TRUE;
            Object nothingCanOrderFlg = dto.get("nothingCanOrderFlg");
            if (Objects.equals(nothingCanOrderFlg, "Y")) {
                negativeValidate = Boolean.FALSE;
            }
            csInventoryOperateReqDto.setValidNegative(negativeValidate);
        }
        csInventoryOperateReqDto.setExternalOrderNo(platformOrderNo);
        csInventoryOperateReqDto.setSourceType(orderType);
        csInventoryOperateReqDto.setSourceNo(saleOrderNo);
        csInventoryOperateReqDto.setDetails(this.getItemDtoList(dto, orderType));
        log.info("\u65b0\u589e\u9500\u552e\u5355\u9884\u5360\u5e93\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)csInventoryOperateReqDto));
        RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApi.preempt(csInventoryOperateReqDto));
        return true;
    }

    private List<OperationDetailDto> getItemDtoList(Map<String, Object> dtoMap, String orderType) {
        ArrayList itemList = Lists.newArrayList();
        List itemReqDtoList = (List)MapUtil.get(dtoMap, (Object)"itemReqDtoList", List.class);
        for (Map map : itemReqDtoList) {
            JSONObject data = new JSONObject(map);
            Integer replacementFlag = 0;
            if (map.containsKey("replacementFlag")) {
                replacementFlag = data.getInteger("replacementFlag");
            }
            if ((Objects.equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), orderType) || Objects.equals(SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType(), orderType)) && Objects.equals(replacementFlag, 0)) continue;
            OperationDetailDto cargoReqDto = new OperationDetailDto();
            cargoReqDto.setNum(data.getBigDecimal("itemNum"));
            cargoReqDto.setSkuCode(data.getString("skuCode"));
            cargoReqDto.setWarehouseCode((String)dtoMap.get("channelWarehouseCode"));
            itemList.add(cargoReqDto);
        }
        return itemList;
    }

    private List<OperationDetailDto> getShOperationDetailDtoList(Map<String, Object> dtoMap, String orderType) {
        ArrayList itemList = Lists.newArrayList();
        List itemReqDtoList = (List)MapUtil.get(dtoMap, (Object)"itemReqDtoList", List.class);
        for (Map map : itemReqDtoList) {
            JSONObject data = new JSONObject(map);
            Integer replacementFlag = 0;
            if (map.containsKey("replacementFlag")) {
                replacementFlag = data.getInteger("replacementFlag");
            }
            if ((Objects.equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), orderType) || Objects.equals(SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType(), orderType)) && Objects.equals(replacementFlag, 0)) continue;
            OperationDetailDto cargoReqDto = new OperationDetailDto();
            cargoReqDto.setNum(data.getBigDecimal("itemNum"));
            cargoReqDto.setSkuCode(data.getString("skuCode"));
            cargoReqDto.setWarehouseCode((String)dtoMap.get("channelWarehouseCode"));
            itemList.add(cargoReqDto);
        }
        return itemList;
    }

    private CsInventoryOperateReqDto getCheckInventoryReqDto(Map<String, Object> dtoMap) {
        Object logicWarehouseCodeObj = dtoMap.get("logicWarehouseCode");
        if (Objects.isNull(logicWarehouseCodeObj)) {
            throw new BizException("\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String logicWarehouseCode = logicWarehouseCodeObj.toString();
        CsLogicWarehouseRespDto warehouseRespDto = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(logicWarehouseCode));
        if (Objects.isNull(warehouseRespDto)) {
            throw new BizException("\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        dtoMap.put("defaultWarehouseCode", warehouseRespDto.getWarehouseCode());
        dtoMap.put("defaultWarehouseId", warehouseRespDto.getId());
        dtoMap.put("defaultWarehouseName", warehouseRespDto.getWarehouseName());
        CsInventoryOperateReqDto checkReqDto = new CsInventoryOperateReqDto();
        checkReqDto.setLogicWarehouseCode(logicWarehouseCode);
        ArrayList itemList = Lists.newArrayList();
        List itemReqDtoList = (List)MapUtil.get(dtoMap, (Object)"itemReqDtoList", List.class);
        for (Map map : itemReqDtoList) {
            JSONObject data = new JSONObject(map);
            CsInventoryOperateCargoReqDto cargoReqDto = new CsInventoryOperateCargoReqDto();
            cargoReqDto.setChangeInventory(data.getBigDecimal("itemNum"));
            cargoReqDto.setLongCode(data.getString("skuCode"));
            String batchNo = data.getString("batchNo");
            cargoReqDto.setBatch(batchNo);
            cargoReqDto.setWarehouseCode(logicWarehouseCode);
            cargoReqDto.setCargoCode(cargoReqDto.getLongCode());
            if (StringUtils.isEmpty((CharSequence)batchNo)) {
                throw new BizException("\u5546\u54c1\u7f16\u7801\u4e3a" + cargoReqDto.getLongCode() + "\u7684\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
            }
            itemList.add(cargoReqDto);
        }
        checkReqDto.setOperateCargoReqDtoList((List)itemList);
        return checkReqDto;
    }

    private boolean isYyJOrder(String orderType) {
        return SaleOrderTypeEnum.ACTIVITY_ORDER.getType().equals(orderType) || SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType().equals(orderType) || SaleOrderTypeEnum.NUTRITION_INTEGRAL.getType().equals(orderType);
    }

    private void releaseChildAndPreemptChild(Map<String, Object> dto, String platformOrderNo, String orderType, Integer negativeValidate) {
        Integer canSplitFlag;
        String newSaleOrderNo = this.getSaleOrderNo(platformOrderNo);
        dto.put("saleOrderNo", newSaleOrderNo);
        log.info("\u9884\u5360\u6e20\u9053\u4ed3\u7684\u8ba2\u5355\u53f7:{},{}", (Object)platformOrderNo, (Object)newSaleOrderNo);
        List<Object> oldSaleOrderList = Lists.newArrayList();
        PlatformOrderQueryReqDto platformOrderQueryReqDto = new PlatformOrderQueryReqDto();
        platformOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
        platformOrderQueryReqDto.setTransferOrderStatusList((List)Lists.newArrayList((Object[])new Integer[]{PlatformTransformOrderStatus.STATUS_1.getCode(), PlatformTransformOrderStatus.STATUS_INIT_1.getCode()}));
        List platformOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryListByParam(platformOrderQueryReqDto));
        log.info("\u5ba1\u6838\u901a\u8fc7\u83b7\u53d6\u5f85\u8f6c\u5355/\u5f02\u5e38\u72b6\u6001\u6e20\u9053\u5355:{},{}", (Object)platformOrderNo, (Object)platformOrderRespDtos.size());
        if (CollectionUtils.isNotEmpty((Collection)platformOrderRespDtos)) {
            List saleOrderNoList = platformOrderRespDtos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSaleOrderNo())).map(PlatformOrderRespDto::getSaleOrderNo).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(saleOrderNoList)) {
                oldSaleOrderList = saleOrderNoList;
            }
        } else {
            SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
            saleOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
            saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode(), SaleOrderStatusEnum.SPLIT.getCode(), SaleOrderStatusEnum.COMPLETE.getCode(), SaleOrderStatusEnum.RECEIVED.getCode()}));
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
            log.info("\u9884\u5360\u6e20\u9053\u4ed3\u7684\u8ba2\u5355\u4fe1\u606f:{},{}", (Object)platformOrderNo, (Object)saleOrderRespDtos.size());
            if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                oldSaleOrderList = saleOrderRespDtos.stream().map(SaleOrderRespDto::getSaleOrderNo).collect(Collectors.toList());
            }
        }
        UpdatePreemptDto param = new UpdatePreemptDto();
        ArrayList releasePreemptParamList = Lists.newArrayList();
        for (String oldSaleOrderNo : oldSaleOrderList) {
            ReleasePreemptDto releaseDto = new ReleasePreemptDto();
            releaseDto.setSourceNo(oldSaleOrderNo);
            releaseDto.setSourceType(orderType);
            releaseDto.setExternalOrderNo(platformOrderNo);
            releasePreemptParamList.add(releaseDto);
        }
        param.setReleasePreemptParamList((List)releasePreemptParamList);
        ArrayList preemptParamList = Lists.newArrayList();
        PreemptDto PreemptDto2 = new PreemptDto();
        PreemptDto2.setSourceNo(newSaleOrderNo);
        PreemptDto2.setSourceType(orderType);
        PreemptDto2.setExternalOrderNo(platformOrderNo);
        PreemptDto2.setIsShoutVirtualWarehouse(Boolean.FALSE);
        PreemptDto2.setValidDisableWarehouse(Boolean.TRUE);
        if (negativeValidate == 0) {
            PreemptDto2.setValidNegative(Boolean.FALSE);
        }
        if (Objects.equals(canSplitFlag = (Integer)dto.getOrDefault("canSplitFlag", 0), YesOrNoEnum.NO.getType()) && Objects.nonNull(dto.get("storagePlace"))) {
            PreemptDto2.setIsShoutVirtualWarehouse(Boolean.TRUE);
            String storagePlace = dto.get("storagePlace").toString();
            PreemptDto2.setShoutVirtualWarehouseCode(storagePlace);
        }
        PreemptDto2.setDetails(this.getShOperationDetailDtoList(dto, orderType));
        preemptParamList.add(PreemptDto2);
        this.setIntegralOrder(dto, negativeValidate, preemptParamList, canSplitFlag);
        param.setPreemptParamList((List)preemptParamList);
        log.info("csp\u5ba1\u6838\u901a\u8fc7\u66f4\u65b0\u5e93\u5b58\u9884\u5360\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)param));
        RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApi.updatePreempt(param));
    }

    private void setIntegralOrder(Map<String, Object> dto, Integer negativeValidate, List<PreemptDto> preemptParamList, Integer canSplitFlag) {
        if (null != dto.get("sourceOrderNo")) {
            String sourceOrderNo = dto.get("sourceOrderNo").toString();
            log.info("SourceOrderNo==>{}", (Object)sourceOrderNo);
            List<String> sourceOrderList = Arrays.asList(sourceOrderNo.split(","));
            PlatformOrderQueryReqDto platformOrderQueryReqDto = new PlatformOrderQueryReqDto();
            platformOrderQueryReqDto.setPlatformOrderNoList(sourceOrderList);
            platformOrderQueryReqDto.setOrderType(SaleOrderTypeEnum.INTEGRAL_ORDER.getType());
            platformOrderQueryReqDto.setTransferOrderStatusList((List)Lists.newArrayList((Object[])new Integer[]{PlatformTransformOrderStatus.STATUS_3.getCode()}));
            List integralOrderList = (List)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryListByParam(platformOrderQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)integralOrderList)) {
                PlatformOrderRespDto platformOrderRespDto = (PlatformOrderRespDto)integralOrderList.get(0);
                List integralOrderItemList = (List)RestResponseHelper.extractData((RestResponse)this.platformOrderItemQueryApi.queryListByOrderId(platformOrderRespDto.getId()));
                PreemptDto integralPreemptParam = new PreemptDto();
                integralPreemptParam.setSourceNo(platformOrderRespDto.getSaleOrderNo());
                integralPreemptParam.setSourceType(platformOrderRespDto.getOrderType());
                integralPreemptParam.setExternalOrderNo(platformOrderRespDto.getPlatformOrderNo());
                integralPreemptParam.setIsShoutVirtualWarehouse(Boolean.FALSE);
                if (negativeValidate == 0) {
                    integralPreemptParam.setValidNegative(Boolean.FALSE);
                }
                if (Objects.equals(canSplitFlag, YesOrNoEnum.NO.getType()) && Objects.nonNull(dto.get("storagePlace"))) {
                    integralPreemptParam.setIsShoutVirtualWarehouse(Boolean.TRUE);
                    String storagePlace = dto.get("storagePlace").toString();
                    integralPreemptParam.setShoutVirtualWarehouseCode(storagePlace);
                }
                ArrayList jfItemList = Lists.newArrayList();
                integralOrderItemList.stream().forEach(item -> {
                    OperationDetailDto cargoReqDto = new OperationDetailDto();
                    cargoReqDto.setNum(item.getItemNum());
                    cargoReqDto.setSkuCode(item.getSkuCode());
                    cargoReqDto.setWarehouseCode(platformOrderRespDto.getChannelWarehouseCode());
                    jfItemList.add(cargoReqDto);
                });
                integralPreemptParam.setDetails((List)jfItemList);
                preemptParamList.add(integralPreemptParam);
            }
        }
    }

    private String getSaleOrderNo(String platformOrderNo) {
        String redisKey = platformOrderNo;
        String saleOrderNo = (String)this.cacheService.getCache(SALE_ORDER_NO_KEY, redisKey, String.class);
        if (StringUtils.isEmpty((CharSequence)saleOrderNo)) {
            saleOrderNo = (String)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.getSaleOrderNo());
            this.cacheService.setCache(SALE_ORDER_NO_KEY, redisKey, (Object)saleOrderNo);
            return saleOrderNo;
        }
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setSaleOrderNo(saleOrderNo);
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
        if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
            log.info("\u6709\u5df2\u4f5c\u5e9f\u72b6\u6001\u9500\u552e\u5355\uff0c\u91cd\u65b0\u751f\u6210\u5355\u636e\u53f7");
            saleOrderNo = (String)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.getSaleOrderNo());
            this.cacheService.setCache(SALE_ORDER_NO_KEY, redisKey, (Object)saleOrderNo);
        }
        return saleOrderNo;
    }

    private com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateCargoReqDto getCsInventoryOperateCargoReqDto(Map<String, Object> dto, Map<String, Object> map) {
        JSONObject data = new JSONObject(map);
        com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateCargoReqDto cargoReqDto = new com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateCargoReqDto();
        cargoReqDto.setChangeInventory(data.getBigDecimal("itemNum"));
        cargoReqDto.setSkuCode(data.getString("skuCode"));
        cargoReqDto.setWarehouseCode((String)dto.get("channelWarehouseCode"));
        return cargoReqDto;
    }

    private boolean releaseInventory(String platformOrderNo, String orderType) {
        String redisKey = platformOrderNo;
        String saleOrderNo = (String)this.cacheService.getCache(SALE_ORDER_NO_KEY, redisKey, String.class);
        if (StringUtils.isNotBlank((CharSequence)saleOrderNo)) {
            ReleasePreemptDto csInventoryOperateReqDto = new ReleasePreemptDto();
            csInventoryOperateReqDto.setSourceNo(saleOrderNo);
            csInventoryOperateReqDto.setSourceType(orderType);
            csInventoryOperateReqDto.setExternalOrderNo(platformOrderNo);
            log.info("\u65b0\u589e\u9500\u552e\u5355\u91ca\u653e\u5e93\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)csInventoryOperateReqDto));
            RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApi.releasePreempt(csInventoryOperateReqDto));
        }
        return true;
    }

    @Override
    public void refundAddProcess(Map<String, Object> dto) {
        log.info("\u65b0\u589e\u9500\u552e\u9000\u8d27\u8ba2\u5355\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        ParamUtil.mustCheck(dto, "platformRefundNo", "orderChannelCode", "refundType", "easOrgId", "thirdPartyId", "refundTotalAmount", "platformRefundApplyTime", "contactPersonName", "contactPhone", "distributionChannel");
        ParamUtil.mustCheckKeyList(dto, "saleRefundOrderItemReqDtoList", "itemNum", "skuCode", "itemUnit", "salePrice", "saleUnitPrice", "gift");
        ParamUtil.mustCheckKeyList(dto, "saleRefundOrderItemReqDtoList", "itemNum", "skuCode", "itemUnit", "salePrice", "saleUnitPrice", "gift");
        ParamUtil.mustCheckKeyPositiveNumberList(dto, "saleRefundOrderItemReqDtoList", "itemNum", "lineAmount");
        ParamUtil.mustCheckKey(dto, "saleRefundAddrReqDto", "receivePhone", "receiveName", "receiveAddress");
        String refundType = dto.get("refundType").toString();
        PlatformAssert.notNull((Object)SaleRefundTypeEnum.enumOf((String)refundType), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8ba2\u5355\u7c7b\u578b\u9519\u8bef"});
        this.sendMessage("ORDER_REFUND_ADD_PROCESS", dto);
    }

    @Override
    public void plannedOrderAdd(Map<String, Object> dto) {
        log.info("\u65b0\u589e\u91c7\u8d2d/\u59d4\u5916/\u751f\u4ea7\u6210\u54c1/\u751f\u4ea7\u9000\u6599\u8ba1\u5212\u5355\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.orderNoItemDetailCheck(dto);
        ParamUtil.mustCheck(dto, "orderType");
        CsInPlannedOrderGenerateExposedReqDto generateExposed = new CsInPlannedOrderGenerateExposedReqDto();
        try {
            BeanUtil.copyProperties(dto, (Object)generateExposed, (String[])new String[0]);
            List itemReqDtoList = (List)MapUtil.get(dto, (Object)"itemDetailList", List.class);
            List itemList = itemReqDtoList.stream().map(items -> {
                CsInPlannedOrderGenerateDetailExposedReqDto detailDto = new CsInPlannedOrderGenerateDetailExposedReqDto();
                BeanUtil.copyProperties((Object)items, (Object)detailDto, (String[])new String[0]);
                detailDto.setExtension(this.buildExtension((Map<String, Object>)items));
                return detailDto;
            }).collect(Collectors.toList());
            generateExposed.setExtension(this.buildExtension(dto));
            generateExposed.setItemDetailList(itemList);
            generateExposed.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BizException("-1", "\u53c2\u6570\u5904\u7406\u5f02\u5e38");
        }
        RestResponseHelper.extractData((RestResponse)this.csEasApi.generatePlannedOrderExposed(generateExposed));
    }

    @Override
    public void plannedOrderRefundAdd(Map<String, Object> dto) {
        log.info("\u65b0\u589e\u91c7\u8d2d\u9000\u8d27/\u751f\u4ea7\u8fd4\u4fee/\u751f\u4ea7\u9886\u6599\u8ba1\u5212\u5355\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.orderNoItemDetailCheck(dto);
        ParamUtil.mustCheck(dto, "orderType");
        CsOutPlannedOrderGenerateReqDto generateReqDto = new CsOutPlannedOrderGenerateReqDto();
        try {
            BeanUtil.copyProperties(dto, (Object)generateReqDto, (String[])new String[0]);
            log.info("\u53c2\u6570\u8f6c\u6362\uff1a{}", (Object)JSON.toJSONString((Object)generateReqDto));
            String orderType = Convert.toStr((Object)dto.get("orderType"));
            this.outPlannedOrderTypeTransition(generateReqDto, orderType);
            generateReqDto.setOperateFlag("submit");
            List itemReqDtoList = (List)MapUtil.get(dto, (Object)"itemDetailList", List.class);
            List itemList = itemReqDtoList.stream().map(items -> {
                CsOutPlannedOrderGenerateDetailReqDto detailReqDto = new CsOutPlannedOrderGenerateDetailReqDto();
                BeanUtil.copyProperties((Object)items, (Object)detailReqDto, (String[])new String[0]);
                detailReqDto.setLongCode(Convert.toStr(items.get("skuCode")));
                detailReqDto.setPlanQuantity(Convert.toBigDecimal(items.get("quantity")));
                detailReqDto.setExtension(this.buildExtension((Map<String, Object>)items));
                return detailReqDto;
            }).collect(Collectors.toList());
            String warehouseCode = generateReqDto.getWarehouseCode();
            if (StringUtils.isBlank((CharSequence)warehouseCode)) {
                generateReqDto.setWarehouseCode(Convert.toStr(((Map)itemReqDtoList.get(0)).get("warehouseCode")));
            }
            generateReqDto.setItemDetailList(itemList);
            generateReqDto.setExtension(this.buildExtension(dto));
            generateReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BizException("-1", "\u53c2\u6570\u5904\u7406\u5f02\u5e38");
        }
        RestResponseHelper.extractData((RestResponse)this.csEasApi.generateRetreatOrder(generateReqDto));
    }

    @Override
    public void closed(Map<String, Object> dto) {
        CsInPlannedOrderClosedReqDto closedReqDto = new CsInPlannedOrderClosedReqDto();
        BeanUtil.copyProperties(dto, (Object)closedReqDto, (String[])new String[0]);
        log.info("SAP\u5173\u5355\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)closedReqDto));
        this.csInPlannedOrderApi.closedOrder(closedReqDto);
    }

    private void outPlannedOrderTypeTransition(CsOutPlannedOrderGenerateReqDto reqDto, String orderType) {
        if (CsPlannedOrderBusinessTypeEnum.PURCHASE_RETREAT.getCode().equals(orderType)) {
            log.info("\u91c7\u8d2d\u9000");
            reqDto.setOrderType(CsPlannedOrderTypeEnum.PURCHASE_RETREAT.getCode());
            reqDto.setBusinessType(CsPlannedOrderBusinessTypeEnum.PURCHASE_RETREAT.getCode());
        } else if (CsPlannedOrderBusinessTypeEnum.OUTSOURCE_RETREAT.getCode().equals(orderType)) {
            log.info("\u59d4\u5916\u9000");
            reqDto.setOrderType(CsPlannedOrderTypeEnum.OUTSOURCE_RETREAT.getCode());
            reqDto.setBusinessType(CsPlannedOrderBusinessTypeEnum.OUTSOURCE_RETREAT.getCode());
        } else if (CsPlannedOrderBusinessTypeEnum.PRODUCT_REPAIR.getCode().equals(orderType)) {
            log.info("\u751f\u4ea7\u9000");
            reqDto.setOrderType(CsPlannedOrderTypeEnum.PRODUCT_REPAIR.getCode());
            reqDto.setBusinessType(CsPlannedOrderBusinessTypeEnum.PRODUCT_REPAIR.getCode());
        } else if (CsPlannedOrderBusinessTypeEnum.PRODUCTION_MATERIALS.getCode().equals(orderType)) {
            log.info("\u751f\u4ea7\u9886\u6599");
            reqDto.setOrderType(CsPlannedOrderTypeEnum.PRODUCTION_MATERIALS.getCode());
            reqDto.setBusinessType(CsPlannedOrderBusinessTypeEnum.PRODUCTION_MATERIALS.getCode());
        } else {
            log.info("\u65e0\u5bf9\u5e94\u4e1a\u52a1");
            throw new BizException("orderType\u65e0\u5bf9\u5e94\u4e1a\u52a1");
        }
    }

    @Override
    public void allotOrderAdd(Map<String, Object> dto) {
        log.info("\u65b0\u589e\u8c03\u62e8\u5355\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.orderNoItemDetailCheck(dto);
        EasTransferOrderReqDto transferOrderReqDto = new EasTransferOrderReqDto();
        transferOrderReqDto.setAutoAudit(Boolean.valueOf(false));
        try {
            BeanUtil.copyProperties(dto, (Object)transferOrderReqDto, (String[])new String[0]);
            List itemReqDtoList = (List)MapUtil.get(dto, (Object)"itemDetailList", List.class);
            List<EasTransferOrderDetailReqDto> itemList = itemReqDtoList.stream().map(items -> {
                EasTransferOrderDetailReqDto detailDto = new EasTransferOrderDetailReqDto();
                BeanUtil.copyProperties((Object)items, (Object)detailDto, (String[])new String[0]);
                detailDto.setLongCode(Convert.toStr(items.get("skuCode")));
                detailDto.setExtension(this.buildExtension((Map<String, Object>)items));
                return detailDto;
            }).collect(Collectors.toList());
            this.buildItemVolume(itemList);
            String inWarehouseCode = transferOrderReqDto.getInWarehouseCode();
            String outWarehouseCode = transferOrderReqDto.getOutWarehouseCode();
            Map item = (Map)itemReqDtoList.get(0);
            if (StringUtils.isBlank((CharSequence)inWarehouseCode)) {
                transferOrderReqDto.setInWarehouseCode(Convert.toStr(item.get("inWarehouseCode")));
            }
            if (StringUtils.isBlank((CharSequence)outWarehouseCode)) {
                transferOrderReqDto.setOutWarehouseCode(Convert.toStr(item.get("outWarehouseCode")));
            }
            transferOrderReqDto.setItemDetailList(itemList);
            transferOrderReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
            transferOrderReqDto.setExtension(this.buildExtension(dto));
            CsLogicWarehouseRespDto inWarehouse = this.queryWarehouseInfo(transferOrderReqDto.getInWarehouseCode());
            CsLogicWarehouseRespDto outWarehouse = this.queryWarehouseInfo(transferOrderReqDto.getOutWarehouseCode());
            if (outWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_B.getCode()) && inWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_B.getCode())) {
                log.info("bb\u8c03\u62e8\u9ed8\u8ba4\u4e0d\u5ba1\u6838");
            }
            if (outWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_C.getCode()) && inWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_B.getCode())) {
                log.info("cb\u8c03\u62e8\u6821\u9a8c\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
                transferOrderReqDto.getItemDetailList().forEach(i -> {
                    if (StringUtils.isBlank((CharSequence)i.getBatch())) {
                        throw new BizException("-1", "\u5546\u54c1 " + i.getLongCode() + " \u7684\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
                this.verifyAddressInfo(dto);
            }
            if (outWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_B.getCode()) && inWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_C.getCode())) {
                log.info("bc\u8c03\u62e8");
                this.verifyAddressInfo(dto);
                this.verifyChannelSupplyInventory(transferOrderReqDto.getItemDetailList(), transferOrderReqDto.getOutWarehouseCode(), InventoryCheckEasReqDto.Type.BC);
            }
            if (outWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_B.getCode()) && inWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_B.getCode())) {
                this.verifyChannelSupplyInventory(transferOrderReqDto.getItemDetailList(), transferOrderReqDto.getOutWarehouseCode(), InventoryCheckEasReqDto.Type.BB);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BizException("-1", "\u53c2\u6570\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage());
        }
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)transferOrderReqDto));
        RestResponseHelper.extractData((RestResponse)this.transferOrderApi.easAddTransferOrder(transferOrderReqDto));
    }

    private void buildItemVolume(List<EasTransferOrderDetailReqDto> itemList) {
        log.info("\u6784\u5efa\u5546\u54c1\u884c\u4f53\u79ef\uff1a{}", (Object)JSON.toJSONString(itemList));
        List<String> longCodes = itemList.stream().map(EasTransferOrderDetailReqDto::getLongCode).collect(Collectors.toList());
        Map<String, PcpItemRespDto> map = this.queryItemInfo(longCodes);
        if (ObjectUtil.isNotEmpty(map)) {
            itemList.forEach(item -> {
                PcpItemRespDto pcpItemRespDto = (PcpItemRespDto)map.get(item.getLongCode());
                if (ObjectUtil.isNotEmpty((Object)pcpItemRespDto) && ObjectUtil.isNotEmpty((Object)pcpItemRespDto.getVolume())) {
                    item.setVolume(item.getQuantity().multiply(pcpItemRespDto.getVolume()).setScale(4, RoundingMode.DOWN));
                }
            });
        }
    }

    private Map<String, PcpItemRespDto> queryItemInfo(List<String> longCodes) {
        try {
            log.info("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(longCodes));
            if (CollectionUtils.isEmpty(longCodes)) {
                return new HashMap<String, PcpItemRespDto>();
            }
            List itemList = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodes));
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                return itemList.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, entity -> entity));
            }
            return new HashMap<String, PcpItemRespDto>();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void verifyAddressInfo(Map<String, Object> dto) {
        log.info("\u6821\u9a8c\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        if (ObjectUtil.isEmpty((Object)dto.get("detailAddress"))) {
            throw new BizException("-1", "\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)dto.get("province"))) {
            throw new BizException("-1", "\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)dto.get("city"))) {
            throw new BizException("-1", "\u57ce\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private boolean verifyBTB(String inCode, String outCode) {
        log.info("\u6821\u9a8c\u8c03\u62e8\u51fa\u5165\u4ed3\u662f\u5426b\u5230b\uff1a{}\uff0c{}", (Object)inCode, (Object)outCode);
        CsLogicWarehouseRespDto inWarehouse = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(inCode));
        if (ObjectUtil.isEmpty((Object)inWarehouse) || StringUtils.isBlank((CharSequence)inWarehouse.getWarehouseType())) {
            return false;
        }
        CsLogicWarehouseRespDto outWarehouse = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(outCode));
        if (ObjectUtil.isEmpty((Object)outWarehouse) || StringUtils.isBlank((CharSequence)outWarehouse.getWarehouseType())) {
            return false;
        }
        return inWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_B.getCode()) && outWarehouse.getWarehouseType().equals(CsWarehouseTypeEnum.TCBJ_B.getCode());
    }

    private void verifyChannelSupplyInventory(List<EasTransferOrderDetailReqDto> itemDetailList, String logicWarehouseCode, InventoryCheckEasReqDto.Type type) {
        log.info("EAS\u53d1\u8d77\u8c03\u62e8\u6821\u9a8c\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58");
        if (CollectionUtils.isEmpty(itemDetailList)) {
            throw new BizException("-1", "\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InventoryCheckEasReqDto reqDto = new InventoryCheckEasReqDto();
        reqDto.setType(type);
        reqDto.setCheckType(InventoryCheckReqDto.CheckType.CHANNEL);
        reqDto.setLogicWarehouseCode(logicWarehouseCode);
        reqDto.setItems(itemDetailList.stream().map(item -> {
            InventoryCheckItem checkItem = new InventoryCheckItem();
            checkItem.setLongCode(item.getLongCode());
            checkItem.setTargetInventory(item.getQuantity());
            return checkItem;
        }).collect(Collectors.toList()));
        log.info("EAS\u53d1\u8d77\u8c03\u62e8\u6821\u9a8c\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        InventoryCheckRespDto respDto = (InventoryCheckRespDto)RestResponseHelper.extractData((RestResponse)this.inventoryCheckApi.checkForEas(reqDto));
        if (!respDto.isCheckResult()) {
            throw new BizException("-1", "\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\u5931\u8d25\uff1a" + this.getMsg(respDto.getItems()));
        }
    }

    private String getMsg(List<InventoryCheckItem> items) {
        if (CollectionUtils.isEmpty(items)) {
            return "\u6821\u9a8c\u5f02\u5e38\uff0c\u5546\u54c1\u5217\u8868\u4e3a\u7a7a";
        }
        StringBuilder msg = new StringBuilder("");
        for (InventoryCheckItem item : items) {
            if (!StringUtils.isNotBlank((CharSequence)item.getCheckReason())) continue;
            msg.append(item.getCheckReason()).append(";");
        }
        return msg.toString();
    }

    private CsLogicWarehouseRespDto queryWarehouseInfo(String warehouseCode) {
        log.info("\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)warehouseCode);
        CsLogicWarehouseRespDto warehouse = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(warehouseCode));
        if (ObjectUtil.isEmpty((Object)warehouse)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230 " + warehouseCode + " \u5bf9\u5e94\u7684\u4ed3\u5e93\u4fe1\u606f");
        }
        if (StringUtils.isBlank((CharSequence)warehouse.getWarehouseType())) {
            throw new BizException("-1", "\u4ed3\u5e93 " + warehouseCode + " \u672a\u5b9a\u4e49\u7c7b\u578b");
        }
        return warehouse;
    }

    @Override
    public void fhAllotOrderAdd(FhAllotOrderReqDto dto) {
        log.info("\u65b0\u589e\u5206\u8d27\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EasTransferOrderReqDto easTransferOrderDetailReqDto = this.checkFhAllotAndConvertDto(dto);
        switch (CsPcpBusinessTypeEnum.getByCode((String)easTransferOrderDetailReqDto.getAllotType())) {
            case INTERNAL_ALLOT: 
            case INTERNAL_EXPORT_DEAL: 
            case INTERNAL_DEAL: 
            case INTERNAL_DEAL_RETURN: 
            case SALE_RETURN_INTERNAL_DEAL: {
                log.info("\u5206\u8d27\u8c03\u62e8\u6216\u5206\u8d27\u4ea4\u6613");
                RestResponseHelper.extractData((RestResponse)this.transferOrderApi.easAddTransferOrder(easTransferOrderDetailReqDto));
                break;
            }
            case ROUTE_INTERNAL_ALLOT: 
            case ROUTE_INTERNAL_DEAL: {
                log.info("\u5728\u9014\u5206\u8d27\u8c03\u62e8\u6216\u8005\u5728\u9014\u5206\u8d27\u4ea4\u6613");
                RestResponseHelper.extractData((RestResponse)this.transferOrderApi.easAddRouterTransferOrder(easTransferOrderDetailReqDto));
                break;
            }
            default: {
                throw new BizException("\u4e1a\u52a1\u7c7b\u578b\u5f02\u5e38");
            }
        }
    }

    private EasTransferOrderReqDto checkFhAllotAndConvertDto(FhAllotOrderReqDto dto) {
        EasTransferOrderReqDto easTransferOrderDetailReqDto = new EasTransferOrderReqDto();
        FhAllotOrderDetailDto detailDto = (FhAllotOrderDetailDto)dto.getItemList().get(0);
        DgLogicWarehousePageReqDto inQueryDto = new DgLogicWarehousePageReqDto();
        inQueryDto.setWarehouseCodes((List)Lists.newArrayList((Object[])new String[]{detailDto.getIssueWarehouse(), detailDto.getReceiptWarehouse()}));
        List logicWarehouseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(inQueryDto));
        Map<String, DgLogicWarehouseDto> warehouseMap = logicWarehouseDtoList.stream().filter(Objects::nonNull).collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, warehouse -> warehouse, (existing, replacement) -> replacement));
        String issueWarehouse = detailDto.getIssueWarehouse();
        String receiptWarehouse = detailDto.getReceiptWarehouse();
        DgLogicWarehouseDto issueWarehouseDto = warehouseMap.get(issueWarehouse);
        DgLogicWarehouseDto receiptWarehouseDto = warehouseMap.get(receiptWarehouse);
        boolean routeType = false;
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (issueWarehouse.equals(receiptWarehouse)) {
            errorMsg.add("\u8c03\u51fa\u4ed3\u548c\u8c03\u5165\u4ed3\u4e0d\u80fd\u76f8\u540c");
        } else {
            CsRelWarehouseRespDto outRelWarehouseRespDto;
            Map collect;
            CsRelWarehouseRespDto inRelWarehouseRespDto;
            if (issueWarehouseDto == null) {
                errorMsg.add("\u8c03\u51fa\u4ed3 [" + issueWarehouse + "] \u4e0d\u5b58\u5728");
            } else if (!CsLogicWarehouseStatusEnum.ENABLE.getCode().equals(issueWarehouseDto.getWarehouseStatus())) {
                errorMsg.add("\u8c03\u51fa\u4ed3 [" + issueWarehouse + "] \u672a\u542f\u7528");
            } else if (issueWarehouseDto.getWarehouseClassify().equals("in_transit")) {
                if (dto.getAllotType().equals("311") || dto.getAllotType().equals("STO")) {
                    routeType = true;
                } else {
                    errorMsg.add("\u8c03\u51fa\u4ed3 [" + issueWarehouse + "] \u4e0d\u80fd\u662f\u5728\u9014\u4ed3");
                }
            }
            if (receiptWarehouseDto == null) {
                errorMsg.add("\u8c03\u5165\u4ed3 [" + receiptWarehouse + "] \u4e0d\u5b58\u5728");
            } else if (!CsLogicWarehouseStatusEnum.ENABLE.getCode().equals(receiptWarehouseDto.getWarehouseStatus())) {
                errorMsg.add("\u8c03\u5165\u4ed3 [" + receiptWarehouse + "] \u672a\u542f\u7528");
            } else if (receiptWarehouseDto.getWarehouseClassify().equals("in_transit")) {
                errorMsg.add("\u8c03\u5165\u4ed3 [" + receiptWarehouse + "] \u4e0d\u80fd\u662f\u5728\u9014\u4ed3");
            }
            log.info("\u6821\u9a8c\u8c03\u5165\u4ed3\u53ca\u8c03\u51fa\u4ed3\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u662f\u5426\u4e00\u81f4\uff1a{}\uff0c{}", (Object)receiptWarehouse, (Object)issueWarehouse);
            String queryDto = new CsRelWarehouseQueryDto();
            queryDto.setWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{receiptWarehouse, issueWarehouse}));
            List csRelWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csRelWarehouseApi.queryList((CsRelWarehouseQueryDto)queryDto));
            if (CollectionUtils.isEmpty((Collection)csRelWarehouseRespDtoList)) {
                errorMsg.add("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u4fe1\u606f");
            }
            if (ObjectUtil.isEmpty((Object)(inRelWarehouseRespDto = (CsRelWarehouseRespDto)(collect = csRelWarehouseRespDtoList.stream().collect(Collectors.toMap(CsRelWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1))).get(receiptWarehouse)))) {
                errorMsg.add(receiptWarehouse + "\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u4fe1\u606f");
            }
            if (ObjectUtil.isEmpty((Object)(outRelWarehouseRespDto = (CsRelWarehouseRespDto)collect.get(issueWarehouse)))) {
                errorMsg.add(issueWarehouse + "\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u4fe1\u606f");
            }
            if (!dto.getAllotType().equals("Z11") && !inRelWarehouseRespDto.getRefWarehouseCode().equals(outRelWarehouseRespDto.getRefWarehouseCode())) {
                errorMsg.add("\u8c03\u51fa\u4ed3\u548c\u8c03\u5165\u4ed3\u4e3a\u4e0d\u540c\u7269\u7406\u4ed3");
            }
        }
        AssertUtil.isTrue(errorMsg.isEmpty(), ((Object)errorMsg).toString());
        log.info("\u5224\u65ad\u5355\u636e\u662f\u5426\u4e3a\u5728\u9014\u5185\u90e8\u4ea4\u6613");
        switch (dto.getAllotType()) {
            case "311": {
                easTransferOrderDetailReqDto.setAllotType(routeType ? CsPcpBusinessTypeEnum.ROUTE_INTERNAL_ALLOT.getCode() : CsPcpBusinessTypeEnum.INTERNAL_ALLOT.getCode());
                break;
            }
            case "STO": {
                easTransferOrderDetailReqDto.setAllotType(routeType ? CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL.getCode() : CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode());
                break;
            }
            case "Z11": {
                easTransferOrderDetailReqDto.setAllotType(CsPcpBusinessTypeEnum.INTERNAL_EXPORT_DEAL.getCode());
                break;
            }
            case "Z13": {
                easTransferOrderDetailReqDto.setAllotType(CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode());
                break;
            }
            default: {
                throw new BizException("-1", "\u5206\u8d27\u7c7b\u578b\u6709\u8bef");
            }
        }
        easTransferOrderDetailReqDto.setPlatformOrderNo(dto.getExternalNo());
        easTransferOrderDetailReqDto.setSourceSystem(CsSourceSystemEnum.SAP.getCode());
        easTransferOrderDetailReqDto.setOutWarehouseCode(detailDto.getIssueWarehouse());
        easTransferOrderDetailReqDto.setInWarehouseCode(detailDto.getReceiptWarehouse());
        easTransferOrderDetailReqDto.setBizDate(dto.getBizDate());
        List itemDetailList = dto.getItemList().stream().map(d -> {
            EasTransferOrderDetailReqDto item = new EasTransferOrderDetailReqDto();
            item.setLongCode(d.getMaterial());
            item.setQuantity(d.getBaseQty());
            item.setOutWarehouseCode(d.getIssueWarehouse());
            item.setInWarehouseCode(d.getReceiptWarehouse());
            item.setBatch(d.getBatch());
            HashMap<String, String> extensionMap = new HashMap<String, String>();
            extensionMap.put(EASExtendKeyEnum.ENTRY_SEQ.code, detailDto.getExternalItemId());
            item.setExtension(JSON.toJSONString(extensionMap));
            return item;
        }).collect(Collectors.toList());
        easTransferOrderDetailReqDto.setItemDetailList(itemDetailList);
        return easTransferOrderDetailReqDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void multiAllotOrderAdd(List<AllotOrderDto> dto) {
        Mutex mutex;
        AllotOrderDto allotOrderDto;
        block7: {
            log.info("\u65b0\u589e\u591a\u65b9\u8c03\u62e8\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(dto));
            this.routeMultiAllotTypeCheck(dto);
            this.multiAllotOrderAddVerify(dto);
            this.dealVerifyChannelSupplyInventory(dto, dto.get(0).getAllotType());
            if (dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode()) || dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode())) {
                log.info("\u5185\u90e8\u4ea4\u6613\u6216\u5185\u90e8\u4ea4\u6613\u9000");
                List<CsInventoryOperateReqDto> csInventoryOperateReqDtoList = this.inventoryOperateListBuild(dto, null);
                List<EasTransferOrderReqDto> easTransferOrderReqDtoList = this.easTransferOrderList(dto);
                log.info("\u5e93\u5b58\u9884\u5360\uff1a{}", (Object)JSON.toJSONString(csInventoryOperateReqDtoList));
                RestResponseHelper.extractData((RestResponse)this.csInventoryExposedApi.batchPreemptInventory(csInventoryOperateReqDtoList));
                CompletableFuture.runAsync(() -> {
                    log.info("\u521b\u5efa\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)easTransferOrderReqDtoList));
                    RestResponseHelper.extractData((RestResponse)this.transferOrderApi.batchEasAddTransferOrder(easTransferOrderReqDtoList));
                });
                return;
            }
            if (dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode())) {
                log.info("\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613\uff01");
                ArrayList internalTradeReqDtoList = new ArrayList();
                AtomicInteger i = new AtomicInteger(1);
                dto.forEach(allot -> {
                    InternalTradeReqDto internalTradeReqDto = new InternalTradeReqDto();
                    internalTradeReqDto.setNo(allot.getPlatformOrderNo());
                    internalTradeReqDto.setNoParent(allot.getPlatformOrderParentNo());
                    internalTradeReqDto.setBusinessType(allot.getAllotType());
                    internalTradeReqDto.setStatus(InternalTradeStatusEnum.WAIT.getCode());
                    internalTradeReqDto.setContent(JSON.toJSONString((Object)allot));
                    internalTradeReqDto.setSort(Integer.valueOf(i.getAndIncrement()));
                    internalTradeReqDtoList.add(internalTradeReqDto);
                });
                RestResponseHelper.extractData((RestResponse)this.internalTradeApi.addBatchInternalTrade(internalTradeReqDtoList));
                try {
                    List<CsInventoryOperateReqDto> csInventoryOperateReqDtoList = this.inventoryOperateListBuild(dto, CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode());
                    log.info("\u5e93\u5b58\u9884\u5360\uff1a{}", (Object)JSON.toJSONString(csInventoryOperateReqDtoList));
                    RestResponseHelper.extractData((RestResponse)this.csInventoryExposedApi.batchPreemptInventory(csInventoryOperateReqDtoList));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    InternalTradeReqDto params = new InternalTradeReqDto();
                    params.setNoParent(((InternalTradeReqDto)internalTradeReqDtoList.get(0)).getNoParent());
                    this.internalTradeApi.removeInternalTrade(params);
                    throw new BizException("\u9884\u5360\u5931\u8d25\uff1a" + e.getMessage());
                }
                CompletableFuture.runAsync(() -> {
                    log.info("\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613,\u5f02\u6b65\u6267\u884c");
                    InternalTradeReqDto params = new InternalTradeReqDto();
                    params.setNo(((InternalTradeReqDto)internalTradeReqDtoList.get(0)).getNo());
                    params.setNoParent(((InternalTradeReqDto)internalTradeReqDtoList.get(0)).getNoParent());
                    params.setStatus(InternalTradeStatusEnum.UNDER_WAY.getCode());
                    this.internalTradeApi.modifyInternalTrade(params);
                    try {
                        List<EasTransferOrderReqDto> easTransferOrderReqDtoList = this.easTransferOrderList(Lists.newArrayList((Object[])new AllotOrderDto[]{(AllotOrderDto)dto.get(0)}));
                        RestResponseHelper.extractData((RestResponse)this.transferOrderApi.batchEasAddTransferOrder(easTransferOrderReqDtoList));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        params.setRemark("\u6267\u884c\u5f02\u5e38\uff0c\u521b\u5efa\u5355\u636e\u5931\u8d25\uff1a" + e.getMessage());
                    }
                });
                return;
            }
            if (!dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL.getCode())) throw new BizException("\u4e1a\u52a1\u7c7b\u578b\u5f02\u5e38");
            log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\uff1a{}", (Object)JacksonUtil.toJson(dto));
            allotOrderDto = dto.get(0);
            AssertUtil.isTrues(allotOrderDto.getItemDetailList().size() > 1, "-1", "\u5728\u9014\u5185\u90e8\u4ea4\u6613\u4e0d\u5141\u8bb8\u53d1\u8d77\u591a\u4e2a\u660e\u7ec6");
            AllotOrderDetailDto allotOrderDetailDto = (AllotOrderDetailDto)allotOrderDto.getItemDetailList().get(0);
            String key = allotOrderDetailDto.getSkuCode() + allotOrderDetailDto.getQuantity() + allotOrderDetailDto.getOutWarehouseCode();
            mutex = null;
            try {
                log.info("\u5206\u5e03\u5f0f\u9501\uff1a{}", (Object)key);
                mutex = this.lockService.lock("ROUTE_INTERNAL_DEAL", key, 60);
                ApiLogReqDto logReqDto = new ApiLogReqDto();
                logReqDto.setClassName(allotOrderDto.getExternalSaleOrderNo());
                logReqDto.setMethodName(RouteMultiAllotNodeEnum.ACCEPT.getName());
                logReqDto.setStatus(1);
                List<ApiLogReqDto> apiLogReqDtoList = this.apiLogService.queryRouteInternalDeal(logReqDto);
                if (!CollectionUtils.isNotEmpty(apiLogReqDtoList)) break block7;
                log.info("\u8be5\u5185\u90e8\u4ea4\u6613\u5df2\u63a5\u5355");
                if (null == mutex) return;
            }
            catch (Throwable throwable) {
                if (null == mutex) throw throwable;
                this.lockService.unlock(mutex);
                throw throwable;
            }
            this.lockService.unlock(mutex);
            return;
        }
        this.routeMultiAllot(allotOrderDto);
        if (null == mutex) return;
        this.lockService.unlock(mutex);
    }

    private void routeMultiAllot(AllotOrderDto allotOrderDto) {
        List<InTransitInNoticeDetailVo> inTransitInNoticeDetailVoList = this.multiAllotOrderService.routeMultiAllotMatch(allotOrderDto);
        this.multiAllotOrderService.routeMultiAllotPreemptInventory(allotOrderDto);
        InTransitInNoticeDetailVo noticeDetailVo = null;
        try {
            noticeDetailVo = this.multiAllotOrderService.routeMultiAllotCancelToWms(inTransitInNoticeDetailVoList, allotOrderDto);
        }
        catch (Exception e) {
            try {
                this.multiAllotOrderService.routeMultiAllotReleaseInventory(allotOrderDto);
            }
            catch (Exception e2) {
                throw new BizException("-1", "\u63a8\u9001WMS\u53d6\u6d88\u5931\u8d25\uff1a" + e.getMessage() + "\uff1b\u91ca\u653e\u5e93\u5b58\u5931\u8d25\uff1a" + e2.getMessage());
            }
            throw new BizException("-1", "\u63a8\u9001WMS\u53d6\u6d88\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.apiLogService.addRouteInternalDeal(allotOrderDto.getExternalSaleOrderNo(), RouteMultiAllotNodeEnum.ACCEPT, true, noticeDetailVo.getInNoticeNo());
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        InTransitInNoticeDetailVo finalNoticeDetailVo = noticeDetailVo;
        CompletableFuture.runAsync(() -> {
            MDC.put((String)"yes.req.requestId", (Object)reqId);
            this.multiAllotOrderService.routeMultiAllotExecute(allotOrderDto, finalNoticeDetailVo);
        });
        log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u63a5\u5355\u5b8c\u6210");
    }

    private void routeMultiAllotTypeCheck(List<AllotOrderDto> dto) {
        AllotOrderDetailDto detailDto = (AllotOrderDetailDto)dto.get(0).getItemDetailList().get(0);
        DgLogicWarehousePageReqDto inQueryDto = new DgLogicWarehousePageReqDto();
        inQueryDto.setWarehouseCodes((List)Lists.newArrayList((Object[])new String[]{detailDto.getOutWarehouseCode(), detailDto.getInWarehouseCode()}));
        List logicWarehouseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(inQueryDto));
        if (CollectionUtil.isEmpty((Collection)logicWarehouseDtoList) || logicWarehouseDtoList.size() != 2) {
            log.info("\u6839\u636e\u51fa\u5165\u4ed3\u5e93\u5224\u65ad\u5355\u636e\u662f\u5426\u4e3a\u5728\u9014\u5185\u90e8\u4ea4\u6613\uff1a{}", (Object)JacksonUtil.toJson((Object)logicWarehouseDtoList));
            throw new BizException("-1", "\u51fa\u5165\u4ed3\u67e5\u8be2\u5f02\u5e38\uff1a{}" + JacksonUtil.toJson((Object)inQueryDto.getWarehouseCodes()));
        }
        List warehouseDtoList = logicWarehouseDtoList.stream().filter(f -> f.getWarehouseClassify().equals("in_transit")).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(warehouseDtoList) && warehouseDtoList.size() == 2) {
            log.info("\u5224\u65ad\u5355\u636e\u662f\u5426\u4e3a\u5728\u9014\u5185\u90e8\u4ea4\u6613");
            dto.get(0).setAllotType(CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL.getCode());
        }
    }

    private void multiAllotOrderAddVerify(List<AllotOrderDto> dto) {
        boolean specifyBatch = true;
        if (dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode()) || dto.get(0).getAllotType().equals(CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL.getCode())) {
            specifyBatch = false;
        }
        boolean finalSpecifyBatch = specifyBatch;
        dto.forEach(d -> {
            block8: {
                if (!finalSpecifyBatch) {
                    log.info("\u4e0d\u6307\u5b9a\u6279\u6b21\u6821\u9a8c\uff1a{}", (Object)d.getSaleCustomerCode());
                    Map<String, List<AllotOrderDetailDto>> collect = d.getItemDetailList().stream().collect(Collectors.groupingBy(AllotOrderDetailDto::getSkuCode));
                    collect.forEach((k, v) -> {
                        if (v.size() > 1) {
                            throw new BizException("\u8bf7\u6c42\u5931\u8d25\uff0c\u5546\u54c1\uff1a" + k + "\u5b58\u5728\u591a\u884c\u660e\u7ec6");
                        }
                    });
                }
                if ((d.getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode()) || d.getAllotType().equals(CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode())) && StringUtils.isNotBlank((CharSequence)d.getPlatformOrderNo())) {
                    Mutex mutex = null;
                    try {
                        log.info("\u5185\u90e8\u4ea4\u6613\u9000\u3001\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613\u7236\u5355\u53f7\u5e42\u7b49\u6821\u9a8c");
                        mutex = this.lockService.lock("ExternalInPutServiceImpl", d.getPlatformOrderNo(), 10);
                        if (null == mutex) {
                            throw new BizException("\u5185\u90e8\u4ea4\u6613\u9000\u3001\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613\u7236\u5355\u53f7\u5e42\u7b49\u6821\u9a8c\u5931\u8d25\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
                        }
                        CsTransferOrderReqDto reqDto = new CsTransferOrderReqDto();
                        reqDto.setPreOrderNo(d.getPlatformOrderNo());
                        List list = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryTransferOrderList(reqDto));
                        if (CollectionUtils.isNotEmpty((Collection)list) && StringUtils.isNotBlank((CharSequence)((CsTransferOrderRespDto)list.get(0)).getTransferOrderNo())) {
                            throw new BizException("\u8be5\u5185\u90e8\u4ea4\u6613\u9000\u3001\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613\u5df2\u5b58\u5728\u5355\u636e\uff1a" + d.getPlatformOrderNo());
                        }
                        if (null == mutex) break block8;
                    }
                    catch (Throwable throwable) {
                        if (null != mutex) {
                            this.lockService.unlock(mutex);
                        }
                        throw throwable;
                    }
                    this.lockService.unlock(mutex);
                }
            }
            String inWarehouseCode = ((AllotOrderDetailDto)d.getItemDetailList().get(0)).getInWarehouseCode();
            String outWarehouseCode = ((AllotOrderDetailDto)d.getItemDetailList().get(0)).getOutWarehouseCode();
            log.info("\u6821\u9a8c\u8c03\u5165\u4ed3\u53ca\u8c03\u51fa\u4ed3\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u662f\u5426\u4e00\u81f4\uff1a{}\uff0c{}", (Object)inWarehouseCode, (Object)outWarehouseCode);
            CsRelWarehouseQueryDto queryDto = new CsRelWarehouseQueryDto();
            queryDto.setWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{inWarehouseCode, outWarehouseCode}));
            List csRelWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csRelWarehouseApi.queryList(queryDto));
            AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)csRelWarehouseRespDtoList), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u4fe1\u606f");
            Map collect = csRelWarehouseRespDtoList.stream().collect(Collectors.toMap(CsRelWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            CsRelWarehouseRespDto inRelWarehouseRespDto = (CsRelWarehouseRespDto)collect.get(inWarehouseCode);
            AssertUtil.isFalse(ObjectUtil.isEmpty((Object)inRelWarehouseRespDto), inWarehouseCode + "\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u4fe1\u606f");
            CsRelWarehouseRespDto outRelWarehouseRespDto = (CsRelWarehouseRespDto)collect.get(outWarehouseCode);
            AssertUtil.isFalse(ObjectUtil.isEmpty((Object)outRelWarehouseRespDto), outWarehouseCode + "\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u4fe1\u606f");
            if (!inRelWarehouseRespDto.getRefWarehouseCode().equals(outRelWarehouseRespDto.getRefWarehouseCode())) {
                throw new BizException("\u8c03\u51fa\u4ed3\u548c\u8c03\u5165\u4ed3\u4e3a\u4e0d\u540c\u7269\u7406\u4ed3");
            }
        });
    }

    private void dealVerifyChannelSupplyInventory(List<AllotOrderDto> dto, String type) {
        log.info("\u591a\u65b9\u8c03\u62e8\u4ea4\u6613\u6e20\u9053\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString(dto));
        boolean ifOpen = Objects.equals("1", Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "INTERNAL_DEAL_CHANNEL_CHECK").getData()).map(DictDto::getValue).orElse("0"));
        if (!ifOpen) {
            log.info("\u63a7\u5236\u5173\u95ed\uff0c\u65e0\u9700\u6821\u9a8c");
            return;
        }
        List<Object> itemDetailList = new ArrayList();
        switch (CsPcpBusinessTypeEnum.getByCode((String)type)) {
            case INTERNAL_DEAL: 
            case INTERNAL_DEAL_RETURN: 
            case ROUTE_INTERNAL_DEAL: {
                itemDetailList = dto.stream().map(AllotOrderDto::getItemDetailList).flatMap(Collection::stream).collect(Collectors.toList());
                break;
            }
            case SALE_RETURN_INTERNAL_DEAL: {
                itemDetailList = dto.get(0).getItemDetailList();
                break;
            }
        }
        List items = itemDetailList.stream().map(detailDto -> {
            InventoryCheckItem item = new InventoryCheckItem();
            item.setLongCode(detailDto.getSkuCode());
            item.setBatch(detailDto.getBatch());
            item.setTargetInventory(detailDto.getQuantity());
            item.setLogicWarehouseCode(detailDto.getOutWarehouseCode());
            return item;
        }).collect(Collectors.toList());
        InventoryCheckReqDto checkReqDto = new InventoryCheckReqDto();
        checkReqDto.setItems(items);
        checkReqDto.setCheckType(InventoryCheckReqDto.CheckType.CHANNEL);
        log.info("\u591a\u65b9\u8c03\u62e8\u4ea4\u6613\u6e20\u9053\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)checkReqDto));
        InventoryCheckRespDto inventoryCheckRespDto = (InventoryCheckRespDto)RestResponseHelper.extractData((RestResponse)this.inventoryCheckApi.batchCheckForShare(checkReqDto));
        log.info("\u591a\u65b9\u8c03\u62e8\u4ea4\u6613\u6e20\u9053\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)inventoryCheckRespDto));
        if (!inventoryCheckRespDto.isCheckResult()) {
            String msg = inventoryCheckRespDto.getItems().stream().filter(c -> !c.isCheckResult()).map(InventoryCheckItem::getCheckReason).collect(Collectors.joining(";")).replaceAll(";", "\n");
            throw new BizException("-1", "\u6e20\u9053\u4ed3\u4f9b\u8d27\u4ed3\u5e93\u5b58\u6821\u9a8c\u5931\u8d25\uff1a" + msg);
        }
    }

    private List<CsInventoryOperateReqDto> inventoryOperateListBuild(List<AllotOrderDto> dto, String allotType) {
        log.info("\u6279\u91cf\u9884\u5360\u6570\u636e\u6784\u5efa\uff1a{}=={}", (Object)JSON.toJSONString(dto), (Object)allotType);
        ArrayList<CsInventoryOperateReqDto> csInventoryOperateReqDtoList = new ArrayList<CsInventoryOperateReqDto>();
        dto.forEach(allot -> {
            if (StringUtils.isBlank((CharSequence)allotType) || allot.getAllotType().equals(allotType)) {
                CsInventoryOperateReqDto csInventoryOperateReqDto = new CsInventoryOperateReqDto();
                BeanUtil.copyProperties((Object)allot, (Object)csInventoryOperateReqDto, (String[])new String[0]);
                csInventoryOperateReqDto.setPlatformOrderNo(allot.getPlatformOrderNo());
                csInventoryOperateReqDto.setSourceNo(allot.getExternalSaleOrderNo());
                csInventoryOperateReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
                csInventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT_PREEMPT.getCode());
                csInventoryOperateReqDto.setBusinessType(CsPcpBusinessTypeEnum.ALLOT_OUT.getCode());
                csInventoryOperateReqDto.setBatchCalculate(Boolean.valueOf(true));
                csInventoryOperateReqDto.setNegativeValidate(Integer.valueOf(1));
                ArrayList inventoryOperateCargoReqDtoList = new ArrayList();
                ArrayList itemDetailList = new ArrayList();
                allot.getItemDetailList().forEach(item -> {
                    CsInventoryOperateCargoReqDto inventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
                    inventoryOperateCargoReqDto.setLongCode(item.getSkuCode());
                    inventoryOperateCargoReqDto.setWarehouseCode(item.getOutWarehouseCode());
                    inventoryOperateCargoReqDto.setChangeInventory(item.getQuantity());
                    inventoryOperateCargoReqDto.setBatch(item.getBatch());
                    inventoryOperateCargoReqDtoList.add(inventoryOperateCargoReqDto);
                });
                csInventoryOperateReqDto.setOperateCargoReqDtoList(inventoryOperateCargoReqDtoList);
                csInventoryOperateReqDtoList.add(csInventoryOperateReqDto);
            }
        });
        return csInventoryOperateReqDtoList;
    }

    private List<EasTransferOrderReqDto> easTransferOrderList(List<AllotOrderDto> dto) {
        ArrayList<EasTransferOrderReqDto> easTransferOrderReqDtoList = new ArrayList<EasTransferOrderReqDto>();
        dto.forEach(allot -> {
            EasTransferOrderReqDto easTransferOrderReqDto = new EasTransferOrderReqDto();
            easTransferOrderReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
            easTransferOrderReqDto.setPlatformOrderNo(allot.getPlatformOrderNo());
            easTransferOrderReqDto.setParentOrderNo(allot.getPlatformOrderParentNo());
            easTransferOrderReqDto.setExternalSaleOrderNo(allot.getExternalSaleOrderNo());
            easTransferOrderReqDto.setExternalPurchaseOrderNo(allot.getExternalPurchaseOrderNo());
            easTransferOrderReqDto.setAllotType(allot.getAllotType());
            easTransferOrderReqDto.setParentOrderNo(allot.getPlatformOrderParentNo());
            easTransferOrderReqDto.setSupplierCode(allot.getSupplierCode());
            easTransferOrderReqDto.setInWarehouseCode(((AllotOrderDetailDto)allot.getItemDetailList().get(0)).getInWarehouseCode());
            easTransferOrderReqDto.setOutWarehouseCode(((AllotOrderDetailDto)allot.getItemDetailList().get(0)).getOutWarehouseCode());
            easTransferOrderReqDto.setRemark(allot.getRemark());
            HashMap<String, Object> extensionMap = new HashMap<String, Object>();
            if (allot.getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode())) {
                extensionMap.put(EASExtendKeyEnum.F_COMPANY_ORG.code, allot.getInInventoryOrgCode());
            } else {
                extensionMap.put(EASExtendKeyEnum.F_COMPANY_ORG.code, allot.getOutInventoryOrgCode());
            }
            extensionMap.put(EASExtendKeyEnum.SOURCE_NUM.code, allot.getExternalPurchaseOrderNo());
            extensionMap.put(EASExtendKeyEnum.SOURCE_ID.code, allot.getExternalPurchaseOrderId());
            extensionMap.put(EASExtendKeyEnum.SALE_ORDER_NO.code, allot.getExternalSaleOrderNo());
            extensionMap.put(EASExtendKeyEnum.SALE_ORDER_ID.code, allot.getExternalSaleOrderId());
            extensionMap.put(EASExtendKeyEnum.SOURCE_ID.code, allot.getExternalPurchaseOrderId());
            extensionMap.put(EASExtendKeyEnum.SALE_ORG_CODE.code, allot.getSaleOrganizationCode());
            extensionMap.put(EASExtendKeyEnum.SALE_CUS_CODE.code, allot.getSaleCustomerCode());
            extensionMap.put(EASExtendKeyEnum.ITEM_TOTAL_AMOUNT.code, allot.getItemTotalAmount());
            easTransferOrderReqDto.setExtension(JSON.toJSONString(extensionMap));
            List<String> longCodes = allot.getItemDetailList().stream().map(AllotOrderDetailDto::getSkuCode).collect(Collectors.toList());
            Map<String, PcpItemRespDto> map = this.queryItemInfo(longCodes);
            ArrayList itemDetailList = new ArrayList();
            allot.getItemDetailList().forEach(item -> {
                PcpItemRespDto pcpItemRespDto;
                EasTransferOrderDetailReqDto easTransferOrderDetailReqDto = new EasTransferOrderDetailReqDto();
                easTransferOrderDetailReqDto.setLongCode(item.getSkuCode());
                easTransferOrderDetailReqDto.setQuantity(item.getQuantity());
                easTransferOrderDetailReqDto.setBatch(item.getBatch());
                if (ObjectUtil.isNotEmpty((Object)map) && ObjectUtil.isNotEmpty(map.get(item.getSkuCode())) && ObjectUtil.isNotEmpty((Object)(pcpItemRespDto = (PcpItemRespDto)map.get(item.getSkuCode())).getVolume())) {
                    easTransferOrderDetailReqDto.setVolume(pcpItemRespDto.getVolume().multiply(item.getQuantity()).setScale(4, RoundingMode.DOWN));
                }
                HashMap<String, Object> itemExtensionMap = new HashMap<String, Object>();
                itemExtensionMap.put(EASExtendKeyEnum.ENTRY_ID.code, item.getPurchaseOrderDetailId());
                itemExtensionMap.put(EASExtendKeyEnum.ENTRY_ID2.code, item.getSaleOrderDetailId());
                itemExtensionMap.put(EASExtendKeyEnum.ITEM_PRICE.code, item.getPrice());
                itemExtensionMap.put(EASExtendKeyEnum.ITEM_SALE_PRICE.code, item.getSalePrice());
                itemExtensionMap.put(EASExtendKeyEnum.ITEM_ACTUALLY_AMOUNT.code, item.getActuallyAmount());
                itemExtensionMap.put(EASExtendKeyEnum.ITEM_PAYABLE_AMOUNT.code, item.getPayableAmount());
                itemExtensionMap.put(EASExtendKeyEnum.DISCOUNT_AMOUNT.code, item.getDiscountAmount());
                itemExtensionMap.put(EASExtendKeyEnum.TAX_RATE.code, item.getTaxRate());
                itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_PROJECT_NO.code, item.getProjectNo());
                itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_IF_ONLINE.code, item.getIfOnline());
                itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_TRACK_PLAN.code, item.getTrackPlan());
                easTransferOrderDetailReqDto.setExtension(JSON.toJSONString(itemExtensionMap));
                itemDetailList.add(easTransferOrderDetailReqDto);
            });
            easTransferOrderReqDto.setItemDetailList(itemDetailList);
            easTransferOrderReqDtoList.add(easTransferOrderReqDto);
        });
        return easTransferOrderReqDtoList;
    }

    @Override
    public void orderCancel(Map<String, Object> dto) {
        log.info("\u5355\u636e\u53d6\u6d88\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(dto));
        this.orderNoCheck(dto);
        OrderCancelReqDto reqDto = (OrderCancelReqDto)JSON.parseObject((String)JSON.toJSONString(dto), OrderCancelReqDto.class);
        log.info("\u5355\u636e\u53d6\u6d88\u8bf7\u6c42\u5165\u53c2\u8f6c\u6362\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isTrues(StringUtils.isBlank((CharSequence)reqDto.getPlatformOrderNo()), "-1", "\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrues(StringUtils.isBlank((CharSequence)reqDto.getOrderChannelCode()), "-1", "\u8ba2\u5355\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrues(!ExternalSystenEnum.checkByCode((String)Convert.toStr((Object)reqDto.getOrderChannelCode())), "-1", "\u8ba2\u5355\u6e20\u9053\u7f16\u7801\u672a\u77e5\uff1a" + reqDto.getOrderChannelCode());
        AssertUtil.isTrues(ObjectUtil.isEmpty((Object)reqDto.getChannelType()), "-1", "\u53d6\u6d88\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrues(!ExternalChannelType.checkByCode((Integer)reqDto.getChannelType()), "-1", "\u53d6\u6d88\u7c7b\u578b\u672a\u77e5\uff1a" + reqDto.getChannelType());
        if (whitePlatformNoList.contains(reqDto.getPlatformOrderNo())) {
            log.info("csp\u6e20\u9053\u5355\u53f7\u767d\u540d\u5355\uff1a{}", (Object)reqDto.getPlatformOrderNo());
            return;
        }
        ExternalChannelType type = ExternalChannelType.getByCode((Integer)reqDto.getChannelType());
        switch (Objects.requireNonNull(ExternalChannelType.getByCode((Integer)reqDto.getChannelType()))) {
            case SALE_ORDER: {
                Object platformOrderStatusObj = dto.get("platformOrderStatus");
                String platformOrderStatus = Convert.toStr((Object)platformOrderStatusObj);
                if (!ExternalPlatformOrderStatusEnum.checkByCode((String)platformOrderStatus)) {
                    throw new BizException("\u8bf7\u786e\u8ba4\u5e73\u53f0\u8ba2\u5355\u64cd\u4f5c\u72b6\u6001[platformOrderStatus]");
                }
                PlatformOrderCancelReqDto refundReqDto = (PlatformOrderCancelReqDto)BeanUtil.copyProperties(dto, PlatformOrderCancelReqDto.class, (String[])new String[0]);
                if (reqDto.getOrderChannelCode().equals(ExternalSystenEnum.CSP.getCode())) {
                    RestResponseHelper.extractData((RestResponse)this.pcpOrderApi.cancelPlatformOrder(refundReqDto));
                }
                if (!reqDto.getOrderChannelCode().equals(ExternalSystenEnum.EAS.getCode())) break;
                if (ExternalPlatformOrderStatusEnum.CANCEL.getCode().equals(platformOrderStatus)) {
                    log.info("EAS\u53cd\u5ba1\u8ba2\u5355");
                    RestResponseHelper.extractData((RestResponse)this.saleOrderApi.easCancelOrderLock(refundReqDto.getPlatformOrderNo()));
                }
                if (!ExternalPlatformOrderStatusEnum.DELETE.getCode().equals(platformOrderStatus)) break;
                log.info("EAS\u5220\u9664\u8ba2\u5355");
                RestResponseHelper.extractData((RestResponse)this.saleOrderApi.easDeleteOrderLock(refundReqDto.getPlatformOrderNo()));
                break;
            }
            case SALES_RETURN: {
                SaleRefundReqDto saleRefund = new SaleRefundReqDto();
                saleRefund.setPlatformRefundNo(reqDto.getPlatformOrderNo());
                RestResponseHelper.extractData((RestResponse)this.saleRefundApi.cancelSaleRefund(saleRefund));
                break;
            }
            case PURCHASE: 
            case PRODUCTION: 
            case OUTSOURCE: 
            case PRODUCTION_MATERIALS_RETURN: {
                CsInPlannedOrderQueryDto queryDto = new CsInPlannedOrderQueryDto();
                queryDto.setPlatformOrderNo(reqDto.getPlatformOrderNo());
                queryDto.setOrderType(type.getType());
                List list = (List)RestResponseHelper.extractData((RestResponse)this.csInPlannedOrderQueryApi.queryList(queryDto));
                List inRespList = list.stream().filter(e -> !e.getOrderStatus().equals("cancel")).collect(Collectors.toList());
                AssertUtil.isTrues(CollectionUtils.isEmpty((Collection)list), "-1", "\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
                AssertUtil.isTrues(inRespList.size() > 1, "-1", "\u5355\u636e\u4fe1\u606f\u5f02\u5e38\uff0c\u5b58\u5728\u591a\u6761\u5355\u636e");
                CsInPlannedOrderRespDto csInPlannedOrderDto = (CsInPlannedOrderRespDto)list.get(0);
                if (!CollectionUtils.isEmpty(inRespList)) {
                    csInPlannedOrderDto = (CsInPlannedOrderRespDto)inRespList.get(0);
                }
                String orderStatus = csInPlannedOrderDto.getOrderStatus();
                String inPlanOrderStatusDesc = CsPlannedOrderStatusEnum.getByCode((String)orderStatus).getDesc();
                AssertUtil.isTrues(!orderStatus.equals(CsPlannedOrderStatusEnum.CANCEL.getCode()), "-1", "\u5355\u636e\u72b6\u6001\u4e3a\uff1a" + inPlanOrderStatusDesc + "\uff0c\u4e0d\u53ef\u76f4\u63a5\u53cd\u5ba1\uff0c\u8bf7\u8054\u7cfb\u7269\u6d41\u90e8\u53d6\u6d88WMS\u4f5c\u4e1a\u5355\u636e\u540e\uff0c\u518d\u91cd\u8bd5\u53cd\u5ba1\uff0c\u8c22\u8c22\uff01");
                break;
            }
            case PURCHASE_RETURN: 
            case PRODUCTION_RETURN: 
            case PRODUCTION_MATERIALS: {
                CsOutPlannedOrderPageQueryDto pageQueryDto = new CsOutPlannedOrderPageQueryDto();
                pageQueryDto.setPlatformOrderNo(reqDto.getPlatformOrderNo());
                pageQueryDto.setOrderType(type.getType());
                List respDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderQueryApi.queryList(pageQueryDto));
                List outRespList = respDtoList.stream().filter(e -> !e.getOrderStatus().equals("cancel")).collect(Collectors.toList());
                AssertUtil.isTrues(CollectionUtils.isEmpty((Collection)respDtoList), "-1", "\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
                AssertUtil.isTrues(outRespList.size() > 1, "-1", "\u5355\u636e\u4fe1\u606f\u5f02\u5e38\uff0c\u5b58\u5728\u591a\u6761\u5355\u636e");
                CsOutPlannedOrderRespDto outPlannedOrder = (CsOutPlannedOrderRespDto)respDtoList.get(0);
                if (!CollectionUtils.isEmpty(outRespList)) {
                    outPlannedOrder = (CsOutPlannedOrderRespDto)outRespList.get(0);
                }
                String outPlanOrderStatusDesc = CsPlannedOrderStatusEnum.getByCode((String)outPlannedOrder.getOrderStatus()).getDesc();
                AssertUtil.isTrues(!outPlannedOrder.getOrderStatus().equals(CsPlannedOrderStatusEnum.CANCEL.getCode()), "-1", "\u5355\u636e\u72b6\u6001\u4e3a\uff1a" + outPlanOrderStatusDesc + "\uff0c\u4e0d\u53ef\u76f4\u63a5\u53cd\u5ba1\uff0c\u8bf7\u8054\u7cfb\u7269\u6d41\u90e8\u53d6\u6d88WMS\u4f5c\u4e1a\u5355\u636e\u540e\uff0c\u518d\u91cd\u8bd5\u53cd\u5ba1\uff0c\u8c22\u8c22\uff01");
                break;
            }
            default: {
                log.info("\u672a\u5904\u7406\u7c7b\u578b\uff01");
            }
        }
    }

    private boolean cancelToWms(String relevanceNo, String orderType) {
        CsOutNoticeOrderQueryDto queryDto = new CsOutNoticeOrderQueryDto();
        queryDto.setRelevanceNo(relevanceNo);
        List noticeOrderList = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByParam(queryDto));
        AssertUtil.isTrues(CollectionUtils.isEmpty((Collection)noticeOrderList), "-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355\uff1a" + relevanceNo);
        AssertUtil.isTrues(noticeOrderList.size() > 1, "-1", "\u5b58\u5728\u591a\u4e2a\u901a\u77e5\u5355\uff1a" + relevanceNo);
        CsOutNoticeOrderRespDto noticeOrderRespDto = (CsOutNoticeOrderRespDto)noticeOrderList.get(0);
        WmsOrderCancelReqDto cancelReqDto = new WmsOrderCancelReqDto();
        cancelReqDto.setOrderCode(noticeOrderRespDto.getDocumentNo());
        cancelReqDto.setOrderType(orderType);
        cancelReqDto.setWarehouseCode(noticeOrderRespDto.getWarehouseCode());
        cancelReqDto.setLogicWarehouseCode(noticeOrderRespDto.getOutPhysicsWarehouseCode());
        log.info("\u8bf7\u6c42WMS\u53d6\u6d88\u51fa\u5165\u5e93\u901a\u77e5:{}", (Object)JSON.toJSONString((Object)cancelReqDto));
        try {
            WmsBaseRespDto wmsBaseRespDto = (WmsBaseRespDto)RestResponseHelper.extractData((RestResponse)this.externalWmsApi.cancel(cancelReqDto));
            AssertUtil.isTrues(!wmsBaseRespDto.isSuccess(), "-1", "\u8bf7\u6c42WMS\u53d6\u6d88\u5165\u5e93\u5931\u8d25\uff1a" + wmsBaseRespDto.getContent());
        }
        catch (Exception e) {
            log.info("WMS\u53d6\u6d88\u901a\u77e5\u5355\u5931\u8d25\uff1a" + cancelReqDto.getOrderCode() + "\u3002" + e.getMessage());
            return false;
        }
        return true;
    }

    private void obsoleteOrder(String platformOrderNo) {
        log.info("\u4f5c\u5e9f\u5e73\u53f0\u5355\u4fe1\u606f:{}", (Object)platformOrderNo);
        RestResponseHelper.extractData((RestResponse)this.platformOrderApi.invalidPlatformOrderByPlatform(platformOrderNo));
    }

    private void cancelPlatformOrder(PlatformOrderCancelReqDto refundReqDto) {
        log.info("\u53d6\u6d88\u5e73\u53f0\u5355\u4fe1\u606f");
        String platformOrderNo = refundReqDto.getPlatformOrderNo();
        PlatformOrderRespDto orderRespDto = (PlatformOrderRespDto)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryByPlatformNo(platformOrderNo));
        if (Objects.isNull(orderRespDto)) {
            log.info("\u6e20\u9053\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        String easOrderNo = null;
        Long platformOrderId = orderRespDto.getId();
        if (Objects.equals(refundReqDto.getPlatformOrderStatus(), PlatformOrderStatusEnum.CANCEL.getCode()) && !Objects.equals(SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType(), orderRespDto.getOrderType())) {
            if (!Objects.equals(orderRespDto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_0.getCode())) {
                log.info("\u5e73\u53f0\u5355:{},\u672a\u8f6c\u5355", (Object)refundReqDto.getPlatformOrderNo());
                return;
            }
            if (Objects.equals(orderRespDto.getOrderBizType(), SaleOrderBizTypeEnum.FINANCIAL_FRONT.getType())) {
                SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
                saleOrderQueryReqDto.setPlatformOrderId(platformOrderId);
                List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
                log.info("\u8f6c\u5355\u540e\u7684\u9500\u552e\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)saleOrderRespDtos));
                if (Objects.equals(((SaleOrderRespDto)saleOrderRespDtos.get(0)).getEasVerifyStatus(), EasVerifyStatusEnum.YES.getType())) {
                    log.info("pcp\u9500\u552e\u5355eas\u5df2\u9a8c\u8bc1");
                    easOrderNo = ((SaleOrderRespDto)saleOrderRespDtos.get(0)).getEasOrderNo();
                    if (StringUtils.isEmpty((CharSequence)easOrderNo)) {
                        String errorMsg = "\u9500\u552e\u5355\u5355\u53f7:" + ((SaleOrderRespDto)saleOrderRespDtos.get(0)).getSaleOrderNo() + "EAS\u5355\u53f7\u672a\u56de\u4f20\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
                        log.info("\u9500\u552e\u5355\u53f7:{},easOrderNo\u4e3a\u7a7a", (Object)((SaleOrderRespDto)saleOrderRespDtos.get(0)).getSaleOrderNo());
                        throw new BizException(errorMsg);
                    }
                }
            }
        }
        RestResponseHelper.extractData((RestResponse)this.pcpOrderApi.cancelPlatformOrder(refundReqDto));
    }

    private void cancelOrderByEas(String platformOrderNo) {
        log.info("EAS\u53d6\u6d88\u8ba2\u5355{}", (Object)platformOrderNo);
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
        saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode(), SaleOrderStatusEnum.CANCEL.getCode()}));
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
        if (CollectionUtils.isEmpty((Collection)saleOrderRespDtos)) {
            log.info("EAS\u53d6\u6d88\u8ba2\u5355\u72b6\u6001\u5df2\u53d6\u6d88\u6216\u4f5c\u5e9f");
            return;
        }
        ArrayList cancelOrderId = Lists.newArrayList();
        for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
            if (Objects.equals(saleOrderRespDto.getLockStatus(), LockStatusEnum.LOCK.getType())) {
                throw new BizException("\u8ba2\u5355\u6302\u8d77\u72b6\u6001,\u8bf7\u89e3\u6302\u540e\u64cd\u4f5c");
            }
            if (Objects.equals(saleOrderRespDto.getOrderStatus(), SaleOrderStatusEnum.WAIT_DELIVERY.getCode()) || Objects.equals(saleOrderRespDto.getOrderStatus(), SaleOrderStatusEnum.COMPLETE.getCode()) || Objects.equals(saleOrderRespDto.getOrderStatus(), SaleOrderStatusEnum.RECEIVED.getCode())) {
                throw new BizException("\u8ba2\u5355\u5df2\u53d1\u8d27,\u4e0d\u53ef\u64cd\u4f5c\u53d6\u6d88");
            }
            cancelOrderId.add(saleOrderRespDto.getId());
        }
        log.info("eas\u53d6\u6d88\u8ba2\u5355id:{}", (Object)JSON.toJSONString((Object)cancelOrderId));
        for (Long orderId : cancelOrderId) {
            try {
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.cancelOrder(orderId, "EAS\u53d6\u6d88\u8ba2\u5355"));
            }
            catch (Exception e) {
                log.info("\u53d6\u6d88\u8ba2\u5355\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public List<Map<String, Object>> cspUpdateEasOrderNo(List<SaleOrderCarryToReqDto> dtos) {
        log.info("\u8425\u9500\u4e91csp\u8ba2\u5355\u53f7\u66f4\u65b0eas\u8ba2\u5355\u53f7\u4ee5\u53ca\u8d22\u52a1\u8fc7\u8d26\u7684\u5b57\u6bb5:{}", (Object)JSON.toJSONString(dtos));
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        dtos.forEach(dto -> {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("documentNo", dto.getDocumentNo());
            try {
                log.info("\u6267\u884c\u8fc7\u8d26\uff1a{}", (Object)JSON.toJSONString((Object)dto));
                CspUpdateEasOrderReqDto cspUpdateEasOrderReqDto = new CspUpdateEasOrderReqDto();
                BeanUtil.copyProperties((Object)dto, (Object)cspUpdateEasOrderReqDto, (String[])new String[0]);
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.cspUpdateEasOrderNo(cspUpdateEasOrderReqDto));
                result.put("resultCode", "0");
                result.put("resultMsg", "\u8bf7\u6c42\u6210\u529f");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                result.put("resultCode", "-1");
                result.put("resultMsg", e.getMessage());
            }
            resultList.add(result);
        });
        return resultList;
    }

    @Override
    public void preemptChannelInvenyory(Map<String, Object> dto) {
        log.info("\u5e93\u5b58\u9884\u5360\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.orderNoCheck(dto);
        ParamUtil.mustCheckKeyList(dto, "operateItemReqDtoList", "skuCode", "changeInventory", "warehouseCode");
        RestResponseHelper.extractData((RestResponse)this.csInventoryExposedApi.preemptInventory(this.dealCsInventoryOperateReqDto(dto)));
    }

    private CsInventoryOperateReqDto dealCsInventoryOperateReqDto(Map<String, Object> dto) {
        CsInventoryOperateReqDto csInventoryOperateReqDto = (CsInventoryOperateReqDto)BeanUtil.copyProperties(dto, CsInventoryOperateReqDto.class, (String[])new String[0]);
        List itemReqDtoList = (List)MapUtil.get(dto, (Object)"operateItemReqDtoList", List.class);
        List itemList = itemReqDtoList.stream().map(items -> {
            CsInventoryOperateCargoReqDto csInventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
            BeanUtil.copyProperties((Object)items, (Object)csInventoryOperateCargoReqDto, (String[])new String[0]);
            csInventoryOperateCargoReqDto.setLongCode(Convert.toStr(items.get("skuCode")));
            return csInventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        csInventoryOperateReqDto.setOperateCargoReqDtoList(itemList);
        return csInventoryOperateReqDto;
    }

    @Override
    public void releaseChannelByPreemption(Map<String, Object> dto) {
        log.info("\u5e93\u5b58\u91ca\u653e\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.orderNoCheck(dto);
        this.sendMessage("RELEASE_CHANNEL_BY_PREEMPTION", dto);
    }

    @Override
    public void syncStockOutInfo(JSONObject dto) {
        log.info("WMS\u51fa\u5e93\u4fe1\u606f\u56de\u4f20\u540c\u6b65\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        String businessType = dto.getString("businessType");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)dto.getString("outNoticeOrderNo")), "\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)businessType), "\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a");
        CsWmsOutSendBackReqDto csWmsOutSendBackReqDto = null;
        csWmsOutSendBackReqDto = Objects.equals("e3", businessType) || Objects.equals("e3my", businessType) || Objects.equals("e3bs", businessType) ? this.buildOutSendBackOFE3(dto, businessType) : (CsWmsOutSendBackReqDto)BeanUtil.copyProperties((Object)dto, CsWmsOutSendBackReqDto.class, (String[])new String[0]);
        RestResponseHelper.checkOrThrow((RestResponse)this.wmsApi.outSendBack(csWmsOutSendBackReqDto));
    }

    private CsWmsOutSendBackReqDto buildOutSendBackOFE3(JSONObject dto, String businessType) {
        log.info("\u6784\u5efa\u56de\u4f20\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        CsWmsOutSendBackReqDto csWmsOutSendBackReqDto = (CsWmsOutSendBackReqDto)BeanUtil.copyProperties((Object)dto, CsWmsOutSendBackReqDto.class, (String[])new String[0]);
        List csOutNoticeOrderList = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByRelevanceNoList((List)Lists.newArrayList((Object[])new String[]{csWmsOutSendBackReqDto.getOutNoticeOrderNo()})));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)csOutNoticeOrderList), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355");
        AssertUtil.isFalse(csOutNoticeOrderList.size() > 1, "\u901a\u77e5\u5355\u636e\u5f02\u5e38\uff0c\u5b58\u5728\u591a\u4e2a\u901a\u77e5\u5355");
        CsOutNoticeOrderRespDto csOutNoticeOrder = (CsOutNoticeOrderRespDto)csOutNoticeOrderList.get(0);
        csWmsOutSendBackReqDto.setOutNoticeOrderNo(csOutNoticeOrder.getDocumentNo());
        CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(csOutNoticeOrder.getRelevanceNo()));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)transferOrder), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
        List transferOrderDetail = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailQueryApi.queryListByTransferOrderNo(csOutNoticeOrder.getRelevanceNo()));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)transferOrderDetail), "\u627e\u4e0d\u5230\u539f\u8c03\u62e8\u5355\u660e\u7ec6");
        Map<Object, Object> itemMap = new HashMap();
        if (Objects.equals("e3my", businessType)) {
            ItemExtendReqDto reqDto = new ItemExtendReqDto();
            reqDto.setItemCodeList(transferOrderDetail.stream().map(CsTransferOrderDetailRespDto::getLongCode).collect(Collectors.toList()));
            List itemThirdCodeList = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(reqDto));
            if (CollectionUtils.isNotEmpty((Collection)itemThirdCodeList)) {
                itemMap = itemThirdCodeList.stream().collect(Collectors.toMap(ItemExtendRespDto::getE3ItemCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        List itemDetailList = JSONArray.parseArray((String)dto.getString("itemDetailList"), CsWmsOutSendBackDetailReqDto.class);
        HashMap finalItemMap = itemMap;
        itemDetailList.forEach(detail -> {
            ItemExtendRespDto itemExtendRespDto;
            if (StringUtils.isBlank((CharSequence)detail.getWarehouseCode())) {
                detail.setWarehouseCode(transferOrder.getOutPhysicsWarehouseCode());
            }
            if (Objects.equals("e3bs", businessType)) {
                for (CsTransferOrderDetailRespDto orderDetail : transferOrderDetail) {
                    if (!orderDetail.getLongCode().substring(orderDetail.getLongCode().lastIndexOf(".") + 1).equals(detail.getSkuCode())) continue;
                    detail.setSkuCode(orderDetail.getLongCode());
                    break;
                }
            }
            if (Objects.equals("e3my", businessType) && ObjectUtil.isNotEmpty((Object)(itemExtendRespDto = (ItemExtendRespDto)finalItemMap.get(detail.getSkuCode())))) {
                detail.setSkuCode(itemExtendRespDto.getItemCode());
            }
        });
        csWmsOutSendBackReqDto.setDetailReqDtoList(itemDetailList);
        csWmsOutSendBackReqDto.setEnableAdjustInTransit(Boolean.valueOf(true));
        csWmsOutSendBackReqDto.setBizType(SendBackBizTypeEnum.E3.getCode());
        log.info("\u53c2\u6570\u6784\u5efa\uff1a{}", (Object)JSON.toJSONString((Object)csWmsOutSendBackReqDto));
        return csWmsOutSendBackReqDto;
    }

    private Object transferStockOutInfo(Map<String, Object> message) {
        WmsOutSendBackReqDto wmsOut = (WmsOutSendBackReqDto)BeanUtil.copyProperties(message, WmsOutSendBackReqDto.class, (String[])new String[0]);
        String outNoticeOrderNo = wmsOut.getOutNoticeOrderNo();
        wmsOut.setOutNoticeOrderNo(Convert.toStr((Object)message.get("order_no"), (String)outNoticeOrderNo));
        String platformOrderNo = wmsOut.getPlatformOrderNo();
        wmsOut.setPlatformOrderNo(Convert.toStr((Object)message.get("omsordercode"), (String)platformOrderNo));
        BigDecimal totalCartons = wmsOut.getTotalCartons();
        wmsOut.setTotalCartons(Convert.toBigDecimal((Object)message.get("box_qty"), (BigDecimal)totalCartons));
        BigDecimal mergeQuantity = wmsOut.getMergeQuantity();
        wmsOut.setMergeQuantity(Convert.toBigDecimal((Object)message.get("mix_box_qty"), (BigDecimal)mergeQuantity));
        List itemReqDtoList = (List)MapUtil.get(message, (Object)"itemDetailList", List.class);
        if (CollectionUtils.isEmpty((Collection)itemReqDtoList)) {
            itemReqDtoList = (List)MapUtil.get(message, (Object)"details", List.class);
        }
        List itemList = itemReqDtoList.stream().map(items -> {
            WmsOutSendBackDetailReqDto dto = new WmsOutSendBackDetailReqDto();
            BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
            String skuCode = dto.getSkuCode();
            dto.setSkuCode(Convert.toStr(items.get("sku"), (String)skuCode));
            Object tcbj_warehouse = items.get("tcbj_warehouse");
            String tcbjWarehouse = Convert.toStr(items.get("tcbjWarehouse"));
            dto.setWarehouseCode(Convert.toStr(tcbj_warehouse, (String)tcbjWarehouse));
            return dto;
        }).collect(Collectors.toList());
        ArrayList shippingInfoList = Lists.newArrayList();
        WmsShippingInfoReqDto shippingInfo = new WmsShippingInfoReqDto();
        shippingInfo.setOutNoticeOrderNo(wmsOut.getOutNoticeOrderNo());
        shippingInfo.setPlatformOrderNo(wmsOut.getPlatformOrderNo());
        shippingInfo.setShippingCompanyCode(Convert.toStr((Object)message.get("shippingCompanyCode")));
        shippingInfo.setShippingCompanyName(Convert.toStr((Object)message.get("shippingCompanyName")));
        shippingInfo.setShippingNo(Convert.toStr((Object)message.get("shipment_code")));
        shippingInfoList.add(shippingInfo);
        wmsOut.setDetailReqDtoList(itemList);
        wmsOut.setShippingInfoReqDtoList((List)shippingInfoList);
        return wmsOut;
    }

    @Override
    public void syncStockInInfo(JSONObject dto) {
        log.info("WMS\u5165\u5e93\u4fe1\u606f\u56de\u4f20\u540c\u6b65\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        String businessType = dto.getString("businessType");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)dto.getString("inNoticeOrderNo")), "\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)businessType), "\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a");
        CsWmsInSendBackReqDto csWmsInSendBackReqDto = null;
        csWmsInSendBackReqDto = Objects.equals("e3", businessType) || Objects.equals("e3my", businessType) || Objects.equals("e3bs", businessType) ? this.buildInSendBackOFE3(dto, businessType) : (CsWmsInSendBackReqDto)BeanUtil.copyProperties((Object)dto, CsWmsInSendBackReqDto.class, (String[])new String[0]);
        RestResponseHelper.checkOrThrow((RestResponse)this.wmsApi.inSendBack(csWmsInSendBackReqDto));
    }

    private CsWmsInSendBackReqDto buildInSendBackOFE3(JSONObject dto, String businessType) {
        CsWmsInSendBackReqDto csWmsOutSendBackReqDto = (CsWmsInSendBackReqDto)BeanUtil.copyProperties((Object)dto, CsWmsInSendBackReqDto.class, (String[])new String[0]);
        CsOutNoticeOrderQueryDto queryDto = new CsOutNoticeOrderQueryDto();
        queryDto.setDocumentNo(csWmsOutSendBackReqDto.getInNoticeOrderNo());
        csWmsOutSendBackReqDto.setEnableAdjustInTransit(Boolean.valueOf(true));
        List respDtoList = (List)RestResponseHelper.extractData((RestResponse)this.outNoticeOrderQueryApi.queryByParam(queryDto));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)respDtoList), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355");
        AssertUtil.isFalse(respDtoList.size() > 1, "\u901a\u77e5\u5355\u5355\u636e\u5f02\u5e38\uff0c\u5b58\u5728\u591a\u4e2a\u5165\u5e93\u901a\u77e5\u5355");
        CsOutNoticeOrderRespDto noticeOrder = (CsOutNoticeOrderRespDto)respDtoList.get(0);
        List transferOrderDetail = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailQueryApi.queryListByTransferOrderNo(noticeOrder.getRelevanceNo()));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)transferOrderDetail), "\u627e\u4e0d\u5230\u539f\u8c03\u62e8\u5355\u660e\u7ec6");
        Map<Object, Object> itemMap = new HashMap();
        if (Objects.equals("e3my", businessType)) {
            ItemExtendReqDto reqDto = new ItemExtendReqDto();
            reqDto.setItemCodeList(transferOrderDetail.stream().map(CsTransferOrderDetailRespDto::getLongCode).collect(Collectors.toList()));
            List itemThirdCodeList = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(reqDto));
            if (CollectionUtils.isNotEmpty((Collection)itemThirdCodeList)) {
                itemMap = itemThirdCodeList.stream().collect(Collectors.toMap(ItemExtendRespDto::getE3ItemCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        List itemDetailList = JSONArray.parseArray((String)dto.getString("itemDetailList"), CsWmsInSendBackDetailReqDto.class);
        HashMap finalItemMap = itemMap;
        itemDetailList.forEach(detail -> {
            ItemExtendRespDto itemExtendRespDto;
            detail.setWarehouseCode(noticeOrder.getInPhysicsWarehouseCode());
            if (Objects.equals("e3bs", businessType)) {
                for (CsTransferOrderDetailRespDto orderDetail : transferOrderDetail) {
                    if (!orderDetail.getLongCode().substring(orderDetail.getLongCode().lastIndexOf(".") + 1).equals(detail.getSkuCode())) continue;
                    detail.setSkuCode(orderDetail.getLongCode());
                    break;
                }
            }
            if (Objects.equals("e3my", businessType) && ObjectUtil.isNotEmpty((Object)(itemExtendRespDto = (ItemExtendRespDto)finalItemMap.get(detail.getSkuCode())))) {
                detail.setSkuCode(itemExtendRespDto.getItemCode());
            }
        });
        csWmsOutSendBackReqDto.setDetailReqDtoList(itemDetailList);
        csWmsOutSendBackReqDto.setBizType(SendBackBizTypeEnum.E3.getCode());
        log.info("\u53c2\u6570\u6784\u5efa\uff1a{}", (Object)JSON.toJSONString((Object)csWmsOutSendBackReqDto));
        return csWmsOutSendBackReqDto;
    }

    private WmsInSendBackReqDto transferStockInInfo(Map<String, Object> message) {
        WmsInSendBackReqDto wmsIn = (WmsInSendBackReqDto)BeanUtil.copyProperties(message, WmsInSendBackReqDto.class, (String[])new String[0]);
        String inNoticeOrderNo = wmsIn.getInNoticeOrderNo();
        wmsIn.setInNoticeOrderNo(Convert.toStr((Object)message.get("order_no"), (String)inNoticeOrderNo));
        List itemReqDtoList = (List)MapUtil.get(message, (Object)"itemDetailList", List.class);
        if (CollectionUtils.isEmpty((Collection)itemReqDtoList)) {
            itemReqDtoList = (List)MapUtil.get(message, (Object)"details", List.class);
        }
        List itemList = itemReqDtoList.stream().map(items -> {
            WmsInSendBackDetailReqDto dto = new WmsInSendBackDetailReqDto();
            BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
            String skuCode = dto.getSkuCode();
            dto.setSkuCode(Convert.toStr(items.get("sku"), (String)skuCode));
            Date produceTime = dto.getProduceTime();
            dto.setProduceTime(Convert.toDate(items.get("product_date"), (Date)produceTime));
            Object tcbj_warehouse = items.get("tcbj_warehouse");
            String tcbjWarehouse = Convert.toStr(items.get("tcbjWarehouse"));
            dto.setWarehouseCode(Convert.toStr(tcbj_warehouse, (String)tcbjWarehouse));
            return dto;
        }).collect(Collectors.toList());
        wmsIn.setDetailReqDtoList(itemList);
        return wmsIn;
    }

    @Override
    public void outDeliveryAdd(Map<String, Object> dto) {
        log.info("\u65b0\u589e\u5176\u4ed6\u51fa\u5e93\u5355\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.orderNoItemDetailCheck(dto);
        this.sendMessage("OUT_DELIVERY_ADD", dto);
    }

    @Override
    public void inDeliveryAdd(Map<String, Object> dto) {
        log.info("\u65b0\u589e\u5176\u4ed6\u5165\u5e93\u5355\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.orderNoItemDetailCheck(dto);
        this.sendMessage("IN_DELIVERY_ADD", dto);
    }

    @Override
    public void releaseAndPreemptionNew(Map<String, Object> dto) {
        log.info("\u5e93\u5b58\u91ca\u653e\u539f\u5355\u5e76\u9884\u5360\u65b0\u5e93\u5b58\u4fe1\u606f\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.orderNoCheck(dto);
        this.sendMessage("RELEASE_AND_PREEMPTION_NEW", dto);
    }

    @Override
    public void logisticsClaimSheet(Map<String, Object> dto) {
        log.info("\u7269\u6d41\u7406\u8d54\u5355\u521b\u5efa\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.sendMessage("LOGISTICS_CLAIM_SHEET", dto);
    }

    @Override
    public void postpositionAudit(Map<String, Object> dto) {
        log.info("\u8d22\u52a1\u540e\u7f6e\u8ba2\u5355\u5ba1\u6838\u901a\u8fc7\u63a5\u53e3\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.orderNoCheck(dto);
        this.sendMessage("POSTPOSITION_AUDIT", dto);
    }

    @Override
    public void refundCancel(Map<String, Object> dto) {
        log.info("\u5e93\u5b58\u5355\u636e\u9000\u8d27\u53d6\u6d88\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.sendMessage("REFUND_CANCEL", dto);
    }

    @Override
    public void addItemDetail(Map<String, Object> dto) {
        log.info("\u7269\u6599\u9644\u5e26\u53c2\u6570\u540c\u6b65\u63a5\u53e3\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.sendMessage("ADD_ITEM_DETAIL", dto);
    }

    @Override
    public void addWarehouse(Map<String, Object> dto) {
        log.info("\u4ed3\u5e93\u57fa\u7840\u4fe1\u606f\u540c\u6b65\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.sendMessage("ADD_WAREHOUSE", dto);
    }

    @Override
    public void addSupplier(Map<String, Object> dto) {
        log.info("\u4f9b\u5e94\u5546\u4fe1\u606f\u540c\u6b65\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.sendMessage("ADD_SUPPLIER", dto);
    }

    @Override
    public void logisticsTrajectory(Map<String, Object> dto) {
        log.info("\u7269\u6d41\u8f68\u8ff9\u4fe1\u606f\u540c\u6b65\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        this.sendMessage("LOGISTICS_TRAJECTORY", dto);
    }

    @Override
    public void plannedOrderCancel(Map<String, Object> dto) {
        log.info("\u5e93\u5b58\u5355\u636e\u53d6\u6d88\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        ParamUtil.mustCheck(dto, "order_no");
        CsWmsCancelReqDto wmsCancelReqDto = new CsWmsCancelReqDto();
        wmsCancelReqDto.setNoticeOrderNo(Convert.toStr((Object)dto.get("order_no")));
        RestResponseHelper.extractData((RestResponse)this.wmsApi.cancelInstruct(wmsCancelReqDto));
    }

    public PageInfo<InventoryQueryRespDto> queryChannelInventory(Map<String, Object> dto) {
        log.info("\u67e5\u8be2\u5e93\u5b58\u4fe1\u606f\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        String channel = "channel";
        String type = (String)dto.getOrDefault("warehouseClassify", channel);
        PageInfo pageInfo = new PageInfo();
        List skuCodeList = (List)dto.get("skuCodeList");
        if (CollectionUtils.isEmpty((Collection)skuCodeList)) {
            skuCodeList = (List)dto.get("cargoCodeList");
        }
        List warehouseCodeList = (List)dto.get("warehouseCodeList");
        if (channel.equals(type)) {
            DgChannelInventoryPageReqDto channelInventoryReqDto;
            channelInventoryReqDto.setPageSize(Integer.valueOf((channelInventoryReqDto = (DgChannelInventoryPageReqDto)BeanUtil.copyProperties(dto, DgChannelInventoryPageReqDto.class, (String[])new String[0])).getPageSize() > 1000 ? 1000 : channelInventoryReqDto.getPageSize()));
            channelInventoryReqDto.setSkuCodeList(skuCodeList);
            channelInventoryReqDto.setWarehouseCodeList(warehouseCodeList);
            PageInfo channelInventoryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgChannelInventoryApi.page(channelInventoryReqDto));
            BeanUtil.copyProperties((Object)channelInventoryRespDtoPageInfo, (Object)pageInfo, (String[])new String[0]);
            Optional.ofNullable(channelInventoryRespDtoPageInfo.getList()).filter(CollectionUtils::isNotEmpty).ifPresent(list -> pageInfo.setList(list.stream().map(data -> {
                InventoryQueryRespDto inventoryQueryRespDto = (InventoryQueryRespDto)BeanUtil.copyProperties((Object)data, InventoryQueryRespDto.class, (String[])new String[0]);
                inventoryQueryRespDto.setSkuCode(data.getSkuCode());
                inventoryQueryRespDto.setCargoCode(data.getSkuCode());
                inventoryQueryRespDto.setCargoName(data.getSkuName());
                return inventoryQueryRespDto;
            }).collect(Collectors.toList())));
        } else if ("logic".equals(type)) {
            String hasBatch = (String)dto.getOrDefault("hasBatch", "0");
            if ("1".equals(hasBatch)) {
                CsLogicInventoryQueryDto pageQuery = (CsLogicInventoryQueryDto)BeanUtil.copyProperties(dto, CsLogicInventoryQueryDto.class, (String[])new String[0]);
                pageQuery.setLongCodes(skuCodeList);
                pageQuery.setWarehouseCodeList(warehouseCodeList);
                pageQuery.setPageNum((Integer)dto.getOrDefault("pageNum", 1));
                pageQuery.setPageSize((Integer)dto.getOrDefault("pageSize", 10));
                PageInfo inventoryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iCsLogicInventoryQueryApi.queryByPage(pageQuery));
                BeanUtil.copyProperties((Object)inventoryRespDtoPageInfo, (Object)pageInfo, (String[])new String[0]);
                Optional.ofNullable(inventoryRespDtoPageInfo.getList()).filter(CollectionUtils::isNotEmpty).ifPresent(list -> pageInfo.setList(list.stream().map(data -> {
                    InventoryQueryRespDto inventoryQueryRespDto = (InventoryQueryRespDto)BeanUtil.copyProperties((Object)data, InventoryQueryRespDto.class, (String[])new String[0]);
                    inventoryQueryRespDto.setSkuCode(data.getCargoCode());
                    inventoryQueryRespDto.setCargoCode(data.getCargoCode());
                    inventoryQueryRespDto.setExpireTime(null != data.getExpireTime() ? DateUtils.formatYMDHms(data.getExpireTime()) : null);
                    inventoryQueryRespDto.setProduceTime(null != data.getProduceTime() ? DateUtils.formatYMDHms(data.getProduceTime()) : null);
                    return inventoryQueryRespDto;
                }).collect(Collectors.toList())));
            } else {
                CsInventoryTotalQueryReqDto pageQuery = (CsInventoryTotalQueryReqDto)BeanUtil.copyProperties(dto, CsInventoryTotalQueryReqDto.class, (String[])new String[0]);
                pageQuery.setLongCodeList(skuCodeList);
                pageQuery.setLogicWarehouseCodeList(warehouseCodeList);
                PageInfo inventoryTotalRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryTotalQueryApi.queryByLogicWarehouseCodePage(pageQuery, (Integer)dto.getOrDefault("pageNum", 1), (Integer)dto.getOrDefault("pageSize", 10)));
                BeanUtil.copyProperties((Object)inventoryTotalRespDtoPageInfo, (Object)pageInfo, (String[])new String[0]);
                Optional.ofNullable(inventoryTotalRespDtoPageInfo.getList()).filter(CollectionUtils::isNotEmpty).ifPresent(list -> pageInfo.setList(list.stream().map(data -> {
                    InventoryQueryRespDto inventoryQueryRespDto = (InventoryQueryRespDto)BeanUtil.copyProperties((Object)data, InventoryQueryRespDto.class, (String[])new String[0]);
                    inventoryQueryRespDto.setSkuCode(data.getCargoCode());
                    inventoryQueryRespDto.setCargoCode(data.getCargoCode());
                    return inventoryQueryRespDto;
                }).collect(Collectors.toList())));
            }
        } else if ("share".equals(type)) {
            InventoryQueryReqDto pageQuery = (InventoryQueryReqDto)BeanUtil.copyProperties(dto, InventoryQueryReqDto.class, (String[])new String[0]);
            pageQuery.setCargoCodes(skuCodeList);
            pageQuery.setWarehouseCodes(warehouseCodeList);
            PageInfo inventoryRespDtoPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.virtualInventoryApi.queryByPage(pageQuery));
            Optional.ofNullable(inventoryRespDtoPage.getList()).filter(CollectionUtils::isNotEmpty).ifPresent(list -> pageInfo.setList(list.stream().map(data -> {
                InventoryQueryRespDto inventoryQueryRespDto = (InventoryQueryRespDto)BeanUtil.copyProperties((Object)data, InventoryQueryRespDto.class, (String[])new String[0]);
                inventoryQueryRespDto.setSkuCode(data.getCargoCode());
                inventoryQueryRespDto.setCargoCode(data.getCargoCode());
                return inventoryQueryRespDto;
            }).collect(Collectors.toList())));
        }
        return pageInfo;
    }

    @Override
    public Object orderDetailQuery(Map<String, Object> dto) {
        log.info("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        String platformOrderNo = Convert.toStr((Object)dto.get("platformOrderNo"));
        ThirdSaleOrderDetailRespDto data = (ThirdSaleOrderDetailRespDto)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryOrderDetailByPlatformNo(platformOrderNo));
        return data;
    }

    @Override
    public Object queryPreemption(Map<String, Object> dto) {
        log.info("\u67e5\u8be2\u5e93\u5b58\u9884\u5360\u4fe1\u606f\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        Assert.isTrue((dto.get("warehouseClassify") != null ? 1 : 0) != 0, (String)"1000", (String)"\u5e93\u5b58\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        CsWarehouseClassifyEnum warehouseClassify = CsWarehouseClassifyEnum.getByCode((String)((String)dto.get("warehouseClassify")));
        PageInfo<CsInventoryPreemptionRespDto> pageInfo = this.loadPreemptPageInfo(dto, warehouseClassify);
        PageInfo resultPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)resultPageInfo, pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return resultPageInfo;
        }
        Map<Object, Object> saleOrderMap = new HashMap(0);
        List saleOrderNoList = pageInfo.getList().stream().map(CsInventoryPreemptionRespDto::getExternalOrderNo).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(saleOrderNoList)) {
            PlatformOrderQueryReqDto saleOrderQueryReqDto = new PlatformOrderQueryReqDto();
            saleOrderQueryReqDto.setPlatformOrderNoList(saleOrderNoList);
            saleOrderQueryReqDto.setNotInTransferOrderStatusList((List)Lists.newArrayList((Object[])new Integer[]{2, 3}));
            List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryListByParam(saleOrderQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtos)) {
                saleOrderMap = saleOrderRespDtos.stream().collect(Collectors.toMap(PlatformOrderRespDto::getPlatformOrderNo, Function.identity(), (o, o1) -> o));
            }
        }
        if (saleOrderMap.isEmpty()) {
            return resultPageInfo;
        }
        ArrayList resultList = Lists.newArrayList();
        for (CsInventoryPreemptionRespDto csInventoryPreemptionRespDto : pageInfo.getList()) {
            CsInventoryPreemptionOrderRespDto csInventoryPreemptionOrderRespDto = new CsInventoryPreemptionOrderRespDto();
            CubeBeanUtils.copyProperties((Object)csInventoryPreemptionOrderRespDto, (Object)csInventoryPreemptionRespDto, (String[])new String[0]);
            if (!saleOrderMap.containsKey(csInventoryPreemptionRespDto.getExternalOrderNo())) continue;
            PlatformOrderRespDto saleOrderRespDto = (PlatformOrderRespDto)saleOrderMap.get(csInventoryPreemptionRespDto.getExternalOrderNo());
            csInventoryPreemptionOrderRespDto.setOrderSource(SaleOrderSourceEnum.enumOf((Integer)saleOrderRespDto.getOrderSource()).getDesc());
            csInventoryPreemptionOrderRespDto.setOrderStatus(PlatformTransformOrderStatus.forCode((int)saleOrderRespDto.getTransferOrderStatus()).getDesc());
            csInventoryPreemptionOrderRespDto.setOrderTime(saleOrderRespDto.getCreateTime());
            csInventoryPreemptionOrderRespDto.setCustomerName(saleOrderRespDto.getCustomerName());
            csInventoryPreemptionOrderRespDto.setSourceTypeName(Optional.ofNullable(CsInventorySourceTypeEnum.getByCode((String)csInventoryPreemptionRespDto.getSourceType())).map(CsInventorySourceTypeEnum::getDesc).orElse(""));
            if (StringUtils.isBlank((CharSequence)csInventoryPreemptionOrderRespDto.getSourceTypeName())) {
                if (StringUtils.equals((CharSequence)"agency_order", (CharSequence)csInventoryPreemptionRespDto.getSourceType())) {
                    csInventoryPreemptionOrderRespDto.setSourceTypeName("\u7ecf\u9500\u8ba2\u5355");
                }
                if (StringUtils.equals((CharSequence)"special_channel_order", (CharSequence)csInventoryPreemptionRespDto.getSourceType())) {
                    csInventoryPreemptionOrderRespDto.setSourceTypeName("\u7279\u6e20\u8ba2\u5355");
                }
            }
            resultList.add(csInventoryPreemptionOrderRespDto);
        }
        resultPageInfo.setList((List)resultList);
        return resultPageInfo;
    }

    private PageInfo<CsInventoryPreemptionRespDto> loadPreemptPageInfo(Map<String, Object> dto, CsWarehouseClassifyEnum warehouseClassify) {
        if (warehouseClassify == null || warehouseClassify.equals((Object)CsWarehouseClassifyEnum.CHANNEL)) {
            ShInventoryPreemptionQueryDto shInventoryPreemptionQueryDto = (ShInventoryPreemptionQueryDto)BeanUtil.copyProperties(dto, ShInventoryPreemptionQueryDto.class, (String[])new String[0]);
            shInventoryPreemptionQueryDto.setSourceType((String)dto.get("businessType"));
            shInventoryPreemptionQueryDto.setCargoCodeList((List)dto.get("skuCodeList"));
            shInventoryPreemptionQueryDto.setValid(CsValidFlagEnum.ENABLE.getCode());
            PageInfo shPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shInventoryPreemptionQueryApi.queryPageInfo(shInventoryPreemptionQueryDto));
            PageInfo pageInfo = new PageInfo();
            BeanUtil.copyProperties((Object)shPageInfo, (Object)pageInfo, (String[])new String[0]);
            Optional.ofNullable(shPageInfo.getList()).ifPresent(list -> pageInfo.setList(list.stream().map(d -> (CsInventoryPreemptionRespDto)BeanUtil.copyProperties((Object)d, CsInventoryPreemptionRespDto.class, (String[])new String[0])).collect(Collectors.toList())));
            return pageInfo;
        }
        RpInventoryPreemptionQueryDto pageQuery = (RpInventoryPreemptionQueryDto)BeanUtil.copyProperties(dto, RpInventoryPreemptionQueryDto.class, (String[])new String[0]);
        pageQuery.setSourceType((String)dto.get("businessType"));
        pageQuery.setCargoCodeList((List)dto.get("skuCodeList"));
        pageQuery.setValid(CsValidFlagEnum.ENABLE.getCode());
        PageInfo shPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInventoryPreemptionQueryApi.queryPage(pageQuery));
        PageInfo pageInfo = new PageInfo();
        BeanUtil.copyProperties((Object)shPageInfo, (Object)pageInfo, (String[])new String[0]);
        Optional.ofNullable(shPageInfo.getList()).ifPresent(list -> pageInfo.setList(list.stream().map(d -> (CsInventoryPreemptionRespDto)BeanUtil.copyProperties((Object)d, CsInventoryPreemptionRespDto.class, (String[])new String[0])).collect(Collectors.toList())));
        return pageInfo;
    }

    @Override
    public Object queryLogisticsByCspNos(List<String> dto) {
        log.info("\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        return Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.logisticsInfoQueryApi.queryByCspNos(dto))).map(r -> r.stream().filter(l -> StringUtils.isNotBlank((CharSequence)l.getCspNo())).collect(Collectors.groupingBy(CsLogisticsInfoRespDto::getCspNo))).map(m -> m.entrySet().stream().flatMap(re -> ((List)re.getValue()).stream().collect(Collectors.toMap(CsLogisticsInfoRespDto::getConsignmentNo, Function.identity(), (o, o1) -> {
            if (StringUtils.isNotBlank((CharSequence)o.getStatus()) && StringUtils.isNotBlank((CharSequence)o1.getStatus())) {
                return o.getStatus().compareTo(o1.getStatus()) > -1 ? o : o1;
            }
            if (StringUtils.isNotBlank((CharSequence)o.getStatus())) {
                return o;
            }
            if (StringUtils.isNotBlank((CharSequence)o1.getStatus())) {
                return o1;
            }
            return o;
        })).values().stream()).map(mm -> {
            if (StringUtils.isBlank((CharSequence)mm.getStatus())) {
                mm.setStatus("0");
            }
            return mm;
        }).collect(Collectors.toList()));
    }

    @Override
    public Object queryLogisticsByCspNosExt(Map<String, Object> dto) {
        log.info("\u7269\u6d41\u4fe1\u606f\u67e5\u8be2Ext\uff1a{}", (Object)JSON.toJSONString(dto));
        AssertUtil.isFalse(ObjectUtil.isEmpty(dto), "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)dto.get("consignmentNo")), "\u8bf7\u6c42\u53c2\u6570consignmentNo\u4e0d\u80fd\u4e3a\u7a7a");
        return RestResponseHelper.extractData((RestResponse)this.logisticsInfoQueryApi.queryLogisticsInfoReqDto(dto.get("consignmentNo").toString()));
    }

    @Override
    public Object queryLogisticsDetails(Map<String, Object> dto) {
        log.info("\u7269\u6d41\u4fe1\u606f\u660e\u7ec6\u67e5\u8be2(\u8865\u5145)\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        CsInfoQueryDto csInfoQueryDto = (CsInfoQueryDto)BeanUtil.copyProperties(dto, CsInfoQueryDto.class, (String[])new String[0]);
        AssertUtil.isTrue(StringUtils.isNotEmpty((CharSequence)csInfoQueryDto.getConsignmentNo()), "\u6258\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotEmpty((CharSequence)csInfoQueryDto.getCspNo()), "CSP\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList deliveredInfoDetailRespDtoList = Lists.newArrayList();
        Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.outResultOrderQueryApis.queryCsOutResultByConsignNos(csInfoQueryDto.getConsignmentNo(), csInfoQueryDto.getCspNo()))).ifPresent(r -> {
            if (CollectionUtils.isEmpty((Collection)r)) {
                return;
            }
            Map<String, String> urlMap = this.getUrlMap2((List<CsOutResultOrderDetailRespDto>)r);
            Map<String, String> urlTransferMap = this.fileTranslationService.loadFile(new ArrayList<String>(urlMap.values()));
            deliveredInfoDetailRespDtoList.addAll(r.stream().map(detail -> {
                RpLogisticsDeliveredInfoDetailRespDto deliveredInfoDetailRespDto = (RpLogisticsDeliveredInfoDetailRespDto)BeanUtil.copyProperties((Object)detail, RpLogisticsDeliveredInfoDetailRespDto.class, (String[])new String[0]);
                deliveredInfoDetailRespDto.setUrl(Optional.ofNullable(urlMap.get(this.getUrlKey(detail.getBatch(), detail.getLongCode()))).map(urlTransferMap::get).orElse(""));
                return deliveredInfoDetailRespDto;
            }).collect(Collectors.toList()));
        });
        log.info("deliveredInfoDetailRespDtoList\uff1a{}", (Object)JSON.toJSONString((Object)deliveredInfoDetailRespDtoList));
        if (CollectionUtils.isNotEmpty((Collection)deliveredInfoDetailRespDtoList)) {
            List longCodeList = deliveredInfoDetailRespDtoList.stream().map(RpLogisticsDeliveredInfoDetailRespDto::getLongCode).collect(Collectors.toList());
            List batchList = deliveredInfoDetailRespDtoList.stream().map(RpLogisticsDeliveredInfoDetailRespDto::getBatch).collect(Collectors.toList());
            GiftPackageInfoReqDto reqDto = new GiftPackageInfoReqDto();
            reqDto.setProNoList(longCodeList);
            reqDto.setLotList(batchList);
            Map<String, List<GiftPackageInfoReqDto>> giftInfoMap = this.giftPackageInfoService.queryByProNoAndLot(reqDto);
            if (ObjectUtil.isNotEmpty(giftInfoMap)) {
                deliveredInfoDetailRespDtoList.forEach(detail -> detail.setGiftInfoList((List)giftInfoMap.get(detail.getLongCode() + detail.getBatch())));
            }
        }
        return deliveredInfoDetailRespDtoList;
    }

    private Map<String, String> getUrlMap2(List<CsOutResultOrderDetailRespDto> resultOrderDetailRespDtos) {
        ArrayList<QualityInspectionDataReqDto> params = new ArrayList<QualityInspectionDataReqDto>();
        List<String> longCodes = resultOrderDetailRespDtos.stream().map(CsOutResultOrderDetailRespDto::getLongCode).collect(Collectors.toList());
        Map<String, PcpItemRespDto> itemMap = this.queryItemInfo(longCodes);
        HashMap<String, String> codeMapping = new HashMap<String, String>();
        for (PcpItemRespDto item : itemMap.values()) {
            String newCode = item.getLongCode();
            String oldCode = item.getOldLongCode();
            if (!ObjectUtil.isNotEmpty((Object)oldCode)) continue;
            codeMapping.put(newCode, oldCode);
            codeMapping.put(oldCode, newCode);
        }
        for (CsOutResultOrderDetailRespDto dto : resultOrderDetailRespDtos) {
            QualityInspectionDataReqDto reqDto = new QualityInspectionDataReqDto();
            reqDto.setQueryOldCode(Boolean.valueOf(true));
            reqDto.setLongCode(dto.getLongCode());
            reqDto.setBatch(dto.getBatch());
            params.add(reqDto);
            String mappingCode = (String)codeMapping.get(dto.getLongCode());
            if (!ObjectUtil.isNotEmpty((Object)mappingCode) || dto.getLongCode().equals(mappingCode)) continue;
            QualityInspectionDataReqDto old = new QualityInspectionDataReqDto();
            old.setQueryOldCode(Boolean.valueOf(true));
            old.setLongCode(mappingCode);
            old.setBatch(dto.getBatch());
            params.add(old);
        }
        List list = (List)RestResponseHelper.extractData((RestResponse)this.qualityInspectionDataQueryApi.queryByList(params));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (QualityInspectionDataRespDto resp : list) {
            String mappingCode;
            String key;
            String batch = resp.getBatch();
            String longCode = resp.getLongCode();
            String oldLongCode = resp.getOldLongCode();
            String reportUrl = resp.getReportResultUrl();
            if (StringUtils.isBlank((CharSequence)batch) || StringUtils.isBlank((CharSequence)reportUrl)) continue;
            if (StringUtils.isNotBlank((CharSequence)longCode)) {
                key = this.getUrlKey(batch, longCode);
                result.put(key, reportUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)oldLongCode)) {
                key = this.getUrlKey(batch, oldLongCode);
                result.put(key, reportUrl);
            }
            if (!ObjectUtil.isNotEmpty((Object)(mappingCode = (String)codeMapping.get(longCode))) || mappingCode.equals(longCode) || mappingCode.equals(oldLongCode)) continue;
            String key2 = this.getUrlKey(batch, mappingCode);
            result.put(key2, reportUrl);
        }
        log.info("getUrlMap2 result\uff1a{}", (Object)JSON.toJSONString(result));
        return result;
    }

    private Map<String, String> getUrlMap(List<CsOutResultOrderDetailRespDto> resultOrderDetailRespDtos) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query((Object)new LimitsEo()).select(new String[]{"samplecode", "lotno", "url"}).in((Object)"samplecode", (Collection)resultOrderDetailRespDtos.stream().map(CsOutResultOrderDetailRespDto::getLongCode).collect(Collectors.toSet()))).in((Object)"lotno", (Collection)resultOrderDetailRespDtos.stream().map(CsOutResultOrderDetailRespDto::getBatch).collect(Collectors.toSet()));
        List limit = this.limitsDas.getMapper().selectList((Wrapper)wrapper);
        return limit.stream().filter(li -> StringUtils.isNotBlank((CharSequence)li.getUrl())).collect(Collectors.toMap(k -> this.getUrlKey(k.getLotno(), k.getSamplecode()), LimitsEo::getUrl, (o, o1) -> o));
    }

    private String getUrlKey(String batch, String longCode) {
        return batch + "_" + longCode;
    }

    private void sendMessage(String tag, Map<String, Object> dto) {
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("OP_EXTERNAL_TOPIC", tag, dto);
        this.updateLog(dto, messageResponse.getData());
    }

    private void sendYyjMessage(String tag, List<YyjOrderReqDto> yyjOrderReqDtos, Long time) {
        MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessage("OP_EXTERNAL_TOPIC", tag, (Object)JSON.toJSONString(yyjOrderReqDtos), time);
    }

    private void orderNoItemDetailCheck(Map<String, Object> dto) {
        ParamUtil.mustCheck(dto, "platformOrderNo");
        ParamUtil.mustCheckKeyList(dto, "itemDetailList", "skuCode", "quantity");
    }

    private void orderNoCheck(Map<String, Object> dto) {
        ParamUtil.mustCheck(dto, "platformOrderNo");
    }

    private void itemDetailCheck(Map<String, Object> dto) {
        ParamUtil.mustCheckKeyList(dto, "itemDetailList", "skuCode", "quantity");
    }

    private void updateLog(Map<String, Object> dto, Object messageResponse) {
        try {
            Long sendLogId = Convert.toLong((Object)dto.get("sendLogId"));
            if (Objects.isNull(sendLogId) || Objects.isNull(messageResponse)) {
                return;
            }
            ExternalApiInLogEo eo = new ExternalApiInLogEo();
            eo.setId(sendLogId);
            eo.setMqResponse(Convert.toStr((Object)messageResponse));
            this.externalApiInLogDas.updateSelective((BaseEo)eo);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u7b2c\u4e09\u65b9\u7cfb\u7edfAPI\u63a5\u6536\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void qualityInspectionDataSync() {
        List<LimsQualityInfoRespDto> list = this.dataDistributeService.selectQualityInspectionData();
        log.info("\u53d1\u9001\u8d28\u68c0\u6570\u636e\u540c\u6b65\u5e93\u5b58\u4e2d\u5fc3\u5f00\u59cb:{}", (Object)JSON.toJSONString(list));
        if (CollectionUtils.isNotEmpty(list)) {
            int length;
            int i = 0;
            for (length = list.size(); length > 100; length -= 100) {
                this.commonsMqService.sendSingleMessage("OP_EXTERNAL_TOPIC", "QUALITY_INSPECTION_DATA_SYNC", (Object)JSON.toJSONString(list.subList(i, i + 200)));
                i += 100;
            }
            if (length > 0) {
                this.commonsMqService.sendSingleMessage("OP_EXTERNAL_TOPIC", "QUALITY_INSPECTION_DATA_SYNC", (Object)JSON.toJSONString(list.subList(i, i + length)));
            }
            this.dataDistributeService.updateQualityWmsStatus(list);
        }
        log.info("\u53d1\u9001\u8d28\u68c0\u6570\u636e\u540c\u6b65\u5e93\u5b58\u4e2d\u5fc3\u7ed3\u675f");
    }

    @Override
    public Object queryPageResultOrderDetail(Map<String, Object> dto) {
        log.info("\u67e5\u8be2\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u5206\u9875\u6570\u636e\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(dto));
        ParamUtil.mustCheck(dto, "createBeginTime", "createEndTime");
        SaleOrderResultReqDto pageQuery = (SaleOrderResultReqDto)BeanUtil.copyProperties(dto, SaleOrderResultReqDto.class, (String[])new String[0]);
        return RestResponseHelper.extractData((RestResponse)this.deliveryResultOrderQueryApi.sapQuerySaleOrderResultInfoPage(pageQuery));
    }

    @Override
    public void saleOrderEasConsistencyVerify(EasSaleVerifyOrderDto dto) {
        log.info("\u7ecf\u9500\u5546\u91c7\u8d2d\uff08\u8d22\u52a1\u524d\u7f6e\uff09EAS\u5355\u636e\u4e00\u81f4\u6027\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        BizSaleOrderRespDto saleDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(dto.getSaleOrderNo()));
        if (ObjectUtil.isEmpty((Object)saleDto) || CollectionUtils.isEmpty((Collection)saleDto.getItemList())) {
            throw new BizException("-1", "\u6821\u9a8c\u5931\u8d25\uff1a\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9500\u552e\u5355\u636e\u4fe1\u606f");
        }
        if (StringUtils.isBlank((CharSequence)saleDto.getEasOrderNo()) && saleDto.getOrderBizType() != 0) {
            throw new BizException("-1", "OCS\u7f3a\u5c11\u9500\u552e\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u4ed3\u5e93\u6216IT\u91cd\u65b0\u8bf7\u6c42\u9500\u552e\u8ba2\u5355");
        }
        if (StringUtils.isBlank((CharSequence)saleDto.getOrderStatus()) || saleDto.getOrderStatus().equals(SaleOrderStatusEnum.OBSOLETE.getCode())) {
            throw new BizException("-1", "\u6821\u9a8c\u5931\u8d25\uff1a\u8ba2\u5355\u5df2\u4f5c\u5e9f\uff01");
        }
        log.info("PCP\u9500\u552e\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)saleDto));
        AssertUtil.isTrue(dto.getCustomerCode().equals(saleDto.getCustomerCode()), "-1", "\u6821\u9a8c\u5931\u8d25\uff1a\u5ba2\u6237\u7f16\u53f7\u4e0d\u4e00\u81f4");
        AssertUtil.isTrue(dto.getOrgCode().equals(saleDto.getEasOrgId()), "-1", "\u6821\u9a8c\u5931\u8d25\uff1a\u7ec4\u7ec7\u7f16\u53f7\u4e0d\u4e00\u81f4");
        AssertUtil.isTrue(dto.getItemList().size() == saleDto.getItemList().size(), "-1", "\u6821\u9a8c\u5931\u8d25\uff1a\u5546\u54c1\u884c\u660e\u7ec6\u6570\u91cf\u4e0d\u4e00\u81f4");
        Map<String, EasSaleVerifyOrderItemDto> itemDtoMap = dto.getItemList().stream().collect(Collectors.toMap(EasSaleVerifyOrderItemDto::getDetailId, a -> a, (k1, k2) -> k1));
        saleDto.getItemList().forEach(item -> {
            Map map;
            EasSaleVerifyOrderItemDto verifyItemDto = null;
            verifyItemDto = (EasSaleVerifyOrderItemDto)itemDtoMap.get(item.getId().toString());
            if (ObjectUtil.isEmpty((Object)verifyItemDto) && StringUtils.isNotBlank((CharSequence)item.getExtension()) && ObjectUtil.isNotEmpty((map = (Map)JSON.parseObject((String)item.getExtension(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0])).get(EASExtendKeyEnum.ENTRY_ID.code))) {
                verifyItemDto = (EasSaleVerifyOrderItemDto)itemDtoMap.get(map.get(EASExtendKeyEnum.ENTRY_ID.code).toString());
            }
            AssertUtil.isFalse(verifyItemDto == null, "\u6821\u9a8c\u5931\u8d25\uff1a\u5546\u54c1\u884c\uff1a" + item.getSkuCode() + "\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(item.getSkuCode().equals(verifyItemDto.getSkuCode()), "-1", "\u6821\u9a8c\u5931\u8d25\uff1a\u5546\u54c1\u7f16\u7801\u4e0d\u4e00\u81f4");
            AssertUtil.isTrue(item.getItemNum().intValue() == verifyItemDto.getNum().intValue(), "-1", "\u6821\u9a8c\u5931\u8d25\uff1a\u5546\u54c1\u6570\u91cf\u4e0d\u4e00\u81f4");
        });
        RestResponseHelper.extractData((RestResponse)this.saleOrderApi.updateEasVerifyStatus(dto.getSaleOrderNo()));
        try {
            log.info("\u901a\u77e5CSP\u72b6\u6001\u66f4\u65b0\u4e3a\u5df2\u8d22\u5ba1\uff1a{}", (Object)saleDto.getPlatformOrderNo());
            if (saleDto.getOrderBizType() == 1 && ObjectUtil.isNotEmpty((Object)saleDto.getPlatformOrderId())) {
                String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
                CompletableFuture.runAsync(() -> {
                    MDC.put((String)"yes.req.requestId", (Object)reqId);
                    ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                    log.info("\u5f02\u6b65\u901a\u77e5CSP\u72b6\u6001\u66f4\u65b0\u4e3a\u5df2\u8d22\u5ba1={}", (Object)saleDto.getPlatformOrderNo());
                    if (saleDto.getOrderType().equals(CsPcpBusinessTypeEnum.SPECIAL_CHANNEL_ORDER.getCode())) {
                        CSPUpdateSpecialChannelOrderReqDto specialChannelOrderReqDto = new CSPUpdateSpecialChannelOrderReqDto();
                        specialChannelOrderReqDto.setOrderNo(saleDto.getPlatformOrderNo());
                        specialChannelOrderReqDto.setStatus(CspOrderStatusEnum.FINANCIAL_AUDIT.getType());
                        specialChannelOrderReqDto.setOrderType(saleDto.getOrderType());
                        specialChannelOrderReqDto.setShippingDtoList(new ArrayList());
                        this.externalCspRest.updateCspSpecialChannelOrderStatus(specialChannelOrderReqDto);
                    } else {
                        CSPUpdateCspOrderReqDto reqDto = new CSPUpdateCspOrderReqDto();
                        reqDto.setEvent(CspOrderStatusEnum.FINANCIAL_AUDIT.getType());
                        reqDto.setOrderNo(saleDto.getPlatformOrderNo());
                        this.externalCspRest.updateCspOrderStatus(reqDto);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("\u901a\u77e5CSP\u72b6\u6001\u66f4\u65b0\u4e3a\u5df2\u8d22\u5ba1\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void cancelTransferOrder(Map<String, Object> dto) {
        if (ObjectUtil.isEmpty(dto) || ObjectUtil.isEmpty((Object)dto.get("orderNo"))) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        log.info("\u53d6\u6d88\u8c03\u62e8\u5355\uff08EAS\u53d1\u8d77\uff09\uff1a{}", dto);
        CsTransferOrderReqDto reqDto = new CsTransferOrderReqDto();
        reqDto.setPreOrderNo(dto.get("orderNo").toString());
        List list = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryTransferOrderList(reqDto));
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BizException("-1", "\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
        }
        log.info("\u96c6\u5408\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)list));
        CsTransferOrderRespDto transferOrderRespDto = null;
        if (list.size() > 1) {
            for (CsTransferOrderRespDto respDto : list) {
                if (respDto.getOrderStatus().equals(CsTransferOrderEnum.Status.CANCELED.getCode())) continue;
                transferOrderRespDto = respDto;
                break;
            }
            if (ObjectUtil.isEmpty((Object)transferOrderRespDto)) {
                return;
            }
        } else {
            transferOrderRespDto = (CsTransferOrderRespDto)list.get(0);
        }
        log.info("\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)transferOrderRespDto));
        if (StringUtils.isBlank((CharSequence)transferOrderRespDto.getSourceSystem()) || !transferOrderRespDto.getSourceSystem().equals(CsSourceSystemEnum.EAS.getCode())) {
            throw new BizException("-1", "\u4e0d\u80fd\u53d6\u6d88\u975eEAS\u53d1\u8d77\u7684\u8c03\u62e8\u5355");
        }
        if (transferOrderRespDto.getOrderStatus().equals(CsTransferOrderEnum.Status.CANCELED.getCode())) {
            return;
        }
        List outNoticeOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.outNoticeOrderQueryApi.queryByRelevanceNoList((List)Lists.newArrayList((Object[])new String[]{transferOrderRespDto.getTransferOrderNo()})));
        if (CollectionUtils.isNotEmpty((Collection)outNoticeOrderRespDtoList)) {
            throw new BizException("-1", "\u5df2\u63a8\u9001WMS\uff0c\u4e0d\u80fd\u53d1\u8d77\u53d6\u6d88");
        }
        CsCancelTransferOrderReqDto cancelReqDto = new CsCancelTransferOrderReqDto();
        cancelReqDto.setKeyWord(transferOrderRespDto.getTransferOrderNo());
        cancelReqDto.setRemark("EAS\u53d1\u8d77\u53d6\u6d88");
        RestResponseHelper.extractData((RestResponse)this.transferOrderApi.cancelTransferOrder(cancelReqDto));
    }

    @Override
    public Object queryCspSaleReceiveDeliveryResultInfoPage(SaleOrderResultReqDto reqDto) {
        log.info("\u83b7\u53d6CSP\u63a8\u9001\u9500\u552e\u7ed3\u679c\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.deliveryResultOrderQueryApi.querySaleReceiveDeliveryResultInfoPageExt(reqDto));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List itemList = pageInfo.getList().stream().map(SaleResultOrderRespDto::getDetails).flatMap(Collection::stream).collect(Collectors.toList());
            List longCodeList = itemList.stream().map(SaleResultOrderDetailRespDto::getLongCode).distinct().collect(Collectors.toList());
            List batchList = itemList.stream().map(SaleResultOrderDetailRespDto::getBatch).distinct().collect(Collectors.toList());
            GiftPackageInfoReqDto infoReqDto = new GiftPackageInfoReqDto();
            infoReqDto.setProNoList(longCodeList);
            infoReqDto.setLotList(batchList);
            Map<String, List<GiftPackageInfoReqDto>> giftInfoMap = this.giftPackageInfoService.queryByProNoAndLot(infoReqDto);
            if (ObjectUtil.isEmpty(giftInfoMap)) {
                return new RestResponse((Object)pageInfo);
            }
            pageInfo.getList().forEach(dto -> {
                if (CollectionUtils.isNotEmpty((Collection)dto.getDetails())) {
                    dto.getDetails().stream().forEach(detail -> {
                        List list = (List)giftInfoMap.get(detail.getLongCode() + detail.getBatch());
                        List objects = JSONArray.parseArray((String)JSON.toJSONString((Object)list), Object.class);
                        detail.setGiftInfoList(objects);
                    });
                }
            });
        }
        return new RestResponse((Object)pageInfo);
    }

    private String buildExtension(Map<String, Object> map) {
        log.info("\u6784\u5efa\u9700\u8981\u7684\u6269\u5c55\u4fe1\u606f\uff1a", (Object)JSON.toJSONString(map));
        HashMap<String, Object> extensionMap = new HashMap<String, Object>();
        for (EASExtendKeyEnum keyEnum : EASExtendKeyEnum.values()) {
            if (!ObjectUtil.isNotEmpty((Object)map.get(keyEnum.code))) continue;
            extensionMap.put(keyEnum.code, map.get(keyEnum.code));
        }
        return JSON.toJSONString(extensionMap);
    }

    @Override
    public RestResponse<Void> addYyjOrder(List<YyjOrderReqDto> yyjOrderReqDtos) {
        try {
            log.info("\u63a5\u6536\u8425\u517b\u5bb6\u8ba2\u5355\u6570\u91cf\u4e3a\uff1a{}", (Object)yyjOrderReqDtos.size());
            List thirdOrgIds = yyjOrderReqDtos.stream().map(YyjOrderReqDto::getEasOrgId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            HashMap<String, ChannelWarehouseRespDto> channelWarehouseMap = new HashMap<String, ChannelWarehouseRespDto>();
            DictDto dictDto = (DictDto)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "YYJ_CHANNEL_WAREHOUSE").getData();
            log.info("\u83b7\u53d6\u8425\u517b\u5bb6\u8ba2\u5355\u7ec4\u7ec7\u5bf9\u5e94\u6e20\u9053\u4ed3:{}", (Object)JSON.toJSONString((Object)dictDto));
            if (Objects.nonNull(dictDto)) {
                for (String orgId : thirdOrgIds) {
                    Map map = (Map)JSON.parseObject((String)dictDto.getValue(), Map.class);
                    if (!map.containsKey(orgId)) continue;
                    ChannelWarehouseRespDto resp = (ChannelWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.channelWarehouseApi.queryByWarehouseCode((String)map.get(orgId)));
                    channelWarehouseMap.put(orgId, resp);
                }
            }
            List logicWarehouses = yyjOrderReqDtos.stream().map(YyjOrderReqDto::getDefaultWarehouseCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List logicWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryList(logicWarehouses));
            log.info("\u8425\u517b\u5bb6\u8ba2\u5355\u67e5\u903b\u8f91\u4ed3\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)logicWarehouseRespDtoList));
            Map<String, CsLogicWarehouseRespDto> logicWarehouseMap = logicWarehouseRespDtoList.stream().collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, warehouse -> warehouse, (existing, replacement) -> existing));
            Integer releaseState = 1;
            String platformParentOrderNo = "";
            for (YyjOrderReqDto yyjOrderReqDto : yyjOrderReqDtos) {
                CsLogicWarehouseRespDto logicWarehouseRespDto = logicWarehouseMap.get(yyjOrderReqDto.getDefaultWarehouseCode());
                ChannelWarehouseRespDto channelWarehouseRespDto = (ChannelWarehouseRespDto)channelWarehouseMap.get(yyjOrderReqDto.getEasOrgId());
                String childOrderNo = yyjOrderReqDto.getPlatformOrderNo();
                String parentOrderNo = yyjOrderReqDto.getPlatformParentOrderNo();
                if (StringUtils.isBlank((CharSequence)yyjOrderReqDto.getCustomerCode())) {
                    yyjOrderReqDto.setCustomerCode(yyjOrderReqDto.getEasOrgId());
                }
                if (StringUtils.isBlank((CharSequence)yyjOrderReqDto.getEasCustomerCode())) {
                    yyjOrderReqDto.setEasCustomerCode(yyjOrderReqDto.getCustomerCode());
                }
                if (StringUtils.isBlank((CharSequence)childOrderNo)) {
                    yyjOrderReqDto.setPlatformOrderNo(parentOrderNo);
                    yyjOrderReqDto.setPlatformParentOrderNo(null);
                }
                this.checkAddr(yyjOrderReqDto);
                HashMap extFields = Maps.newHashMap();
                if (Objects.equals(SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType(), yyjOrderReqDto.getOrderType())) {
                    extFields.put("rdc", yyjOrderReqDto.getDefaultWarehouseCode());
                }
                if (Objects.isNull(yyjOrderReqDto.getCanSplitFlag())) {
                    log.info("\u63a5\u6536\u7684\u62c6\u5355\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u5141\u8bb8\u62c6\u5355");
                    yyjOrderReqDto.setCanSplitFlag(Integer.valueOf(1));
                }
                extFields.put("canSplitFlag", yyjOrderReqDto.getCanSplitFlag());
                extFields.put("thirdOrgID", yyjOrderReqDto.getThirdOrgId());
                extFields.put("thirdPartyId", yyjOrderReqDto.getCustomerCode());
                yyjOrderReqDto.setExtFields((Map)extFields);
                yyjOrderReqDto.setDefaultWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
                yyjOrderReqDto.setDefaultWarehouseName(logicWarehouseRespDto.getWarehouseName());
                yyjOrderReqDto.setChannelWarehouseCode(channelWarehouseRespDto.getWarehouseCode());
                yyjOrderReqDto.setChannelWarehouseName(channelWarehouseRespDto.getWarehouseName());
                String platformOrderNo = yyjOrderReqDto.getPlatformOrderNo();
                platformParentOrderNo = yyjOrderReqDto.getPlatformParentOrderNo();
                releaseState = yyjOrderReqDto.getReleaseState();
                String orderChannelCode = yyjOrderReqDto.getOrderChannelCode();
                PlatformOrderRespDto orderRespDto = (PlatformOrderRespDto)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryByPlatformNo(platformOrderNo));
                if (orderRespDto != null && Objects.equals(orderRespDto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_INIT_1.getCode())) {
                    if (StringUtils.isBlank((CharSequence)orderRespDto.getPlatformParentOrderNo())) {
                        AssertUtil.isTrue(this.releaseInventory(orderRespDto.getPlatformOrderNo(), yyjOrderReqDto.getOrderType()), "\u9884\u5360\u91ca\u653e\u5931\u8d25");
                    }
                    this.abolishPcpOrder(platformOrderNo, PlatformOrderSource.SOURCE_1.getCode(), orderRespDto.getId());
                }
                if (StringUtils.isBlank((CharSequence)platformParentOrderNo) && releaseState == 1) {
                    Map orderMap = BeanUtil.beanToMap((Object)yyjOrderReqDto);
                    List itemMapList = yyjOrderReqDto.getItemReqDtoList().stream().map(BeanUtil::beanToMap).collect(Collectors.toList());
                    orderMap.put("itemReqDtoList", itemMapList);
                    AssertUtil.isTrue(this.preemptInventory(orderMap, platformOrderNo, orderChannelCode, yyjOrderReqDto.getOrderType()), "\u5e93\u5b58\u4e0d\u8db3");
                    yyjOrderReqDto.setPreemptInventory(true);
                    String saleOrderNo = orderMap.get("saleOrderNo") != null ? orderMap.get("saleOrderNo").toString() : "";
                    yyjOrderReqDto.setSaleOrderNo(saleOrderNo);
                    log.info("[\u8425\u517b\u5bb6\u8ba2\u5355\u9884\u5360\u6210\u529f]\uff1a{}", (Object)yyjOrderReqDto.getPlatformOrderNo());
                    log.info("[\u8425\u517b\u5bb6\u8ba2\u5355\u5b50\u5355\u6570\u91cf]\u5e73\u53f0\u5355\u53f7\uff1a{},\u5b50\u8ba2\u5355\u6570\u91cf", (Object)yyjOrderReqDto.getPlatformOrderNo(), (Object)yyjOrderReqDto.getChildOrderNum());
                    this.cacheService.setCache(YYJ_CHILD_ORDER_NUM_GROUP, yyjOrderReqDto.getPlatformOrderNo(), (Object)yyjOrderReqDto.getChildOrderNum());
                }
                if (!StringUtils.isNotEmpty((CharSequence)platformParentOrderNo) || releaseState != 1) continue;
                String saleOrderNo = this.getSaleOrderNo(platformOrderNo);
                yyjOrderReqDto.setSaleOrderNo(saleOrderNo);
            }
            this.externalDataService.addYyjPcpOrderProcess(yyjOrderReqDtos);
        }
        catch (Exception e) {
            log.error("[\u8425\u517b\u5bb6\u63d0\u4ea4\u8ba2\u5355\u5931\u8d25]\uff1a{}", (Throwable)e);
            for (YyjOrderReqDto yyjOrderReqDto : yyjOrderReqDtos) {
                if (!yyjOrderReqDto.isPreemptInventory()) continue;
                log.info("[\u8425\u517b\u5bb6\u56de\u6eda\u5e93\u5b58]\uff1a{}", (Object)yyjOrderReqDto.getPlatformOrderNo());
                AssertUtil.isTrue(this.releaseInventory(yyjOrderReqDto.getPlatformOrderNo(), yyjOrderReqDto.getOrderType()), "\u9884\u5360\u91ca\u653e\u5931\u8d25");
                log.info("[\u8425\u517b\u5bb6\u8ba2\u5355\u5b50\u5355\u6570\u91cf]\u5220\u9664\u7f13\u5b58\uff1a{}", (Object)yyjOrderReqDto.getPlatformOrderNo());
                this.cacheService.delCache(YYJ_CHILD_ORDER_NUM_GROUP, yyjOrderReqDto.getPlatformOrderNo());
            }
            throw new BizException(e.getMessage());
        }
        return RestResponse.VOID;
    }

    private void checkAddr(YyjOrderReqDto orderReqDto) {
        if (StringUtils.isNotBlank((CharSequence)orderReqDto.getPlatformParentOrderNo())) {
            if (orderReqDto.getPlatformOrderAddrReqDto() == null) {
                throw new com.dtyunxi.exceptions.BizException("\u8ba2\u5355\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)orderReqDto.getPlatformOrderAddrReqDto().getReceiveName())) {
                throw new com.dtyunxi.exceptions.BizException("\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)orderReqDto.getPlatformOrderAddrReqDto().getReceivePhone())) {
                throw new com.dtyunxi.exceptions.BizException("\u6536\u8d27\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)orderReqDto.getPlatformOrderAddrReqDto().getReceiveAddress())) {
                throw new com.dtyunxi.exceptions.BizException("\u6536\u8d27\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)orderReqDto.getPlatformOrderAddrReqDto().getProvince())) {
                throw new com.dtyunxi.exceptions.BizException("\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)orderReqDto.getPlatformOrderAddrReqDto().getCity())) {
                throw new com.dtyunxi.exceptions.BizException("\u5730\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)orderReqDto.getPlatformOrderAddrReqDto().getCounty())) {
                throw new com.dtyunxi.exceptions.BizException("\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (orderReqDto.getChildOrderNum() == null) {
            throw new BizException("\u5b50\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public Object queryPlatformOrderList(PlatformOrderQueryReqDto reqDto) {
        log.info("\u83b7\u53d6CSP\u6e20\u9053\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.assertNotEmpty(reqDto.getPlatformOrderNoList(), "\u6e20\u9053\u5355\u53f7\u96c6\u5408\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        List platformOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryListByParam(reqDto));
        if (CollectionUtils.isEmpty((Collection)platformOrderRespDtos)) {
            return null;
        }
        Map platformOrderMap = platformOrderRespDtos.stream().collect(Collectors.toMap(PlatformOrderRespDto::getPlatformOrderNo, Function.identity(), (k1, k2) -> k1.getId().compareTo(k2.getId()) > 0 ? k1 : k2));
        ArrayList platformOrderList = new ArrayList(platformOrderMap.values());
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, platformOrderList, CspTransformStatusDto.class);
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            List platformOrderNoList = resultList.stream().map(CspTransformStatusDto::getPlatformOrderNo).distinct().collect(Collectors.toList());
            SaleTransferReportReqDto reportReqDto = new SaleTransferReportReqDto();
            reportReqDto.setPlatformOrderNoList(platformOrderNoList);
            List saleTransferReportRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferReportApi.querySaleTransferList(reportReqDto));
            Map saleTransferReportRespDtoMap = Optional.ofNullable(saleTransferReportRespDtoList).map(m -> m.stream().collect(Collectors.groupingBy(SaleTransferReportRespDto::getPlatformOrderNo))).orElse(new HashMap());
            resultList.forEach(dto -> dto.setSaleTransferReportRespDtoList((List)saleTransferReportRespDtoMap.get(dto.getPlatformOrderNo())));
        }
        return resultList;
    }

    @Override
    public void addMaiyouProcess(Map<String, Object> dto) {
        log.info("\u65b0\u589e\u9ea6\u4f18\u8c03\u62e8\u8865\u8d27\u9500\u552e\u8ba2\u5355\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        ParamUtil.mustCheck(dto, "platformOrderNo", "orderChannelCode", "orderType", "easOrgId", "orderSource", "isOnline", "thirdOrgID", "easOrgId", "thirdPartyId", "allotType", "allotInWarehouseCode");
        ParamUtil.mustCheckKeyList(dto, "itemReqDtoList", "itemNum", "skuCode", "saleUnitPrice", "salePrice", "gift", "orderTotalAmount", "payAmount");
        ParamUtil.mustCheckKey(dto, "platformOrderAddrReqDto", "receivePhone", "receiveName");
        String orderType = dto.get("orderType").toString();
        String platformOrderNo = dto.get("platformOrderNo").toString();
        if (whitePlatformNoList.contains(platformOrderNo)) {
            log.info("csp\u6e20\u9053\u5355\u53f7\u767d\u540d\u5355=={}", (Object)platformOrderNo);
            return;
        }
        String allotType = (String)dto.get("allotType");
        String allotOutWarehouseCode = (String)dto.getOrDefault("allotOutWarehouseCode", "");
        if ((Objects.equals(allotType, AllotTypeEnum.MAIYOU_CC_ALLOT.getType()) || Objects.equals(allotType, AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType())) && StringUtils.isEmpty((CharSequence)allotOutWarehouseCode)) {
            throw new BizException("CC\u8c03\u62e8\uff0callotOutWarehouseCode\u4e0d\u53ef\u4e3a\u7a7a");
        }
        this.externalDataService.checkChannelWarehouse(dto);
        ParamUtil.mustCheckKey(dto, "platformOrderAddrReqDto", "provinceCode", "cityCode", "receiveAddress");
        String orderStatus = "platformOrderStatus";
        dto.putIfAbsent(orderStatus, "submit");
        dto.putIfAbsent("releaseState", 1);
        if (!Objects.equals(allotType, AllotTypeEnum.MAIYOU_BC_ALLOT.getType()) && !Objects.equals(allotType, AllotTypeEnum.MAIYOU_BC_SAME_ORG_ALLOT.getType())) {
            dto.put("releaseState", 0);
        }
        this.doAddProcess(dto, dto.get(orderStatus).toString());
    }

    @Override
    public Object queryTransferOrderList(Map<String, Object> dto) {
        TransferOrderReportExtReqDto reqDto = (TransferOrderReportExtReqDto)BeanUtil.copyProperties(dto, TransferOrderReportExtReqDto.class, (String[])new String[0]);
        return RestResponseHelper.extractData((RestResponse)this.transferOrderReportQueryApi.transferOrderDetailReportExtPage(reqDto));
    }

    @Override
    public void updateSaleOrderPssStatus(String mergeOrder) {
        log.info("\u66f4\u65b0\u9500\u552e\u5408\u5355\u6570\u636e\u63a8\u9001\u72b6\u6001\uff1a{}", (Object)mergeOrder);
        SaleOrderMergeDataDto dataDto = new SaleOrderMergeDataDto();
        dataDto.setMergeOrder(mergeOrder);
        List saleOrderMergeDataDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderMergeDataApi.querySaleOrderMergeDataList(dataDto));
        AssertUtil.isFalse(CollectionUtils.isEmpty((Collection)saleOrderMergeDataDtoList), "\u627e\u4e0d\u5230\u5408\u5355\u4fe1\u606f");
        log.info("\u5408\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderMergeDataDtoList));
        saleOrderMergeDataDtoList.forEach(dto -> {
            List<String> saleOrderNoList = Arrays.asList(dto.getSaleOrder().split(","));
            RestResponseHelper.extractData((RestResponse)this.saleOrderApi.updatePssStatus(saleOrderNoList, YesOrNoEnum.YES.getType()));
        });
    }

    @Override
    public void saleOrderSapAudit(Map<String, Object> dto) {
        log.info("sap\u8ba2\u5355\u5ba1\u6838\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        SaleOrderSapAuditReqDto saleOrderSapAuditReqDto = new SaleOrderSapAuditReqDto();
        BeanUtil.copyProperties(dto, (Object)saleOrderSapAuditReqDto, (String[])new String[0]);
        AssertUtil.isTrue(StringUtils.isBlank((CharSequence)saleOrderSapAuditReqDto.getSapOrderType()), "\u9500\u552e\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (saleOrderSapAuditReqDto.getCreditCheckStatus().booleanValue()) {
            if (saleOrderSapAuditReqDto.getSapOrderType().equals("ZREB")) {
                List respList = (List)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryDetailByPlatformRefundNo(saleOrderSapAuditReqDto.getCustomerOrderNumber()));
                if (CollectionUtils.isNotEmpty((Collection)respList)) {
                    this.saleRefundOptApi.saleRefundSapAudit(saleOrderSapAuditReqDto);
                }
            } else if (saleOrderSapAuditReqDto.getSapOrderType().equals("ZORB")) {
                SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
                saleOrderQueryReqDto.setPlatformOrderNo(saleOrderSapAuditReqDto.getCustomerOrderNumber());
                saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode(), SaleOrderStatusEnum.SPLIT.getCode()}));
                List saleOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
                if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDtoList)) {
                    ((SaleOrderRespDto)saleOrderRespDtoList.get(0)).getOrderType();
                    List cspCancelSaleOrderList = saleOrderRespDtoList.stream().filter(sale -> !Objects.equals(sale.getLockType(), LockTypeEnum.CSP_CANCEL.getType())).collect(Collectors.toList());
                    AssertUtil.isTrue(CollectionUtils.isEmpty(cspCancelSaleOrderList), "\u6d41\u7a0b\u9519\u8bef\uff0c\u5355\u636e\u672a\u53cd\u5ba1");
                }
                Map<String, Object> stringObjectMap = this.buildPlatformOrder(saleOrderSapAuditReqDto);
                this.sendMessage("ORDER_ADD_PROCESS", stringObjectMap);
            } else if (!saleOrderSapAuditReqDto.getSapOrderType().equals("ZORC")) {
                throw new BizException("\u9500\u552e\u8ba2\u5355\u7c7b\u578b\uff0c\u672a\u77e5\u7c7b\u578b");
            }
        }
    }

    private Map<String, Object> buildPlatformOrder(SaleOrderSapAuditReqDto saleOrderSapAuditReqDto) {
        log.info("SAP\u6e20\u9053\u5355\u5ba1\u6838\u6784\u5efa\u6e20\u9053\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderSapAuditReqDto));
        PlatformOrderQueryReqDto saleOrderQueryReqDto = new PlatformOrderQueryReqDto();
        saleOrderQueryReqDto.setPlatformOrderNo(saleOrderSapAuditReqDto.getCustomerOrderNumber());
        saleOrderQueryReqDto.setNotInTransferOrderStatusList((List)Lists.newArrayList((Object[])new Integer[]{PlatformTransformOrderStatus.STATUS_2.getCode(), PlatformTransformOrderStatus.STATUS_3.getCode()}));
        List platformOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryListByParam(saleOrderQueryReqDto));
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)platformOrderRespDtoList), "\u627e\u4e0d\u5230\u5355\u636e\uff1a" + saleOrderSapAuditReqDto.getCustomerOrderNumber());
        PlatformOrderRespDto platformOrderRespDto = (PlatformOrderRespDto)platformOrderRespDtoList.get(0);
        PlatformOrderPcpExtendReqDto extendReqDto = new PlatformOrderPcpExtendReqDto();
        extendReqDto.setPlatformOrderId(platformOrderRespDto.getId());
        PageInfo pcpExtendRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.platformOrderPcpExtendQueryApi.queryByPage(JSON.toJSONString((Object)extendReqDto), Integer.valueOf(1), Integer.valueOf(1)));
        PlatformOrderPcpExtendRespDto platformOrderPcpExtendRespDto = (PlatformOrderPcpExtendRespDto)pcpExtendRespDtoPageInfo.getList().get(0);
        String cspExtendJson = platformOrderPcpExtendRespDto.getCspExtendJson();
        Map map = (Map)JSON.parseObject((String)cspExtendJson, Map.class);
        List itemReqDtoList = (List)MapUtil.get((Map)map, (Object)"itemReqDtoList", List.class);
        itemReqDtoList.forEach(item -> item.remove("sapLineNo"));
        saleOrderSapAuditReqDto.getItemList().forEach(item -> {
            boolean ifT = false;
            for (Map reqItem : itemReqDtoList) {
                if (!ObjectUtil.isNotEmpty(reqItem.get("cspLineNo")) || !reqItem.get("cspLineNo").toString().equals(item.getCustomerOrderItemNumber())) continue;
                reqItem.put("sapLineNo", item.getSapOrderItemId());
                ifT = true;
                break;
            }
            if (!ifT) {
                throw new BizException("\u5339\u914d\u4e0d\u5230\u539f\u5355CSP\u884c\u53f7\uff1a" + JSON.toJSONString((Object)item));
            }
        });
        map.put("itemReqDtoList", itemReqDtoList);
        map.put("sapPlatformOrderNo", saleOrderSapAuditReqDto.getSapOrderNo());
        log.info("SAP\u6e20\u9053\u5355\u5ba1\u6838\u6784\u5efa\u6e20\u9053\u5355\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)map));
        return map;
    }

    @Override
    public void externalApiCallBack(CallbackRequestDto dto) {
        log.info("externalApiCallBack\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        CallbackHeaderDto headerDto = dto.getCallbackHeader();
        BusinessContextDto contextDto = dto.getBusinessContext();
        Map businessData = dto.getBusinessData();
        AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)headerDto), "headerDto\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)contextDto), "contextDto\u4e0d\u80fd\u4e3a\u7a7a");
        switch (headerDto.getSourceSystem()) {
            case "SAP_ZMM039": {
                if (!"SUCCESS".equals(contextDto.getProcessStatus())) break;
                AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)businessData), "businessData\u4e0d\u80fd\u4e3a\u7a7a");
                String sapDocumentNo = (String)businessData.get("MaterialDocument");
                AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)sapDocumentNo), "sapDocumentNo\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)contextDto.getBusinessType()), "businessType\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.isTrue(ObjectUtil.isNotEmpty((Object)contextDto.getBusinessOrderNo()), "businessOrderNo");
                JSONArray wmsResultNoData = JSONArray.parseArray((String)businessData.get("wmsResultNoData").toString());
                Set uniqueWmsNos = wmsResultNoData.stream().map(item -> ((JSONObject)item).getString("wmsResultNo")).filter(wmsNo -> wmsNo != null && !wmsNo.trim().isEmpty()).collect(Collectors.toSet());
                for (String wmsNo2 : uniqueWmsNos) {
                    try {
                        this.sapDocumentNoCallBack(sapDocumentNo, contextDto.getBusinessType(), contextDto.getBusinessOrderNo(), null, wmsNo2);
                    }
                    catch (Exception e) {
                        log.error("\u8c03\u7528 sapDocumentNoCallBack \u5931\u8d25", (Throwable)e);
                    }
                }
                break;
            }
        }
    }

    @Override
    public void sapDocumentNoCallBack(String sapDocumentNo, String businessType, String businessOrderNo, Long deliveryResultOrderId, String deliveryResultOrderNo) {
        ReceiveDeliveryResultOrderPageReqDto orderDto;
        log.info("\u56de\u5199SAP\u51ed\u8bc1\u53f7\uff1a{}\uff0c{},{},{},{}", new Object[]{sapDocumentNo, businessType, businessOrderNo, deliveryResultOrderId, deliveryResultOrderNo});
        if (StringUtils.isBlank((CharSequence)sapDocumentNo) || StringUtils.isBlank((CharSequence)businessType)) {
            log.info("\u56de\u5199\u6761\u4ef6\u5f02\u5e38\uff0c\u7f3a\u5c11\u5173\u952e\u53c2\u6570");
            return;
        }
        if (ObjectUtil.isEmpty((Object)deliveryResultOrderId) && ObjectUtil.isNotEmpty((Object)deliveryResultOrderNo)) {
            orderDto = new ReceiveDeliveryResultOrderPageReqDto();
            orderDto.setDocumentNo(deliveryResultOrderNo);
            orderDto.setDr(Integer.valueOf(0));
            orderDto.setPageNum(Integer.valueOf(1));
            orderDto.setPageSize(Integer.valueOf(1));
            PageInfo page = (PageInfo)this.receiveDeliveryResultOrderApi.page(orderDto).getData();
            if (page != null && ObjectUtil.isNotEmpty((Object)page.getList())) {
                deliveryResultOrderId = ((ReceiveDeliveryResultOrderDto)page.getList().get(0)).getId();
            }
        }
        if (ObjectUtil.isNotEmpty((Object)deliveryResultOrderId)) {
            log.info("\u66f4\u65b0\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u7684SAP\u51ed\u8bc1\u53f7\uff1a{}", (Object)deliveryResultOrderId);
            orderDto = new ReceiveDeliveryResultOrderDto();
            orderDto.setId(deliveryResultOrderId);
            orderDto.setSapNo(sapDocumentNo);
            orderDto.setRemark(sapDocumentNo);
            this.receiveDeliveryResultOrderApi.update((ReceiveDeliveryResultOrderDto)orderDto);
        }
        switch (CsPcpBusinessTypeEnum.getByCode((String)businessType)) {
            case IN_TRANSIT_ADJUSTMENT_IN: 
            case IN_TRANSIT_ADJUSTMENT_OUT: {
                AdjustmentInventoryRespDto adjustmentInventory = (AdjustmentInventoryRespDto)RestResponseHelper.extractData((RestResponse)this.adjustmentInventoryApi.queryByAdjustmentNo(businessOrderNo));
                AssertUtil.isFalse(ObjectUtil.isEmpty((Object)adjustmentInventory), "\u627e\u4e0d\u5230\u8c03\u6574\u5355\uff1a" + businessOrderNo);
                AdjustmentInventoryReqDto update = new AdjustmentInventoryReqDto();
                update.setId(adjustmentInventory.getId());
                update.setExternalOrderNo(sapDocumentNo);
                update.setAdjustmentType(null);
                this.adjustmentInventoryApi.modifyAdjustmentInventory(update);
                if (adjustmentInventory.getSourceType().equals(CsPcpBusinessTypeEnum.IN_TRANSIT_TRANSFER.getCode())) {
                    log.info("\u6682\u4e0d\u56de\u5b58\u8f6c\u5408\u683c\u7684\u8c03\u6574\u5355\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
                    return;
                }
                this.updateTransOrder(businessType, sapDocumentNo, adjustmentInventory.getRelevanceNo());
                break;
            }
            case BC_EQUAL_ALLOT: 
            case CB_EQUAL_ALLOT: 
            case INSPECTION_QUALIFIED: 
            case INSPECTION_UNQUALIFIED: 
            case ALLOT_LOGIC_OUT: 
            case CLAIM_ALLOT: 
            case BORROW_ALLOT: 
            case ALLOT_OUT_ONLY: 
            case ALLOT_IN_ONLY: {
                this.updateTransOrder(businessType, sapDocumentNo, businessOrderNo);
                break;
            }
            case PURCHASE: 
            case OUTSOURCE: 
            case PRODUCTION: 
            case PRODUCTION_MATERIALS_RETURN: {
                break;
            }
            case PURCHASE_REFUND: 
            case PRODUCT_REPAIR: 
            case PRODUCTIONRETREAT: 
            case PRODUCTION_MATERIALS: {
                break;
            }
            case OTHER_OUT: 
            case OTHER_IN: {
                CsOtherStorageOrderEditReqDto editReqDto = new CsOtherStorageOrderEditReqDto();
                editReqDto.setStorageOrderNo(businessOrderNo);
                editReqDto.setExternalOrderNo(sapDocumentNo);
                RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.editOtherStorageOrder(editReqDto));
                break;
            }
            case NUTRITION_INTEGRAL: 
            case OTHER_OUT_STOCK: 
            case CUSTOMER_REFUNDING_ORDER: 
            case QUALITY_REFUNDING_ORDER: 
            case REPLENISH_ORDER: {
                RestResponseHelper.extractData((RestResponse)this.saleOrderApi.updateEasOutOrderNo(Arrays.asList(businessOrderNo), sapDocumentNo));
                break;
            }
            case INTERNAL_ALLOT: 
            case INTERNAL_EXPORT_DEAL: 
            case INTERNAL_DEAL: 
            case INTERNAL_DEAL_RETURN: 
            case SALE_RETURN_INTERNAL_DEAL: 
            case ROUTE_INTERNAL_ALLOT: 
            case ROUTE_INTERNAL_DEAL: {
                RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.updateTransferOrderSapNo(businessOrderNo, sapDocumentNo));
                break;
            }
            default: {
                log.info("\u672a\u5904\u7406\u7c7b\u578b\uff1a{}", (Object)businessType);
            }
        }
    }

    private void updateTransOrder(String businessType, String sapDocumentNo, String businessOrderNo) {
        log.info("\u66f4\u65b0\u8c03\u62e8\u5355\u5916\u90e8\u5355\u53f7\uff1a{}\uff0c{}\uff0c{}", new Object[]{sapDocumentNo, businessType, businessOrderNo});
        CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(businessOrderNo));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)transferOrder), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
        CsTransferOrderReqDto transferOrderReqDto = new CsTransferOrderReqDto();
        transferOrderReqDto.setId(transferOrder.getId());
        String extension = transferOrder.getExtension();
        Map<String, String> map = new HashMap<String, String>();
        if (StringUtils.equals((CharSequence)CsPcpBusinessTypeEnum.CLAIM_ALLOT.getCode(), (CharSequence)businessType)) {
            transferOrderReqDto.setExternalSaleOrderNo(sapDocumentNo);
        }
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            map = (Map)JSON.parseObject((String)extension, Map.class);
            Object externalOrderNOs = map.get("externalOrderNOs");
            if (ObjectUtil.isNotEmpty(externalOrderNOs)) {
                map.put("externalOrderNOs", externalOrderNOs.toString() + "," + sapDocumentNo);
            } else {
                map.put("externalOrderNOs", sapDocumentNo);
            }
        } else {
            map.put("externalOrderNOs", sapDocumentNo);
            transferOrderReqDto.setPreOrderNo(sapDocumentNo);
        }
        transferOrderReqDto.setExtension(JSON.toJSONString(map));
        log.info("\u66f4\u65b0\u8c03\u62e8\u5355\u5916\u90e8\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString((Object)transferOrderReqDto));
        RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.modifyCsTransferOrderExtension(transferOrderReqDto));
    }
}

