/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.ItemUpdatePriceVo;
import com.dtyunxi.tcbj.app.open.biz.service.ISellerSkuPriceService;
import com.dtyunxi.tcbj.app.open.dao.eo.SellerSkuPriceEo;
import com.dtyunxi.yundt.cube.center.item.api.ISellerSkuPriceApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ProductPriceRespDto;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ItemUpdatePriceProcessor
implements IMessageProcessor<Object> {
    private static final Logger log = LoggerFactory.getLogger(ItemUpdatePriceProcessor.class);
    @Resource
    private ISellerSkuPriceApi sellerSkuPriceApi;
    @Value(value="${customer.price.relation.pageSize:5000}")
    private Integer pageSize;
    @Value(value="${customer.price.relation.limitCount:15}")
    private Integer limitCount;
    @Resource
    private ISellerSkuPriceService sellerSkuPriceService;
    @Value(value="${customer.price.relation.sync:false}")
    private boolean syncOpen;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICacheService cacheService;
    public static final String SPLIT = "itemUpdatePriceVo";
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 2, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(2, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public MessageResponse process(Object message) {
        MDC.put((String)"yes.req.requestId", (String)UUID.randomUUID().toString().replace("-", ""));
        log.info("\u63a5\u6536\u5230\u4ef7\u683c\u4fee\u6539MQ\u6570\u636e:{}", message);
        ItemUpdatePriceVo itemUpdatePriceVo = (ItemUpdatePriceVo)JSONObject.parseObject((String)message.toString(), ItemUpdatePriceVo.class);
        if (!this.syncOpen && !itemUpdatePriceVo.isTouchSync()) {
            log.info("\u6682\u65f6\u5148\u4e0d\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        if (Objects.isNull(itemUpdatePriceVo.getTenantId())) {
            log.info("\u53c2\u6570\u65e0\u79df\u6237id");
            return MessageResponse.SUCCESS;
        }
        int sec = 60;
        List itemList = this.cacheService.getList("PRICE_TENANT:UPDATE", String.class);
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            if (itemList.stream().noneMatch(x -> x.startsWith(itemUpdatePriceVo.getTenantId() + SPLIT))) {
                this.cacheService.lpushx("PRICE_TENANT:UPDATE", (List)Lists.newArrayList((Object[])new String[]{itemUpdatePriceVo.getTenantId() + SPLIT + JSONObject.toJSONString((Object)itemUpdatePriceVo)}));
            }
        } else {
            this.cacheService.lpush("PRICE_TENANT:UPDATE", (List)Lists.newArrayList((Object[])new String[]{itemUpdatePriceVo.getTenantId() + SPLIT + JSONObject.toJSONString((Object)itemUpdatePriceVo)}));
        }
        return MessageResponse.SUCCESS;
    }

    public void execute(ItemUpdatePriceVo itemUpdatePriceVo) {
        this.executorService.execute(() -> {
            try {
                log.info("\u4ef7\u683c\u4fee\u6539\u6570\u636eJSON\u8f6c\u6362\u540e:{}", (Object)itemUpdatePriceVo);
                List<String> applierIds = this.sellerSkuPriceService.selectApplierIdsBySupplierId(itemUpdatePriceVo.getTenantId());
                if (CollectionUtils.isEmpty(applierIds)) {
                    return;
                }
                ItemUpdatePriceVo itemUpdatePriceCopyVo = (ItemUpdatePriceVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)itemUpdatePriceVo), ItemUpdatePriceVo.class);
                Stream.iterate(0, n -> n + 1).limit(this.getCount(applierIds.size()).intValue()).forEach(i -> {
                    List<String> limitApplierIds = applierIds.stream().skip((long)i.intValue() * (long)this.limitCount.intValue()).limit(this.limitCount.intValue()).collect(Collectors.toList());
                    itemUpdatePriceCopyVo.setApplierIds(limitApplierIds);
                    this.handle(this.sellerSkuPriceService.selectListNoLimit(itemUpdatePriceCopyVo));
                });
            }
            catch (Exception e) {
                log.error("\u76d1\u542c\u5668\u63a5\u6536\u5230\u6d88\u606f\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
            }
        });
    }

    private Integer getCount(Integer size) {
        return (this.limitCount + size - 1) / this.limitCount;
    }

    private void handle(List<SellerSkuPriceEo> sellerSkuPriceEo) {
        if (CollectionUtils.isEmpty(sellerSkuPriceEo)) {
            return;
        }
        this.sellerSkuPriceApi.updatePriceList(sellerSkuPriceEo.stream().map(eo -> {
            ProductPriceRespDto productPriceRespDto = new ProductPriceRespDto();
            BeanUtil.copyProperties((Object)eo, (Object)productPriceRespDto, (String[])new String[0]);
            return productPriceRespDto;
        }).collect(Collectors.toList()));
    }

    private void sendMessage(ProductPriceRespDto productPriceRespDto) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)productPriceRespDto);
        log.info("\u53d1\u9001\u4ef7\u683c\u540c\u6b65mq\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.sendSingleMessageAsync("ITEM_UPDATE_PRICE_TOPIC", "ITEM_UPDATE_PRICE_TAG", (Object)messageVo);
    }
}

