/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.tcbj.app.open.biz.service.IFileTranslationService;
import com.dtyunxi.tcbj.app.open.dao.das.FileTranslationDas;
import com.dtyunxi.tcbj.app.open.dao.eo.FileTranslationEo;
import com.dtyunxi.util.MD5Util;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FileTranslationServiceImpl
implements IFileTranslationService {
    @Resource
    private FileTranslationDas fileTranslationDas;
    @Resource
    private IObjectStorageService objectStorageService;
    @Value(value="${huieryun.ossregistryvo.bucketName}")
    private String bucket;

    @Override
    public Map<String, String> loadFile(List<String> url) {
        ArrayList saves = new ArrayList(10);
        Map md5 = Optional.ofNullable(url).filter(CollectionUtils::isNotEmpty).map(list -> list.stream().distinct().collect(Collectors.toMap(k -> k, MD5Util::getMd5ByString, (o, o1) -> o))).map(map -> {
            Map<String, String> collect = ((ExtQueryChainWrapper)this.fileTranslationDas.filter().in((Object)"md5", map.values())).list().stream().collect(Collectors.toMap(FileTranslationEo::getOrgiUrl, FileTranslationEo::getTranslationUrl, (o, o1) -> o));
            return map.keySet().stream().collect(Collectors.toMap(k -> k, k -> Optional.ofNullable(collect.get(k)).filter(StringUtils::isNotBlank).orElseGet(() -> {
                String put = this.getTranslationUrl((String)k);
                FileTranslationEo fileTranslationEo = new FileTranslationEo();
                fileTranslationEo.setOrgiUrl(k);
                fileTranslationEo.setTranslationUrl(put);
                fileTranslationEo.setMd5((String)map.get(k));
                saves.add(fileTranslationEo);
                return put;
            })));
        }).orElse(Maps.newHashMap());
        Optional.of(saves).filter(CollectionUtils::isNotEmpty).ifPresent(arg_0 -> ((FileTranslationDas)this.fileTranslationDas).insertBatch(arg_0));
        return md5;
    }

    private String getTranslationUrl(String k) {
        String put;
        if (StringUtils.isBlank((CharSequence)k) || k.contains("10.10.141.13")) {
            return k;
        }
        try {
            put = this.objectStorageService.put(this.bucket, k.substring(k.lastIndexOf("/") + 1), FileTranslationServiceImpl.getInputStream(k));
        }
        catch (Exception e) {
            e.printStackTrace();
            put = "url\u8f6c\u6362\u5f02\u5e38";
        }
        return put;
    }

    public static InputStream getInputStream(String url) {
        InputStream is;
        try {
            HttpURLConnection httpURLConnection = FileTranslationServiceImpl.getHttpURLConnection(url);
            is = httpURLConnection.getInputStream();
        }
        catch (FileNotFoundException e) {
            throw new BizException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38");
        }
        return is;
    }

    public static HttpURLConnection getHttpURLConnection(String url) {
        HttpURLConnection http = null;
        try {
            URL realUrl = new URL(url);
            http = (HttpURLConnection)realUrl.openConnection();
            http.setRequestMethod("GET");
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            http.setDoOutput(true);
            http.setDoInput(true);
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
            System.setProperty("sun.net.client.defaultReadTimeout", "30000");
            http.connect();
        }
        catch (IOException e) {
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38");
        }
        return http;
    }
}

