/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.service.ICompanyService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.company.CompanyVerifyReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyResultDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.CompanyUrlEnum;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CompanyServiceImpl
implements ICompanyService {
    private static final Logger logger = LoggerFactory.getLogger(CompanyServiceImpl.class);
    @Value(value="${tyc.company.token}")
    private String authorization;
    @Value(value="${tyc.company.url}")
    private String url;

    @Override
    public CompanyVerifyRespDto queryCompanyVerify(CompanyVerifyReqDto dto) {
        logger.info("\u4f01\u4e1a\u4e09\u8981\u7d20\u9a8c\u8bc1\u5165\u53c2\uff1a{}", (Object)dto);
        JSONObject params = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dto));
        String tokenUrl = this.url + CompanyUrlEnum.COMPANY_VERIFY.getUrl();
        tokenUrl = this.jointParameters(tokenUrl, (Map<String, Object>)params);
        String result = CompanyServiceImpl.executeGet(tokenUrl, this.authorization);
        logger.info("\u8bf7\u6c42\u53c2\u6570\u4e3a:{},\u8ba4\u8bc1\u4fe1\u606f:{},\u4f01\u4e1a\u4e09\u8981\u7d20\u9a8c\u8bc1\u8fd4\u56de\u6570\u636e:{}", new Object[]{tokenUrl, this.authorization, result});
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new BizException("\u6821\u9a8c\u4fe1\u606f\u4e0d\u901a\u8fc7");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (!"0".equals(jsonObject.getString("error_code"))) {
            CompanyVerifyRespDto companyVerifyRespDto = new CompanyVerifyRespDto();
            companyVerifyRespDto.setResult(Integer.valueOf(0));
            companyVerifyRespDto.setRemark(jsonObject.getString("reason"));
            return companyVerifyRespDto;
        }
        return (CompanyVerifyRespDto)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)jsonObject.getString("result")), CompanyVerifyRespDto.class);
    }

    @Override
    public CompanyResultDto queryCompanyByDesc(final String desc) {
        logger.info("\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u67e5\u8be2 param :{}", (Object)desc);
        String tokenUrl = this.url + CompanyUrlEnum.COMPANY_INFO.getUrl();
        HashMap<String, Object> params = new HashMap<String, Object>(){
            {
                this.put("keyword", desc);
            }
        };
        tokenUrl = this.jointParameters(tokenUrl, (Map<String, Object>)params);
        String result = CompanyServiceImpl.executeGet(tokenUrl, this.authorization);
        logger.info("\u8bf7\u6c42\u53c2\u6570\u4e3a:{},\u8ba4\u8bc1\u4fe1\u606f:{},\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f:{}", new Object[]{tokenUrl, this.authorization, result});
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new BizException("\u6821\u9a8c\u4fe1\u606f\u4e0d\u901a\u8fc7");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if ("0".equals(jsonObject.getString("error_code"))) {
            return (CompanyResultDto)JSONObject.parseObject((String)result, CompanyResultDto.class);
        }
        return null;
    }

    private String jointParameters(String url, Map<String, Object> params) {
        StringBuffer stringBuffer = new StringBuffer(url);
        if (ObjectUtils.isNotEmpty(params)) {
            stringBuffer.append("?");
            for (Map.Entry<String, Object> map : params.entrySet()) {
                try {
                    stringBuffer.append((Object)map.getKey()).append("=").append(URLEncoder.encode(String.valueOf(map.getValue()), "UTF-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            url = stringBuffer.substring(0, stringBuffer.length() - 1);
            return url;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String executeGet(String url, String token) {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)1000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)1000);
        DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)httpParams);
        String result = null;
        try {
            HttpGet get = new HttpGet(url);
            get.setHeader("Authorization", token);
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return result;
    }
}

