/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.external.SapRespBean;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SapResponseHelper {
    private static final String SUCCESS = "SUCCESS";
    public static final String TOKEN_DISABLED_CODE = "10000";

    private SapResponseHelper() {
    }

    public static void checkOrThrow(SapRespBean restResp) {
        SapResponseHelper.extractData(restResp);
    }

    public static String checkData(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            throw new BizException("\u670d\u52a1\u7aef\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
        }
        SapRespBean sapRespBean = (SapRespBean)JSON.parseObject((String)data, SapRespBean.class);
        return SapResponseHelper.check(sapRespBean);
    }

    public static String check(SapRespBean restResp) {
        if (restResp == null) {
            throw new BizException("\u670d\u52a1\u7aef\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
        }
        String code = restResp.getCode();
        if (Objects.equals(code, "1000")) {
            return TOKEN_DISABLED_CODE;
        }
        if (!Objects.equals(code, "200")) {
            throw new BizException(restResp.getStatus());
        }
        return restResp.getData();
    }

    public static void notAllowNull(SapRespBean restResp) {
        if (SapResponseHelper.extractData(restResp) == null) {
            throw new BizException("\u670d\u52a1\u7aef\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
        }
    }

    public static Object extractData(SapRespBean restResp) {
        if (restResp == null) {
            return null;
        }
        String code = restResp.getCode();
        if (!Objects.equals(code, "200")) {
            throw new BizException(restResp.getStatus());
        }
        String data = restResp.getData();
        if (StringUtils.isBlank((CharSequence)data) || !data.contains(SUCCESS)) {
            throw new BizException(data);
        }
        return data;
    }
}

