/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.tcbj.app.open.biz.config.MarketingCloudConfig;
import com.dtyunxi.tcbj.app.open.biz.service.MarketingCloudService;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.external.CspHttpResponseDto;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CspClient {
    private static Logger logger = LoggerFactory.getLogger(CspClient.class);
    @Resource
    private MarketingCloudService marketingCloudServiceBean;
    @Resource
    private MarketingCloudConfig marketingCloudConfigBean;
    private static MarketingCloudService marketingCloudService;
    private static MarketingCloudConfig marketingCloudConfig;

    @PostConstruct
    public void init() {
        marketingCloudService = this.marketingCloudServiceBean;
        marketingCloudConfig = this.marketingCloudConfigBean;
    }

    public static CspHttpResponseDto execute(String urlKey, Map<String, Object> params) {
        String token = null;
        if (marketingCloudConfig.getIfTokenVerify().booleanValue()) {
            token = marketingCloudService.getToken(marketingCloudConfig.getPcpAppId(), marketingCloudConfig.getPcpAppSecret());
            CspClient.isTrue(StringUtils.isBlank((CharSequence)token), "TOKEN\u83b7\u53d6\u5931\u8d25");
        }
        return CspClient.execute(urlKey, params, token, CspHttpResponseDto.class);
    }

    public static CspHttpResponseDto executeNotVerify(String urlKey, Map<String, Object> params) {
        return CspClient.execute(urlKey, params, null, CspHttpResponseDto.class);
    }

    public static <T> T executeNotVerify(String urlKey, Map<String, Object> params, Class<T> clazz) {
        return CspClient.execute(urlKey, params, null, clazz);
    }

    public static <T> T execute(String urlKey, Map<String, Object> params, String token, Class<T> clazz) {
        logger.info("csp\u670d\u52a1\u8bf7\u6c42\uff1a{}=={}=={}", new Object[]{urlKey, JSON.toJSONString(params), token});
        if (StringUtils.isNotBlank((CharSequence)token)) {
            urlKey = urlKey + "?access_token=" + token;
        }
        logger.info("\u7ec4\u5408\u8def\u5f84\uff1a{}", (Object)urlKey);
        HttpRequest post = HttpUtil.createPost((String)urlKey);
        String bodyStr = JSON.toJSONString(params);
        post.body(bodyStr);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)urlKey);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", (Object)bodyStr);
        Instant start = Instant.now();
        HttpResponse httpResponse = post.execute();
        String body = httpResponse.body();
        Instant end = Instant.now();
        logger.info("\u8bf7\u6c42CSP\u670d\u52a1\u54cd\u5e94\uff0c\u8017\u65f6\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)Duration.between(start, end).toMillis(), (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseStatus", (Object)httpResponse.isGzip());
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseData", (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseCode", (Object)httpResponse.getStatus());
        return (T)JSON.parseObject((String)body, clazz);
    }

    private static void isTrue(boolean b, String msg) {
        if (b) {
            throw new BizException(msg);
        }
    }
}

