/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.SapMaterialPriceListDto;
import com.dtyunxi.tcbj.app.open.biz.dto.SapMaterialPriceReqDto;
import com.dtyunxi.tcbj.app.open.biz.service.ISapCenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapModelTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.IItemExtendApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SapCenterHandleProductPriceServiceImpl
implements ISapCenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(SapCenterHandleProductPriceServiceImpl.class);
    @Resource
    private IItemExtendQueryApi iItemExtendQueryApi;
    @Resource
    private IItemExtendApi itemExtendApi;

    @Override
    public String getModelType() {
        return SapModelTypeEnum.PRODUCTPRICE.getValue();
    }

    @Override
    public void handle(Map<String, Object> map) {
        logger.info("sap-ocs \u4ea7\u54c1\u4ef7\u683c\u4fe1\u606f\u4e3b\u6570\u636e-\u6570\u636e\u5206\u53d1:{}", (Object)JSONUtil.toJsonStr(map));
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty(map), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-map \u4e3a\u7a7a!");
        SapMaterialPriceListDto data = this.productPricePropertyConvert(map);
        if (CollectionUtils.isNotEmpty(data.getPriceList())) {
            for (SapMaterialPriceReqDto reqDto : data.getPriceList()) {
                if (ObjectUtils.isNotEmpty((Object)reqDto)) {
                    Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getMaterialNum()), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65 \u5546\u54c1\u4ef7\u683c-MATNR \u7269\u6599\u7f16\u7801 \u4e3a\u7a7a!");
                    Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)reqDto.getPrice()), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65 \u5546\u54c1\u4ef7\u683c -KBETR  \u4ef7\u683c \u4e3a\u7a7a!");
                }
                ItemExtendReqDto itemExtendReq = new ItemExtendReqDto();
                itemExtendReq.setItemCode(reqDto.getMaterialNum());
                List itemExtendRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iItemExtendQueryApi.queryParam(itemExtendReq));
                if (!CollectionUtils.isNotEmpty((Collection)itemExtendRespDtos)) continue;
                for (ItemExtendRespDto dto : itemExtendRespDtos) {
                    ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
                    itemExtendReqDto.setItemCode(reqDto.getMaterialNum());
                    dto.setRecommendPrice(reqDto.getPrice());
                    this.itemExtendApi.modifyPrice(itemExtendReqDto);
                }
            }
        }
    }

    private SapMaterialPriceListDto productPricePropertyConvert(Map map) {
        JSONArray itemArray;
        SapMaterialPriceListDto respDto = new SapMaterialPriceListDto();
        ArrayList<SapMaterialPriceReqDto> priceList = new ArrayList<SapMaterialPriceReqDto>();
        if (ObjectUtil.isNotEmpty((Object)map) && CollectionUtils.isNotEmpty((Collection)(itemArray = JSONUtil.parseArray(map.get("priceList"))))) {
            for (int i = 0; i < itemArray.size(); ++i) {
                JSONObject jsonObject = itemArray.getJSONObject((Object)i);
                SapMaterialPriceReqDto priceSyncCmd = new SapMaterialPriceReqDto();
                if (ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"KSCHL"))) {
                    priceSyncCmd.setConditionType(jsonObject.get((Object)"KSCHL").toString());
                }
                if (ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"VKORG"))) {
                    priceSyncCmd.setOrgCode(jsonObject.get((Object)"VKORG").toString());
                }
                if (ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"VTWEG"))) {
                    priceSyncCmd.setDistChannel(jsonObject.get((Object)"VTWEG").toString());
                }
                if (ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"MATNR"))) {
                    priceSyncCmd.setMaterialNum(jsonObject.get((Object)"MATNR").toString());
                }
                if (ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"KBETR"))) {
                    priceSyncCmd.setPrice(new BigDecimal(jsonObject.get((Object)"KBETR").toString()));
                }
                if (ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"DATAB"))) {
                    priceSyncCmd.setStartDt((Date)DateUtil.parseDate((CharSequence)jsonObject.get((Object)"DATAB").toString()));
                }
                if (ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"DATBI"))) {
                    priceSyncCmd.setEndDt((Date)DateUtil.parseDate((CharSequence)jsonObject.get((Object)"DATBI").toString()));
                }
                if (ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"CreationDate"))) {
                    priceSyncCmd.setCreateDt((Date)DateUtil.parseDate((CharSequence)jsonObject.get((Object)"CreationDate").toString()));
                }
                if (ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"KONWA"))) {
                    priceSyncCmd.setCurrency(jsonObject.get((Object)"KONWA").toString());
                }
                priceList.add(priceSyncCmd);
            }
        }
        respDto.setPriceList(priceList);
        return respDto;
    }
}

