/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.service.ISapCenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.UpdateItemDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapModelTypeEnum;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapProductInfoEnum;
import com.dtyunxi.yundt.cube.center.item.api.IItemExtendApi;
import com.dtyunxi.yundt.cube.center.item.api.IPcpItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemSkuApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SapCenterHandleProductInfoServiceImpl
implements ISapCenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(SapCenterHandleProductInfoServiceImpl.class);
    @Resource
    private IItemApi iItemApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemSkuApi iItemSkuApi;
    @Resource
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Resource
    private IPcpItemApi pcpItemApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private IPcpItemQueryApi iPcpItemQueryApi;
    @Resource
    private IItemExtendQueryApi itemExtendQueryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IItemExtendQueryApi iItemExtendQueryApi;
    @Resource
    private IItemExtendApi itemExtendApi;
    @Autowired
    private IUnitQueryApi unitQueryApi;

    @Override
    public String getModelType() {
        return SapModelTypeEnum.MATERIAL.getValue();
    }

    @Override
    public void handle(Map<String, Object> map) {
        logger.info("sap-ocs \u4ea7\u54c1\u4fe1\u606f\u4e3b\u6570\u636e-\u6570\u636e\u5206\u53d1:{}", (Object)JSON.toJSONString(map));
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty(map), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-map \u4e3a\u7a7a!");
        Map dataMap = (Map)JSONUtil.toBean((String)map.get(SapProductInfoEnum.HEADER.getCode()).toString(), Map.class);
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)dataMap), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-dataMap \u4e3a\u7a7a!");
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty(dataMap.get(SapProductInfoEnum.MATNR.getCode())), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-MATNR \u7269\u6599\u7f16\u7801 \u4e3a\u7a7a!");
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty(dataMap.get(SapProductInfoEnum.MAKTX.getCode())), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-MAKTX  \u7269\u6599\u540d\u79f0 \u4e3a\u7a7a!");
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty(dataMap.get(SapProductInfoEnum.BISMT.getCode())), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-BISMT \u65e7\u7f16\u7801 \u4e3a\u7a7a!");
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty(dataMap.get(SapProductInfoEnum.MTART.getCode())), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-MTART  \u7269\u6599\u7c7b\u578b\u4e3a\u7a7a!");
        List<String> filters = Arrays.asList("ZFIN", "ZSFG", "ZGEN");
        if (!filters.contains(dataMap.get(SapProductInfoEnum.MTART.getCode()).toString())) {
            logger.info("syncDataFormSap->syncDataFormSapProductInfo\u540c\u6b65\u5546\u54c1\u4fe1\u606f,\u7269\u6599\u7c7b\u578b\u975e ZFIN  ZSFG ZGEN  \u8df3\u8fc7\u3002\u3002\u3002\u540c\u6b65\u5546\u54c1\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(map));
        } else {
            Long itemId = this.sapSaveItem(dataMap);
            logger.info("sap-ocs \u4ea7\u54c1\u4fe1\u606f\u4e3b\u6570\u636e-\u6570\u636e\u5206\u53d1 sapSaveItem  itemId:{},\u4ea7\u54c1\u7f16\u7801:{}", (Object)itemId, (Object)dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
            this.sapSaveItemSku(dataMap, itemId);
            logger.info("sap-ocs \u4ea7\u54c1\u4fe1\u606f\u4e3b\u6570\u636e-\u6570\u636e\u5206\u53d1 sapSaveItemExtend  itemId:{},\u4ea7\u54c1\u7f16\u7801:{}", (Object)itemId, (Object)dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
            this.sapSaveItemExtend(dataMap, itemId);
            logger.info("sap-ocs \u4ea7\u54c1\u4fe1\u606f\u4e3b\u6570\u636e-\u6570\u636e\u5206\u53d1 broadcastToOtherSystems  itemId:{},\u4ea7\u54c1\u7f16\u7801:{}", (Object)itemId, (Object)dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
            this.broadcastToOtherSystems(dataMap);
        }
    }

    private void sapSaveItemExtend(Map dataMap, Long itemId) {
        ItemExtendReqDto saveItemExtendReqDto = new ItemExtendReqDto();
        ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
        itemExtendReqDto.setItemCodeList(Arrays.asList(dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString()));
        List dbItemExtendRespDto = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(itemExtendReqDto));
        if (CollectionUtils.isNotEmpty((Collection)dbItemExtendRespDto)) {
            ItemExtendRespDto itemExtend = (ItemExtendRespDto)dbItemExtendRespDto.get(0);
            saveItemExtendReqDto.setId(itemExtend.getId());
            BeanUtils.copyProperties((Object)itemExtend, (Object)saveItemExtendReqDto);
            saveItemExtendReqDto.setItemId(itemId);
            saveItemExtendReqDto.setItemCode(dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZBARCODE.getCode()))) {
                saveItemExtendReqDto.setBarCode(dataMap.get(SapProductInfoEnum.ZBARCODE.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.MAKTX.getCode()))) {
                saveItemExtendReqDto.setItemName(dataMap.get(SapProductInfoEnum.MAKTX.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZPKG_LG_B.getCode()))) {
                saveItemExtendReqDto.setLength(new BigDecimal(dataMap.get(SapProductInfoEnum.ZPKG_LG_B.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZPKG_HG_B.getCode()))) {
                saveItemExtendReqDto.setHeight(new BigDecimal(dataMap.get(SapProductInfoEnum.ZPKG_HG_B.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZPKG_WD_B.getCode()))) {
                saveItemExtendReqDto.setWidth(new BigDecimal(dataMap.get(SapProductInfoEnum.ZPKG_WD_B.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZMIN_VOL.getCode()))) {
                saveItemExtendReqDto.setVolume(new BigDecimal(dataMap.get(SapProductInfoEnum.ZMIN_VOL.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZMIN_WGT.getCode()))) {
                saveItemExtendReqDto.setGrossWeight(new BigDecimal(dataMap.get(SapProductInfoEnum.ZMIN_WGT.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZMIN_WGT.getCode()))) {
                saveItemExtendReqDto.setNetWeight(new BigDecimal(dataMap.get(SapProductInfoEnum.ZMIN_WGT.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZPKG_RT_B.getCode()))) {
                saveItemExtendReqDto.setBigRatio(Long.valueOf(Long.parseLong(dataMap.get(SapProductInfoEnum.ZPKG_RT_B.getCode()).toString())));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZPKG_RT_M.getCode()))) {
                saveItemExtendReqDto.setMiddleRatio(Long.valueOf(Long.parseLong(dataMap.get(SapProductInfoEnum.ZPKG_RT_M.getCode()).toString())));
            }
            saveItemExtendReqDto.setSmallRatio(Long.valueOf(1L));
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZSEC_CODE.getCode()))) {
                saveItemExtendReqDto.setSecurityCode(dataMap.get(SapProductInfoEnum.ZSEC_CODE.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZSHELF_LF.getCode()))) {
                saveItemExtendReqDto.setExpirationDate(dataMap.get(SapProductInfoEnum.ZSHELF_LF.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.BZTXT.getCode()))) {
                saveItemExtendReqDto.setSpecs(dataMap.get(SapProductInfoEnum.BZTXT.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.BZTXT.getCode()))) {
                saveItemExtendReqDto.setSpecContent(dataMap.get(SapProductInfoEnum.BZTXT.getCode()).toString());
            }
            saveItemExtendReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            saveItemExtendReqDto.setTenantId(this.requestBaseData.getTenantId());
            this.itemExtendApi.modifyItemExtend(saveItemExtendReqDto);
        } else {
            saveItemExtendReqDto.setItemId(itemId);
            saveItemExtendReqDto.setItemCode(dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZBARCODE.getCode()))) {
                saveItemExtendReqDto.setBarCode(dataMap.get(SapProductInfoEnum.ZBARCODE.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.MAKTX.getCode()))) {
                saveItemExtendReqDto.setItemName(dataMap.get(SapProductInfoEnum.MAKTX.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZPKG_LG_B.getCode()))) {
                saveItemExtendReqDto.setLength(new BigDecimal(dataMap.get(SapProductInfoEnum.ZPKG_LG_B.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZPKG_HG_B.getCode()))) {
                saveItemExtendReqDto.setHeight(new BigDecimal(dataMap.get(SapProductInfoEnum.ZPKG_HG_B.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZPKG_WD_B.getCode()))) {
                saveItemExtendReqDto.setWidth(new BigDecimal(dataMap.get(SapProductInfoEnum.ZPKG_WD_B.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZMIN_VOL.getCode()))) {
                saveItemExtendReqDto.setVolume(new BigDecimal(dataMap.get(SapProductInfoEnum.ZMIN_VOL.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZMIN_WGT.getCode()))) {
                saveItemExtendReqDto.setGrossWeight(new BigDecimal(dataMap.get(SapProductInfoEnum.ZMIN_WGT.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZMIN_WGT.getCode()))) {
                saveItemExtendReqDto.setNetWeight(new BigDecimal(dataMap.get(SapProductInfoEnum.ZMIN_WGT.getCode()).toString()));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZPKG_RT_B.getCode()))) {
                saveItemExtendReqDto.setBigRatio(Long.valueOf(Long.parseLong(dataMap.get(SapProductInfoEnum.ZPKG_RT_B.getCode()).toString())));
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZPKG_RT_M.getCode()))) {
                saveItemExtendReqDto.setMiddleRatio(Long.valueOf(Long.parseLong(dataMap.get(SapProductInfoEnum.ZPKG_RT_M.getCode()).toString())));
            }
            saveItemExtendReqDto.setSmallRatio(Long.valueOf(1L));
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZSEC_CODE.getCode()))) {
                saveItemExtendReqDto.setSecurityCode(dataMap.get(SapProductInfoEnum.ZSEC_CODE.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZSHELF_LF.getCode()))) {
                saveItemExtendReqDto.setExpirationDate(dataMap.get(SapProductInfoEnum.ZSHELF_LF.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.BZTXT.getCode()))) {
                saveItemExtendReqDto.setSpecs(dataMap.get(SapProductInfoEnum.BZTXT.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.BZTXT.getCode()))) {
                saveItemExtendReqDto.setSpecContent(dataMap.get(SapProductInfoEnum.BZTXT.getCode()).toString());
            }
            saveItemExtendReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            saveItemExtendReqDto.setTenantId(this.requestBaseData.getTenantId());
            this.itemExtendApi.addItemExtend(saveItemExtendReqDto);
        }
    }

    private void broadcastToOtherSystems(Map dataMap) {
        ArrayList<PcpItemRespDto> itemExtendRespDtoList = new ArrayList<PcpItemRespDto>();
        ArrayList<UpdateItemDto> updateItemDtoList = new ArrayList<UpdateItemDto>();
        UpdateItemDto updateItemDto = new UpdateItemDto();
        updateItemDto.setCode(dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
        updateItemDto.setName(dataMap.get(SapProductInfoEnum.MAKTX.getCode()).toString());
        updateItemDtoList.add(updateItemDto);
        if (CollectionUtil.isNotEmpty(updateItemDtoList)) {
            MessageVo messageVo;
            ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
            List itemCodeList = updateItemDtoList.stream().map(UpdateItemDto::getCode).collect(Collectors.toList());
            itemExtendReqDto.setItemCodeList(itemCodeList);
            List csInventorySupplierRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(itemExtendReqDto));
            logger.info("SapCenterHandleProductInfoServiceImpl \u540c\u6b65\u5546\u54c1\u67e5\u8be2\u5230\u6570\u636e:{}", (Object)JSON.toJSONString((Object)csInventorySupplierRespDtos));
            for (ItemExtendRespDto dto : csInventorySupplierRespDtos) {
                if (dto.getId() == null) continue;
                PcpItemRespDto pcpItemRespDto = (PcpItemRespDto)RestResponseHelper.extractData((RestResponse)this.iPcpItemQueryApi.queryByPrimaryKey(dto.getId()));
                itemExtendRespDtoList.add(pcpItemRespDto);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemExtendRespDtoList)) {
                messageVo = new MessageVo();
                messageVo.setData((Object)JSON.toJSONString(itemExtendRespDtoList));
                this.commonsMqService.sendSingleMessage("PRODUCT_INFORMATION_RECEIVING_LOG", (Object)messageVo);
            }
            logger.info("\u5e7f\u64ad\u540c\u6b65\u5546\u54c1\u6d88\u606f\uff0c\u4f9b\u5176\u4ed6\u4e2d\u5fc3\u66f4\u65b0\u5546\u54c1\u540d\u79f0\u7b49\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(updateItemDtoList));
            try {
                messageVo = new MessageVo();
                messageVo.setData((Object)JSON.toJSONString(updateItemDtoList));
                this.commonsMqService.publishMessage("PCP_PUBLIC_SYNC_ITEM", (Object)messageVo);
            }
            catch (Exception e) {
                logger.error("\u5e7f\u64ad\u540c\u6b65\u5546\u54c1\u6d88\u606f\uff0c\u4f9b\u5176\u4ed6\u4e2d\u5fc3\u66f4\u65b0\u5546\u54c1\u540d\u79f0\u7b49\u4fe1\u606f\u5f02\u5e38");
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sapSaveItemSku(Map dataMap, Long itemId) {
        ItemBundleReqDto itemBundleReqDto = new ItemBundleReqDto();
        List skuRespDtos = (List)this.iItemSkuQueryApi.queryBySkuCode((List)Lists.newArrayList((Object[])new String[]{dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString()})).getData();
        logger.info("SapCenterHandleProductInfoServiceImpl \u67e5\u8be2\u5546\u54c1sku\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)skuRespDtos));
        if (CollectionUtil.isNotEmpty((Collection)skuRespDtos)) {
            UnitRespDto unitRespDto;
            logger.info("SapCenterHandleProductInfoServiceImpl \u5546\u54c1sku\u5df2\u5b58\u5728\uff01code:{}", (Object)dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
            ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)skuRespDtos.get(0);
            BeanUtils.copyProperties((Object)itemSkuRespDto, (Object)itemBundleReqDto);
            itemBundleReqDto.setBarCode(dataMap.get(SapProductInfoEnum.ZBARCODE.getCode()).toString().toString());
            itemBundleReqDto.setName(dataMap.get(SapProductInfoEnum.MAKTX.getCode()).toString());
            itemBundleReqDto.setId(itemSkuRespDto.getId());
            String unitCode = "";
            String unitName = "";
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.MEINS.getCode()))) {
                unitCode = dataMap.get(SapProductInfoEnum.MEINS.getCode()).toString();
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.MSEHL.getCode()))) {
                unitName = dataMap.get(SapProductInfoEnum.MSEHL.getCode()).toString();
            }
            itemBundleReqDto.setAttr("{\"\u9ed8\u8ba4\":\"" + unitName + "\"}");
            if (StringUtils.isNotBlank((CharSequence)unitCode) && ObjectUtil.isNotEmpty((Object)(unitRespDto = (UnitRespDto)this.unitQueryApi.queryByCode(unitCode).getData()))) {
                itemBundleReqDto.setUnit(unitRespDto.getId().toString());
            }
            ArrayList bundleReqDtos = Lists.newArrayList();
            bundleReqDtos.add(itemBundleReqDto);
            this.iItemSkuApi.modifyItemSku((List)bundleReqDtos);
        } else {
            UnitRespDto unitRespDto;
            itemBundleReqDto.setItemId(itemId);
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZBARCODE.getCode()))) {
                itemBundleReqDto.setBarCode(dataMap.get(SapProductInfoEnum.ZBARCODE.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZMIN_VOL.getCode()))) {
                itemBundleReqDto.setVolumeUnit(dataMap.get(SapProductInfoEnum.ZMIN_VOL.getCode()).toString());
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZMIN_WGT.getCode()))) {
                itemBundleReqDto.setGrossWeight(new BigDecimal(dataMap.get(SapProductInfoEnum.ZMIN_WGT.getCode()).toString()));
            }
            String unitCode = "";
            String unitName = "";
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.MEINS.getCode()))) {
                unitCode = dataMap.get(SapProductInfoEnum.MEINS.getCode()).toString();
            }
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.MSEHL.getCode()))) {
                unitName = dataMap.get(SapProductInfoEnum.MSEHL.getCode()).toString();
            }
            itemBundleReqDto.setAttr("{\"\u9ed8\u8ba4\":\"" + unitName + "\"}");
            if (StringUtils.isNotBlank((CharSequence)unitCode) && ObjectUtil.isNotEmpty((Object)(unitRespDto = (UnitRespDto)this.unitQueryApi.queryByCode(unitCode).getData()))) {
                itemBundleReqDto.setUnit(unitRespDto.getId().toString());
            }
            itemBundleReqDto.setName(dataMap.get(SapProductInfoEnum.MAKTX.getCode()).toString());
            itemBundleReqDto.setMinPackage(Integer.valueOf(1));
            itemBundleReqDto.setCargoCode(dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
            itemBundleReqDto.setCode(dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
            itemBundleReqDto.setCreatePerson("SAP");
            itemBundleReqDto.setTenantId(this.requestBaseData.getTenantId());
            itemBundleReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            ArrayList prices = Lists.newArrayList();
            ItemPriceReqDto itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u5212\u7ebf\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            itemPriceReqDto.setPrice(new BigDecimal(99999.9));
            itemPriceReqDto.setPriceType("PRICE");
            prices.add(itemPriceReqDto);
            itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u552e\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            itemPriceReqDto.setPrice(new BigDecimal(99999.9));
            itemPriceReqDto.setPriceType("RETAIL_PRICE");
            prices.add(itemPriceReqDto);
            itemBundleReqDto.setPrices((List)prices);
            logger.info("SapCenterHandleProductInfoServiceImpl =================> \u65b0\u589e\u5546\u54c1sku\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)itemBundleReqDto));
            this.iItemSkuApi.addItemSku((List)Lists.newArrayList((Object[])new ItemBundleReqDto[]{itemBundleReqDto}));
        }
    }

    private Long sapSaveItem(Map dataMap) {
        Long itemId = null;
        List itemRespDtoList = (List)this.itemQueryApi.queryByItemLongCodes((List)Lists.newArrayList((Object[])new String[]{dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString()})).getData();
        if (CollectionUtils.isNotEmpty((Collection)itemRespDtoList)) {
            ItemReqDto itemReqDto = new ItemReqDto();
            Long id = ((ItemRespDto)itemRespDtoList.get(0)).getId();
            itemReqDto.setName(dataMap.get(SapProductInfoEnum.MAKTX.getCode()).toString());
            itemReqDto.setId(id);
            itemReqDto.setUpdatePerson("SAP");
            this.iItemApi.modifyItem(itemReqDto);
            PcpItemReqDto pcpItemReqDto = new PcpItemReqDto();
            pcpItemReqDto.setLongCode(dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
            this.pcpItemApi.modifyPcpItem(pcpItemReqDto);
        } else {
            String productType;
            ItemChangeApplyDto changApply = new ItemChangeApplyDto();
            changApply.setBrand(dataMap.get(SapProductInfoEnum.ZBRAND.getCode()).toString());
            BrandRespDto brandRespDto = (BrandRespDto)this.brandQueryApi.queryCode(dataMap.get(SapProductInfoEnum.ZBRAND.getCode()).toString()).getData();
            if (ObjectUtils.isNotEmpty((Object)brandRespDto)) {
                changApply.setBrandId(brandRespDto.getId());
            }
            changApply.setStatus(Integer.valueOf(2));
            changApply.setItemCode(dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
            changApply.setLongCode(dataMap.get(SapProductInfoEnum.MATNR.getCode()).toString());
            changApply.setItemName(dataMap.get(SapProductInfoEnum.MAKTX.getCode()).toString());
            changApply.setDisplayName(dataMap.get(SapProductInfoEnum.MAKTX.getCode()).toString());
            changApply.setDirId(Long.valueOf(1288630386802423099L));
            changApply.setDirName("\u9ed8\u8ba4\u7c7b\u76ee");
            changApply.setType(Integer.valueOf(1));
            String materialType = dataMap.get(SapProductInfoEnum.MTART.getCode()).toString();
            if (StringUtils.isNotBlank((CharSequence)materialType)) {
                if ("ZFIN".equals(materialType)) {
                    changApply.setSubType(Integer.valueOf(1));
                }
                if ("ZSFG".equals(materialType)) {
                    changApply.setSubType(Integer.valueOf(4));
                }
                if ("ZGEN".equals(materialType)) {
                    changApply.setSubType(Integer.valueOf(3));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(productType = dataMap.get(SapProductInfoEnum.ZPRD_TYPE.getCode()).toString())) && ("14".equals(productType) || "15".equals(productType))) {
                changApply.setSubType(Integer.valueOf(2));
            }
            changApply.setAttrs("");
            changApply.setSellerId(Long.valueOf(0L));
            changApply.setCreatePerson("SAP");
            changApply.setUpdatePerson("SAP");
            if (ObjectUtil.isNotEmpty(dataMap.get(SapProductInfoEnum.ZDOS_FORM.getCode()))) {
                changApply.setDosageForm(dataMap.get(SapProductInfoEnum.ZDOS_FORM.getCode()).toString());
            }
            changApply.setTenantId(this.requestBaseData.getTenantId());
            changApply.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("sapSaveItem iItemApi.addItem  \u5546\u54c1\u4fe1\u606fchangApply:{}", (Object)JSONUtil.toJsonStr((Object)changApply));
            itemId = (Long)this.iItemApi.addItem(changApply).getData();
        }
        return itemId;
    }
}

