/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICostCenterApi;
import com.dtyunxi.tcbj.api.dto.request.CostCenterReqDto;
import com.dtyunxi.tcbj.api.query.ICostCenterQueryApi;
import com.dtyunxi.tcbj.app.open.biz.enums.PcpSupplierColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ISapCenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapModelTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="SapCenterHandleCostCenterServiceImpl")
public class SapCenterHandleCostCenterServiceImpl
implements ISapCenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(SapCenterHandleCostCenterServiceImpl.class);
    @Resource
    private ICostCenterApi costCenterApi;
    @Resource
    private ICostCenterQueryApi costCenterQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Override
    public String getModelType() {
        return SapModelTypeEnum.COSTCENTER.getValue();
    }

    @Override
    public void handle(Map<String, Object> reqDto) {
        logger.info("\u6210\u672c\u4e2d\u5fc3\u6570\u636e\u5206\u53d1:{}", (Object)JSON.toJSONString(reqDto));
        long startTime = System.currentTimeMillis();
        String obj = JSONObject.toJSONString((Object)reqDto.get("data"));
        JSONObject dataObj = JSONObject.parseObject((String)obj);
        CostCenterReqDto queryDto = new CostCenterReqDto();
        queryDto.setCostCenterCode(dataObj.getString("number"));
        PageInfo resPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.costCenterQueryApi.queryByPageByPost(queryDto));
        List list = resPage.getList();
        OrganizationDto organization = (OrganizationDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOneByOrgCode(null, dataObj.getString("orgNum")));
        try {
            CostCenterReqDto costCenterReqDto;
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                costCenterReqDto = new CostCenterReqDto();
                costCenterReqDto.setCostCenterCode(dataObj.getString("number"));
                costCenterReqDto.setCostCenterName(dataObj.getString("name"));
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                if (organization != null) {
                    costCenterReqDto.setOrganizationId(organization.getId());
                }
                costCenterReqDto.setStartDate(format.parse(dataObj.getString("startDate")));
                costCenterReqDto.setEndDate(format.parse(dataObj.getString("endDate")));
                this.costCenterApi.modifyCostCenter(costCenterReqDto);
            } else {
                costCenterReqDto = new CostCenterReqDto();
                costCenterReqDto.setCostCenterCode(dataObj.getString("number"));
                costCenterReqDto.setCostCenterName(dataObj.getString("name"));
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                if (organization != null) {
                    costCenterReqDto.setOrganizationId(organization.getId());
                }
                costCenterReqDto.setStartDate(format.parse(dataObj.getString("startDate")));
                costCenterReqDto.setEndDate(format.parse(dataObj.getString("endDate")));
                this.costCenterApi.addCostCenter(costCenterReqDto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        logger.info("\u3010\u6210\u672c\u4e2d\u5fc3\u65b0\u589e\u540c\u6b65\u3011\u8017\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        logger.info("\u3010\u6210\u672c\u4e2d\u5fc3\u65b0\u589e\u540c\u6b65\u3011\u7ed3\u675f\u540c\u6b65--------->");
    }

    private String validaData(List<Map> dataMap) {
        if (dataMap == null || dataMap.size() <= 0) {
            return "\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (Map map : dataMap) {
            for (Object s : map.keySet()) {
                if (Objects.isNull(s)) {
                    return "\u540c\u6b65\u6570\u636e\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a";
                }
                PcpSupplierColumnEnum pcpSupplierColumnEnum = PcpSupplierColumnEnum.getByField(s.toString());
                if (pcpSupplierColumnEnum == null || pcpSupplierColumnEnum.validate(s.toString()).booleanValue()) continue;
                return String.format("%s\u4e0d\u80fd\u4e3a\u7a7a", pcpSupplierColumnEnum.getFieldName());
            }
        }
        return null;
    }
}

