/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.connector.comm.constant.Constants;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InventoryDataComparisonConfig
implements CommandLineRunner {
    private final Logger logger = LoggerFactory.getLogger(InventoryDataComparisonConfig.class);
    @Resource
    private ITaskApi iTaskApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Value(value="${scheduler.client.app_code: tcbj-openapi-platform}")
    private String appCode;
    @Value(value="${scheduler.client.syncCargoBalanceEventCron: 0 0 3 * * ?}")
    private String syncCargoBalanceEventCron;
    @Value(value="${scheduler.client.contrastInventoryPreemptEventCron: 0 15 3 * * ?}")
    private String contrastInventoryPreemptEventCron;
    @Value(value="${scheduler.client.syncQualityDetailEventCron: 0 */10 * * * ?}")
    private String syncQualityDetailEventCron;
    private static final String cargoBalanceCode = "syncCargoBalanceEvent";
    private static final String contrastInventoryPreemptCode = "contrastInventoryPreemptEvent";
    private static final String syncQualityDetailCode = "syncQualityDetailEvent";

    public void run(String ... args) {
        AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
        appBizQueryReqDto.setAppCode(this.appCode);
        String filter = ObjectHelper.bean2Json((Object)appBizQueryReqDto);
        this.logger.info("\u5e93\u5b58\u4e2d\u5fc3\u6570\u636e\u5bf9\u6bd4 \u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2\u4efb\u52a1\u5165\u53c2\uff1a{}", (Object)filter);
        PageInfo pageInfo = null;
        try {
            pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(10)));
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            return;
        }
        this.logger.info("\u5e93\u5b58\u4e2d\u5fc3\u6570\u636e\u5bf9\u6bd4 \u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2\u4efb\u52a1\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        boolean cargoBalanceExist = false;
        boolean contrastInventoryPreemptExist = false;
        boolean syncQualityDetailExist = false;
        if (Objects.nonNull(pageInfo) && !CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            for (TaskQueryRespDto taskDto : pageInfo.getList()) {
                if (cargoBalanceCode.equals(taskDto.getAppBizRespDto().getBizCode())) {
                    cargoBalanceExist = true;
                }
                if (contrastInventoryPreemptCode.equals(taskDto.getAppBizRespDto().getBizCode())) {
                    contrastInventoryPreemptExist = true;
                }
                if (!syncQualityDetailCode.equals(taskDto.getAppBizRespDto().getBizCode())) continue;
                syncQualityDetailExist = true;
            }
        }
        try {
            if (!cargoBalanceExist) {
                this.logger.info(">>>>\u3010\u5b9a\u65f6\u5bf9\u6bd4\u8425\u9500\u4e91\u5e93\u5b58\u548c\u5e93\u5b58\u4e2d\u5fc3\u5e93\u5b58\u3011\u8c03\u5ea6\u4efb\u52a1\u5f00\u59cb\u521b\u5efa");
                this.startSyncEvent(cargoBalanceCode, "\u5b9a\u65f6\u5bf9\u6bd4\u8425\u9500\u4e91\u5e93\u5b58\u548c\u5e93\u5b58\u4e2d\u5fc3\u5e93\u5b58", this.syncCargoBalanceEventCron);
                this.logger.info(">>>>\u3010\u5b9a\u65f6\u5bf9\u6bd4\u8425\u9500\u4e91\u5e93\u5b58\u548c\u5e93\u5b58\u4e2d\u5fc3\u5e93\u5b58\u3011\u8c03\u5ea6\u4efb\u52a1\u521b\u5efa\u6210\u529f");
            }
            if (!contrastInventoryPreemptExist) {
                this.logger.info(">>>>\u3010\u5b9a\u65f6\u5bf9\u6bd4\u4e2d\u53f0\u9884\u5360\u4e0e\u4ea4\u6613\u8ba2\u5355\u72b6\u6001\u3001\u8fdb\u9500\u5b58\u9884\u5360\u5dee\u5f02\u3011\u8c03\u5ea6\u4efb\u52a1\u5f00\u59cb\u521b\u5efa");
                this.startSyncEvent(contrastInventoryPreemptCode, "\u5b9a\u65f6\u5bf9\u6bd4\u4e2d\u53f0\u9884\u5360\u4e0e\u4ea4\u6613\u8ba2\u5355\u72b6\u6001\u3001\u8fdb\u9500\u5b58\u9884\u5360\u5dee\u5f02", this.contrastInventoryPreemptEventCron);
                this.logger.info(">>>>\u3010\u5b9a\u65f6\u5bf9\u6bd4\u4e2d\u53f0\u9884\u5360\u4e0e\u4ea4\u6613\u8ba2\u5355\u72b6\u6001\u3001\u8fdb\u9500\u5b58\u9884\u5360\u5dee\u5f02\u3011\u8c03\u5ea6\u4efb\u52a1\u521b\u5efa\u6210\u529f");
            }
            if (!syncQualityDetailExist) {
                this.logger.info(">>>>\u3010\u5b9a\u65f6\u62c9\u53d6LIMS\u8d28\u68c0\u62a5\u544a\u6570\u636e\u3011\u8c03\u5ea6\u4efb\u52a1\u5f00\u59cb\u521b\u5efa");
                this.startSyncEvent(syncQualityDetailCode, "\u5b9a\u65f6\u62c9\u53d6LIMS\u8d28\u68c0\u62a5\u544a\u6570\u636e", this.syncQualityDetailEventCron);
                this.logger.info(">>>>\u3010\u5b9a\u65f6\u62c9\u53d6LIMS\u8d28\u68c0\u62a5\u544a\u6570\u636e\u3011\u8c03\u5ea6\u4efb\u52a1\u521b\u5efa\u6210\u529f");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void startSyncEvent(String code, String name, String cron) {
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode(code);
        dto.setBizName(name);
        dto.setScheduleExpression(cron);
        dto.setTaskName(name);
        dto.setTenantId(Constants.CONNECTOR_TENANT_ID);
        dto.setInstanceId(Constants.CONNECTOR_INSTANCE_ID);
        dto.setShardType("SINGLE");
        try {
            this.logger.info("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\uff1a{}", (Object)JSON.toJSONString((Object)dto));
            Long taskId = (Long)RestResponseHelper.extractData((RestResponse)this.iTaskApi.addWithBiz(dto));
            this.logger.info("\u521b\u5efa\u4efb\u52a1id\uff1a{}", (Object)taskId);
            if (Objects.nonNull(taskId)) {
                RequestDto requestDto = new RequestDto();
                requestDto.setInstanceId(Constants.CONNECTOR_INSTANCE_ID);
                requestDto.setTenantId(Constants.CONNECTOR_TENANT_ID);
                this.iTaskApi.enableById(taskId, ObjectHelper.bean2Json((Object)requestDto));
                this.logger.info("\u6839\u636e\u4efb\u52a1id\uff1a{} \u542f\u52a8\u4efb\u52a1\u6210\u529f", (Object)taskId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

