/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.request.PcpSupplier;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.PcpSupplierColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.ICsInventorySupplierApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventorySupplierReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsInventorySupplierRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import liquibase.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="CenterHandlePcpSupplierServiceImpl")
public class CenterHandlePcpSupplierServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandlePcpSupplierServiceImpl.class);
    @Resource
    private ICsInventorySupplierApi csInventorySupplierApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.SUPPLIER.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        long startTime = System.currentTimeMillis();
        ArrayList<DataDistributeRespDto> respDtoList = new ArrayList<DataDistributeRespDto>();
        DataDistributeRespDto respDto = new DataDistributeRespDto();
        logger.info("\u4f9b\u5e94\u5546\u6570\u636e\u5206\u53d1:{}", (Object)JSON.toJSONString((Object)modelInfoReqDto));
        List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        String str = this.validaData(maps);
        if (StringUtils.isNotEmpty((String)str)) {
            respDto.setReason(str);
            respDto.setType(DataDistributeRespEnum.FAILURE.name());
            respDtoList.add(respDto);
            return respDtoList;
        }
        List pcpWarehousesList = JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), PcpSupplier.class);
        List supplierCodeList = pcpWarehousesList.stream().map(PcpSupplier::getSupplierCode).collect(Collectors.toList());
        List orgCodeList = pcpWarehousesList.stream().map(PcpSupplier::getOrgCode).collect(Collectors.toList());
        CsInventorySupplierReqDto csInventorySupplierReqDto = new CsInventorySupplierReqDto();
        csInventorySupplierReqDto.setSupplierCodeList(supplierCodeList);
        List csInventorySupplierRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csInventorySupplierApi.queryParam(csInventorySupplierReqDto));
        Map supplierMap = csInventorySupplierRespDtos.stream().collect(Collectors.toMap(CsInventorySupplierRespDto::getSupplierCode, Functions.identity(), (n1, n2) -> n1));
        List organizationDtoList = (List)this.organizationQueryExtApi.queryOrgDetailByThirdCode(orgCodeList).getData();
        Map orgMap = null;
        if (!CollectionUtils.isEmpty((Collection)organizationDtoList)) {
            orgMap = organizationDtoList.stream().collect(Collectors.toMap(OrgAdvDetailRespDto::getThirdOrgId, Functions.identity(), (n1, n2) -> n1));
        }
        AtomicInteger insertCount = new AtomicInteger(0);
        AtomicInteger updateCount = new AtomicInteger(0);
        AtomicInteger failCount = new AtomicInteger(0);
        OrgAdvDetailRespDto organizationDto = null;
        for (PcpSupplier dto : pcpWarehousesList) {
            respDto = new DataDistributeRespDto();
            respDto.setType(DataDistributeRespEnum.SUCCESS.getCode());
            respDto.setTask_id(dto.getCidpTaskUuid());
            try {
                CsInventorySupplierRespDto supplierRespDto = (CsInventorySupplierRespDto)supplierMap.get(dto.getSupplierCode());
                if (orgMap != null && (organizationDto = (OrgAdvDetailRespDto)orgMap.get(dto.getOrgCode())) != null) {
                    dto.setOrgId(organizationDto.getId());
                }
                if (Objects.nonNull(supplierRespDto)) {
                    CsInventorySupplierReqDto modifyReqDto = new CsInventorySupplierReqDto();
                    modifyReqDto.setId(supplierRespDto.getId());
                    modifyReqDto.setEasOrgCode(dto.getOrgCode());
                    CubeBeanUtils.copyProperties((Object)modifyReqDto, (Object)dto, (String[])new String[0]);
                    this.csInventorySupplierApi.modifyCsInventorySupplier(modifyReqDto);
                    updateCount.addAndGet(1);
                    respDto.setReason("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a" + modifyReqDto.getSupplierCode() + "\u66f4\u65b0\u6210\u529f");
                } else {
                    CsInventorySupplierReqDto addReqDto = new CsInventorySupplierReqDto();
                    CubeBeanUtils.copyProperties((Object)addReqDto, (Object)dto, (String[])new String[0]);
                    addReqDto.setEasOrgCode(dto.getOrgCode());
                    this.csInventorySupplierApi.addCsInventorySupplier(addReqDto);
                    insertCount.addAndGet(1);
                    respDto.setReason("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a" + addReqDto.getSupplierCode() + "\u65b0\u589e\u6210\u529f");
                }
                respDtoList.add(respDto);
            }
            catch (Exception e) {
                logger.info("\u540c\u6b65\u4f9b\u5e94\u5546\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
                respDto.setType(DataDistributeRespEnum.FAILURE.getCode());
                respDto.setReason(e.getMessage());
                respDtoList.add(respDto);
            }
        }
        logger.info("\u3010PCP\u4f9b\u5e94\u5546\u65b0\u589e\u540c\u6b65mq\u3011\u843d\u5e93\u5b8c\u6210\uff0c\u5171\u8ba1\uff1a{}\uff0c\u65b0\u589e\uff1a{}\uff0c\u66f4\u65b0\uff1a{}\uff0c\u5f02\u5e38\uff1a{}", new Object[]{maps.size(), insertCount, updateCount, failCount});
        long endTime = System.currentTimeMillis();
        logger.info("\u3010PCP\u4f9b\u5e94\u5546\u65b0\u589e\u540c\u6b65mq\u3011\u8017\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        logger.info("\u3010PCP\u4f9b\u5e94\u5546\u65b0\u589e\u540c\u6b65mq\u3011\u7ed3\u675f\u540c\u6b65--------->");
        return respDtoList;
    }

    private String validaData(List<Map> dataMap) {
        if (dataMap == null || dataMap.size() <= 0) {
            return "\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (Map map : dataMap) {
            for (Object s : map.keySet()) {
                if (Objects.isNull(s)) {
                    return "\u540c\u6b65\u6570\u636e\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a";
                }
                PcpSupplierColumnEnum pcpSupplierColumnEnum = PcpSupplierColumnEnum.getByField(s.toString());
                if (pcpSupplierColumnEnum == null || pcpSupplierColumnEnum.validate(s.toString()).booleanValue()) continue;
                return String.format("%s\u4e0d\u80fd\u4e3a\u7a7a", pcpSupplierColumnEnum.getFieldName());
            }
        }
        return null;
    }

    private static Map convert(Map map) {
        HashMap newMap = Maps.newHashMap();
        for (Object s : map.keySet()) {
            String key = StrUtil.toCamelCase((CharSequence)s.toString().toLowerCase());
            newMap.put(key, map.get(s));
        }
        return newMap;
    }
}

