/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalOutService;
import com.dtyunxi.tcbj.app.open.biz.service.ISapCenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapModelTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.MaterialPriceReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.MaterialPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.IItemExtendApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SapCenterHandleMaterialPriceServiceImpl
implements ISapCenterHandleService {
    private static final Logger logger = LoggerFactory.getLogger(SapCenterHandleMaterialPriceServiceImpl.class);
    @Resource
    private IExternalOutService externalOutService;
    @Resource
    private IItemExtendApi itemExtendApi;

    @Override
    public String getModelType() {
        return SapModelTypeEnum.MATERIALPRICE.getValue();
    }

    @Override
    public void handle(Map<String, Object> map) {
        logger.info("sap-ocs\u4ef7\u683c\u6570\u636e\u62c9\u53d6:{}", (Object)JSON.toJSONString(map));
        MaterialPriceReqDto reqDto = new MaterialPriceReqDto();
        String[] materialTypes = new String[]{"ZFIN", "ZGEN"};
        LocalDate currentDate = LocalDate.now();
        LocalDate sevenDaysAgo = currentDate.minusDays(7L);
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE;
        String startDate = sevenDaysAgo.format(formatter);
        String endDate = currentDate.format(formatter);
        reqDto.setStartDate(startDate);
        reqDto.setEndDate(endDate);
        for (String materialType : materialTypes) {
            ItemExtendReqDto itemExtendReqDto;
            reqDto.setMaterialType(materialType);
            List<MaterialPriceRespDto> respDtoList = this.externalOutService.queryMaterialPriceList(reqDto);
            if (materialType.equals("ZFIN")) {
                for (MaterialPriceRespDto dto : respDtoList) {
                    itemExtendReqDto = new ItemExtendReqDto();
                    itemExtendReqDto.setItemCode(dto.getMatnr());
                    itemExtendReqDto.setClaimPrice(dto.getNetpr());
                    this.itemExtendApi.modifyPrice(itemExtendReqDto);
                }
                continue;
            }
            for (MaterialPriceRespDto dto : respDtoList) {
                itemExtendReqDto = new ItemExtendReqDto();
                itemExtendReqDto.setItemCode(dto.getMatnr());
                itemExtendReqDto.setRecommendPrice(dto.getNetpr());
                itemExtendReqDto.setClaimPrice(dto.getNetpr());
                this.itemExtendApi.modifyPrice(itemExtendReqDto);
            }
        }
        logger.info("\u7269\u6599\u4ef7\u683c\u6570\u636e\u66f4\u65b0\u5b8c\u6210");
    }
}

