/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.INutritionCollectApi;
import com.dtyunxi.tcbj.api.dto.response.SaleCompensationOrderSyncDto;
import com.dtyunxi.tcbj.app.open.biz.config.MarketingCloudConfig;
import com.dtyunxi.tcbj.app.open.biz.config.NutritionConfig;
import com.dtyunxi.tcbj.app.open.biz.config.PsiConfig;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalOutService;
import com.dtyunxi.tcbj.app.open.biz.service.IGiftPackageInfoService;
import com.dtyunxi.tcbj.app.open.biz.service.MarketingCloudService;
import com.dtyunxi.tcbj.app.open.biz.service.impl.ExternalPsiService;
import com.dtyunxi.tcbj.app.open.biz.utils.AssertUtil;
import com.dtyunxi.tcbj.app.open.biz.utils.CspClient;
import com.dtyunxi.tcbj.app.open.biz.utils.CspResponseHelper;
import com.dtyunxi.tcbj.app.open.biz.utils.EasClient;
import com.dtyunxi.tcbj.app.open.biz.utils.NutritionClient;
import com.dtyunxi.tcbj.app.open.biz.utils.NutritionResponseHelper;
import com.dtyunxi.tcbj.app.open.biz.utils.RqWmsClient;
import com.dtyunxi.tcbj.app.open.biz.utils.SapClient;
import com.dtyunxi.tcbj.app.open.biz.utils.WmsResponseHelper;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.GiftPackageInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.LimsQualityInfoPredictReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.GiftPackageInfoRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.LimsQualityInfoPredictRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.LimsQualityInfoRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.external.CspHttpResponseDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.external.RqWmsInventoryDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.external.RqWmsRespBean;
import com.dtyunxi.tcbj.center.openapi.api.enums.EasApiEnum;
import com.dtyunxi.tcbj.center.openapi.api.enums.RqWmsApiEnum;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapApiEnum;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalOutEasApi;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.AllotDifferenceDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.AllotOrderStatusReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPCargoLossAllotOrderApprovalReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPPurchaseCreateReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateCspClaimOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateCspOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateCspOrderRespDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateExchangeGoodsHeadReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateSpecialChannelOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.PushAllotDifferenceReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASOrderKayEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.SyncSystemTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.CancelOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASBillReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASOrderAuditReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASOrderBaseResult;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASQueryBaseReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.InventoryReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.MoveIssueBill;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.SaleOrder;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.SaleOrderUpdate;
import com.dtyunxi.tcbj.center.openapi.common.nutrition.dto.ReceiveCheckoutInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.nutrition.dto.ReceiveExpressInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.psi.dto.PSIOrderDto;
import com.dtyunxi.tcbj.center.openapi.common.psi.dto.PSIOrderItemDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.DeliveryOrderSignReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.InventoryMoveReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.InventoryStoMoveReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.InventoryStoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.MaterialPriceReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.MaterialPriceRespDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.SalesOrderCreateReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.SapSaleOrderRespDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.StockPostingReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.WarehouseDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderEditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderItemApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpDictQueryApi;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalOutServiceImpl
implements IExternalOutService {
    private static final Logger log = LoggerFactory.getLogger(ExternalOutServiceImpl.class);
    @Resource
    private ISaleOrderApi saleOrderApi;
    @Resource
    private ISaleOrderItemApi saleOrderItemApi;
    @Resource
    private MarketingCloudConfig marketingCloudConfig;
    @Resource
    private NutritionConfig nutritionConfig;
    @Resource
    private PsiConfig psiConfig;
    @Resource
    private ExternalPsiService externalPsiService;
    @Resource
    private INutritionCollectApi nutritionCollectApi;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderApi;
    @Resource
    private ICsDeliveryResultOrderQueryApi csDeliveryResultOrderQueryApi;
    @Resource
    private ICsDeliveryResultOrderApi csDeliveryResultOrderApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private IAdjustmentInventoryApi adjustmentInventoryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;
    @Resource
    private IPcpDictQueryApi pcpDictApi;
    @Autowired
    private IExternalOutEasApi externalOutEasRest;
    @Resource
    private IGiftPackageInfoService giftPackageInfoService;
    @Resource
    private MarketingCloudService marketingCloudService;

    @Override
    public void inBoundOrder(Map<String, Object> dto) {
        log.info("\u8363\u5e86WMS-\u521b\u5efa\u5165\u5e93\u5355\uff08\u8c03\u62e8\u5165\u5e93\u5355\uff09\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        String data = (String)RestResponseHelper.extractData(RqWmsClient.execute(dto, RqWmsApiEnum.IN_BOUND_ORDER));
        WmsResponseHelper.check((RqWmsRespBean)JSON.parseObject((String)data, RqWmsRespBean.class));
    }

    @Override
    public void outBoundOrder(Map<String, Object> dto) {
        log.info("\u8363\u5e86WMS-\u51fa\u5e93\u5355\u63a5\u53e3\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        String data = (String)RestResponseHelper.extractData(RqWmsClient.execute(dto, RqWmsApiEnum.OUT_BOUND_ORDER));
        WmsResponseHelper.check((RqWmsRespBean)JSON.parseObject((String)data, RqWmsRespBean.class));
    }

    @Override
    public void internalTransaction(Map<String, Object> dto) {
        log.info("\u8363\u5e86WMS-\u5185\u90e8\u4ea4\u6613\u63a5\u53e3\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        String data = (String)RestResponseHelper.extractData(RqWmsClient.execute(dto, RqWmsApiEnum.INTERNAL_TRANSACTION));
        WmsResponseHelper.check((RqWmsRespBean)JSON.parseObject((String)data, RqWmsRespBean.class));
    }

    @Override
    public void goodsAdjustment(Map<String, Object> dto) {
        log.info("\u8363\u5e86WMS-\u5f85\u68c0\u8f6c\u5408\u683c\u63a5\u53e3\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString(dto));
        String data = (String)RestResponseHelper.extractData(RqWmsClient.execute(dto, RqWmsApiEnum.GOODS_ADJUSTMENT));
        WmsResponseHelper.check((RqWmsRespBean)JSON.parseObject((String)data, RqWmsRespBean.class));
    }

    @Override
    public List<RqWmsInventoryDto> inventoryQuery(String warehousecode) {
        log.info("\u8363\u5e86WMS-\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u5165\u53c2:{}", (Object)warehousecode);
        HashMap map = Maps.newHashMap();
        map.put("warehousecode", warehousecode);
        String data = (String)RestResponseHelper.extractData(RqWmsClient.execute(map, RqWmsApiEnum.INVENTORY_QUERY));
        RqWmsRespBean rqWmsRespBean = (RqWmsRespBean)JSON.parseObject((String)data, RqWmsRespBean.class);
        List<RqWmsInventoryDto> rqWmsInventories = WmsResponseHelper.extractData(rqWmsRespBean);
        return rqWmsInventories;
    }

    @Override
    public void cancelOrder(CancelOrderReqDto dto) {
        log.info("EAS\uff0c\u53d6\u6d88\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (StringUtils.isBlank((CharSequence)dto.getSyscSystemType())) {
            dto.setSyscSystemType(SyncSystemTypeEnum.PCP.code);
        }
        EasClient.executeCommon(BeanUtil.beanToMap((Object)dto), EasApiEnum.CANCEL_ORDER);
    }

    @Override
    public EASOrderBaseResult purchaseIn(EASBillReqDto dto) {
        log.info("EAS\uff0c\u91c7\u8d2d\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASOrderBaseResult result = EasClient.executeParseArray(BeanUtil.beanToMap((Object)dto), EasApiEnum.IN_PLANNED_ORDER, EASOrderBaseResult.class);
        try {
            if (ObjectUtil.isNotEmpty((Object)result) && StringUtils.isNotBlank((CharSequence)result.getOrderNum()) && StringUtils.isNotBlank((CharSequence)result.getOtherNum())) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(EASOrderKayEnum.PURCHASE_IN.getCode(), result.getOrderNum());
                CsDeliveryResultOrderUpdateReqDto reqDto = new CsDeliveryResultOrderUpdateReqDto();
                reqDto.setDocumentNo(result.getOtherNum());
                reqDto.setExtensionMap(map);
                this.csDeliveryResultOrderApi.updateExtension(reqDto);
            }
        }
        catch (Exception e) {
            log.error("\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public void purchaseReturn(EASBillReqDto dto) {
        log.info("EAS\uff0c\u91c7\u8d2d\u9000\u8d27\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EasClient.executeCommon(BeanUtil.beanToMap((Object)dto), EasApiEnum.IN_PLANNED_ORDER);
    }

    @Override
    public void outsourceIn(EASBillReqDto dto) {
        dto.getPurInWarehsBills().forEach(pur -> {
            pur.getEntrys().forEach(e -> {
                e.setScUnWrittenOffBaseQty(e.getQty());
                e.setScUnWrittenOffQty(e.getQty());
            });
            pur.setPurchaseType("SUBCONTRACT");
        });
        log.info("EAS\uff0c\u59d4\u5916\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EasClient.executeCommon(BeanUtil.beanToMap((Object)dto), EasApiEnum.IN_PLANNED_ORDER);
    }

    @Override
    public void outsourceReturn(EASBillReqDto dto) {
        log.info("EAS\uff0c\u59d4\u5916\u9000\u8d27\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EasClient.executeCommon(BeanUtil.beanToMap((Object)dto), EasApiEnum.IN_PLANNED_ORDER);
    }

    @Override
    public void productionIn(EASBillReqDto dto) {
        log.info("EAS\uff0c\u751f\u4ea7\u6210\u54c1\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        this.purchaseInRestrict(new Date());
        EasClient.executeCommon(BeanUtil.beanToMap((Object)dto), EasApiEnum.PRODUCE_ORDER);
    }

    @Override
    public void productionReturn(EASBillReqDto dto) {
        log.info("EAS\uff0c\u751f\u4ea7\u6210\u54c1\u9000\u8d27\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EasClient.executeCommon(BeanUtil.beanToMap((Object)dto), EasApiEnum.PRODUCE_ORDER);
    }

    @Override
    public EASOrderBaseResult saleOrder(EASBillReqDto dto) {
        log.info("EAS\uff0c\u9500\u552e\u8ba2\u5355\uff08\u975e\u836f\u4e1a\uff09\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASOrderBaseResult result = EasClient.executeParseArray(BeanUtil.beanToMap((Object)dto), EasApiEnum.SALE_ORDER, EASOrderBaseResult.class);
        this.updateSaleExtension(((SaleOrder)dto.getSaleOrders().get(0)).getPcpSaleId(), result);
        return result;
    }

    @Override
    public void otherIn(EASBillReqDto dto) {
        log.info("EAS\uff0c\u5176\u4ed6\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASOrderBaseResult result = EasClient.executeParseArray(BeanUtil.beanToMap((Object)dto), EasApiEnum.OTHER_IN, EASOrderBaseResult.class);
        if (StringUtils.isNotBlank((CharSequence)result.getOrderNum()) && StringUtils.isNotBlank((CharSequence)result.getOrderNum())) {
            this.otherOutCallBackUpdate(result.getOtherNum(), result.getOrderNum());
        }
    }

    @Override
    public EASOrderBaseResult otherOut(EASBillReqDto dto) {
        log.info("EAS\uff0c\u5176\u4ed6\u51fa\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASOrderBaseResult result = EasClient.executeParseArray(BeanUtil.beanToMap((Object)dto), EasApiEnum.OTHER_OUT, EASOrderBaseResult.class);
        if (StringUtils.isNotBlank((CharSequence)result.getOrderNum()) && StringUtils.isNotBlank((CharSequence)result.getOrderNum())) {
            this.otherOutCallBackUpdate(result.getOtherNum(), result.getOrderNum());
        }
        return result;
    }

    @Override
    public void inventoryOutbound(InventoryReqDto dto) {
        log.info("EAS\uff0c\u8c03\u62e8\u51fa\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EasClient.executeCommon(BeanUtil.beanToMap((Object)dto), EasApiEnum.INVENTORY_OUTBOUND);
    }

    @Override
    public void inventoryInbound(InventoryReqDto dto) {
        log.info("EAS\uff0c\u8c03\u62e8\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EasClient.executeCommon(BeanUtil.beanToMap((Object)dto), EasApiEnum.INVENTORY_INBOUND);
    }

    @Override
    public EASOrderBaseResult inventoryAllot(InventoryReqDto dto) {
        log.info("EAS\uff0c\u5e93\u5b58\u8c03\u62e8\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASOrderBaseResult result = EasClient.executeParseArray(BeanUtil.beanToMap((Object)dto), EasApiEnum.INVENTORY_ALLOT, EASOrderBaseResult.class);
        this.inventoryAllotCallBack(dto, result);
        return result;
    }

    @Override
    public void saleOrderOut(EASBillReqDto dto) {
        log.info("EAS\uff0c\u9500\u552e\u51fa\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EasClient.executeCommon(BeanUtil.beanToMap((Object)dto), EasApiEnum.INVOKE_CUBE_ORDER);
    }

    @Override
    public void updateSaleOrderOutLogisticsStatus(List<SaleOrderUpdate> saleOrderUpdateList) {
        log.info("EAS\uff0c\u9500\u552e\u51fa\u5e93\u5355\u66f4\u65b0\u7269\u6d41\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString(saleOrderUpdateList));
        HashMap map = Maps.newHashMap();
        map.put("updateList", saleOrderUpdateList);
        EasClient.executeCommon(map, EasApiEnum.SALE_ORDER_STATUS_UPDATE);
    }

    @Override
    public void purchaseOrderCreate(CSPPurchaseCreateReqDto reqDto) {
        log.info("PSI\uff0c\u91c7\u8d2d\u5355/\u91c7\u8d2d\u5165\u5e93\u5355\u521b\u5efa\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.externalPsiService.executePost(this.psiConfig.getAddPurWarehousOrderApi(), BeanUtil.beanToMap((Object)reqDto));
    }

    @Override
    public void updateCspOrderStatus(CSPUpdateCspOrderReqDto reqDto) {
        log.info("CSP\uff0c\u63a8\u9001csp\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\uff1a{}", (Object)reqDto);
        if (StringUtils.isBlank((CharSequence)reqDto.getOrderNo()) || StringUtils.isBlank((CharSequence)reqDto.getStatus())) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        CspResponseHelper.check(CspClient.executeNotVerify(this.marketingCloudConfig.getUpdateCspOrderStatus(), BeanUtil.beanToMap((Object)reqDto), CSPUpdateCspOrderRespDto.class));
    }

    @Override
    public void updateCspClaimOrderStatus(CSPUpdateCspClaimOrderReqDto reqDto) {
        log.info("CSP\uff0c\u63a8\u9001csp\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\uff1a{}", (Object)reqDto);
        if (StringUtils.isBlank((CharSequence)reqDto.getOaSheetNo()) || StringUtils.isBlank((CharSequence)reqDto.getStatus())) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        CspResponseHelper.check(CspClient.executeNotVerify(this.marketingCloudConfig.getUpdateCspClaimOrderStatus(), BeanUtil.beanToMap((Object)reqDto), CSPUpdateCspOrderRespDto.class));
    }

    @Override
    public void updateCspSpecialChannelOrderStatus(CSPUpdateSpecialChannelOrderReqDto reqDto) {
        log.info("CSP\uff0c\u7279\u6e20\u8ba2\u5355\u63a8\u9001csp\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\uff1a{}", (Object)reqDto);
        if (StringUtils.isBlank((CharSequence)reqDto.getOrderNo()) || StringUtils.isBlank((CharSequence)reqDto.getStatus())) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        CspResponseHelper.check(CspClient.executeNotVerify(this.marketingCloudConfig.getUpdateCspSpecialChannelOrderStatus(), BeanUtil.beanToMap((Object)reqDto), CSPUpdateCspOrderRespDto.class));
    }

    @Override
    public void receiveCheckoutInfo(ReceiveCheckoutInfoReqDto reqDto) {
        log.info("\u63a5\u6536\u603b\u5355\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        NutritionResponseHelper.checkResponse(NutritionClient.execute(this.nutritionConfig.getReceiveCheckoutInfoApi(), reqDto));
    }

    @Override
    public void receiveExpressInfo(ReceiveExpressInfoReqDto reqDto) {
        log.info("\u63a5\u6536\u5feb\u9012\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        NutritionResponseHelper.checkResponse(NutritionClient.execute(this.nutritionConfig.getReceiveExpressInfoApi(), reqDto));
    }

    @Override
    public void easOrderAudit(EASOrderAuditReqDto reqDto) {
        log.info("EAS\u8ba2\u5355\u5ba1\u6838\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        EasClient.executeCommon(BeanUtil.beanToMap((Object)reqDto), EasApiEnum.ORDER_AUDIT);
    }

    @Override
    public void psiCreateOrder(PSIOrderDto psiOrderDto) {
        log.info("\u8fdb\u9500\u5b58PSI\u8ba2\u5355\u521b\u5efa\uff1a{}", (Object)JSON.toJSONString((Object)psiOrderDto));
        if (CollectionUtil.isNotEmpty((Collection)psiOrderDto.getItemList())) {
            List longCodeList = psiOrderDto.getItemList().stream().map(PSIOrderItemDto::getMaterialNo).collect(Collectors.toList());
            List batchList = psiOrderDto.getItemList().stream().map(PSIOrderItemDto::getLot).collect(Collectors.toList());
            GiftPackageInfoReqDto reqDto = new GiftPackageInfoReqDto();
            reqDto.setProNoList(longCodeList);
            reqDto.setLotList(batchList);
            Map<String, List<GiftPackageInfoReqDto>> giftInfoMap = this.giftPackageInfoService.queryByProNoAndLot(reqDto);
            if (ObjectUtil.isNotEmpty(giftInfoMap)) {
                psiOrderDto.getItemList().forEach(item -> {
                    List dtoList = (List)giftInfoMap.get(item.getMaterialNo() + item.getLot());
                    List objects = JSONArray.parseArray((String)JSON.toJSONString((Object)dtoList), Object.class);
                    item.setGiftInfoList(objects);
                });
            }
        }
        log.info("\u8fdb\u9500\u5b58PSI\u8ba2\u5355\u521b\u5efa\uff0c\u586b\u5145\u793c\u76d2\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)psiOrderDto));
        this.externalPsiService.executePost(this.psiConfig.getAddPurWarehousOrderApi(), BeanUtil.beanToMap((Object)psiOrderDto));
    }

    @Override
    public void updateExchangeGoodsHeadSheet(CSPUpdateExchangeGoodsHeadReqDto reqDto) {
        log.info("CSP\uff0c\u63a8\u9001csp\u66f4\u65b0\u6d88\u8d39\u8005\u9000\u6362\u8d27\u63a5\u53e3\uff1a{}", (Object)reqDto);
        if (StringUtils.isBlank((CharSequence)reqDto.getBillNo())) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        CspResponseHelper.check(CspClient.executeNotVerify(this.marketingCloudConfig.getUpdateExchangeGoodsHeadSheet(), BeanUtil.beanToMap((Object)reqDto), CSPUpdateCspOrderRespDto.class));
    }

    @Override
    public void cargoLossAllotOrderApproval(CSPCargoLossAllotOrderApprovalReqDto reqDto) {
        reqDto.setTrigger("OCS");
        log.info("CSP\uff0c\u7d22\u8d54\u8c03\u62e8\u8ba2\u5355\u5ba1\u6279\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getOrderNo()) || StringUtils.isBlank((CharSequence)reqDto.getEvent())) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        this.marketingCloudConfig.setIfTokenVerify(true);
        CspResponseHelper.newCspCheck(CspClient.cspExecute(this.marketingCloudConfig.getUpdateCspcargoLossAllotOrderApprovalStatus(), BeanUtil.beanToMap((Object)reqDto)));
    }

    @Override
    public <T> List<T> queryBase(EASQueryBaseReqDto reqDto, Class<T> tClass) {
        log.info("\u67e5\u8be2\u5668\u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.externalPsiService.queryBaseExecute(reqDto, tClass);
    }

    @Override
    public List<LimsQualityInfoRespDto> queryQualityReport(LimsQualityInfoPredictReqDto reqDto) {
        log.info("\u8d28\u68c0\u62a5\u544a\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        EASQueryBaseReqDto baseReqDto = new EASQueryBaseReqDto();
        baseReqDto.setTableName(this.psiConfig.getQualityReportName());
        baseReqDto.setSql(" ETID,REPORTNO,SAMPLECODE,LOTNO,DDIS_ISLOADED,UD,URL,SOURCEFROM,REMARK,QUANUM,UQUANUM,DEVQUANUM,IFLGOA,WMSSTATUS,SAMPLETYPE,RELEASEDATE ");
        StringBuilder builder = new StringBuilder(" where 1=1");
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getOrderNOs())) {
            builder.append(this.arrayToStr("REPORTNO", reqDto.getOrderNOs()));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getLongCodes())) {
            builder.append(this.arrayToStr("SAMPLECODE", reqDto.getLongCodes()));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getBatchs())) {
            builder.append(this.arrayToStr("LOTNO", reqDto.getBatchs()));
        }
        HashMap<String, String> mapParams = new HashMap<String, String>();
        HashMap<String, String> fieldType = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getStartDate())) {
            mapParams.put("startDate", reqDto.getStartDate());
            fieldType.put("startDate", "java.sql.Timestamp");
            builder.append(" and RELEASEDATE >=:startDate");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getEndDate())) {
            mapParams.put("endDate", reqDto.getEndDate());
            fieldType.put("endDate", "java.sql.Timestamp");
            builder.append(" and RELEASEDATE <:endDate");
        }
        baseReqDto.setMapParams(mapParams);
        baseReqDto.setFieldType(fieldType);
        baseReqDto.setWhere(builder.toString());
        if (ObjectUtil.isNotEmpty((Object)reqDto.getPage())) {
            baseReqDto.setCurrentPage(reqDto.getPage());
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getSize())) {
            baseReqDto.setPageSize(reqDto.getSize());
        }
        return this.externalPsiService.queryBaseExecute(baseReqDto, LimsQualityInfoRespDto.class);
    }

    @Override
    public List<LimsQualityInfoRespDto> queryQualityReportBySap(LimsQualityInfoPredictReqDto reqDto) {
        log.info("\u8d28\u68c0\u62a5\u544a\u67e5\u8be2\uff0c\u6765\u6e90SAP\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getStartDate())) {
            param.put("STARTDATE", reqDto.getStartDate());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getEndDate())) {
            param.put("ENDDATE", reqDto.getEndDate());
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getBatchs())) {
            param.put("LOTNO", String.join((CharSequence)",", reqDto.getBatchs()));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getLongCodes())) {
            param.put("SAMPLECODE", String.join((CharSequence)",", reqDto.getLongCodes()));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getOrderNOs())) {
            param.put("ORDERNO", String.join((CharSequence)",", reqDto.getOrderNOs()));
        }
        return SapClient.executeQueryLimsReport(param, LimsQualityInfoRespDto.class);
    }

    @Override
    public List<LimsQualityInfoPredictRespDto> queryPredictQualityReport(LimsQualityInfoPredictReqDto reqDto) {
        log.info("\u67e5\u9884\u8ba1\u8d28\u68c0\u62a5\u544a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        EASQueryBaseReqDto queryBaseReqDto = new EASQueryBaseReqDto();
        queryBaseReqDto.setTableName(this.psiConfig.getQualitySubmitReportName());
        queryBaseReqDto.setSql(" \u59d4\u6258\u5355\u53f7,\u7269\u6599\u7f16\u7801,\u7269\u6599\u540d\u79f0,\u6279\u53f7,\u4f9b\u5e94\u5546\u540d\u79f0,\u662f\u5426\u52a0\u6025,\u53d7\u7406\u65e5\u671f,\u63d0\u4ea4\u65f6\u95f4,\u662f\u5426\u5916\u68c0,\u7406\u8bba\u51fa\u62a5\u544a\u65e5\u671f,\u8d85\u671f\u65f6\u95f4,\u8bc1\u4ef6\u662f\u5426\u9f50\u5168 ");
        StringBuilder builder = new StringBuilder(" where 1=1");
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getOrderNOs())) {
            builder.append(this.arrayToStr("\u59d4\u6258\u5355\u53f7", reqDto.getOrderNOs()));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getLongCodes())) {
            builder.append(this.arrayToStr("\u7269\u6599\u7f16\u7801", reqDto.getLongCodes()));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getBatchs())) {
            builder.append(this.arrayToStr("\u6279\u53f7", reqDto.getBatchs()));
        }
        HashMap<String, String> mapParams = new HashMap<String, String>();
        HashMap<String, String> fieldType = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getStartDate())) {
            mapParams.put("startDate", reqDto.getStartDate());
            fieldType.put("startDate", "java.sql.Timestamp");
            builder.append(" and \u63d0\u4ea4\u65f6\u95f4 >=:startDate");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getEndDate())) {
            mapParams.put("endDate", reqDto.getEndDate());
            fieldType.put("endDate", "java.sql.Timestamp");
            builder.append(" and \u63d0\u4ea4\u65f6\u95f4 <:endDate");
        }
        queryBaseReqDto.setMapParams(mapParams);
        queryBaseReqDto.setFieldType(fieldType);
        queryBaseReqDto.setWhere(builder.toString());
        if (ObjectUtil.isNotEmpty((Object)reqDto.getPage())) {
            queryBaseReqDto.setCurrentPage(reqDto.getPage());
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getSize())) {
            queryBaseReqDto.setPageSize(reqDto.getSize());
        }
        return this.externalPsiService.queryBaseExecute(queryBaseReqDto, LimsQualityInfoPredictRespDto.class);
    }

    @Override
    public List<GiftPackageInfoRespDto> queryGiftPackageInfo(GiftPackageInfoReqDto reqDto) {
        log.info("\u67e5\u8be2\u793c\u76d2\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getProNo()) || StringUtils.isBlank((CharSequence)reqDto.getLot())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u6709\u8bef\uff0cproNo\u3001lot\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("proNo", reqDto.getProNo());
        params.put("lot", reqDto.getLot());
        return this.externalPsiService.queryGet(this.psiConfig.getQueryGiftPackageApi(), params, GiftPackageInfoRespDto.class);
    }

    @Override
    public List<GiftPackageInfoRespDto> queryGiftPackageInfoByTime(GiftPackageInfoReqDto reqDto) {
        log.info("\u67e5\u8be2\u793c\u76d2\u4fe1\u606f\u6839\u636e\u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getBeginDate()) || StringUtils.isBlank((CharSequence)reqDto.getEndDate())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u6709\u8bef\uff0cbeginDate\u3001endDate\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("beginDate", reqDto.getBeginDate());
        params.put("endDate", reqDto.getEndDate());
        return this.externalPsiService.queryGet(this.psiConfig.getQueryGiftPackageApiByTime(), params, GiftPackageInfoRespDto.class);
    }

    private String arrayToStr(String field, List<String> list) {
        if (CollectionUtil.isNotEmpty(list)) {
            StringBuffer str = new StringBuffer(" and " + field + " in (");
            list.forEach(s -> str.append("'").append((String)s).append("',"));
            str.replace(str.length() - 1, str.length(), ")");
            return str.toString();
        }
        return null;
    }

    private void updateSaleExtension(Long id, EASOrderBaseResult dto) {
        log.info("\u63a8\u9001\u9500\u552e\u5355\u81f3eas\u540e\uff0c\u8865\u5145\u5355\u636e\u6269\u5c55\u4fe1\u606f\uff1a{}=={}", (Object)id, (Object)JSON.toJSONString((Object)dto));
        if (dto.getMessage().toLowerCase().equals("success") || dto.getNote().equals("\u5df2\u7ecf\u5bfc\u5165\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u5bfc\u5165")) {
            try {
                SaleOrderReqDto saleOrderReqDto = new SaleOrderReqDto();
                saleOrderReqDto.setId(id);
                saleOrderReqDto.setEasOrderNo(dto.getOrderNum());
                HashMap<String, String> extensionMap = new HashMap<String, String>();
                extensionMap.put(EASExtendKeyEnum.SOURCE_ID.code, dto.getOrderId());
                saleOrderReqDto.setExtension(JSON.toJSONString(extensionMap));
                this.saleOrderApi.modifySaleOrder(saleOrderReqDto);
                dto.getItemList().forEach(item -> {
                    SaleOrderItemReqDto saleOrderItemReqDto = new SaleOrderItemReqDto();
                    saleOrderItemReqDto.setId(Long.valueOf(item.getOutId()));
                    HashMap<String, String> itemExtensionMap = new HashMap<String, String>();
                    itemExtensionMap.put(EASExtendKeyEnum.ENTRY_ID.code, item.getId());
                    saleOrderItemReqDto.setExtension(JSON.toJSONString(itemExtensionMap));
                    this.saleOrderItemApi.modifySaleOrderItem(saleOrderItemReqDto);
                });
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58EAS\u5355\u53f7\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                throw new BizException("-1", "\u4fdd\u5b58EAS\u5355\u53f7\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    private void otherOutCallBackUpdate(String documentNo, String externalOrderNo) {
        try {
            log.info("\u5904\u7406EAS\u5176\u4ed6\u51fa\u5165\u56de\u8c03\uff0c\u4fdd\u5b58\u5916\u90e8\u5355\u53f7\u5230\u5bf9\u5e94\u7684\u5355\u636e\u4e2d\uff1a{}\uff0c{}", (Object)documentNo, (Object)externalOrderNo);
            CsDeliveryResultOrderRespDto respDto = (CsDeliveryResultOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryByDocumentNo(documentNo));
            if (ObjectUtil.isEmpty((Object)respDto)) {
                log.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ed3\u679c\u5355");
                return;
            }
            log.info("\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
            if (respDto.getRelevanceTableName().equals("cs_other_storage_order")) {
                log.info("\u539f\u5355\u4e3a\u5176\u4ed6\u51fa\u5165\u5e93\u5355\uff0c\u4fdd\u5b58\u5230\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e\u5185");
                CsOtherStorageOrderEditReqDto editReqDto = new CsOtherStorageOrderEditReqDto();
                editReqDto.setStorageOrderNo(respDto.getRelevanceNo());
                editReqDto.setExternalOrderNo(externalOrderNo);
                RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.editOtherStorageOrder(editReqDto));
            } else if (respDto.getRelevanceTableName().equals(CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode()) && !respDto.getBusinessType().equals(CsPcpBusinessTypeEnum.NUTRITION_INTEGRAL.getCode()) && !respDto.getBusinessType().equals(CsPcpBusinessTypeEnum.ACTIVITY_ORDER.getCode()) && !respDto.getBusinessType().equals(CsPcpBusinessTypeEnum.REPLENISHMENT_ORDER.getCode())) {
                log.info("\u539f\u5355\u4e3a\u9500\u552e\u5355\uff0c\u4e14\u975e\u8425\u517b\u5bb6\u5355\u636e\uff0c\u4fdd\u5b58\u5230\u9500\u552e\u5355\u636e\u5185");
                BizSaleOrderRespDto bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(respDto.getRelevanceNo()));
                if (ObjectUtil.isNotEmpty((Object)bizSaleOrderRespDto)) {
                    BizSaleOrderReqDto saleOrderReqDto = new BizSaleOrderReqDto();
                    saleOrderReqDto.setId(bizSaleOrderRespDto.getId());
                    saleOrderReqDto.setEasOutOrderNo(externalOrderNo);
                    RestResponseHelper.extractData((RestResponse)this.saleOrderApi.modifySaleOrder((SaleOrderReqDto)saleOrderReqDto));
                    return;
                }
                log.info("\u627e\u4e0d\u5230\u9500\u552e\u5355\u636e");
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5176\u4ed6\u51fa\u5165\u5355\u4fe1\u606f\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void inventoryAllotCallBack(InventoryReqDto reqDto, EASOrderBaseResult result) {
        try {
            log.info("\u63a8\u9001EAS\u8c03\u62e8\u56de\u8c03\uff0c\u66f4\u65b0\u5916\u90e8\u5355\u53f7\u7b49\u76f8\u5173\u4fe1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            if (StringUtils.isBlank((CharSequence)result.getOrderNum())) {
                log.info("\u63a8\u9001\u7ed3\u679c\u4e3a\u7a7a");
                return;
            }
            AdjustmentInventoryRespDto adjustmentInventory = (AdjustmentInventoryRespDto)RestResponseHelper.extractData((RestResponse)this.adjustmentInventoryApi.queryByAdjustmentNo(((MoveIssueBill)reqDto.getStocktransferorders().get(0)).getSeq()));
            if (ObjectUtil.isEmpty((Object)adjustmentInventory) || ObjectUtil.isEmpty((Object)adjustmentInventory.getId())) {
                log.info("\u627e\u4e0d\u5230\u8c03\u6574\u5355\u4fe1\u606f");
                return;
            }
            AdjustmentInventoryReqDto update = new AdjustmentInventoryReqDto();
            update.setId(adjustmentInventory.getId());
            update.setExternalOrderNo(result.getOrderNum());
            update.setAdjustmentType(null);
            this.adjustmentInventoryApi.modifyAdjustmentInventory(update);
            String transferOrderNo = null;
            if (adjustmentInventory.getSourceType().equals(CsPcpBusinessTypeEnum.IN_TRANSIT_TRANSFER.getCode())) {
                log.info("\u6682\u4e0d\u56de\u5b58\u8f6c\u5408\u683c\u7684\u8c03\u6574\u5355\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
                return;
            }
            transferOrderNo = adjustmentInventory.getRelevanceNo();
            CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(transferOrderNo));
            AssertUtil.isFalse(ObjectUtil.isEmpty((Object)transferOrder), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u6574\u5355");
            CsTransferOrderReqDto transferOrderReqDto = new CsTransferOrderReqDto();
            transferOrderReqDto.setId(transferOrder.getId());
            transferOrderReqDto.setPreOrderNo(StringUtils.isNotBlank((CharSequence)transferOrder.getPreOrderNo()) ? transferOrder.getPreOrderNo() + "," + result.getOrderNum() : result.getOrderNum());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("externalOrderNOs", transferOrderReqDto.getPreOrderNo());
            transferOrderReqDto.setExtension(JSON.toJSONString(map));
            this.csTransferOrderApi.modifyCsTransferOrderExtension(transferOrderReqDto);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001EAS\u8c03\u62e8\u5355\u5b8c\u6210\u66f4\u65b0\u8c03\u6574\u5355\u5916\u90e8\u5355\u53f7\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void purchaseInRestrict(Date date) {
        log.info("\u9650\u5236\u67d0\u65f6\u95f4\u6bb5\u4e0d\u63a8\u9001EAS\uff1a{}", (Object)JSON.toJSONString((Object)date));
        String start = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "PURCHASE_IN_START").getData()).map(DictDto::getValue).orElse(null);
        String end = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "PURCHASE_IN_END").getData()).map(DictDto::getValue).orElse(null);
        if (StringUtils.isBlank((CharSequence)start) || StringUtils.isBlank((CharSequence)end)) {
            log.info("\u65e0\u65f6\u95f4\u9650\u5236");
            return;
        }
        Date startDate = DateUtil.parseDate((String)start, (String)"yyyy-MM-dd HH:mm:ss");
        Date endDate = DateUtil.parseDate((String)end, (String)"yyyy-MM-dd HH:mm:ss");
        Calendar calendarStart = Calendar.getInstance();
        calendarStart.setTime(startDate);
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(endDate);
        if (date.after(calendarStart.getTime()) && date.before(calendarEnd.getTime())) {
            throw new BizException("\u5728 " + start + " \u81f3 " + end + " \u65f6\u95f4\u8303\u56f4\u5185\uff0c\u9650\u5236\u4e0d\u80fd\u63a8\u9001EAS");
        }
        log.info("\u4e0d\u5728\u9650\u5236\u8303\u56f4\u5185");
    }

    @Override
    public String syncSaleCompensationOrderInfo(List<SaleCompensationOrderSyncDto> listOrder) {
        log.info("\u540c\u6b65\u7d22\u8d54\u8ba2\u5355\u53d1\u8d27\u5b9e\u9645\u5ba2\u6237\uff1a{}", (Object)JSON.toJSONString(listOrder));
        JSONArray array = new JSONArray();
        try {
            if (CollectionUtil.isNotEmpty(listOrder)) {
                for (SaleCompensationOrderSyncDto dto : listOrder) {
                    JSONObject object = new JSONObject();
                    object.put("EAS_CODE", (Object)dto.getEasCode());
                    object.put("CUSTOMER_CODE", (Object)dto.getCustomerCode());
                    object.put("CUSTOMER_NAME", (Object)dto.getCustomerName());
                    object.put("SP_CUSTOMER_CODE", (Object)dto.getActualCustomerCode());
                    object.put("SP_CUSTOMER_NAME", (Object)dto.getActualCustomerName());
                    array.add((Object)object);
                }
            }
            String jsonStr = JSONArray.toJSONString((Object)array);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("jsonStr", jsonStr);
            params.put("DSSUploadingId", this.psiConfig.getDSSUploadingId());
            log.info(((Object)params).toString());
            List list = this.externalPsiService.executeFormPost(this.psiConfig.getSyncSaleCompensationOrderInfo(), params, null, null);
            log.info(JSON.toJSONString(list));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u7d22\u8d54\u8ba2\u5355\u53d1\u8d27\u5b9e\u9645\u5ba2\u6237\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
        return "success";
    }

    @Override
    public SapSaleOrderRespDto sapSalesOrderCreate(SalesOrderCreateReqDto dto) {
        String json = JSON.toJSONString((Object)dto);
        log.info("SAP\uff0c\u9500\u552e\u8ba2\u5355\u521b\u5efa\uff1a{}", (Object)json);
        Object dto1 = SapClient.executeParseObject((Map<String, Object>)JSON.parseObject((String)json), SapApiEnum.SALES_ORDER_CREATE, Map.class).get("ApplicationID");
        SapSaleOrderRespDto respDto = (SapSaleOrderRespDto)JSONObject.parseObject((String)JSONObject.toJSONString(dto1), SapSaleOrderRespDto.class);
        return respDto;
    }

    @Override
    public void sapDeliveryOrderSign(DeliveryOrderSignReqDto dto) {
        String json = JSON.toJSONString((Object)dto);
        log.info("SAP\uff0c\u4ea4\u8d27\u8ba2\u5355\u7b7e\u6536\uff1a{}", (Object)json);
        SapClient.execute((Map<String, Object>)JSON.parseObject((String)json), SapApiEnum.DELIVERY_ORDER_SIGN);
    }

    @Override
    public String sapInventoryMove(InventoryMoveReqDto dto) {
        String json = JSON.toJSONString((Object)dto);
        log.info("SAP\uff0c\u5e93\u5b58\u72b6\u6001\u8c03\u6574\uff1a{}", (Object)json);
        return (String)SapClient.executeParseObject((Map<String, Object>)JSON.parseObject((String)json), SapApiEnum.INVENTORY_MOVE, Map.class).get("MaterialDocument");
    }

    @Override
    public void sapInventoryMoveCallBack(InventoryMoveReqDto dto, String respOrderNo) {
        log.info("ZMM039\uff0c\u540c\u5de5\u5382\u5e93\u5b58\u79fb\u52a8\uff0c\u56de\u8c03\u65b9\u6cd5\uff1a{}\uff0c{}", (Object)respOrderNo, (Object)JSON.toJSONString((Object)dto));
        if (StringUtils.isBlank((CharSequence)respOrderNo) || StringUtils.isBlank((CharSequence)dto.getBusinessType())) {
            log.info("\u56de\u8c03\u6761\u4ef6\u5f02\u5e38\uff0c\u7f3a\u5c11\u5173\u952e\u53c2\u6570");
            return;
        }
        String orderNo = dto.getBusinessOrderNo();
        switch (CsPcpBusinessTypeEnum.getByCode((String)dto.getBusinessType())) {
            case IN_TRANSIT_ADJUSTMENT_IN: 
            case IN_TRANSIT_ADJUSTMENT_OUT: {
                AdjustmentInventoryRespDto adjustmentInventory = (AdjustmentInventoryRespDto)RestResponseHelper.extractData((RestResponse)this.adjustmentInventoryApi.queryByAdjustmentNo(dto.getBusinessOrderNo()));
                AssertUtil.isFalse(ObjectUtil.isEmpty((Object)adjustmentInventory), "\u627e\u4e0d\u5230\u8c03\u6574\u5355\uff1a" + dto.getBusinessOrderNo());
                AdjustmentInventoryReqDto update = new AdjustmentInventoryReqDto();
                update.setId(adjustmentInventory.getId());
                update.setExternalOrderNo(respOrderNo);
                update.setAdjustmentType(null);
                this.adjustmentInventoryApi.modifyAdjustmentInventory(update);
                if (adjustmentInventory.getSourceType().equals(CsPcpBusinessTypeEnum.IN_TRANSIT_TRANSFER.getCode())) {
                    log.info("\u6682\u4e0d\u56de\u5b58\u8f6c\u5408\u683c\u7684\u8c03\u6574\u5355\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
                    return;
                }
                orderNo = adjustmentInventory.getRelevanceNo();
            }
            case BC_EQUAL_ALLOT: 
            case CB_EQUAL_ALLOT: 
            case INSPECTION_QUALIFIED: 
            case INSPECTION_UNQUALIFIED: 
            case ALLOT_LOGIC_OUT: 
            case CLAIM_ALLOT: 
            case BORROW_ALLOT: 
            case ALLOT_OUT_ONLY: 
            case ALLOT_IN_ONLY: {
                CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(orderNo));
                AssertUtil.isFalse(ObjectUtil.isEmpty((Object)transferOrder), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
                CsTransferOrderReqDto transferOrderReqDto = new CsTransferOrderReqDto();
                transferOrderReqDto.setId(transferOrder.getId());
                transferOrderReqDto.setPreOrderNo(respOrderNo);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("externalOrderNOs", transferOrderReqDto.getPreOrderNo());
                transferOrderReqDto.setExtension(JSON.toJSONString(map));
                RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.modifyCsTransferOrderExtension(transferOrderReqDto));
                break;
            }
            default: {
                log.info("\u672a\u5904\u7406\u7c7b\u578b\uff1a{}", (Object)dto.getBusinessType());
            }
        }
    }

    @Override
    public String sapInventoryStoMove(InventoryStoMoveReqDto dto) {
        String json = JSON.toJSONString((Object)dto);
        log.info("SAP\uff0c\u5e93\u5b58\u72b6\u6001\u8c03\u6574\uff1a{}", (Object)json);
        return (String)SapClient.executeParseObject((Map<String, Object>)JSON.parseObject((String)json), SapApiEnum.INVENTORY_STO_MOVE, Map.class).get("ProcessingBatchNumber");
    }

    @Override
    public String sapInventorySto(InventoryStoReqDto dto) {
        String json = JSON.toJSONString((Object)dto);
        log.info("SAP\uff0c\u8de8\u5de5\u5382\u95f4\u8c03\u62d4\uff1a{}", (Object)json);
        return (String)SapClient.executeParseObject((Map<String, Object>)JSON.parseObject((String)json), SapApiEnum.INVENTORY_STO, Map.class).get("ProcessingBatchNumber");
    }

    @Override
    public List<WarehouseDto> queryWarehouseList() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("werks", "");
        String json = JSON.toJSONString(map);
        log.info("SAP\uff0c\u67e5\u8be2\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)json);
        return SapClient.executeParseArray((Map<String, Object>)JSON.parseObject((String)json), SapApiEnum.WAREHOUSE_QUERY, WarehouseDto.class, "details");
    }

    @Override
    public List<MaterialPriceRespDto> queryMaterialPriceList(MaterialPriceReqDto reqDto) {
        String json = JSON.toJSONString((Object)reqDto);
        log.info("SAP\uff0c\u67e5\u8be2\u7269\u6599\u4ef7\u683c\u4fe1\u606f\uff1a{}", (Object)json);
        return SapClient.executeParseArray((Map<String, Object>)JSON.parseObject((String)json), SapApiEnum.MATERIAL_PRICE, MaterialPriceRespDto.class, "details");
    }

    @Override
    public String sapStockPosting(StockPostingReqDto dto) {
        String json = JSON.toJSONString((Object)dto);
        log.info("SAP\uff0c\u63a8\u9001\u5f85\u68c0\u8f6c\u5408\u683c\u4fe1\u606f\u5230SAP\uff1a{}", (Object)json);
        String result = SapClient.executeParseObject((Map<String, Object>)JSON.parseObject((String)json), SapApiEnum.EXAMINE_TRANSFORM, String.class);
        log.info("\u5f85\u68c0\u8f6c\u5408\u683csap\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)result);
        return result;
    }

    @Override
    public void updateAllotOrderStatus(AllotOrderStatusReqDto reqDto) {
        log.info("CSP\uff0c\u63a8\u9001csp\u66f4\u65b0\u7535\u5546bc\u8c03\u62e8\u5355\u72b6\u6001\uff1a{}", (Object)reqDto);
        this.marketingCloudConfig.setIfTokenVerify(true);
        CspResponseHelper.check(CspClient.cspExecute(this.marketingCloudConfig.getUpdateDsCspTransOrderStatus(), BeanUtil.beanToMap((Object)reqDto)));
    }

    @Override
    public AllotDifferenceDto pushAllotDifference(PushAllotDifferenceReqDto reqDto) {
        log.info("CSP\uff0c\u63a8\u9001\u7d22\u8d54\u8c03\u62e8\u6570\u636e\u7ed9csp\uff1a{}", (Object)reqDto);
        this.marketingCloudConfig.setIfTokenVerify(true);
        CspHttpResponseDto cspHttpResponseDto = CspClient.cspExecute(this.marketingCloudConfig.getPushAllotDifference(), BeanUtil.beanToMap((Object)reqDto));
        return CspResponseHelper.check(cspHttpResponseDto, AllotDifferenceDto.class);
    }
}

