/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.tcbj.app.open.biz.config.SapConfig;
import com.dtyunxi.tcbj.app.open.biz.utils.SapResponseHelper;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.external.SapLimsRespBean;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapApiEnum;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
public class SapClient {
    private static final Logger log = LoggerFactory.getLogger(SapClient.class);
    @Autowired
    private SapConfig sapConfig;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ILockService lockService;
    private static ILockService LOCK_SERVICE;
    private static SapClient sapClient;
    private static SapConfig SAP_CONFIG;
    private static ICacheService CACHE_SERVICE;
    public static final String SAP_TOKEN_KEY = "external:sap:SAP_TOKEN_KEY";
    private static final String EXPIRED_TOKEN = "\u8bf7\u91cd\u65b0\u767b\u9646";
    private static final String SAP_TOKEN_REDIS_LOCK_KEY = "SAP_TOKEN_REDIS_LOCK_KEY";

    @PostConstruct
    public void init() {
        sapClient = new SapClient();
        SAP_CONFIG = this.sapConfig;
        CACHE_SERVICE = this.cacheService;
        LOCK_SERVICE = this.lockService;
    }

    public static <T> T executeParseObject(Map<String, Object> param, SapApiEnum sapApiEnum, Class<T> tClass) {
        String data = SapClient.execute(param, sapApiEnum);
        if (data == null || data.isEmpty()) {
            return null;
        }
        Object result = JSONObject.parseObject((String)data, tClass);
        return (T)result;
    }

    public static <T> List<T> executeParseArray(Map<String, Object> param, SapApiEnum sapApiEnum, Class<T> tClass, String listName) {
        String data = SapClient.execute(param, sapApiEnum);
        Object listObj = JSONObject.parseObject((String)data).get((Object)listName);
        String listData = JSONObject.toJSONString((Object)listObj);
        if (StringUtils.isBlank((CharSequence)listData)) {
            throw new BizException("API\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            List list = JSONObject.parseArray((String)listData, tClass);
            if (CollectionUtil.isEmpty((Collection)list)) {
                throw new BizException("\u89e3\u6790\u7ed3\u679c\u4e3a\u7a7a\u5217\u8868");
            }
            return list;
        }
        catch (Exception e) {
            log.error("\u89e3\u6790SAP API\u8fd4\u56de\u6570\u636e\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new BizException("\u89e3\u6790SAP\u6570\u636e\u5931\u8d25: " + e.getMessage());
        }
    }

    public static <T> T executeParseSingleOrNull(Map<String, Object> param, SapApiEnum sapApiEnum, Class<T> tClass, String listName) {
        try {
            List<T> list = SapClient.executeParseArray(param, sapApiEnum, tClass, listName);
            return list.isEmpty() ? null : (T)list.get(0);
        }
        catch (BizException e) {
            log.warn("SAP API\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static String execute(Map<String, Object> param, SapApiEnum sapApiEnum) {
        String url = SAP_CONFIG.getUrl() + sapApiEnum.getApiLink();
        HttpRequest post = (HttpRequest)HttpUtil.createPost((String)url).header("Authorization", "Bearer " + SapClient.buildToken());
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)url);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", param);
        String bodyStr = JSON.toJSONString(param);
        post.body(bodyStr);
        String data = SapResponseHelper.checkData(SapClient.execute_post(post, param));
        if ("10000".equals(data) && (data = SapClient.retryTokenCommon(post, param)).equals("10000")) {
            throw new BizException("SAP\u7684TOKEN\u5df2\u7ecf\u5931\u6548");
        }
        return data;
    }

    private static String retryTokenCommon(HttpRequest post, Map<String, Object> bodyMap) {
        log.info("TOKEN\u8fc7\u671f\uff0c\u6e05\u9664TOKEN\u91cd\u65b0\u8bf7\u6c42");
        CACHE_SERVICE.delCache(SAP_TOKEN_KEY);
        String token = SapClient.buildToken();
        String url = SAP_CONFIG.getUrl() + "/api?token=" + token;
        post.setUrl(url);
        return SapResponseHelper.checkData(SapClient.execute_post(post, bodyMap));
    }

    private static String execute_post(HttpRequest post, Map<String, Object> bodyMap) {
        log.info("\u6267\u884cSAP\uff0cAPI\u8bf7\u6c42url:{}\uff0c\u53c2\u6570\uff1a{}", (Object)post.getUrl(), (Object)JSON.toJSONString(bodyMap));
        Instant start = Instant.now();
        post.timeout(SAP_CONFIG.getTimeout().intValue());
        HttpResponse httpResponse = post.execute();
        String body = httpResponse.body();
        Instant end = Instant.now();
        log.info("\u6267\u884cSAP API\u8bf7\u6c42\u54cd\u5e94\uff0c\u8bf7\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(bodyMap));
        log.info("\u6267\u884cSAP API\u8bf7\u6c42\u54cd\u5e94\uff0c\u8017\u65f6\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)Duration.between(start, end).toMillis(), (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseStatus", (Object)httpResponse.isGzip());
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseData", (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseCode", (Object)httpResponse.getStatus());
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buildToken() {
        String string;
        block9: {
            Mutex mutex;
            block7: {
                String string2;
                block8: {
                    mutex = null;
                    log.info("\u83b7\u53d6SAP\u670d\u52a1Token\uff1a{}\uff0c{}", (Object)SAP_TOKEN_KEY, (Object)SAP_TOKEN_KEY);
                    mutex = LOCK_SERVICE.lock("SAPClient", SAP_TOKEN_REDIS_LOCK_KEY, 10);
                    if (null == mutex) {
                        throw new BizException("\u83b7\u53d6SAP\u670d\u52a1Token\u5931\u8d25\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
                    }
                    String cacheToken = (String)CACHE_SERVICE.getCache(SAP_TOKEN_KEY, String.class);
                    if (!StringUtils.isNotBlank((CharSequence)cacheToken)) break block7;
                    log.info("\u8bfb\u53d6\u7f13\u5b58\u5185Token\uff1a{}", (Object)cacheToken);
                    string2 = cacheToken;
                    if (null == mutex) break block8;
                    LOCK_SERVICE.unlock(mutex);
                }
                return string2;
            }
            try {
                String tokenUrl = SAP_CONFIG.getTokenUrl();
                String credentials = Base64.encode((CharSequence)(SAP_CONFIG.getClientId() + ":" + SAP_CONFIG.getClientSecret()));
                log.info("\u91cd\u65b0\u83b7\u53d6Token\uff1a{}\uff0c{}\uff0c{}", new Object[]{tokenUrl, SAP_CONFIG.getTokenTimeout(), credentials});
                HttpRequest post = (HttpRequest)HttpUtil.createPost((String)tokenUrl).header("Authorization", "Basic " + credentials);
                HttpResponse httpResponse = post.execute();
                String body = httpResponse.body();
                JSONObject bodyObj = JSON.parseObject((String)body);
                log.info("\u91cd\u65b0\u83b7\u53d6Token\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)bodyObj));
                String token = bodyObj.getString("access_token");
                CACHE_SERVICE.setCache(SAP_TOKEN_KEY, token, (Object)SAP_CONFIG.getTokenTimeout());
                string = token;
                if (null == mutex) break block9;
            }
            catch (Exception e) {
                String string3;
                block10: {
                    try {
                        log.error("\u83b7\u53d6SAP\u670d\u52a1Token\u5931\u8d25\uff0c\u7a0b\u5e8f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                        log.error(e.getMessage(), (Throwable)e);
                        string3 = null;
                        if (null == mutex) break block10;
                    }
                    catch (Throwable throwable) {
                        if (null != mutex) {
                            LOCK_SERVICE.unlock(mutex);
                        }
                        throw throwable;
                    }
                    LOCK_SERVICE.unlock(mutex);
                }
                return string3;
            }
            LOCK_SERVICE.unlock(mutex);
        }
        return string;
    }

    public static String refreshToken() {
        CACHE_SERVICE.delCache(SAP_TOKEN_KEY);
        return SapClient.buildToken();
    }

    public static <T> List<T> executeQueryLimsReport(Map<String, Object> param, Class<T> tClass) {
        Instant start = Instant.now();
        HttpRequest post = (HttpRequest)((HttpRequest)HttpUtil.createPost((String)SAP_CONFIG.getStarLimsReportApi()).header("SL-API-Auth", SAP_CONFIG.getStarLimsReportAuth())).header("Content-Type", "application/json");
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)SAP_CONFIG.getStarLimsReportApi());
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", param);
        String bodyStr = JSON.toJSONString(param);
        post.body(bodyStr, "application/json");
        post.timeout(SAP_CONFIG.getTimeout().intValue());
        HttpResponse httpResponse = post.execute();
        String body = httpResponse.body();
        Instant end = Instant.now();
        log.info("\u6267\u884cSAP API\u8bf7\u6c42\u54cd\u5e94\uff0c\u8bf7\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(param));
        log.info("\u6267\u884cSAP API\u8bf7\u6c42\u54cd\u5e94\uff0c\u8017\u65f6\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)Duration.between(start, end).toMillis(), (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseStatus", (Object)httpResponse.isGzip());
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseData", (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseCode", (Object)httpResponse.getStatus());
        SapLimsRespBean sapRespBean = (SapLimsRespBean)JSON.parseObject((String)body, SapLimsRespBean.class);
        if (StringUtils.isBlank((CharSequence)sapRespBean.getSucceed()) || sapRespBean.getSucceed().equals("false")) {
            throw new BizException("-1", "\u8bf7\u6c42\u5f02\u5e38\uff1a" + sapRespBean.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)sapRespBean.getData())) {
            return null;
        }
        String data = sapRespBean.getData();
        return JSONObject.parseArray((String)data, tClass);
    }
}

