/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.wms;

import cn.hutool.core.collection.CollUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.wms.AbstractOrderTypeService;
import com.dtyunxi.tcbj.center.openapi.common.qimen.constant.QimenOrderTypeEnum;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Service;

@Service
public class WmsOrderTypeSelector
implements BeanFactoryAware {
    private final Map<String, AbstractOrderTypeService> serviceMap = new ConcurrentHashMap<String, AbstractOrderTypeService>(10);

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Optional.of(((ConfigurableListableBeanFactory)beanFactory).getBeansOfType(AbstractOrderTypeService.class)).filter(CollUtil::isNotEmpty).map(Map::values).ifPresent(beans -> beans.forEach(bean -> this.serviceMap.put(bean.getOrderTypeCode(), (AbstractOrderTypeService)bean)));
    }

    public AbstractOrderTypeService selector(String orderType) {
        QimenOrderTypeEnum serviceEnum = Optional.ofNullable(QimenOrderTypeEnum.getEnumByCode((String)orderType)).get();
        if (Objects.isNull(serviceEnum)) {
            new BizException("\u65e0\u6cd5\u9002\u914d\u7684\u7c7b\u578b");
        }
        return this.serviceMap.get(serviceEnum.getCode());
    }
}

