/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalOutService;
import com.dtyunxi.tcbj.app.open.biz.service.IGiftPackageInfoService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.GiftPackageInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.GiftPackageInfoRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SyncGiftPackageInfoEvent")
@Scope(value="prototype")
public class SyncGiftPackageInfoEvent
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SyncGiftPackageInfoEvent.class);
    @Resource
    private IExternalOutService externalOutService;
    @Resource
    private IGiftPackageInfoService giftPackageInfoService;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
    }

    public boolean execute(TaskMsg taskMsg) {
        List<GiftPackageInfoRespDto> dtoList;
        logger.info("\u540c\u6b65\u793c\u76d2\u4fe1\u606f\u8c03\u5ea6\uff1a{}", (Object)JSON.toJSONString((Object)taskMsg.getContent()));
        GiftPackageInfoReqDto reqDto = (GiftPackageInfoReqDto)JSON.parseObject((String)taskMsg.getContent(), GiftPackageInfoReqDto.class);
        if (ObjectUtils.isEmpty((Object)reqDto) || StringUtils.isBlank((CharSequence)reqDto.getBeginDate()) || StringUtils.isBlank((CharSequence)reqDto.getEndDate())) {
            reqDto = new GiftPackageInfoReqDto();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            reqDto.setEndDate(DateUtils.format((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            calendar.add(12, -5);
            reqDto.setBeginDate(DateUtils.format((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (CollectionUtil.isEmpty(dtoList = this.externalOutService.queryGiftPackageInfoByTime(reqDto))) {
            logger.info("\u65e0\u6570\u636e\u9700\u540c\u6b65");
            return true;
        }
        ArrayList<GiftPackageInfoReqDto> list = new ArrayList<GiftPackageInfoReqDto>();
        CubeBeanUtils.copyCollection(list, dtoList, GiftPackageInfoReqDto.class);
        this.giftPackageInfoService.addBatchGiftPackageInfo(list);
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

