/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.wms.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalInPutService;
import com.dtyunxi.tcbj.app.open.biz.wms.AbstractOrderTypeService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.LogisticsInformationDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.constant.QimenOrderTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.StoreprocessConfirmRequestDto;
import com.dtyunxi.yundt.cube.center.inventory.api.INoticeWmsStatusApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.NoticeWmsStatusReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CargoTrackWmsAdaptor
implements AbstractOrderTypeService {
    private static Logger logger = LoggerFactory.getLogger(CargoTrackWmsAdaptor.class);
    @Resource
    private INoticeWmsStatusApi noticeWmsStatusApi;
    @Resource
    private ICsOutResultOrderQueryApi csOutResultOrderQueryApi;
    @Resource
    private IExternalInPutService externalInPutService;

    @Override
    public String getOrderTypeCode() {
        return QimenOrderTypeEnum.CARGO_TRACK.getCode();
    }

    @Override
    public void doSomething(StoreprocessConfirmRequestDto confirmRequestDto) {
        if (Objects.isNull(confirmRequestDto) || Objects.isNull(confirmRequestDto.getExtendProps()) || confirmRequestDto.getExtendProps().isEmpty()) {
            logger.info("\u8d27\u54c1\u8f68\u8ff9dto\u4e3anull\u6216\u5907\u6ce8\u5b57\u6bb5\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        try {
            Map extendProps = confirmRequestDto.getExtendProps();
            String s = JSON.toJSONString((Object)extendProps);
            NoticeWmsStatusReqDto addTrackDto = (NoticeWmsStatusReqDto)JSONObject.parseObject((String)s, NoticeWmsStatusReqDto.class);
            RestResponseHelper.checkOrThrow((RestResponse)this.noticeWmsStatusApi.addNoticeWmsStatus(addTrackDto));
            if (Objects.equals("out", addTrackDto.getType())) {
                CsOutResultOrderQueryDto csOutResultOrderQueryDto = new CsOutResultOrderQueryDto();
                csOutResultOrderQueryDto.setPreOrderNo(addTrackDto.getDocumentNo());
                List dtoList = (List)RestResponseHelper.extractData((RestResponse)this.csOutResultOrderQueryApi.queryByParam(csOutResultOrderQueryDto));
                if (CollectionUtil.isEmpty((Collection)dtoList)) {
                    return;
                }
                CsOutResultOrderRespDto csOutResultOrderRespDto = (CsOutResultOrderRespDto)dtoList.get(0);
                if (StringUtils.isBlank((CharSequence)csOutResultOrderRespDto.getConsignmentNo())) {
                    return;
                }
                LogisticsInformationDto logisticsInformationDto = new LogisticsInformationDto();
                LogisticsInformationDto.Datas datas = new LogisticsInformationDto.Datas();
                datas.setTH_CODE(csOutResultOrderRespDto.getConsignmentNo());
                datas.setOPER_TIME(DateUtil.formatDateTime((Date)addTrackDto.getOptTime()));
                datas.setOPER_PERSON(addTrackDto.getOptPerson());
                datas.setOPER_INFO(addTrackDto.getOptContent());
                datas.setSTATUS(addTrackDto.getOrderStatus());
                logisticsInformationDto.getDatas().add(datas);
                logger.info("\u7269\u6d41\u4fe1\u606f\u540c\u6b65logisticsInformationDto:{}", (Object)JSON.toJSONString((Object)logisticsInformationDto));
                Map map = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)logisticsInformationDto), Map.class);
                this.externalInPutService.logisticsTrajectory(map);
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u8d27\u54c1\u8f68\u8ff9\u5931\u8d25", (Throwable)e);
        }
    }
}

