/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.dto.marketingcloud.WarehouseTenantRespDto;
import com.dtyunxi.tcbj.app.open.biz.service.MarketingCloudService;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPhysicsWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="syncWarehouseTenantEvent")
@Scope(value="prototype")
public class SyncWarehouseTenantEvent
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(SyncWarehouseTenantEvent.class);
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private MarketingCloudService marketingCloudService;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICsPhysicsWarehouseApi csPhysicsWarehouseApi;
    @Resource
    private ICsPhysicsWarehouseQueryApi csPhysicsWarehouseQueryApi;
    private static final Integer LIMIT = 100;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        return this.task(null);
    }

    public boolean task(List<String> idsStr) {
        logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u540c\u6b65\u5f00\u59cb--------->");
        long startTime = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(idsStr)) {
            logger.info("\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u4e3a\u7a7a");
            return true;
        }
        String accessToken = this.marketingCloudService.getToken();
        ArrayList dataList = new ArrayList();
        int max = LIMIT;
        int currentIndex = 0;
        while (idsStr.size() > currentIndex) {
            Object warehouseTenantList;
            List<String> id = null;
            if (idsStr.size() - currentIndex > max) {
                id = idsStr.subList(currentIndex, currentIndex + max);
                currentIndex += max;
            } else {
                id = idsStr.subList(currentIndex, idsStr.size());
                currentIndex = idsStr.size();
            }
            if (!CollectionUtils.isNotEmpty(warehouseTenantList = this.marketingCloudService.getWarehouseTenantList(id, accessToken))) continue;
            dataList.addAll(warehouseTenantList);
        }
        logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u83b7\u53d6\u4ed3\u5e93\u4e0e\u79df\u6237\u5173\u7cfb\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(dataList));
        if (CollectionUtils.isEmpty(dataList)) {
            logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u540c\u6b65\u7ed3\u675f\uff0c\u65e0\u7ecf\u4ed3\u5e93\u4e0e\u79df\u6237\u5173\u7cfb\u6570\u636e");
            return false;
        }
        List orgDtoList = (List)this.bizOrganizationQueryApi.getOrganizations(idsStr).getData();
        logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u6839\u636e\u7f16\u53f7\u67e5\u8be2\u5728\u5e93\u7ec4\u7ec7\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)orgDtoList));
        if (CollectionUtils.isEmpty((Collection)orgDtoList)) {
            logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u540c\u6b65\u7ed3\u675f\uff0c\u65e0\u7ec4\u7ec7\u6570\u636e");
            return false;
        }
        for (WarehouseTenantRespDto dto : dataList) {
            for (OrganizationDto org : orgDtoList) {
                if (!dto.getExtTenantId().equals(org.getCode())) continue;
                dto.setOrgId(org.getId());
                dto.setOrgName(org.getName());
            }
        }
        logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u8d4b\u4e88\u7ec4\u7ec7ID\u4e0e\u7f16\u53f7\u540e\u4ed3\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(dataList));
        CsPhysicsWarehouseQueryDto queryDto = new CsPhysicsWarehouseQueryDto();
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(10000));
        PageInfo warehousePage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseQueryApi.queryByPage(queryDto));
        logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u67e5\u8be2\u5728\u5e93\u4ed3\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)warehousePage));
        List warehouseList = warehousePage.getList();
        int insertCount = 0;
        int updateCount = 0;
        int failCount = 0;
        logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u8fdb\u884c\u843d\u5e93");
        for (WarehouseTenantRespDto dto : dataList) {
            logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u5904\u7406\u4ed3\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
            if (dto.getOrgId() == null) {
                logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u5f02\u5e38\u6570\u636e\uff0c\u65e0\u5339\u914d\u7ec4\u7ec7");
                ++failCount;
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)warehouseList)) {
                boolean isNew = true;
                for (CsPhysicsWarehouseRespDto warehouse : warehouseList) {
                    if (!dto.getNumber().equals(warehouse.getWarehouseCode())) continue;
                    isNew = false;
                    dto.setWarehouseRespDto(warehouse);
                    break;
                }
                if (isNew) {
                    this.csPhysicsWarehouseApi.initPhysicsWarehouse(this.getCreateReqDto(dto));
                    ++insertCount;
                    continue;
                }
                this.csPhysicsWarehouseApi.updatePhysicsWarehouse(dto.getWarehouseRespDto().getId(), this.getUpdateReqDto(dto));
                ++updateCount;
                continue;
            }
            this.csPhysicsWarehouseApi.initPhysicsWarehouse(this.getCreateReqDto(dto));
            ++insertCount;
        }
        logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u843d\u5e93\u5b8c\u6210\uff0c\u5171\u8ba1\uff1a{}\uff0c\u65b0\u589e\uff1a{}\uff0c\u66f4\u65b0\uff1a{}\uff0c\u5f02\u5e38\uff1a{}", new Object[]{dataList.size(), insertCount, updateCount, failCount});
        long endTime = System.currentTimeMillis();
        logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u8017\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        logger.info("\u3010\u5b9a\u65f6\u540c\u6b65-\u4ed3\u5e93\u3011\u7ed3\u675f\u540c\u6b65--------->");
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }

    private CsPhysicsWarehouseAddReqDto getCreateReqDto(WarehouseTenantRespDto dto) {
        CsPhysicsWarehouseAddReqDto physicsWarehouseAddReqDto = new CsPhysicsWarehouseAddReqDto();
        physicsWarehouseAddReqDto.setWarehouseStatus(CsPhysicsWarehouseStatusEnum.INITIAL.getCode());
        physicsWarehouseAddReqDto.setOrganizationName(dto.getName());
        physicsWarehouseAddReqDto.setOrganizationId(dto.getOrgId());
        physicsWarehouseAddReqDto.setWarehouseName(dto.getName());
        physicsWarehouseAddReqDto.setWarehouseCode(dto.getNumber());
        physicsWarehouseAddReqDto.setWarehouseType(dto.getType().toString());
        physicsWarehouseAddReqDto.setMainWarehouse(this.getIsDefault(dto.getIsDefault()));
        logger.info("\u65b0\u589e\u4ed3\u5e93\u5bf9\u8c61\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)physicsWarehouseAddReqDto));
        return physicsWarehouseAddReqDto;
    }

    private CsPhysicsWarehouseUpdateReqDto getUpdateReqDto(WarehouseTenantRespDto dto) {
        CsPhysicsWarehouseUpdateReqDto warehouseUpdateReqDto = new CsPhysicsWarehouseUpdateReqDto();
        warehouseUpdateReqDto.setWarehouseStatus(dto.getWarehouseRespDto().getWarehouseStatus());
        warehouseUpdateReqDto.setOrganizationName(dto.getName());
        warehouseUpdateReqDto.setOrganizationId(dto.getOrgId());
        warehouseUpdateReqDto.setWarehouseName(dto.getName());
        warehouseUpdateReqDto.setWarehouseCode(dto.getNumber());
        warehouseUpdateReqDto.setWarehouseType(dto.getType().toString());
        warehouseUpdateReqDto.setMainWarehouse(this.getIsDefault(dto.getIsDefault()));
        logger.info("\u66f4\u65b0\u4ed3\u5e93\u5bf9\u8c61\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)warehouseUpdateReqDto));
        return warehouseUpdateReqDto;
    }

    private Integer getIsDefault(Boolean value) {
        if (value.booleanValue()) {
            return 1;
        }
        return 0;
    }
}

