/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.processor;

import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.tcbj.app.open.biz.service.IDataDistributeService;
import com.dtyunxi.tcbj.app.open.biz.service.IThirdMqLogService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.DataDistributeMessageReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.DataDistributeReqDto;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="DATADISTRIBUTE_SYNC_TAG")
public class DataDistributeProcessor
implements IMessageProcessor<DataDistributeMessageReqDto> {
    private static final Logger log = LoggerFactory.getLogger(DataDistributeProcessor.class);
    @Autowired
    IDataDistributeService dataDistributeService;
    @Autowired
    private IThirdMqLogService thirdMqLogService;
    @Autowired
    private ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(DataDistributeMessageReqDto message) {
        MessageResponse messageResponse;
        log.info("\u63a5\u6536\u5230\u4e3b\u6570\u636e\u6570\u636e\u5206\u53d1\u540c\u6b65MQ\u6570\u636e:{}", (Object)message);
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("DATA_DISTRIBUTE_LOCK", message.getSendLogId(), 0, 300, TimeUnit.SECONDS);
            DataDistributeReqDto dataDistributeReqDto = new DataDistributeReqDto();
            BeanUtils.copyProperties((Object)message, (Object)dataDistributeReqDto);
            this.dataDistributeService.updateData(dataDistributeReqDto);
            this.thirdMqLogService.updateThirdLogStatus(Long.valueOf(message.getSendLogId()));
            messageResponse = MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            try {
                log.error("\u63a5\u6536\u5230\u4e3b\u6570\u636e\u6570\u636e\u5206\u53d1\u540c\u6b65\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
            this.lockService.unlock(mutex);
        }
        this.lockService.unlock(mutex);
        return messageResponse;
        log.info("\u63a5\u6536\u5230\u4e3b\u6570\u636e\u6570\u636e\u5206\u53d1\u540c\u6b65\u5931\u8d25");
        return MessageResponse.ERROR;
    }
}

