/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.utils.RestUtil;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.connector.comm.constant.Constants;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class SchedulerHelper {
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private ITaskApi iTaskApi;

    public void stopEvent(String bizName) {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setBizName(bizName);
        PageInfo task = (PageInfo)RestUtil.checkResponse(this.taskQueryApi.queryByPage(JSONObject.toJSONString((Object)taskQueryReqDto), Integer.valueOf(1), Integer.valueOf(1)));
        if (CollectionUtils.isEmpty((Collection)task.getList())) {
            return;
        }
        RequestDto requestDto = new RequestDto();
        requestDto.setInstanceId(Constants.CONNECTOR_INSTANCE_ID);
        requestDto.setTenantId(Constants.CONNECTOR_TENANT_ID);
        this.iTaskApi.enableById(((TaskQueryRespDto)task.getList().get(0)).getId(), ObjectHelper.bean2Json((Object)requestDto));
    }

    public void startSyncEvent(String appCode, String code, String name, String cron) {
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(appCode);
        dto.setBizCode(code);
        dto.setBizName(name);
        dto.setScheduleExpression(cron);
        dto.setTaskName(name);
        dto.setTenantId(Constants.CONNECTOR_TENANT_ID);
        dto.setInstanceId(Constants.CONNECTOR_INSTANCE_ID);
        dto.setShardType("SINGLE");
        try {
            RestResponse restResponse = this.iTaskApi.addWithBiz(dto);
            if (null != restResponse && "0".equals(restResponse.getResultCode())) {
                RequestDto requestDto = new RequestDto();
                requestDto.setInstanceId(Constants.CONNECTOR_INSTANCE_ID);
                requestDto.setTenantId(Constants.CONNECTOR_TENANT_ID);
                this.iTaskApi.enableById((Long)restResponse.getData(), ObjectHelper.bean2Json((Object)requestDto));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

