/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsOutNoticeOrderDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.CsOutNoticeOrderDetailRespDto;
import com.dtyunxi.tcbj.api.query.ICsOutNoticeOrderDetailQueryApi;
import com.dtyunxi.tcbj.app.open.biz.apiimpl.query.StringCodeQueryApiImpl;
import com.dtyunxi.tcbj.app.open.biz.service.FetchDataService;
import com.dtyunxi.tcbj.app.open.biz.service.IStringCodeService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.StringCodeCheckReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.StringCodeCheckRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="stringCodeCheckEvent")
@Scope(value="prototype")
public class StringCodeCheckEvent
extends SingleTupleScheduleEvent
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(StringCodeCheckEvent.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICsOutNoticeOrderDetailQueryApi csOutNoticeOrderDetailQueryApi;
    @Resource
    private StringCodeQueryApiImpl stringCodeQueryApiImpl;
    @Resource
    private IStringCodeService stringCodeService;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    private static final String CHECK_ORDER_KEY = "StringCodeCheckEvent:thirdNo";
    private static final String CHECK_ORDER_KEY_FLAG = "StringCodeCheckEvent:syncFlag";

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("\u5f02\u6b65\u4e32\u7801\u6821\u9a8c\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        String key = "StringCodeCheckEvent";
        int cacheTime = 60000;
        if (Boolean.FALSE.equals(this.cacheService.setIfAbsent(key, (Object)1, cacheTime))) {
            logger.info("\u6709\u4efb\u52a1\u6267\u884c\u4e2d");
            return true;
        }
        try {
            this.execute();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u4e32\u7801\u4efb\u52a1\u6267\u884c\u5f02\u5e38:{}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.cacheService.delCache(key);
        }
    }

    private void execute() {
        this.commonStringCheck();
        this.allotSaleStringCheck();
    }

    private void allotSaleStringCheck() {
        CsOutNoticeOrderDetailReqDto detailReqDto = new CsOutNoticeOrderDetailReqDto();
        detailReqDto.setStringCodeFlag(Integer.valueOf(2));
        FetchDataService dataListFetch = req -> (PageInfo)this.csOutNoticeOrderDetailQueryApi.queryByPagePost(detailReqDto).getData();
        Optional.ofNullable(dataListFetch.fetchAll(detailReqDto)).filter(CollUtil::isNotEmpty).map(details -> details.stream().map(i -> {
            StringCodeCheckReqDto reqDto = new StringCodeCheckReqDto();
            reqDto.setDocumentNo(i.getDocumentNo());
            reqDto.setEasSaleOrderNo(this.getThirdNoBySaleAllot((CsOutNoticeOrderDetailRespDto)i));
            reqDto.setNum(Integer.valueOf(i.getDoneQuantity().intValue()));
            reqDto.setItemLongCode(i.getLongCode());
            reqDto.setBatch(i.getBatch());
            return reqDto;
        }).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(StringCodeCheckReqDto::getDocumentNo)).values()).ifPresent(val -> val.forEach(this::doExecute));
    }

    private String getThirdNoBySaleAllot(CsOutNoticeOrderDetailRespDto i) {
        return Optional.ofNullable(i.getSplitPlatformNo()).filter(r -> StringUtils.isNotBlank((CharSequence)r) && StringUtils.isNotBlank((CharSequence)i.getEasOrderNo())).orElseGet(() -> Optional.ofNullable(i.getEasOrderNo()).filter(StringUtils::isNotBlank).orElse(i.getSaleOrderNo()));
    }

    private void commonStringCheck() {
        CsOutNoticeOrderDetailReqDto detailReqDto = new CsOutNoticeOrderDetailReqDto();
        detailReqDto.setStringCodeFlag(Integer.valueOf(1));
        FetchDataService dataListFetch = req -> (PageInfo)this.csOutNoticeOrderDetailQueryApi.queryByPagePost(detailReqDto).getData();
        Optional.ofNullable(dataListFetch.fetchAll(detailReqDto)).filter(CollUtil::isNotEmpty).map(details -> details.stream().map(i -> {
            StringCodeCheckReqDto reqDto = new StringCodeCheckReqDto();
            reqDto.setDocumentNo(i.getDocumentNo());
            reqDto.setEasSaleOrderNo(this.getThirdNo((CsOutNoticeOrderDetailRespDto)i));
            reqDto.setNum(Integer.valueOf(i.getDoneQuantity().intValue()));
            reqDto.setItemLongCode(i.getLongCode());
            reqDto.setBatch(i.getBatch());
            return reqDto;
        }).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(StringCodeCheckReqDto::getDocumentNo)).values()).ifPresent(val -> val.forEach(this::doExecute));
    }

    private String getThirdNo(CsOutNoticeOrderDetailRespDto i) {
        return Optional.ofNullable(this.cacheService.hget(CHECK_ORDER_KEY, i.getDocumentNo(), String.class)).orElseGet(() -> {
            CsOutNoticeOrderRespDto data = (CsOutNoticeOrderRespDto)this.csOutNoticeOrderQueryApi.queryByDocumentNo(i.getDocumentNo()).getData();
            logger.info("\u67e5\u8be2\u901a\u77e5\u5355\u4fe1\u606fdata:{}", (Object)JSON.toJSONString((Object)data));
            String thirdNo = this.getThirdNo(data);
            this.cacheService.hset(CHECK_ORDER_KEY, i.getDocumentNo(), (Object)thirdNo, 1800);
            if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(data.getBusinessType())) {
                this.cacheService.setCache(CHECK_ORDER_KEY_FLAG, i.getDocumentNo(), (Object)"1", 1800);
            }
            return thirdNo;
        });
    }

    private void doExecute(List<StringCodeCheckReqDto> list) {
        List<StringCodeCheckRespDto> checkResult = this.getCheckResult(list);
        Optional.of(checkResult.stream().filter(StringCodeCheckRespDto::isCheckResult).map(StringCodeCheckReqDto::getDocumentNo).collect(Collectors.toList())).filter(CollUtil::isNotEmpty).ifPresent(orderNos -> this.cacheService.hdel(CHECK_ORDER_KEY, orderNos.toArray(new String[0])));
        this.stringCodeService.sendMqAndUpdateCache(checkResult);
    }

    private List<StringCodeCheckRespDto> getCheckResult(List<StringCodeCheckReqDto> list) {
        RestResponse<List<StringCodeCheckRespDto>> check = this.stringCodeQueryApiImpl.check(list);
        return (List)RestResponseHelper.extractData(check);
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u5f02\u6b65\u4e32\u7801\u6821\u9a8c\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f");
    }

    private String getThirdNo(CsOutNoticeOrderRespDto noticeOrderRespDto) {
        switch (CsPcpBusinessTypeEnum.getByCode((String)noticeOrderRespDto.getBusinessType())) {
            case INTERNAL_DEAL: 
            case INTERNAL_DEAL_RETURN: {
                return Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(noticeOrderRespDto.getRelevanceNo()))).map(CsTransferOrderRespDto::getExternalPurchaseOrderNo).orElse(noticeOrderRespDto.getExternalOrderNo());
            }
            case ALLOT_OUT: 
            case MAIYOU_ALLOT_OUT: 
            case ALLOT_IN_ONLY: 
            case ALLOT_OUT_ONLY: 
            case ALLOT_SALE: 
            case ALLOT_SALE_BH: {
                return Optional.ofNullable(noticeOrderRespDto.getExternalOrderNo()).filter(StringUtils::isNotEmpty).orElse(noticeOrderRespDto.getRelevanceNo());
            }
            case OTHER_OUT: 
            case OTHER_IN: 
            case REPLENISH_ORDER: 
            case INSPECTION_QUALIFIED: {
                return noticeOrderRespDto.getRelevanceNo();
            }
            case ALLOT_LOSE_EFFICACY: {
                return noticeOrderRespDto.getDocumentNo();
            }
            case NUTRITION_INTEGRAL: 
            case OTHER_OUT_STOCK: 
            case AGENCY_ORDER: 
            case SHOPPE_ORDER: 
            case INTEGRAL_ORDER: 
            case REPLENISHMENT_ORDER: 
            case ACTIVITY_ORDER: 
            case INTERNAL_DISTRIBUTION: 
            case SECONDARY_DISTRIBUTION: 
            case COMPENSATION_ORDER: 
            case QUALITY_REFUNDING_ORDER: 
            case PRESALE_ORDER: 
            case CUSTOMER_REFUNDING_ORDER: 
            case CLAIM_POSTING: 
            case CLAIM_REISSUE: 
            case COMMON_ORDER: 
            case BAIJIAN_DIRECT_SALES: {
                BizSaleOrderRespDto data = (BizSaleOrderRespDto)Optional.ofNullable(this.saleOrderQueryApi.queryByOrderNo(noticeOrderRespDto.getRelevanceNo()).getData()).orElse(new BizSaleOrderRespDto());
                return this.getThirdOrderNo(noticeOrderRespDto.getRelevanceNo(), data);
            }
        }
        return noticeOrderRespDto.getExternalOrderNo();
    }

    private String getThirdOrderNo(String relevanceNo, BizSaleOrderRespDto order) {
        return Optional.ofNullable(order.getSplitPlatformNo()).filter(r -> StringUtils.isNotBlank((CharSequence)r) && StringUtils.isNotBlank((CharSequence)order.getEasOrderNo())).orElseGet(() -> Optional.ofNullable(order.getEasOrderNo()).filter(StringUtils::isNotBlank).orElse(relevanceNo));
    }

    public void run(String ... args) throws Exception {
        this.cacheService.delCache("StringCodeCheckEvent");
    }
}

